/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.expression.calculate;

import com.jinfonet.dataservice.expression.calculate.ASingleCalculateExpression;
import jet.dataengine.api.SumrySpecKeyTool;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.OperatorTypes;
import jet.dataengine.api.expression.calculate.op.ICalculateOperator;
import jet.dataengine.api.expression.calculate.op.ISpecialFunc;
import jet.dataengine.api.expression.variable.IVariableExpression;
import jet.formula.SpecFormulaInfo;

public final class SingleCalculateExpressionImpl
extends ASingleCalculateExpression {
    public SingleCalculateExpressionImpl(ICalculateOperator iCalculateOperator, IVariableExpression iVariableExpression) throws ConditionException {
        super(iCalculateOperator, iVariableExpression);
    }

    @Override
    public int expressionType() {
        return 147456;
    }

    @Override
    public void check() throws ConditionException {
    }

    @Override
    public String toExpString() throws ConditionException {
        String string = "op";
        try {
            if (this.getOperator().operatorType() == 0x14000001) {
                SpecFormulaInfo specFormulaInfo = ((ISpecialFunc)this.operator).getSpecFmlInfo();
                string = SumrySpecKeyTool.getSpecKey(specFormulaInfo);
            } else {
                string = OperatorTypes.getOpTypeName(this.getOperator().operatorType());
            }
        }
        catch (ConditionException conditionException) {
            throw new RuntimeException("ConditionException", conditionException);
        }
        return string + " ( " + this.getExpression().toExpString() + " )";
    }

    public String toString() {
        String string = "op";
        try {
            if (this.getOperator().operatorType() == 0x14000001) {
                SpecFormulaInfo specFormulaInfo = ((ISpecialFunc)this.operator).getSpecFmlInfo();
                string = SumrySpecKeyTool.getSpecKey(specFormulaInfo);
            } else {
                string = OperatorTypes.getOpTypeName(this.getOperator().operatorType());
            }
        }
        catch (ConditionException conditionException) {
            throw new RuntimeException("ConditionException", conditionException);
        }
        return string + " ( " + this.getExpression().toString() + " )";
    }

    @Override
    public void setExpression(IExpression iExpression) throws ConditionException {
        if (iExpression == null) {
            super.setExpression(null);
        }
        if (!ExpressionToolKit.isVariableExp(iExpression.expressionType())) {
            throw new IllegalArgumentException("set sub exp must be variable exp, not " + iExpression.expressionType());
        }
        super.setExpression(iExpression);
    }
}

