/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.expression.context.implement;

import com.jinfonet.api.datatypes.Blob;
import com.jinfonet.api.datatypes.Clob;
import com.jinfonet.api.datatypes.Date;
import com.jinfonet.api.datatypes.Time;
import com.jinfonet.api.datatypes.Timestamp;
import com.jinfonet.dataservice.expression.context.ContextType;
import com.jinfonet.dataservice.expression.context.DataTypeInfo;
import com.jinfonet.dataservice.expression.context.IContextScope;
import com.jinfonet.dataservice.expression.context.INumericVariable;
import com.jinfonet.dataservice.expression.context.IVariable;
import com.jinfonet.dataservice.expression.context.implement.AContextObjectContainer;
import com.jinfonet.dataservice.expression.context.implement.AVariable;
import com.jinfonet.dataservice.expression.context.implement.VBigDecimal;
import com.jinfonet.dataservice.expression.context.implement.VBlob;
import com.jinfonet.dataservice.expression.context.implement.VBoolean;
import com.jinfonet.dataservice.expression.context.implement.VByte;
import com.jinfonet.dataservice.expression.context.implement.VBytes;
import com.jinfonet.dataservice.expression.context.implement.VClob;
import com.jinfonet.dataservice.expression.context.implement.VCustomer;
import com.jinfonet.dataservice.expression.context.implement.VDate;
import com.jinfonet.dataservice.expression.context.implement.VDouble;
import com.jinfonet.dataservice.expression.context.implement.VFloat;
import com.jinfonet.dataservice.expression.context.implement.VInteger;
import com.jinfonet.dataservice.expression.context.implement.VLong;
import com.jinfonet.dataservice.expression.context.implement.VRelation;
import com.jinfonet.dataservice.expression.context.implement.VShort;
import com.jinfonet.dataservice.expression.context.implement.VString;
import com.jinfonet.dataservice.expression.context.implement.VTime;
import com.jinfonet.dataservice.expression.context.implement.VTimestamp;
import com.jinfonet.dataservice.relational.IRelationData;
import java.math.BigDecimal;
import java.math.BigInteger;
import jet.dataengine.api.DSException;

public class ContextScope
extends AContextObjectContainer
implements IContextScope {
    public ContextScope() throws DSException {
        this(null);
    }

    public ContextScope(String string) throws DSException {
        super(string, ContextType.CONTEXTSCOPE);
        super.addContentType(ContextType.VARIABLE);
    }

    @Override
    public void destroy() throws DSException {
        IVariable[] iVariableArray = (IVariable[])super.getAllContentElements(new IVariable[0]);
        for (int i = 0; i < iVariableArray.length; ++i) {
            iVariableArray[i].setNull();
        }
        super.removeAllContentElements();
    }

    @Override
    public IVariable getVariable(String string) {
        return (IVariable)super.getContentElement(string);
    }

    @Override
    public IVariable[] getAllVariables() {
        return (IVariable[])super.getAllContentElements(new IVariable[0]);
    }

    @Override
    public String[] getAllVariableNames() {
        return super.getAllContentElementNames();
    }

    @Override
    public IVariable createNullVariable(String string, int n) throws DSException {
        AVariable aVariable = null;
        switch (n) {
            case -6: {
                aVariable = new VByte(string);
                break;
            }
            case 5: {
                aVariable = new VShort(string);
                break;
            }
            case 4: {
                aVariable = new VInteger(string);
                break;
            }
            case -5: {
                aVariable = new VLong(string);
                break;
            }
            case 6: {
                aVariable = new VFloat(string);
                break;
            }
            case 8: {
                aVariable = new VDouble(string);
                break;
            }
            case 3: {
                aVariable = new VBigDecimal(string);
                break;
            }
            case -7: {
                aVariable = new VBoolean(string);
                break;
            }
            case 91: {
                aVariable = new VDate(string);
                break;
            }
            case 92: {
                aVariable = new VTime(string);
                break;
            }
            case 93: {
                aVariable = new VTimestamp(string);
                break;
            }
            case 12: {
                aVariable = new VString(string);
                break;
            }
            case -2: {
                aVariable = new VBytes(string);
                break;
            }
            case 2005: {
                aVariable = new VClob(string);
                break;
            }
            case 2004: {
                aVariable = new VBlob(string);
                break;
            }
            case 0x7FFFFFFF: {
                aVariable = new VRelation(string);
                break;
            }
            case 0x7FFFFFFD: {
                aVariable = new VCustomer(string);
                break;
            }
            default: {
                throw new ClassCastException("Unsupported Data Type :" + n);
            }
        }
        super.addVariable(aVariable);
        return aVariable;
    }

    @Override
    public IVariable createVariable(String string, byte by) throws DSException {
        VByte vByte = new VByte(string, by);
        super.addVariable(vByte);
        return vByte;
    }

    @Override
    public IVariable createVariable(String string, short s) throws DSException {
        VShort vShort = new VShort(string, s);
        super.addVariable(vShort);
        return vShort;
    }

    @Override
    public IVariable createVariable(String string, int n) throws DSException {
        VInteger vInteger = new VInteger(string, n);
        super.addVariable(vInteger);
        return vInteger;
    }

    @Override
    public IVariable createVariable(String string, long l) throws DSException {
        VLong vLong = new VLong(string, l);
        super.addVariable(vLong);
        return vLong;
    }

    @Override
    public IVariable createVariable(String string, float f) throws DSException {
        VFloat vFloat = new VFloat(string, f);
        super.addVariable(vFloat);
        return vFloat;
    }

    @Override
    public IVariable createVariable(String string, double d) throws DSException {
        VDouble vDouble = new VDouble(string, d);
        super.addVariable(vDouble);
        return vDouble;
    }

    @Override
    public IVariable createVariable(String string, boolean bl) throws DSException {
        VBoolean vBoolean = new VBoolean(string, bl);
        super.addVariable(vBoolean);
        return vBoolean;
    }

    @Override
    public IVariable createVariable(String string, Date date) throws DSException {
        VDate vDate = new VDate(string, date);
        super.addVariable(vDate);
        return vDate;
    }

    @Override
    public IVariable createVariable(String string, Time time2) throws DSException {
        VTime vTime = new VTime(string, time2);
        super.addVariable(vTime);
        return vTime;
    }

    @Override
    public IVariable createVariable(String string, Timestamp timestamp) throws DSException {
        VTimestamp vTimestamp = new VTimestamp(string, timestamp);
        super.addVariable(vTimestamp);
        return vTimestamp;
    }

    @Override
    public IVariable createVariable(String string, BigDecimal bigDecimal, int n) throws DSException {
        VBigDecimal vBigDecimal = new VBigDecimal(string, bigDecimal, n);
        super.addVariable(vBigDecimal);
        return vBigDecimal;
    }

    @Override
    public IVariable createVariable(String string, String string2) throws DSException {
        VString vString = new VString(string, string2);
        super.addVariable(vString);
        return vString;
    }

    @Override
    public IVariable createVariable(String string, byte[] byArray) throws DSException {
        VBytes vBytes = new VBytes(string, byArray);
        super.addVariable(vBytes);
        return vBytes;
    }

    @Override
    public IVariable createVariable(String string, Blob blob) throws DSException {
        VBlob vBlob = new VBlob(string, blob);
        super.addVariable(vBlob);
        return vBlob;
    }

    @Override
    public IVariable createVariable(String string, Clob clob) throws DSException {
        VClob vClob = new VClob(string, clob);
        super.addVariable(vClob);
        return vClob;
    }

    @Override
    public IVariable createVariable(String string, IRelationData iRelationData) throws DSException {
        VRelation vRelation = new VRelation(string, iRelationData);
        super.addVariable(vRelation);
        return vRelation;
    }

    @Override
    public IVariable createVariable(String string, Object object) throws DSException {
        VCustomer vCustomer = new VCustomer(string, object);
        super.addVariable(vCustomer);
        return vCustomer;
    }

    @Override
    public void setVariable(String string, byte by) {
        IVariable iVariable = this.getVariable(string);
        ContextType contextType = iVariable.getContextType();
        if (!ContextType.NUMERIC.isTypeOfMine(contextType)) {
            throw new ClassCastException();
        }
        INumericVariable iNumericVariable = (INumericVariable)iVariable;
        iNumericVariable.setValue(by);
    }

    @Override
    public void setVariable(String string, short s) {
        IVariable iVariable = this.getVariable(string);
        ContextType contextType = iVariable.getContextType();
        if (!ContextType.NUMERIC.isTypeOfMine(contextType)) {
            throw new ClassCastException();
        }
        INumericVariable iNumericVariable = (INumericVariable)iVariable;
        iNumericVariable.setValue(s);
    }

    @Override
    public void setVariable(String string, int n) {
        IVariable iVariable = this.getVariable(string);
        ContextType contextType = iVariable.getContextType();
        if (!ContextType.NUMERIC.isTypeOfMine(contextType)) {
            throw new ClassCastException();
        }
        INumericVariable iNumericVariable = (INumericVariable)iVariable;
        iNumericVariable.setValue(n);
    }

    @Override
    public void setVariable(String string, long l) {
        IVariable iVariable = this.getVariable(string);
        ContextType contextType = iVariable.getContextType();
        if (!ContextType.NUMERIC.isTypeOfMine(contextType)) {
            throw new ClassCastException();
        }
        INumericVariable iNumericVariable = (INumericVariable)iVariable;
        iNumericVariable.setValue(l);
    }

    public void setVariable(String string, BigInteger bigInteger) {
        IVariable iVariable = this.getVariable(string);
        ContextType contextType = iVariable.getContextType();
        if (!ContextType.NUMERIC.isTypeOfMine(contextType)) {
            throw new ClassCastException();
        }
        INumericVariable iNumericVariable = (INumericVariable)iVariable;
        iNumericVariable.setValue(bigInteger);
    }

    @Override
    public void setVariable(String string, float f) {
        IVariable iVariable = this.getVariable(string);
        ContextType contextType = iVariable.getContextType();
        if (!ContextType.NUMERIC.isTypeOfMine(contextType)) {
            throw new ClassCastException();
        }
        INumericVariable iNumericVariable = (INumericVariable)iVariable;
        iNumericVariable.setValue(f);
    }

    @Override
    public void setVariable(String string, double d) {
        IVariable iVariable = this.getVariable(string);
        ContextType contextType = iVariable.getContextType();
        if (!ContextType.NUMERIC.isTypeOfMine(contextType)) {
            throw new ClassCastException();
        }
        INumericVariable iNumericVariable = (INumericVariable)iVariable;
        iNumericVariable.setValue(d);
    }

    @Override
    public void setVariable(String string, BigDecimal bigDecimal) {
        IVariable iVariable = this.getVariable(string);
        ContextType contextType = iVariable.getContextType();
        if (!ContextType.NUMERIC.isTypeOfMine(contextType)) {
            throw new ClassCastException();
        }
        INumericVariable iNumericVariable = (INumericVariable)iVariable;
        iNumericVariable.setValue(bigDecimal);
    }

    @Override
    public void setVariable(String string, boolean bl) {
        IVariable iVariable = this.getVariable(string);
        DataTypeInfo dataTypeInfo = iVariable.getDataTypeInfo();
        if (dataTypeInfo.getDataType() != -7) {
            throw new ClassCastException();
        }
        VBoolean vBoolean = (VBoolean)iVariable;
        vBoolean.setValue(bl);
    }

    @Override
    public void setVariable(String string, Date date) {
        IVariable iVariable = this.getVariable(string);
        DataTypeInfo dataTypeInfo = iVariable.getDataTypeInfo();
        if (dataTypeInfo.getDataType() != 91) {
            throw new ClassCastException();
        }
        VDate vDate = (VDate)iVariable;
        vDate.setValue(date);
    }

    @Override
    public void setVariable(String string, Time time2) {
        IVariable iVariable = this.getVariable(string);
        DataTypeInfo dataTypeInfo = iVariable.getDataTypeInfo();
        if (dataTypeInfo.getDataType() != 92) {
            throw new ClassCastException();
        }
        VTime vTime = (VTime)iVariable;
        vTime.setValue(time2);
    }

    @Override
    public void setVariable(String string, Timestamp timestamp) {
        IVariable iVariable = this.getVariable(string);
        DataTypeInfo dataTypeInfo = iVariable.getDataTypeInfo();
        if (dataTypeInfo.getDataType() != 93) {
            throw new ClassCastException();
        }
        VTimestamp vTimestamp = (VTimestamp)iVariable;
        vTimestamp.setValue(timestamp);
    }

    @Override
    public void setVariable(String string, String string2) {
        IVariable iVariable = this.getVariable(string);
        DataTypeInfo dataTypeInfo = iVariable.getDataTypeInfo();
        if (dataTypeInfo.getDataType() != 12) {
            throw new ClassCastException();
        }
        VString vString = (VString)iVariable;
        vString.setValue(string2);
    }

    @Override
    public void setVariable(String string, byte[] byArray) {
        IVariable iVariable = this.getVariable(string);
        DataTypeInfo dataTypeInfo = iVariable.getDataTypeInfo();
        if (dataTypeInfo.getDataType() != -2) {
            throw new ClassCastException();
        }
        VBytes vBytes = (VBytes)iVariable;
        vBytes.setValue(byArray);
    }

    @Override
    public void setVariable(String string, Blob blob) {
        IVariable iVariable = this.getVariable(string);
        DataTypeInfo dataTypeInfo = iVariable.getDataTypeInfo();
        if (dataTypeInfo.getDataType() != 2004) {
            throw new ClassCastException();
        }
        VBlob vBlob = (VBlob)iVariable;
        vBlob.setValue(blob);
    }

    @Override
    public void setVariable(String string, Clob clob) {
        IVariable iVariable = this.getVariable(string);
        DataTypeInfo dataTypeInfo = iVariable.getDataTypeInfo();
        if (dataTypeInfo.getDataType() != 2005) {
            throw new ClassCastException();
        }
        VClob vClob = (VClob)iVariable;
        vClob.setValue(clob);
    }

    @Override
    public void setVariable(String string, IRelationData iRelationData) {
        IVariable iVariable = this.getVariable(string);
        DataTypeInfo dataTypeInfo = iVariable.getDataTypeInfo();
        if (dataTypeInfo.getDataType() != Integer.MAX_VALUE) {
            throw new ClassCastException();
        }
        VRelation vRelation = (VRelation)iVariable;
        vRelation.setValue(iRelationData);
    }

    @Override
    public void setVariable(String string, Object object) {
        IVariable iVariable = this.getVariable(string);
        DataTypeInfo dataTypeInfo = iVariable.getDataTypeInfo();
        if (dataTypeInfo.getDataType() != 0x7FFFFFFD) {
            throw new ClassCastException();
        }
        VCustomer vCustomer = (VCustomer)iVariable;
        vCustomer.setValue(object);
    }
}

