/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.expression.context.implement;

import com.jinfonet.dataservice.expression.context.DataTypeInfo;
import jet.dataengine.api.DSException;

public class NumericDataTypeInfo
extends DataTypeInfo {
    protected static final int PRECISION_NOT_SPECIFY = -1;
    protected static final int SCALE_NOT_SPECIFY = -1;
    protected static final int PRECISION_BYTE = NumericDataTypeInfo.getPrecisionByMax(127.0);
    protected static final int PRECISION_SHORT = NumericDataTypeInfo.getPrecisionByMax(32767.0);
    protected static final int PRECISION_INTEGER = NumericDataTypeInfo.getPrecisionByMax(2.147483647E9);
    protected static final int PRECISION_LONG = NumericDataTypeInfo.getPrecisionByMax(9.223372036854776E18);
    protected static final int PRECISION_FLOAT = -1;
    protected static final int PRECISION_DOUBLE = -1;
    private int SEDU = -1;
    private int ceil = -1;

    protected static int getPrecisionByMax(double d) {
        return (int)Math.ceil(Math.log(d) / Math.log(10.0));
    }

    public NumericDataTypeInfo(int n, int n2, int n3) throws DSException {
        super(n);
        this.SEDU = n2;
        this.ceil = n3;
        this.PRECISION_BYTE();
    }

    private void PRECISION_BYTE() throws DSException {
        switch (this.dataType) {
            case -6: {
                this.typeSize = 1;
                break;
            }
            case 5: {
                this.typeSize = 2;
                break;
            }
            case 4: {
                this.typeSize = 4;
                break;
            }
            case -5: {
                this.typeSize = 8;
                break;
            }
            case 6: {
                this.typeSize = 4;
                break;
            }
            case 8: {
                this.typeSize = 8;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    public int getPrecision() {
        return this.SEDU;
    }

    public int getScale() {
        return this.ceil;
    }
}

