/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.expression.executor;

import com.jinfonet.dataservice.api.expression.relational.localrelation.ICartesian;
import com.jinfonet.dataservice.api.expression.relational.localrelation.IJoinOperator;
import com.jinfonet.dataservice.api.expression.relational.localrelation.IUnion;
import com.jinfonet.dataservice.api.expression.relational.op.IBinaryRelationOperator;
import com.jinfonet.dataservice.api.expression.relational.op.IExtend;
import com.jinfonet.dataservice.api.expression.relational.op.IProject;
import com.jinfonet.dataservice.api.expression.relational.op.IRelationSort;
import com.jinfonet.dataservice.api.expression.relational.op.ISelect;
import com.jinfonet.dataservice.api.expression.relational.op.ISingleRelationOperator;
import com.jinfonet.dataservice.api.expression.relational.op.ITopN;
import com.jinfonet.dataservice.api.schema.relational.JRelationMetaData;
import com.jinfonet.dataservice.expression.executor.IRelationOperatorExecutor;
import com.jinfonet.dataservice.expression.executor.impl.CartesianOpExecutor;
import com.jinfonet.dataservice.expression.executor.impl.ExtendOpExecutor;
import com.jinfonet.dataservice.expression.executor.impl.IExpressionExecutorEnv;
import com.jinfonet.dataservice.expression.executor.impl.JoinOpExecutor;
import com.jinfonet.dataservice.expression.executor.impl.MaxRowOpExecutor;
import com.jinfonet.dataservice.expression.executor.impl.ProjectOpExecutor;
import com.jinfonet.dataservice.expression.executor.impl.RelationSortOpExecutor;
import com.jinfonet.dataservice.expression.executor.impl.SelectOpExecutor;
import com.jinfonet.dataservice.expression.executor.impl.UnionOpExecutor;
import com.jinfonet.dataservice.relational.IRelationData;
import jet.dataengine.api.DSException;
import jet.dataengine.api.expression.OperatorToolKit;

public class RelationOpExecutorFactory {
    public static IRelationOperatorExecutor getSingleRelationOpExecutor(ISingleRelationOperator iSingleRelationOperator, String string, IRelationData iRelationData, JRelationMetaData jRelationMetaData, IExpressionExecutorEnv iExpressionExecutorEnv) throws DSException {
        if (OperatorToolKit.isSelect(iSingleRelationOperator.operatorType())) {
            return new SelectOpExecutor((ISelect)iSingleRelationOperator, string, iRelationData, jRelationMetaData, iExpressionExecutorEnv);
        }
        if (OperatorToolKit.isRelationSort(iSingleRelationOperator.operatorType())) {
            return new RelationSortOpExecutor((IRelationSort)iSingleRelationOperator, string, iRelationData, jRelationMetaData, iExpressionExecutorEnv);
        }
        if (OperatorToolKit.isExtend(iSingleRelationOperator.operatorType())) {
            return new ExtendOpExecutor((IExtend)iSingleRelationOperator, string, iRelationData, jRelationMetaData, iExpressionExecutorEnv);
        }
        if (OperatorToolKit.isProject(iSingleRelationOperator.operatorType())) {
            return new ProjectOpExecutor((IProject)iSingleRelationOperator, string, iRelationData, jRelationMetaData, iExpressionExecutorEnv);
        }
        if (OperatorToolKit.isRelationTopN(iSingleRelationOperator.operatorType())) {
            return new MaxRowOpExecutor((ITopN)iSingleRelationOperator, string, iRelationData, jRelationMetaData, iExpressionExecutorEnv);
        }
        throw new DSException(8500, new Object[]{"not support operator, type error: " + iSingleRelationOperator.operatorType()});
    }

    public static IRelationOperatorExecutor getBinaryRelationOpExecutor(IBinaryRelationOperator iBinaryRelationOperator, String string, IRelationData iRelationData, IRelationData iRelationData2, JRelationMetaData jRelationMetaData, IExpressionExecutorEnv iExpressionExecutorEnv) throws DSException {
        if (OperatorToolKit.isJoin(iBinaryRelationOperator.operatorType())) {
            return new JoinOpExecutor((IJoinOperator)iBinaryRelationOperator, string, iRelationData, iRelationData2, jRelationMetaData, iExpressionExecutorEnv);
        }
        if (OperatorToolKit.isCartesian(iBinaryRelationOperator.operatorType())) {
            return new CartesianOpExecutor((ICartesian)iBinaryRelationOperator, string, iRelationData, iRelationData2, jRelationMetaData, iExpressionExecutorEnv);
        }
        if (OperatorToolKit.isUnion(iBinaryRelationOperator.operatorType())) {
            return new UnionOpExecutor((IUnion)iBinaryRelationOperator, string, iRelationData, iRelationData2, jRelationMetaData, iExpressionExecutorEnv);
        }
        throw new DSException(8501, new Object[]{"not support operator, type error: " + iBinaryRelationOperator.operatorType()});
    }
}

