/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.expression.executor;

import com.jinfonet.webservice.security.api.WSSecurityContext;
import com.jinfonet.webservice.security.api.WSSecurityProcessor;
import com.jinfonet.webservice.security.api.WSSecurityProcessorFactory;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import jet.dataengine.api.DSException;
import jet.log.JRLogger;
import jet.util.Base64;
import jet.util.StringTools;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SOAPMessageProcessor {
    private static JRLogger SEDU;
    private static String addAttribute;
    private static String addChildElement;
    private static String addHeader;
    private static String addNamespaceDeclaration;
    private static String addTextNode;
    private static String append;
    private static String call;
    private static String close;
    private static String contains;
    private static String create;

    private SOAPMessageProcessor() {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getResult(QName qName, String[] stringArray, Element[] elementArray, WSSecurityContext[] wSSecurityContextArray, String[] stringArray2, String string, String[] stringArray3, String string2, String string3) throws DSException {
        SOAPConnectionFactory sOAPConnectionFactory;
        if (stringArray != null && SEDU.isDebugEnabled()) {
            SEDU.debug("***operation QName: " + qName);
            for (int i = 0; i < stringArray.length; ++i) {
                SEDU.debug("***uri: " + i + " address is:" + stringArray[i]);
            }
        }
        long l = System.currentTimeMillis();
        String string4 = "";
        WSSecurityProcessor wSSecurityProcessor = null;
        SOAPMessage sOAPMessage = null;
        SOAPConnection sOAPConnection = null;
        try {
            sOAPConnectionFactory = SOAPConnectionFactory.newInstance();
            sOAPConnection = sOAPConnectionFactory.createConnection();
        }
        catch (SOAPException sOAPException) {
            throw new DSException(3091);
        }
        try {
            Object object;
            int n;
            sOAPConnectionFactory = MessageFactory.newInstance();
            SOAPMessage sOAPMessage2 = sOAPConnectionFactory.createMessage();
            SOAPPart sOAPPart = sOAPMessage2.getSOAPPart();
            SOAPEnvelope sOAPEnvelope = sOAPPart.getEnvelope();
            sOAPEnvelope.addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
            sOAPEnvelope.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            sOAPEnvelope.addNamespaceDeclaration("enc", "http://schemas.xmlsoap.org/soap/encoding/");
            sOAPEnvelope.addNamespaceDeclaration("env", "http://schemas.xmlsoap.org/soap/envelop/");
            sOAPEnvelope.setEncodingStyle("http://schemas.xmlsoap.org/soap/encoding/");
            SOAPBody sOAPBody = sOAPMessage2.getSOAPBody();
            SOAPElement sOAPElement = null;
            MimeHeaders mimeHeaders = sOAPMessage2.getMimeHeaders();
            String string5 = null;
            for (n = 0; n < stringArray3.length; ++n) {
                if (stringArray3[n] == null || stringArray3[n].trim().length() <= 0) continue;
                string5 = stringArray3[n];
                break;
            }
            if (SEDU.isDebugEnabled()) {
                SEDU.debug("***Get SOAP Action from wsdl definition: " + string5 + " namespaceURI is:" + qName.getNamespaceURI());
            }
            if (string5 == null) {
                string5 = qName.getNamespaceURI();
                if (string5 != null && string5.length() > 0) {
                    if (!string5.endsWith("/")) {
                        string5 = string5 + "/";
                    }
                    string5 = string5 + qName.getLocalPart();
                } else {
                    string5 = qName.getLocalPart();
                }
            }
            if (SEDU.isDebugEnabled()) {
                SEDU.debug("***SOAP Action: " + string5);
            }
            mimeHeaders.addHeader("SOAPAction", string5);
            if (!StringTools.nullOrAllSpaces(string2) && !StringTools.nullOrAllSpaces(string3)) {
                String string6 = string2 + ":" + string3;
                byte[] byArray = Base64.encode(string6);
                object = null;
                try {
                    object = new String(byArray, "8859_1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    object = new String(byArray);
                }
                mimeHeaders.addHeader("Authorization", "Basic " + (String)object);
            }
            if (elementArray != null && elementArray.length > 0) {
                SOAPMessageProcessor.addAttribute(sOAPBody, sOAPElement, elementArray, sOAPEnvelope, stringArray2, qName, string);
            }
            if (SEDU.isDebugEnabled()) {
                SEDU.debug("***SOAP request message without security info is as follows:\n" + SOAPMessageProcessor.SEDU(sOAPMessage2, true));
            }
            if (stringArray == null) throw new DSException(3093);
            int n2 = stringArray.length;
            for (n = 0; n < n2; ++n) {
                block40: {
                    if (wSSecurityContextArray != null && wSSecurityContextArray.length > 0 && wSSecurityContextArray[n] != null) {
                        if (SEDU.isDebugEnabled()) {
                            SEDU.debug("***Handling SOAP request message with security info.");
                        }
                        wSSecurityProcessor = WSSecurityProcessorFactory.create(wSSecurityContextArray[n]);
                        object = sOAPEnvelope.getOwnerDocument();
                        wSSecurityProcessor.doSecurity((Document)object);
                    }
                    sOAPMessage2.saveChanges();
                    if (SEDU.isDebugEnabled()) {
                        SEDU.debug("The uri is :" + stringArray[n]);
                        SEDU.debug("***SOAP request message with security info is as follows:\n" + SOAPMessageProcessor.SEDU(sOAPMessage2, true));
                    }
                    if ((sOAPMessage = sOAPConnection.call(sOAPMessage2, (Object)stringArray[n])).getSOAPBody().hasFault()) break block40;
                    if (SEDU.isDebugEnabled()) {
                        SEDU.debug("***We get the original response message(not decrypted),as follows:\n" + SOAPMessageProcessor.SEDU(sOAPMessage, false));
                    }
                    if (wSSecurityProcessor != null) {
                        object = sOAPMessage.getSOAPPart().getEnvelope().getOwnerDocument();
                        wSSecurityProcessor.decrypt((Document)object);
                        sOAPMessage.saveChanges();
                        if (sOAPMessage.getSOAPBody().hasFault()) {
                            if (!SEDU.isErrorEnabled()) throw new SOAPException();
                            SEDU.error("***We get the fault response message(after decrypting),as follows:\n" + SOAPMessageProcessor.SEDU(sOAPMessage, false));
                            throw new SOAPException();
                        }
                    }
                    sOAPMessage.saveChanges();
                    if (SEDU.isDebugEnabled()) {
                        SEDU.debug("***We get the final response message(which was decryped),as follows:\n" + SOAPMessageProcessor.SEDU(sOAPMessage, false) + "\n");
                    }
                    string4 = SOAPMessageProcessor.SEDU(sOAPMessage, false);
                    if (SEDU.isDebugEnabled()) {
                        SEDU.debug("***We get the final response message  which we use to generate the report,as follows:\n" + string4);
                    }
                    object = string4;
                    {
                        catch (SOAPException sOAPException) {
                            if (n == n2 - 1) throw new DSException(3092, (Throwable)sOAPException);
                            continue;
                        }
                    }
                    try {
                        if (sOAPConnection == null) return object;
                        sOAPConnection.close();
                        long l2 = System.currentTimeMillis();
                        long l3 = l2 - l;
                        if (!SEDU.isDebugEnabled()) return object;
                        SEDU.debug("***Soap response time :" + l3 + "ms");
                        return object;
                    }
                    catch (SOAPException sOAPException) {
                        throw new DSException(3095, (Object[])new String[]{" Details are :" + sOAPException.getMessage()}, (Throwable)sOAPException);
                    }
                }
                if (!SEDU.isErrorEnabled()) throw new SOAPException();
                SEDU.error("***We get the fault response message,as follows:\n" + SOAPMessageProcessor.SEDU(sOAPMessage, true));
                throw new SOAPException();
            }
        }
        catch (SOAPException sOAPException) {
            try {
                throw new DSException(3094, (Object[])new String[]{" Details are :" + sOAPException.getMessage()}, (Throwable)sOAPException);
            }
            catch (Throwable throwable) {
                try {
                    if (sOAPConnection == null) throw throwable;
                    sOAPConnection.close();
                    long l4 = System.currentTimeMillis();
                    long l5 = l4 - l;
                    if (!SEDU.isDebugEnabled()) throw throwable;
                    SEDU.debug("***Soap response time :" + l5 + "ms");
                    throw throwable;
                }
                catch (SOAPException sOAPException2) {
                    throw new DSException(3095, (Object[])new String[]{" Details are :" + sOAPException2.getMessage()}, (Throwable)sOAPException2);
                }
            }
        }
        try {
            if (sOAPConnection == null) throw new DSException(3096);
            sOAPConnection.close();
            long l6 = System.currentTimeMillis();
            long l7 = l6 - l;
            if (!SEDU.isDebugEnabled()) throw new DSException(3096);
            SEDU.debug("***Soap response time :" + l7 + "ms");
            throw new DSException(3096);
        }
        catch (SOAPException sOAPException) {
            throw new DSException(3095, (Object[])new String[]{" Details are :" + sOAPException.getMessage()}, (Throwable)sOAPException);
        }
    }

    private static String SEDU(SOAPMessage sOAPMessage, boolean bl) throws SOAPException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        StringBuffer stringBuffer = new StringBuffer();
        SOAPPart sOAPPart = sOAPMessage.getSOAPPart();
        NodeList nodeList = null;
        if (bl) {
            nodeList = sOAPPart.getChildNodes();
        } else {
            NamedNodeMap namedNodeMap;
            SOAPEnvelope sOAPEnvelope = sOAPPart.getEnvelope();
            if (sOAPEnvelope.hasAttributes()) {
                namedNodeMap = sOAPEnvelope.getAttributes();
                for (int i = namedNodeMap.getLength() - 1; i >= 0; --i) {
                    Attr attr = (Attr)namedNodeMap.item(i);
                    String string = attr.getName();
                    String string2 = attr.getValue();
                    hashMap.put(string, string2);
                }
            }
            namedNodeMap = sOAPMessage.getSOAPBody();
            nodeList = namedNodeMap.getChildNodes();
        }
        stringBuffer = SOAPMessageProcessor.call(nodeList, stringBuffer, 0, hashMap);
        return stringBuffer.toString();
    }

    private static void addAttribute(SOAPBody sOAPBody, SOAPElement sOAPElement, Element[] elementArray, SOAPEnvelope sOAPEnvelope, String[] stringArray, QName qName, String string) throws SOAPException {
        block4: {
            String string2;
            block5: {
                int n;
                block3: {
                    if (!string.equals("20")) break block3;
                    SOAPMessageProcessor.addChildElement((SOAPElement)sOAPBody, sOAPElement, elementArray[0], sOAPEnvelope);
                    break block4;
                }
                if (!string.equals("11")) break block4;
                string2 = null;
                for (n = 0; n < stringArray.length; ++n) {
                    if (stringArray[n] == null || stringArray[n].trim().length() <= 0) continue;
                    string2 = stringArray[n];
                    break;
                }
                if (string2 != null && !string2.equalsIgnoreCase("document")) break block5;
                for (n = 0; n < elementArray.length; ++n) {
                    SOAPMessageProcessor.addChildElement((SOAPElement)sOAPBody, sOAPElement, elementArray[n], sOAPEnvelope);
                }
                break block4;
            }
            if (!string2.equalsIgnoreCase("rpc")) break block4;
            SOAPElement sOAPElement2 = sOAPBody.addChildElement(qName);
            for (int i = 0; i < elementArray.length; ++i) {
                SOAPMessageProcessor.addChildElement(sOAPElement2, sOAPElement, elementArray[i], sOAPEnvelope);
            }
        }
    }

    private static void addChildElement(SOAPElement sOAPElement, SOAPElement sOAPElement2, Element element, SOAPEnvelope sOAPEnvelope) throws SOAPException {
        String string = element.getNodeName();
        if (string.contains(":")) {
            String[] stringArray = string.split(":");
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            if (element.hasAttributes()) {
                NamedNodeMap namedNodeMap = element.getAttributes();
                Attr attr = SOAPMessageProcessor.addNamespaceDeclaration(string2, namedNodeMap);
                String string4 = attr.getValue();
                sOAPElement2 = sOAPElement.addChildElement(sOAPEnvelope.createName(string3, string2, string4));
                int n = namedNodeMap.getLength();
                for (int i = 0; i < n; ++i) {
                    Attr attr2 = (Attr)namedNodeMap.item(i);
                    String string5 = attr2.getName();
                    String string6 = attr2.getValue();
                    if (string5.contains(":")) {
                        String[] stringArray2 = string5.split(":");
                        String string7 = stringArray2[0];
                        String string8 = stringArray2[1];
                        if (string8.equals(string2) || !string7.equals("xmlns")) continue;
                        sOAPElement2.addNamespaceDeclaration(string8, string6);
                        continue;
                    }
                    sOAPElement2.addAttribute(new QName(string5), string6);
                }
            }
        } else {
            String string9 = SOAPMessageProcessor.addHeader(element);
            sOAPElement2 = sOAPElement.addChildElement(sOAPEnvelope.createName(string, "", string9));
            if (element.hasAttributes()) {
                NamedNodeMap namedNodeMap = element.getAttributes();
                int n = namedNodeMap.getLength();
                for (int i = 0; i < n; ++i) {
                    Attr attr = (Attr)namedNodeMap.item(i);
                    String string10 = attr.getName();
                    String string11 = attr.getValue();
                    if (string10.contains(":")) {
                        String[] stringArray = string10.split(":");
                        String string12 = stringArray[1];
                        sOAPElement2.addNamespaceDeclaration(string12, string11);
                        continue;
                    }
                    if (string10.equals("xmlns")) continue;
                    sOAPElement2.addAttribute(new QName(string10), string11);
                }
            }
        }
        if (element.hasChildNodes()) {
            SOAPMessageProcessor.addTextNode(sOAPElement2, element);
        }
    }

    private static String addHeader(Element element) {
        String string = "";
        if (element.hasAttributes()) {
            NamedNodeMap namedNodeMap = element.getAttributes();
            int n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                String string2 = attr.getName();
                String string3 = attr.getValue();
                if (!string2.equals("xmlns")) continue;
                return string3;
            }
        }
        return string;
    }

    private static Attr addNamespaceDeclaration(String string, NamedNodeMap namedNodeMap) {
        Attr attr = null;
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Attr attr2 = (Attr)namedNodeMap.item(i);
            String string2 = attr2.getName();
            if (!string2.contains(":")) continue;
            String[] stringArray = string2.split(":");
            String string3 = stringArray[0];
            String string4 = stringArray[1];
            if (!string4.equals(string) || !string3.equals("xmlns")) continue;
            attr = attr2;
            return attr;
        }
        return attr;
    }

    private static SOAPElement addTextNode(SOAPElement sOAPElement, Element element) throws SOAPException {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node;
            String string;
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() == 3 && !(string = (node = (Text)node2).getTextContent().trim()).equals("") && null != string) {
                sOAPElement.addTextNode(string);
            }
            if (node2.getNodeType() != 1) continue;
            node = (Element)node2;
            string = node.getNodeName();
            String[] stringArray = null;
            if (string.contains(":")) {
                stringArray = string.split(":");
                sOAPElement = node.getParentNode().equals(element) && !SOAPMessageProcessor.append(element).equals(node) ? sOAPElement.getParentElement().addChildElement(stringArray[1], stringArray[0]) : sOAPElement.addChildElement(stringArray[1], stringArray[0]);
            } else {
                sOAPElement = node.getParentNode().equals(element) && !SOAPMessageProcessor.append(element).equals(node) ? sOAPElement.getParentElement().addChildElement(string) : sOAPElement.addChildElement(string);
            }
            if (node.hasAttributes()) {
                NamedNodeMap namedNodeMap = node.getAttributes();
                int n2 = namedNodeMap.getLength();
                for (int j = 0; j < n2; ++j) {
                    Attr attr = (Attr)namedNodeMap.item(j);
                    String string2 = attr.getName();
                    String string3 = attr.getValue();
                    if (string2.contains(":")) {
                        String[] stringArray2 = string2.split(":");
                        String string4 = stringArray2[0];
                        String string5 = stringArray2[1];
                        sOAPElement = sOAPElement.addAttribute(new QName(string3, string5, string4), string3);
                        continue;
                    }
                    sOAPElement = sOAPElement.addAttribute(new QName(string2), string3);
                }
            }
            if (!node.hasChildNodes()) continue;
            SOAPMessageProcessor.addTextNode(sOAPElement, (Element)node);
        }
        return sOAPElement;
    }

    private static Element append(Element element) {
        Element element2 = null;
        if (element.hasChildNodes()) {
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                element2 = (Element)node;
                return element2;
            }
        }
        return element2;
    }

    private static StringBuffer call(NodeList nodeList, StringBuffer stringBuffer, int n, HashMap hashMap) {
        int n2 = nodeList.getLength();
        StringBuffer stringBuffer2 = new StringBuffer("");
        for (int i = 0; i < n2; ++i) {
            int n3;
            Node node;
            String string;
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() == 3 && !(string = (node = (Text)node2).getTextContent().trim()).equals("") && string != null) {
                string = SOAPMessageProcessor.close(string);
                stringBuffer.append(string);
            }
            if (node2.getNodeType() != 1) continue;
            node = (Element)node2;
            string = node.getNodeName();
            stringBuffer.append("<" + string);
            if (node.hasAttributes()) {
                NamedNodeMap namedNodeMap = node.getAttributes();
                for (int j = namedNodeMap.getLength() - 1; j >= 0; --j) {
                    Attr attr = (Attr)namedNodeMap.item(j);
                    String string2 = attr.getName();
                    String string3 = attr.getValue();
                    if (hashMap != null) {
                        hashMap.remove(string2);
                    }
                    stringBuffer.append(" " + string2 + "=\"" + string3 + "\"");
                }
            }
            int n4 = n3 = hashMap != null ? hashMap.size() : 0;
            if (i == 0 && n == 0 && hashMap != null && n3 > 0) {
                for (Map.Entry entry : hashMap.entrySet()) {
                    stringBuffer.append(" " + (String)entry.getKey() + "=\"" + (String)entry.getValue() + "\"");
                }
            }
            stringBuffer.append(">");
            if (node.hasChildNodes()) {
                NodeList nodeList2 = node.getChildNodes();
                SOAPMessageProcessor.call(nodeList2, stringBuffer, n + 1, null);
            }
            stringBuffer.append("</" + string + ">");
        }
        return stringBuffer;
    }

    private static String close(String string) {
        String string2 = string.replaceAll(addAttribute, addChildElement);
        string2 = string2.replaceAll(addHeader, addNamespaceDeclaration);
        string2 = string2.replaceAll(addTextNode, append);
        string2 = string2.replaceAll(call, close);
        string2 = string2.replaceAll(contains, create);
        return string2;
    }

    static {
        addAttribute = "&";
        addChildElement = "&amp;";
        addHeader = "<";
        addNamespaceDeclaration = "&lt;";
        addTextNode = ">";
        append = "&gt;";
        call = "'";
        close = "&apos;";
        contains = "\"";
        create = "&quot;";
        SEDU = JRLogger.getLogger(SOAPMessageProcessor.class.getName());
    }
}

