/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.expression.executor;

import com.jinfonet.dataservice.api.expression.relational.IRelationModelExpression;
import com.jinfonet.dataservice.api.schema.relational.JRelationModel;
import com.jinfonet.dataservice.api.schema.relational.datasource.xml.JXmlConnection;
import com.jinfonet.dataservice.api.schema.relational.datasource.xml.JXmlRelationModel;
import com.jinfonet.dataservice.api.schema.relational.datasource.xml.JXmlSchema;
import com.jinfonet.dataservice.expression.context.IContextable;
import com.jinfonet.dataservice.expression.context.implement.VRelation;
import com.jinfonet.dataservice.expression.executor.IRelationExpressionExecutor;
import com.jinfonet.dataservice.expression.executor.InstructionSet;
import com.jinfonet.dataservice.relational.IRelationData;
import com.jinfonet.dataservice.relational.datasource.xml.SaxParseProcess;
import com.jinfonet.dataservice.relational.swap.RelationPool;
import com.jinfonet.dataservice.schema.relational.TransformRelationModel;
import com.jinfonet.util.JRLog;
import com.jinfonet.webservice.policy.PolicyMap;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import jet.dataengine.api.DSException;
import jet.dataengine.api.datasource.xml.InstanceSOAPInfo;
import jet.dataengine.api.datasource.xml.InstanceStreamInfo;
import jet.dataengine.api.datasource.xml.XMLDSTool;
import jet.dataengine.api.datasource.xml.XMLInstanceSource;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.util.DSLog;
import jet.dataengine8.core.queryengine.transform.SoapRespondToolkit;
import jet.datasource.InputStreamFactory;
import org.w3c.dom.Element;

public class XMLQueryExecutor
implements IRelationExpressionExecutor {
    private String add = "";
    private JXmlSchema currentTimeMillis;
    private JXmlConnection debug;
    private JXmlRelationModel desiredAssertionStatus;
    private IRelationModelExpression expressionType;
    SaxParseProcess saxParseProcess;
    JXmlRelationModel[] models = null;
    private DSLog getAllRelationData = DSLog.getDSLog(this.getClass().getName());
    HashMap ro;

    public XMLQueryExecutor(HashMap hashMap) {
        this.ro = hashMap;
    }

    @Override
    public VRelation execute(IContextable iContextable, IExpression iExpression) throws DSException {
        if (iExpression.expressionType() == 229440) {
            this.expressionType = (IRelationModelExpression)iExpression;
            try {
                this.add = this.expressionType.getName();
            }
            catch (ConditionException conditionException) {
                throw new DSException(conditionException.getMessage());
            }
            IRelationData iRelationData = this.getResultRelation(this.expressionType);
            iContextable.setVariable(this.add, iRelationData);
            return (VRelation)iContextable.getVariable(this.add);
        }
        return null;
    }

    @Override
    public InstructionSet getInstructionSet() {
        return null;
    }

    @Override
    public boolean canResolveExpression(IContextable iContextable, IExpression iExpression) {
        return iExpression.expressionType() == 229440;
    }

    public IRelationData getResultRelation(IRelationModelExpression iRelationModelExpression) throws DSException {
        this.currentTimeMillis = (JXmlSchema)iRelationModelExpression.getRelationalSchema();
        this.debug = (JXmlConnection)this.currentTimeMillis.getDSConnection();
        this.desiredAssertionStatus = (JXmlRelationModel)iRelationModelExpression.getRecordModel();
        Object object = this.currentTimeMillis.getResult(this.desiredAssertionStatus.getQualifyName());
        if (object != null && object instanceof IRelationData) {
            if (!((IRelationData)object).isClosed()) {
                return (IRelationData)object;
            }
            this.currentTimeMillis.removeResult(this.desiredAssertionStatus.getQualifyName());
        }
        return this.getResult();
    }

    public JXmlRelationModel[] getModels() {
        return this.models;
    }

    public RelationPool getResult() throws DSException {
        RelationPool[] relationPoolArray = null;
        if (this.currentTimeMillis.getExecuteLevel() == 0) {
            JRelationModel[] jRelationModelArray = this.currentTimeMillis.getRelationModels();
            this.models = new JXmlRelationModel[jRelationModelArray.length];
            int n = jRelationModelArray.length;
            for (int i = 0; i < n; ++i) {
                this.models[i] = (JXmlRelationModel)jRelationModelArray[i];
            }
        } else if (this.currentTimeMillis.getExecuteLevel() == 1) {
            this.models = new JXmlRelationModel[1];
            this.models[0] = this.desiredAssertionStatus;
        }
        relationPoolArray = this.parseToGetResult(this.models);
        if (this.currentTimeMillis.getExecuteLevel() == 0) {
            // empty if block
        }
        for (int i = 0; i < this.models.length; ++i) {
            this.currentTimeMillis.holdResult(this.models[i].getQualifyName(), relationPoolArray[i]);
        }
        return (RelationPool)this.currentTimeMillis.getResult(this.desiredAssertionStatus.getQualifyName());
    }

    public RelationPool[] parseToGetResult(JXmlRelationModel[] jXmlRelationModelArray) {
        String string = this.debug.getUrl();
        Vector<JXmlRelationModel> vector = new Vector<JXmlRelationModel>();
        for (int i = 0; i < jXmlRelationModelArray.length; ++i) {
            vector.add(jXmlRelationModelArray[i]);
        }
        return SaxParseProcess.getAllResult(string, vector, this.ro);
    }

    public Map getAllResultSets(TransformRelationModel[] transformRelationModelArray, XMLInstanceSource xMLInstanceSource) throws DSException {
        long l = System.currentTimeMillis();
        TimeZone timeZone = TimeZone.getTimeZone(xMLInstanceSource.getTimeZone());
        Locale locale = xMLInstanceSource.getLocale();
        this.saxParseProcess = new SaxParseProcess(transformRelationModelArray, timeZone, locale, this.ro);
        if (xMLInstanceSource.wasStreaminfo()) {
            InputStreamFactory inputStreamFactory = xMLInstanceSource.getStreamInfo().getStreamFactory();
            assert (timeZone != null) : "the timezone is null";
            assert (locale != null) : "the locale is null";
            this.getAllRelationData.debug(" *** xmlinstance is input stream factory.");
            this.getAllRelationData.debug(" *** [input stream factory]:'" + inputStreamFactory + "' .***");
            this.getAllRelationData.debug(" *** [timeZone]:'" + timeZone + "' .***");
            InstanceStreamInfo instanceStreamInfo = xMLInstanceSource.getStreamInfo();
            if (xMLInstanceSource.needValidate()) {
                xMLInstanceSource.getXMLModelSource();
                XMLDSTool.isValidate(xMLInstanceSource.getXMLModelSource(), xMLInstanceSource);
            }
            Map map = this.saxParseProcess.getAllRelationData(inputStreamFactory, xMLInstanceSource.getStreamInfo().getConnectionName());
            long l2 = System.currentTimeMillis();
            this.getAllRelationData.debug(" *** complete xml data fetch. use time:" + (double)(l2 - l) / 1000.0 + " seconds");
            return map;
        }
        String string = xMLInstanceSource.getInstURI();
        assert (timeZone != null) : "the timezone is null";
        assert (locale != null) : "the locale is null";
        this.getAllRelationData.debug(" *** xmlinstance is uri.");
        this.getAllRelationData.debug(" *** [xmlUri]:'" + string + "' .***");
        this.getAllRelationData.debug(" *** [timeZone]:'" + timeZone + "' .***");
        if (xMLInstanceSource.needValidate()) {
            XMLDSTool.isValidate(xMLInstanceSource.getXMLModelSource(), xMLInstanceSource);
        }
        Map map = this.saxParseProcess.getAllRelationData(string);
        long l3 = System.currentTimeMillis();
        this.getAllRelationData.debug(" *** complete xml data fetch. use time:" + (double)(l3 - l) / 1000.0 + " seconds");
        return map;
    }

    public void cancel() {
        if (this.saxParseProcess != null) {
            this.saxParseProcess.setCancel(true);
        }
    }

    public Map getAllResultSets(TransformRelationModel[] transformRelationModelArray, XMLInstanceSource xMLInstanceSource, Element[] elementArray, PolicyMap policyMap, Hashtable hashtable, String string) throws DSException {
        TimeZone timeZone = TimeZone.getTimeZone(xMLInstanceSource.getTimeZone());
        Locale locale = xMLInstanceSource.getLocale();
        this.saxParseProcess = new SaxParseProcess(transformRelationModelArray, timeZone, locale, this.ro);
        InstanceSOAPInfo instanceSOAPInfo = xMLInstanceSource.getSOAPInfo();
        String string2 = SoapRespondToolkit.getSoapRespondForWebService(instanceSOAPInfo, elementArray, policyMap, hashtable, string);
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, "%%%%%%%%\t\tXMLQueryExecutor: Print soap respond for the instance source: ServiceQName = " + instanceSOAPInfo.getServiceQName() + ", OperationQName = " + instanceSOAPInfo.getInterfaceOperationQName());
            JRLog.trace(5, "%%%%%%%%\t\t" + string2);
        }
        Map map = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes("UTF-8"));
            map = this.saxParseProcess.getAllRelationData(byteArrayInputStream);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
            map = this.saxParseProcess.getAllRelationData(byteArrayInputStream);
        }
        return map;
    }

    String name() {
        return this.getClass().getName();
    }
}

