/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.expression.executor.conditiontools.executor;

import com.jinfonet.api.datatypes.Date;
import com.jinfonet.api.datatypes.Time;
import com.jinfonet.api.datatypes.Timestamp;
import com.jinfonet.dataservice.expression.executor.conditiontools.executor.FilterException;
import com.jinfonet.dataservice.expression.executor.conditiontools.executor.api.IVarNode;
import com.jinfonet.dataservice.expression.executor.conditiontools.executor.impl.VarNodeImpl;
import com.jinfonet.datatypes.JinfonetDate;
import com.jinfonet.datatypes.JinfonetTime;
import com.jinfonet.datatypes.JinfonetTimeStamp;
import java.math.BigDecimal;
import jet.connect.DbBigInt;
import jet.connect.DbBit;
import jet.connect.DbChar;
import jet.connect.DbDate;
import jet.connect.DbDecimal;
import jet.connect.DbDouble;
import jet.connect.DbTime;
import jet.connect.DbTimestamp;
import jet.connect.DbValue;

public class CalculateToolkit {
    public static IVarNode getNewDataTypeVarNode(int n, DbValue dbValue) throws FilterException {
        VarNodeImpl varNodeImpl = new VarNodeImpl();
        if (dbValue.isNull()) {
            varNodeImpl.putNull();
            return varNodeImpl;
        }
        varNodeImpl.setDataType(n);
        switch (n) {
            case -5: {
                long l = ((DbBigInt)dbValue).get();
                varNodeImpl.putValue(l);
                break;
            }
            case 8: {
                double d = ((DbDouble)dbValue).get();
                varNodeImpl.putValue(d);
                break;
            }
            case 3: {
                BigDecimal bigDecimal = ((DbDecimal)dbValue).get();
                varNodeImpl.putValue(bigDecimal);
                break;
            }
            case 12: {
                String string = ((DbChar)dbValue).get();
                varNodeImpl.putValue(string);
                break;
            }
            case 91: {
                JinfonetDate jinfonetDate = new JinfonetDate(((DbDate)dbValue).get());
                varNodeImpl.putValue(jinfonetDate);
                break;
            }
            case 92: {
                JinfonetTime jinfonetTime = new JinfonetTime(((DbTime)dbValue).get());
                varNodeImpl.putValue(jinfonetTime);
                break;
            }
            case 93: {
                JinfonetTimeStamp jinfonetTimeStamp = new JinfonetTimeStamp(((DbTimestamp)dbValue).get());
                varNodeImpl.putValue(jinfonetTimeStamp);
                break;
            }
            case -7: {
                boolean bl = ((DbBit)dbValue).get();
                varNodeImpl.putValue(bl);
                break;
            }
            default: {
                throw new FilterException(5835, new String[]{"Unsupport data type in filter expression!"});
            }
        }
        return varNodeImpl;
    }

    public static void setValue2DbValue(IVarNode iVarNode, DbValue dbValue) throws FilterException {
        switch (iVarNode.getDataType()) {
            case -5: {
                long l = iVarNode.getLong();
                ((DbBigInt)dbValue).set(l);
                break;
            }
            case 8: {
                double d = iVarNode.getDouble();
                ((DbDouble)dbValue).set(d);
                break;
            }
            case 3: {
                BigDecimal bigDecimal = iVarNode.getBigDecimal();
                ((DbDecimal)dbValue).set(bigDecimal);
                break;
            }
            case 12: {
                String string = iVarNode.getString();
                ((DbChar)dbValue).set(string);
                break;
            }
            case 91: {
                Date date = iVarNode.getDate();
                ((DbDate)dbValue).set(date.getTime());
                break;
            }
            case 92: {
                Time time2 = iVarNode.getTime();
                ((DbTime)dbValue).set(time2.getTime());
                break;
            }
            case 93: {
                Timestamp timestamp = iVarNode.getTimestamp();
                ((DbTimestamp)dbValue).set(timestamp.getTime());
                ((DbTimestamp)dbValue).setNanos(timestamp.getNanos());
                break;
            }
            case -7: {
                boolean bl = iVarNode.getBoolean();
                ((DbBit)dbValue).set(bl);
                break;
            }
            default: {
                throw new FilterException(5835, new String[]{"Unsupport data type in filter expression!"});
            }
        }
    }
}

