/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.expression.executor.conditiontools.executor.impl;

import com.jinfonet.api.datatypes.Date;
import com.jinfonet.api.datatypes.Time;
import com.jinfonet.api.datatypes.Timestamp;
import com.jinfonet.api.datatypes.Types;
import com.jinfonet.dataservice.expression.executor.conditiontools.executor.FilterException;
import com.jinfonet.dataservice.expression.executor.conditiontools.executor.api.ExpTypes;
import com.jinfonet.dataservice.expression.executor.conditiontools.executor.api.IBinaryConditionExpression;
import com.jinfonet.dataservice.expression.executor.conditiontools.executor.api.IVar;
import com.jinfonet.dataservice.expression.executor.conditiontools.executor.api.IVarList;
import com.jinfonet.dataservice.expression.executor.conditiontools.executor.api.IVarNode;
import java.math.BigDecimal;
import jet.dataengine.api.expression.IFilterExpression;

public abstract class ABinaryConditionExpression
implements IBinaryConditionExpression {
    static byte DOUBLE_NAN = 1;
    static byte DOUBLE_POSITIVE_INFINITY = (byte)2;
    static byte DOUBLE_NEGATIVE_INFINITY = (byte)3;
    static byte EQUAL = 0;
    static byte LESS = (byte)-1;
    static byte GREATER = 1;
    static byte NOTEQUAL = (byte)2;
    static byte UNKNOWN = (byte)-2;
    protected IFilterExpression leftValue = null;
    protected IFilterExpression rightValue = null;

    protected ABinaryConditionExpression(IFilterExpression iFilterExpression, IFilterExpression iFilterExpression2) throws FilterException {
        int n = iFilterExpression.FilterType();
        if (!ExpTypes.isVariable(n) && !ExpTypes.isCalculateEXP(n)) {
            throw new FilterException(5822, new String[]{" Misinput filter expression! "});
        }
        this.leftValue = iFilterExpression;
        n = iFilterExpression2.FilterType();
        if (!ExpTypes.isVariable(n) && !ExpTypes.isCalculateEXP(n)) {
            throw new FilterException(5823, new String[]{" Misinput filter expression! "});
        }
        this.rightValue = iFilterExpression2;
    }

    @Override
    public IFilterExpression getLeftValue() {
        return this.leftValue;
    }

    @Override
    public IFilterExpression getRightValue() {
        return this.rightValue;
    }

    @Override
    public void setLeftValue(IFilterExpression iFilterExpression) {
        this.leftValue = iFilterExpression;
    }

    @Override
    public void setRightValue(IFilterExpression iFilterExpression) {
        this.rightValue = iFilterExpression;
    }

    public boolean containsALL(IVarList iVarList, IVarList iVarList2) throws FilterException {
        int n = iVarList.size();
        if (iVarList.isNull() || n == 0) {
            return true;
        }
        if (iVarList2.isNull() || iVarList2.size() == 0) {
            return false;
        }
        int n2 = ((IVarNode)iVarList2.getNode(0)).getDataType();
        int n3 = ((IVarNode)iVarList.getNode(0)).getDataType();
        if (Types.isNumeric(n3) && Types.isNumeric(n2)) {
            n3 = Types.getCompatibleNumaricType(n3, n2);
        }
        for (int i = 0; i < n; ++i) {
            IVarNode iVarNode = (IVarNode)iVarList.getNode(i);
            if (this.contains(iVarNode, iVarList2, n3)) continue;
            return false;
        }
        return true;
    }

    public byte checkNaN_infinity(IVarNode iVarNode, IVarNode iVarNode2) throws FilterException {
        double d;
        byte by = UNKNOWN;
        byte by2 = 0;
        int n = iVarNode.getDataType();
        if (n == 8) {
            d = iVarNode.getDouble();
            if (d == Double.NaN) {
                return NOTEQUAL;
            }
            if (d == Double.POSITIVE_INFINITY) {
                by2 = DOUBLE_POSITIVE_INFINITY;
            } else if (d == Double.NEGATIVE_INFINITY) {
                by2 = DOUBLE_NEGATIVE_INFINITY;
            }
        }
        if ((n = iVarNode2.getDataType()) == 8) {
            d = iVarNode2.getDouble();
            if (d == Double.NaN) {
                return NOTEQUAL;
            }
            if (d == Double.POSITIVE_INFINITY) {
                if (by2 == DOUBLE_POSITIVE_INFINITY) {
                    return EQUAL;
                }
                return LESS;
            }
            if (d == Double.NEGATIVE_INFINITY) {
                if (by2 == DOUBLE_NEGATIVE_INFINITY) {
                    return EQUAL;
                }
                return GREATER;
            }
        }
        if (by2 == DOUBLE_POSITIVE_INFINITY) {
            return GREATER;
        }
        if (by2 == DOUBLE_NEGATIVE_INFINITY) {
            return LESS;
        }
        return UNKNOWN;
    }

    public int getRealDataType(IVar iVar, IVar iVar2) throws FilterException {
        int n = iVar2.getDataType();
        int n2 = iVar.getDataType();
        if ((n2 == 2003 || iVar instanceof IVarList) && ((IVarList)iVar).size() > 0) {
            n2 = ((IVarNode)((IVarList)iVar).getNode(0)).getDataType();
        }
        if ((n == 2003 || iVar2 instanceof IVarList) && ((IVarList)iVar2).size() > 0) {
            n = ((IVarNode)((IVarList)iVar2).getNode(0)).getDataType();
        }
        if (Types.isNumeric(n2) && Types.isNumeric(n)) {
            n2 = Types.getCompatibleNumaricType(n2, n);
        }
        return n2;
    }

    public boolean contains(IVarNode iVarNode, IVarList iVarList, int n) throws FilterException {
        if (iVarNode == null) {
            return true;
        }
        if (iVarList == null || iVarList.size() == 0) {
            return false;
        }
        if (iVarNode.isNull()) {
            for (int i = 0; i < iVarList.size(); ++i) {
                if (!((IVarNode)iVarList.getNode(i)).isNull()) continue;
                return true;
            }
            return false;
        }
        if (n == -1) {
            n = iVarNode.getDataType();
            int n2 = -1;
            if (iVarList.size() > 0) {
                n2 = ((IVarNode)iVarList.getNode(0)).getDataType();
            }
            if (Types.isNumeric(n) && Types.isNumeric(n2)) {
                n = Types.getCompatibleNumaricType(n, n2);
            }
        }
        switch (n) {
            case -5: {
                long l = iVarNode.getLong();
                for (int i = 0; i < iVarList.size(); ++i) {
                    IVarNode iVarNode2 = (IVarNode)iVarList.getNode(i);
                    if (l != iVarNode2.getLong()) continue;
                    return true;
                }
                return false;
            }
            case 8: {
                double d = iVarNode.getDouble();
                for (int i = 0; i < iVarList.size(); ++i) {
                    IVarNode iVarNode3 = (IVarNode)iVarList.getNode(i);
                    if (!(Math.abs(d - iVarNode3.getDouble()) < 4.0E-16)) continue;
                    return true;
                }
                return false;
            }
            case 3: {
                BigDecimal bigDecimal = iVarNode.getBigDecimal();
                for (int i = 0; i < iVarList.size(); ++i) {
                    IVarNode iVarNode4 = (IVarNode)iVarList.getNode(i);
                    if (!(Math.abs(bigDecimal.subtract(iVarNode4.getBigDecimal()).doubleValue()) < 4.0E-16)) continue;
                    return true;
                }
                return false;
            }
            case 12: {
                String string = iVarNode.getString();
                for (int i = 0; i < iVarList.size(); ++i) {
                    IVarNode iVarNode5 = (IVarNode)iVarList.getNode(i);
                    if (!(iVarNode.getCaseSensitive() ? string.equals(iVarNode5.getString()) : string.toUpperCase().equals(iVarNode5.getString().toUpperCase()))) continue;
                    return true;
                }
                return false;
            }
            case 91: {
                Date date = iVarNode.getDate();
                for (int i = 0; i < iVarList.size(); ++i) {
                    IVarNode iVarNode6 = (IVarNode)iVarList.getNode(i);
                    if (!date.equals(iVarNode6.getDate())) continue;
                    return true;
                }
                return false;
            }
            case 92: {
                Time time2 = iVarNode.getTime();
                for (int i = 0; i < iVarList.size(); ++i) {
                    IVarNode iVarNode7 = (IVarNode)iVarList.getNode(i);
                    if (!time2.equals(iVarNode7.getTime())) continue;
                    return true;
                }
                return false;
            }
            case 93: {
                Timestamp timestamp = iVarNode.getTimestamp();
                for (int i = 0; i < iVarList.size(); ++i) {
                    IVarNode iVarNode8 = (IVarNode)iVarList.getNode(i);
                    if (!timestamp.equals(iVarNode8.getTimestamp())) continue;
                    return true;
                }
                return false;
            }
            case -7: {
                Boolean bl = iVarNode.getBoolean();
                for (int i = 0; i < iVarList.size(); ++i) {
                    IVarNode iVarNode9 = (IVarNode)iVarList.getNode(i);
                    if (!bl.equals(iVarNode9.getBoolean())) continue;
                    return true;
                }
                return false;
            }
        }
        throw new FilterException(5836, new String[]{"Unsupport data type in filter expression!"});
    }
}

