/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.expression.executor.conditiontools.executor.impl;

import com.jinfonet.api.datatypes.Date;
import com.jinfonet.api.datatypes.Time;
import com.jinfonet.api.datatypes.Timestamp;
import com.jinfonet.dataservice.expression.executor.conditiontools.executor.FilterException;
import com.jinfonet.dataservice.expression.executor.conditiontools.executor.api.ExpTypes;
import com.jinfonet.dataservice.expression.executor.conditiontools.executor.api.ICalculateExpression;
import com.jinfonet.dataservice.expression.executor.conditiontools.executor.api.IVar;
import com.jinfonet.dataservice.expression.executor.conditiontools.executor.api.IVarList;
import com.jinfonet.dataservice.expression.executor.conditiontools.executor.api.IVarNode;
import com.jinfonet.dataservice.expression.executor.conditiontools.executor.impl.ABinaryConditionExpression;
import java.math.BigDecimal;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.IFilterExpression;

public class InImpl
extends ABinaryConditionExpression {
    public InImpl(IVar iVar, IVar iVar2) throws FilterException {
        super(iVar, iVar2);
    }

    public InImpl(IFilterExpression iFilterExpression, IFilterExpression iFilterExpression2) throws FilterException {
        super(iFilterExpression, iFilterExpression2);
    }

    @Override
    public int FilterType() {
        return 299022;
    }

    @Override
    public String toExpString() throws ConditionException {
        return "(" + this.leftValue.toExpString() + " IN " + this.rightValue.toExpString() + ")";
    }

    @Override
    public boolean interpret() throws FilterException {
        IFilterExpression iFilterExpression = this.leftValue;
        IFilterExpression iFilterExpression2 = this.rightValue;
        IVarNode iVarNode = null;
        if (ExpTypes.isCalculateEXP(iFilterExpression.FilterType())) {
            iVarNode = ((ICalculateExpression)iFilterExpression).interpret();
        } else if (ExpTypes.isVariable(iFilterExpression.FilterType())) {
            iVarNode = (IVarNode)iFilterExpression;
        }
        IVarList iVarList = (IVarList)iFilterExpression2;
        if (iVarNode.getDataType() == 2003) {
            return this.containsALL(iVarNode.getArrayList(), iVarList);
        }
        if (iVarNode.isNull() && iVarList.size() == 0) {
            return true;
        }
        if (iVarNode.isNull()) {
            for (int i = 0; i < iVarList.size(); ++i) {
                if (!((IVarNode)iVarList.getNode(i)).isNull()) continue;
                return true;
            }
            return false;
        }
        int n = this.getRealDataType(iVarNode, iVarList);
        switch (n) {
            case -5: {
                long l = iVarNode.getLong();
                for (int i = 0; i < iVarList.size(); ++i) {
                    IVarNode iVarNode2 = (IVarNode)iVarList.getNode(i);
                    if (iVarNode2.isNull() || l != iVarNode2.getLong()) continue;
                    return true;
                }
                return false;
            }
            case 8: {
                double d = iVarNode.getDouble();
                for (int i = 0; i < iVarList.size(); ++i) {
                    IVarNode iVarNode3 = (IVarNode)iVarList.getNode(i);
                    if (iVarNode3.isNull() || !(Math.abs(d - iVarNode3.getDouble()) < 4.0E-16)) continue;
                    return true;
                }
                return false;
            }
            case 3: {
                BigDecimal bigDecimal = iVarNode.getBigDecimal();
                for (int i = 0; i < iVarList.size(); ++i) {
                    IVarNode iVarNode4 = (IVarNode)iVarList.getNode(i);
                    if (iVarNode4.isNull() || !(Math.abs(bigDecimal.subtract(iVarNode4.getBigDecimal()).doubleValue()) < 4.0E-16)) continue;
                    return true;
                }
                return false;
            }
            case 12: {
                String string = iVarNode.getString();
                for (int i = 0; i < iVarList.size(); ++i) {
                    IVarNode iVarNode5 = (IVarNode)iVarList.getNode(i);
                    if (iVarNode5.isNull() || !(iVarNode.getCaseSensitive() ? string.equals(iVarNode5.getString()) : string.toUpperCase().equals(iVarNode5.getString().toUpperCase()))) continue;
                    return true;
                }
                return false;
            }
            case 91: {
                Date date = iVarNode.getDate();
                for (int i = 0; i < iVarList.size(); ++i) {
                    IVarNode iVarNode6 = (IVarNode)iVarList.getNode(i);
                    if (iVarNode6.isNull() || !date.equals(iVarNode6.getDate())) continue;
                    return true;
                }
                return false;
            }
            case 92: {
                Time time2 = iVarNode.getTime();
                for (int i = 0; i < iVarList.size(); ++i) {
                    IVarNode iVarNode7 = (IVarNode)iVarList.getNode(i);
                    if (iVarNode7.isNull() || !time2.equals(iVarNode7.getTime())) continue;
                    return true;
                }
                return false;
            }
            case 93: {
                Timestamp timestamp = iVarNode.getTimestamp();
                for (int i = 0; i < iVarList.size(); ++i) {
                    IVarNode iVarNode8 = (IVarNode)iVarList.getNode(i);
                    if (iVarNode8.isNull() || !timestamp.equals(iVarNode8.getTimestamp())) continue;
                    return true;
                }
                return false;
            }
            case -7: {
                Boolean bl = iVarNode.getBoolean();
                for (int i = 0; i < iVarList.size(); ++i) {
                    IVarNode iVarNode9 = (IVarNode)iVarList.getNode(i);
                    if (iVarNode9.isNull() || !bl.equals(iVarNode9.getBoolean())) continue;
                    return true;
                }
                return false;
            }
        }
        throw new FilterException(5836, new String[]{"Unsupport data type in filter expression!"});
    }
}

