/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.expression.executor.conditiontools.executor.impl;

import com.jinfonet.dataservice.expression.executor.conditiontools.executor.FilterException;
import com.jinfonet.dataservice.expression.executor.conditiontools.executor.api.ExpTypes;
import com.jinfonet.dataservice.expression.executor.conditiontools.executor.api.ICalculateExpression;
import com.jinfonet.dataservice.expression.executor.conditiontools.executor.api.IVarNode;
import com.jinfonet.dataservice.expression.executor.conditiontools.executor.impl.ABinaryConditionExpression;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.IFilterExpression;

public final class LessThanImpl
extends ABinaryConditionExpression {
    public LessThanImpl(IFilterExpression iFilterExpression, IFilterExpression iFilterExpression2) throws FilterException {
        super(iFilterExpression, iFilterExpression2);
    }

    @Override
    public boolean interpret() throws FilterException {
        IFilterExpression iFilterExpression = this.leftValue;
        IFilterExpression iFilterExpression2 = this.rightValue;
        IVarNode iVarNode = null;
        if (ExpTypes.isCalculateEXP(iFilterExpression.FilterType())) {
            iVarNode = ((ICalculateExpression)iFilterExpression).interpret();
        } else if (ExpTypes.isVariable(iFilterExpression.FilterType())) {
            iVarNode = (IVarNode)iFilterExpression;
        }
        IVarNode iVarNode2 = null;
        if (ExpTypes.isCalculateEXP(iFilterExpression2.FilterType())) {
            iVarNode2 = ((ICalculateExpression)iFilterExpression2).interpret();
        } else if (ExpTypes.isVariable(iFilterExpression2.FilterType())) {
            iVarNode2 = (IVarNode)iFilterExpression2;
        }
        if (iVarNode.isNull() || iVarNode2.isNull()) {
            return false;
        }
        int n = this.getRealDataType(iVarNode, iVarNode2);
        switch (n) {
            case -5: {
                return iVarNode2.getLong() > iVarNode.getLong();
            }
            case 8: {
                byte by = this.checkNaN_infinity(iVarNode, iVarNode2);
                if (by == LESS) {
                    return true;
                }
                if (by != UNKNOWN) {
                    return false;
                }
                return iVarNode2.getDouble() - iVarNode.getDouble() > 4.0E-16;
            }
            case 3: {
                byte by = this.checkNaN_infinity(iVarNode, iVarNode2);
                if (by == LESS) {
                    return true;
                }
                if (by != UNKNOWN) {
                    return false;
                }
                return iVarNode2.getBigDecimal().subtract(iVarNode.getBigDecimal()).doubleValue() > 4.0E-16;
            }
            case 12: {
                if (iVarNode.getCaseSensitive()) {
                    return iVarNode2.getString().compareTo(iVarNode.getString()) > 0;
                }
                return iVarNode2.getString().toUpperCase().compareTo(iVarNode.getString().toUpperCase()) > 0;
            }
            case 91: {
                return iVarNode.getDate().before(iVarNode2.getDate());
            }
            case 92: {
                return iVarNode.getTime().before(iVarNode2.getTime());
            }
            case 93: {
                return iVarNode.getTimestamp().before(iVarNode2.getTimestamp());
            }
        }
        throw new FilterException(5841, new String[]{"Unsupport data type in filter expression!"});
    }

    @Override
    public int FilterType() {
        return ExpTypes.LESSTHAN;
    }

    @Override
    public String toExpString() throws ConditionException {
        return "(" + this.leftValue.toExpString() + " LESS THAN " + this.rightValue.toExpString() + ")";
    }
}

