/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.expression.executor.conditiontools.executor.impl;

import com.jinfonet.dataservice.expression.executor.conditiontools.executor.FilterException;
import com.jinfonet.dataservice.expression.executor.conditiontools.executor.api.ExpTypes;
import com.jinfonet.dataservice.expression.executor.conditiontools.executor.api.ICalculateExpression;
import com.jinfonet.dataservice.expression.executor.conditiontools.executor.api.IVarList;
import com.jinfonet.dataservice.expression.executor.conditiontools.executor.api.IVarNode;
import com.jinfonet.dataservice.expression.executor.conditiontools.executor.impl.ABinaryConditionExpression;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.IFilterExpression;

public final class NotEqualsImpl
extends ABinaryConditionExpression {
    public NotEqualsImpl(IFilterExpression iFilterExpression, IFilterExpression iFilterExpression2) throws FilterException {
        super(iFilterExpression, iFilterExpression2);
    }

    @Override
    public boolean interpret() throws FilterException {
        IFilterExpression iFilterExpression = this.leftValue;
        IFilterExpression iFilterExpression2 = this.rightValue;
        IVarNode iVarNode = null;
        IVarList iVarList = null;
        if (ExpTypes.isCalculateEXP(iFilterExpression.FilterType())) {
            iVarNode = ((ICalculateExpression)iFilterExpression).interpret();
        } else if (ExpTypes.isVariable(iFilterExpression.FilterType())) {
            if (iFilterExpression instanceof IVarList) {
                iVarList = (IVarList)iFilterExpression;
            } else {
                iVarNode = (IVarNode)iFilterExpression;
                if (iVarNode.getDataType() == 2003) {
                    iVarList = iVarNode.getArrayList();
                }
            }
        }
        IVarNode iVarNode2 = null;
        IVarList iVarList2 = null;
        if (ExpTypes.isCalculateEXP(iFilterExpression2.FilterType())) {
            iVarNode2 = ((ICalculateExpression)iFilterExpression2).interpret();
        } else if (ExpTypes.isVariable(iFilterExpression2.FilterType())) {
            if (iFilterExpression2 instanceof IVarList) {
                iVarList2 = (IVarList)iFilterExpression2;
            } else {
                iVarNode2 = (IVarNode)iFilterExpression2;
                if (iVarNode2.getDataType() == 2003) {
                    iVarList2 = iVarNode2.getArrayList();
                }
            }
        }
        if (iVarList != null || iVarList2 != null) {
            if (iVarList == null) {
                if (iVarList2.size() != 1) {
                    return true;
                }
                iVarNode2 = (IVarNode)iVarList2.getNode(0);
            } else if (iVarList2 == null) {
                if (iVarList.size() != 1) {
                    return true;
                }
                iVarNode = (IVarNode)iVarList.getNode(0);
            } else {
                if (!this.containsALL(iVarList, iVarList2)) {
                    return true;
                }
                return !this.containsALL(iVarList2, iVarList);
            }
        }
        if (iVarNode.isNull() || iVarNode2.isNull()) {
            return false;
        }
        int n = this.getRealDataType(iVarNode, iVarNode2);
        switch (n) {
            case -5: {
                return iVarNode.getLong() != iVarNode2.getLong();
            }
            case 8: {
                byte by = this.checkNaN_infinity(iVarNode, iVarNode2);
                if (by == EQUAL) {
                    return false;
                }
                if (by != UNKNOWN) {
                    return true;
                }
                return !(Math.abs(iVarNode.getDouble() - iVarNode2.getDouble()) < 4.0E-16);
            }
            case 3: {
                byte by = this.checkNaN_infinity(iVarNode, iVarNode2);
                if (by == EQUAL) {
                    return false;
                }
                if (by != UNKNOWN) {
                    return true;
                }
                return !(Math.abs(iVarNode.getBigDecimal().subtract(iVarNode2.getBigDecimal()).doubleValue()) < 4.0E-16);
            }
            case 12: {
                if (iVarNode.getCaseSensitive()) {
                    return !iVarNode.getString().equals(iVarNode2.getString());
                }
                return !iVarNode.getString().toUpperCase().equals(iVarNode2.getString().toUpperCase());
            }
            case 91: {
                return !iVarNode.getDate().equals(iVarNode2.getDate());
            }
            case 92: {
                return !iVarNode.getTime().equals(iVarNode2.getTime());
            }
            case 93: {
                return !iVarNode.getTimestamp().equals(iVarNode2.getTimestamp());
            }
            case -7: {
                return iVarNode.getBoolean() != iVarNode2.getBoolean();
            }
        }
        throw new FilterException(5849, new String[]{"Unsupport data type in filter expression!"});
    }

    @Override
    public int FilterType() {
        return ExpTypes.NOTEQUALS;
    }

    @Override
    public String toExpString() throws ConditionException {
        return "(" + this.leftValue.toExpString() + " NOT EQUALS " + this.rightValue.toExpString() + ")";
    }
}

