/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.expression.executor.conditiontools.executor.impl;

import com.jinfonet.api.datatypes.Date;
import com.jinfonet.api.datatypes.Time;
import com.jinfonet.api.datatypes.Timestamp;
import com.jinfonet.dataservice.expression.executor.conditiontools.executor.FilterException;
import com.jinfonet.dataservice.expression.executor.conditiontools.executor.api.ExpTypes;
import com.jinfonet.dataservice.expression.executor.conditiontools.executor.api.ICalculateExpression;
import com.jinfonet.dataservice.expression.executor.conditiontools.executor.api.IVarList;
import com.jinfonet.dataservice.expression.executor.conditiontools.executor.api.IVarNode;
import com.jinfonet.dataservice.expression.executor.conditiontools.executor.impl.ABinaryConditionExpression;
import java.math.BigDecimal;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.IFilterExpression;

public class NotInImpl
extends ABinaryConditionExpression {
    public NotInImpl(IFilterExpression iFilterExpression, IFilterExpression iFilterExpression2) throws FilterException {
        super(iFilterExpression, iFilterExpression2);
    }

    @Override
    public boolean interpret() throws FilterException {
        IFilterExpression iFilterExpression = this.leftValue;
        IFilterExpression iFilterExpression2 = this.rightValue;
        IVarNode iVarNode = null;
        if (ExpTypes.isCalculateEXP(iFilterExpression.FilterType())) {
            iVarNode = ((ICalculateExpression)iFilterExpression).interpret();
        } else if (ExpTypes.isVariable(iFilterExpression.FilterType())) {
            iVarNode = (IVarNode)iFilterExpression;
        }
        IVarList iVarList = (IVarList)iFilterExpression2;
        if (iVarNode.getDataType() == 2003) {
            return !this.containsALL(iVarNode.getArrayList(), iVarList);
        }
        if (iVarNode.isNull() && iVarList.size() == 0) {
            return false;
        }
        if (iVarNode.isNull()) {
            for (int i = 0; i < iVarList.size(); ++i) {
                if (!((IVarNode)iVarList.getNode(i)).isNull()) continue;
                return false;
            }
            return true;
        }
        boolean bl = false;
        int n = this.getRealDataType(iVarNode, iVarList);
        switch (n) {
            case -5: {
                long l = iVarNode.getLong();
                for (int i = 0; i < iVarList.size(); ++i) {
                    IVarNode iVarNode2 = (IVarNode)iVarList.getNode(i);
                    if (l != iVarNode2.getLong()) continue;
                    return false;
                }
                return !bl;
            }
            case 8: {
                double d = iVarNode.getDouble();
                for (int i = 0; i < iVarList.size(); ++i) {
                    IVarNode iVarNode3 = (IVarNode)iVarList.getNode(i);
                    if (!(Math.abs(d - iVarNode3.getDouble()) < 4.0E-16)) continue;
                    return false;
                }
                return !bl;
            }
            case 3: {
                BigDecimal bigDecimal = iVarNode.getBigDecimal();
                for (int i = 0; i < iVarList.size(); ++i) {
                    IVarNode iVarNode4 = (IVarNode)iVarList.getNode(i);
                    if (!(Math.abs(bigDecimal.subtract(iVarNode4.getBigDecimal()).doubleValue()) < 4.0E-16)) continue;
                    return false;
                }
                return !bl;
            }
            case 12: {
                String string = iVarNode.getString();
                for (int i = 0; i < iVarList.size(); ++i) {
                    IVarNode iVarNode5 = (IVarNode)iVarList.getNode(i);
                    if (!(iVarNode.getCaseSensitive() ? string.equals(iVarNode5.getString()) : string.toUpperCase().equals(iVarNode5.getString().toUpperCase()))) continue;
                    return false;
                }
                return !bl;
            }
            case -7: {
                Boolean bl2 = iVarNode.getBoolean();
                for (int i = 0; i < iVarList.size(); ++i) {
                    IVarNode iVarNode6 = (IVarNode)iVarList.getNode(i);
                    if (!bl2.equals(iVarNode6.getBoolean())) continue;
                    return false;
                }
                return !bl;
            }
            case 91: {
                Date date = iVarNode.getDate();
                for (int i = 0; i < iVarList.size(); ++i) {
                    IVarNode iVarNode7 = (IVarNode)iVarList.getNode(i);
                    if (!date.equals(iVarNode7.getDate())) continue;
                    return false;
                }
                return !bl;
            }
            case 92: {
                Time time2 = iVarNode.getTime();
                for (int i = 0; i < iVarList.size(); ++i) {
                    IVarNode iVarNode8 = (IVarNode)iVarList.getNode(i);
                    if (!time2.equals(iVarNode8.getTime())) continue;
                    return false;
                }
                return !bl;
            }
            case 93: {
                Timestamp timestamp = iVarNode.getTimestamp();
                for (int i = 0; i < iVarList.size(); ++i) {
                    IVarNode iVarNode9 = (IVarNode)iVarList.getNode(i);
                    if (!timestamp.equals(iVarNode9.getTimestamp())) continue;
                    return false;
                }
                return !bl;
            }
        }
        throw new FilterException(5851, new String[]{"Unsupport data type in filter expression!"});
    }

    @Override
    public int FilterType() {
        return 299029;
    }

    @Override
    public String toExpString() throws ConditionException {
        return "(" + this.leftValue.toExpString() + " NOT IN " + this.rightValue.toExpString() + ")";
    }
}

