/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.expression.relational;

import com.jinfonet.dataservice.api.expression.relational.IRelationExpression;
import com.jinfonet.dataservice.api.expression.relational.op.IRelationOperator;
import com.jinfonet.dataservice.api.schema.relational.JAttribute;
import com.jinfonet.dataservice.api.schema.relational.JRelationMetaData;
import com.jinfonet.dataservice.expression.impl.AExpression;
import com.jinfonet.dataservice.relational.Attribute;
import jet.dataengine.api.DSException;
import jet.dataengine.api.expression.ConditionException;

public abstract class ARelationExpression
extends AExpression
implements IRelationExpression {
    protected final IRelationOperator operator;
    protected JRelationMetaData metaData;

    public ARelationExpression(String string, IRelationOperator iRelationOperator) throws ConditionException {
        super(string);
        if (iRelationOperator == null) {
            throw new ConditionException(8400, new Object[]{"operator was null"});
        }
        this.operator = iRelationOperator;
    }

    @Override
    public IRelationOperator getOperator() {
        return this.operator;
    }

    public abstract String toString();

    @Override
    public abstract int hashCode();

    @Override
    public abstract boolean equals(Object var1);

    protected JAttribute[] getAllSingleAtts(JRelationMetaData jRelationMetaData) throws ConditionException {
        JAttribute[] jAttributeArray = null;
        try {
            jAttributeArray = new JAttribute[jRelationMetaData.getColumnCount()];
            for (int i = 0; i < jRelationMetaData.getColumnCount(); ++i) {
                if (!(jRelationMetaData.getAttribute(i + 1) instanceof JAttribute)) {
                    throw new IllegalArgumentException("input relation metadata attribute is not Attribute");
                }
                jAttributeArray[i] = jRelationMetaData.getAttribute(i + 1);
            }
        }
        catch (DSException dSException) {
            throw new ConditionException(8410, (Throwable)dSException);
        }
        return jAttributeArray;
    }

    protected JAttribute[] getAllBinaryAtts(JRelationMetaData jRelationMetaData, JRelationMetaData jRelationMetaData2) throws ConditionException {
        JAttribute[] jAttributeArray = null;
        int n = 0;
        try {
            int n2;
            jAttributeArray = new JAttribute[jRelationMetaData.getColumnCount() + jRelationMetaData2.getColumnCount()];
            for (n2 = 0; n2 < jRelationMetaData.getColumnCount(); ++n2) {
                if (!(jRelationMetaData.getAttribute(n2 + 1) instanceof JAttribute)) {
                    throw new IllegalArgumentException("input relation metadata 1 attribute is not Attribute " + jRelationMetaData.getAttribute(n2 + 1).toString());
                }
                jAttributeArray[n++] = jRelationMetaData.getAttribute(n2 + 1);
            }
            for (n2 = 0; n2 < jRelationMetaData2.getColumnCount(); ++n2) {
                if (!(jRelationMetaData2.getAttribute(n2 + 1) instanceof JAttribute)) {
                    throw new IllegalArgumentException("input relation metadata 2 attribute is not Attribute " + jRelationMetaData2.getAttribute(n2 + 1).toString());
                }
                jAttributeArray[n++] = jRelationMetaData2.getAttribute(n2 + 1);
            }
        }
        catch (DSException dSException) {
            throw new ConditionException(8410, (Throwable)dSException);
        }
        return jAttributeArray;
    }

    protected JAttribute[] createAllAtts(JAttribute[] jAttributeArray) {
        JAttribute[] jAttributeArray2 = new JAttribute[jAttributeArray.length];
        for (int i = 0; i < jAttributeArray.length; ++i) {
            jAttributeArray2[i] = new Attribute(jAttributeArray[i]);
        }
        return jAttributeArray2;
    }

    @Override
    public String getStringValue(boolean bl) {
        throw new UnsupportedOperationException();
    }
}

