/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.expression.set;

import com.jinfonet.dataservice.expression.impl.AOperatorInformation;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.OperatorInfoToolkit;
import jet.dataengine.api.expression.info.ITopNInformation;

public final class TopNInformationImpl
extends AOperatorInformation
implements ITopNInformation {
    private double SEDU;
    private int append;

    public TopNInformationImpl(int n, double d) throws ConditionException {
        this.append = n;
        this.SEDU = d;
    }

    @Override
    public void check() throws ConditionException {
        if (!OperatorInfoToolkit.isTopNType(this.append)) {
            throw new ConditionException(8237, new Object[]{"top N type error : " + this.append});
        }
        if (this.SEDU < 0.0) {
            throw new ConditionException(8238, new Object[]{"top N is negative : " + this.SEDU});
        }
    }

    @Override
    public int getTopNType() {
        return this.append;
    }

    @Override
    public int getN() {
        return (int)Math.round(this.SEDU);
    }

    @Override
    public double getPercent() {
        return this.SEDU;
    }

    @Override
    public void setN(double d) throws ConditionException {
        this.SEDU = d;
    }

    @Override
    public int informationType() {
        return 16384;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        stringBuffer.append("<info : ");
        switch (this.append) {
            case 0: {
                stringBuffer.append("topN ");
                stringBuffer.append(Math.round(this.SEDU));
                break;
            }
            case 1: {
                stringBuffer.append("bottomN ");
                stringBuffer.append(Math.round(this.SEDU));
                break;
            }
            case 2: {
                stringBuffer.append("topPercent ");
                string = Double.toString(this.SEDU);
                if (string.length() < 4) {
                    string = string + "00";
                }
                stringBuffer.append(string.substring(0, string.indexOf(".") + 3));
                break;
            }
            case 3: {
                stringBuffer.append("bottomPercent ");
                string = Double.toString(this.SEDU);
                if (string.length() < 4) {
                    string = string + "00";
                }
                stringBuffer.append(string.substring(0, string.indexOf(".") + 3));
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown top-n type info: " + this.append);
            }
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        ITopNInformation iTopNInformation;
        if (object instanceof ITopNInformation && this.append == (iTopNInformation = (ITopNInformation)object).getTopNType()) {
            if (this.append == 1 || this.append == 0) {
                return this.getN() == iTopNInformation.getN();
            }
            if (this.append == 3 || this.append == 2) {
                return this.getPercent() - iTopNInformation.getPercent() < 4.0E-16;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.append == 1 || this.append == 0) {
            return this.getTopNType() + this.getN();
        }
        return this.getTopNType() + new Double(this.getPercent()).hashCode();
    }
}

