/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.expression.tuple;

import com.jinfonet.dataservice.expression.tuple.ASingleTupleExpression;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.OperatorTypes;
import jet.dataengine.api.expression.calculate.ICalculateExpression;
import jet.dataengine.api.expression.tuple.ISingleConditionExpression;
import jet.dataengine.api.expression.tuple.op.ISingleConditionOperator;
import jet.dataengine.api.expression.variable.IVariableExpression;
import jet.universe.businesslogic.JUnifiedBusinessView;

public final class SingleConditionExpressionImpl
extends ASingleTupleExpression
implements ISingleConditionExpression {
    public SingleConditionExpressionImpl(ISingleConditionOperator iSingleConditionOperator, IVariableExpression iVariableExpression) throws ConditionException {
        super(iSingleConditionOperator, iVariableExpression);
    }

    public SingleConditionExpressionImpl(ISingleConditionOperator iSingleConditionOperator, ICalculateExpression iCalculateExpression) throws ConditionException {
        super(iSingleConditionOperator, iCalculateExpression);
    }

    @Override
    public int expressionType() {
        return 0x121002;
    }

    @Override
    public void check() throws ConditionException {
    }

    @Override
    public String toExpString() throws ConditionException {
        return OperatorTypes.getOpTypeName(this.getOperator().operatorType()) + " ( " + this.getExpression().toExpString() + " )";
    }

    @Override
    public String toString() {
        String string = "op";
        try {
            string = OperatorTypes.getOpTypeName(this.getOperator().operatorType());
        }
        catch (ConditionException conditionException) {
            throw new RuntimeException("ConditionException", conditionException);
        }
        return string + " ( " + this.getExpression().toString() + " )";
    }

    @Override
    public void setExpression(IExpression iExpression) throws ConditionException {
        if (iExpression == null) {
            super.setExpression(null);
        }
        if (!ExpressionToolKit.isCalculateExp(iExpression.expressionType()) && !ExpressionToolKit.isVariableExp(iExpression.expressionType())) {
            throw new IllegalArgumentException("set sub exp must be calculate exp or variable exp, not " + iExpression.expressionType());
        }
        super.setExpression(iExpression);
    }

    @Override
    public String getStringValue(boolean bl) throws ConditionException {
        String string = "op";
        try {
            string = " " + OperatorTypes.getOpTypeValue(this.getOperator().operatorType()) + " ";
        }
        catch (ConditionException conditionException) {
            throw new RuntimeException("ConditionException", conditionException);
        }
        return this.getExpression().getStringValue(bl) + string;
    }

    @Override
    public String getStringValue(JUnifiedBusinessView jUnifiedBusinessView, boolean bl) throws ConditionException {
        String string = "op";
        try {
            string = " " + OperatorTypes.getOpTypeValue(this.getOperator().operatorType()) + " ";
        }
        catch (ConditionException conditionException) {
            throw new RuntimeException("ConditionException", conditionException);
        }
        return this.getExpression().getStringValue(jUnifiedBusinessView, bl) + string;
    }
}

