/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.expression.tuple;

import com.jinfonet.dataservice.expression.tuple.ASingleTupleExpression;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.OperatorTypes;
import jet.dataengine.api.expression.tuple.IBooleanExpression;
import jet.dataengine.api.expression.tuple.ISingleLogicExpression;
import jet.dataengine.api.expression.tuple.op.ISingleLogicOperator;
import jet.dataengine.api.expression.variable.IVariableExpression;

public final class SingleLogicExpressionImpl
extends ASingleTupleExpression
implements ISingleLogicExpression {
    public SingleLogicExpressionImpl(ISingleLogicOperator iSingleLogicOperator, IVariableExpression iVariableExpression) throws ConditionException {
        super(iSingleLogicOperator, iVariableExpression);
    }

    public SingleLogicExpressionImpl(ISingleLogicOperator iSingleLogicOperator, IBooleanExpression iBooleanExpression) throws ConditionException {
        super(iSingleLogicOperator, iBooleanExpression);
    }

    @Override
    public int expressionType() {
        return 0x121001;
    }

    @Override
    public void check() throws ConditionException {
    }

    @Override
    public String toExpString() throws ConditionException {
        return OperatorTypes.getOpTypeName(this.getOperator().operatorType()) + " ( " + this.getExpression().toExpString() + " )";
    }

    @Override
    public String toString() {
        String string = "op";
        try {
            string = OperatorTypes.getOpTypeName(this.getOperator().operatorType());
        }
        catch (ConditionException conditionException) {
            throw new RuntimeException("ConditionException", conditionException);
        }
        return string + " ( " + this.getExpression().toString() + " )";
    }

    @Override
    public void setExpression(IExpression iExpression) throws ConditionException {
        if (iExpression == null) {
            super.setExpression(null);
        }
        if (!ExpressionToolKit.isBooleanExp(iExpression.expressionType()) && !ExpressionToolKit.isVariableExp(iExpression.expressionType())) {
            throw new IllegalArgumentException("set sub exp must be boolean exp or variable exp, not " + iExpression.expressionType());
        }
        super.setExpression(iExpression);
    }

    @Override
    public String getStringValue(boolean bl) throws ConditionException {
        String string = "op";
        try {
            string = " " + OperatorTypes.getOpTypeValue(this.getOperator().operatorType()) + " ";
        }
        catch (ConditionException conditionException) {
            throw new RuntimeException("ConditionException", conditionException);
        }
        return string + this.getExpression().getStringValue(bl);
    }
}

