/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.expression.variable;

import com.jinfonet.dataservice.ANamedObject;
import com.jinfonet.dataservice.api.expression.relational.IRelationExpression;
import com.jinfonet.dataservice.api.expression.relational.IRelationModelExpression;
import com.jinfonet.dataservice.api.expression.relational.op.IRelationOperator;
import com.jinfonet.dataservice.api.schema.relational.JRelationMetaData;
import com.jinfonet.dataservice.api.schema.relational.JRelationModel;
import com.jinfonet.dataservice.api.schema.relational.JRelationalSchema;
import com.jinfonet.dataservice.relational.RelationMetaData;
import jet.dataengine.api.DSException;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.ExpressionToolKit;

public abstract class ARelationModelExpression
extends ANamedObject
implements IRelationModelExpression {
    protected JRelationMetaData metaData;
    private JRelationalSchema SEDU;
    private JRelationModel append;
    private int expressionType;
    private boolean getAliasName;
    private String getAttribute;
    protected boolean isParenthesized = false;
    private String getAttributes;
    private boolean getColumnCount;

    public ARelationModelExpression(String string, String string2, JRelationalSchema jRelationalSchema, JRelationModel jRelationModel) throws ConditionException, DSException {
        super(string);
        if (jRelationalSchema == null) {
            throw new ConditionException(8410, new Object[]{"relation schema was null"});
        }
        this.SEDU = jRelationalSchema;
        if (jRelationModel == null) {
            throw new ConditionException(8411, new Object[]{"relation model was null"});
        }
        this.append = jRelationModel;
        if (string2 == null) {
            throw new ConditionException(8413, new Object[]{"relation as name was null"});
        }
        this.getAttribute = string2;
        this.expressionType = Integer.MAX_VALUE;
        this.getAliasName = true;
    }

    @Override
    public JRelationMetaData getResultMetaData() throws ConditionException {
        if (this.metaData == null) {
            if (this.append.getAttributes() == null) {
                throw new ConditionException(8412, new Object[]{"get attributes from relation model was null"});
            }
            this.metaData = new RelationMetaData(this.append.getAttributes());
        }
        return this.metaData;
    }

    @Override
    public boolean isLocal() {
        return this.getAliasName;
    }

    @Override
    public void setIsLocal(boolean bl) {
        this.getAliasName = bl;
    }

    @Override
    public int getDataType() {
        return this.expressionType;
    }

    @Override
    public void setDataType(int n) throws ConditionException {
        this.expressionType = n;
    }

    @Override
    public String getAsName() {
        return this.getAttribute;
    }

    @Override
    public JRelationalSchema getRelationalSchema() {
        return this.SEDU;
    }

    @Override
    public JRelationModel getRecordModel() {
        return this.append;
    }

    @Override
    public IRelationExpression getExpression() {
        return null;
    }

    @Override
    public IRelationOperator getOperator() {
        return null;
    }

    @Override
    public String toExpString() throws ConditionException {
        StringBuffer stringBuffer = new StringBuffer();
        if (ExpressionToolKit.isXMLRelationModelExp(this.expressionType())) {
            stringBuffer.append("XML RelationModel Exp");
        } else if (ExpressionToolKit.isRDBRelationModelExp(this.expressionType())) {
            stringBuffer.append("RDB RelationModel Exp");
        } else {
            stringBuffer.append("UNKNOWN RelationModel Exp");
        }
        stringBuffer.append(" - " + this.name + " [");
        this.SEDU(stringBuffer);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private void SEDU(StringBuffer stringBuffer) throws ConditionException {
        this.metaData = this.getResultMetaData();
        try {
            for (int i = 1; i <= this.metaData.getColumnCount(); ++i) {
                stringBuffer.append(this.metaData.getAttribute(i).getAliasName());
                if (i >= this.metaData.getColumnCount()) continue;
                stringBuffer.append(", ");
            }
        }
        catch (DSException dSException) {
            throw new ConditionException(dSException.getErrorKey(), (Throwable)dSException);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (ExpressionToolKit.isXMLRelationModelExp(this.expressionType())) {
            stringBuffer.append("XML_RM@");
        } else if (ExpressionToolKit.isRDBRelationModelExp(this.expressionType())) {
            stringBuffer.append("RDB_RM@");
        } else {
            stringBuffer.append("UNKNOWN_RM@");
        }
        stringBuffer.append(this.name);
        return stringBuffer.toString();
    }

    @Override
    public boolean isParenthesized() {
        return this.isParenthesized;
    }

    @Override
    public void parenthesize(boolean bl) {
        this.isParenthesized = bl;
    }

    @Override
    public String getErrorDescription() {
        return this.getAttributes;
    }

    @Override
    public boolean isError() {
        return this.getColumnCount;
    }

    @Override
    public void setErrorDescription(String string) {
        this.getAttributes = string;
    }

    @Override
    public void setIsError(boolean bl) {
        this.getColumnCount = bl;
    }
}

