/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.expression.variable;

import com.jinfonet.api.datatypes.Types;
import com.jinfonet.dataservice.expression.impl.AVariableExpression;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.variable.IConstant;

public final class ConstantImpl
extends AVariableExpression
implements IConstant {
    protected String strValue;
    protected Object obValue;
    protected boolean needParse = true;
    protected boolean isNull = false;
    protected boolean isSpecialField = false;
    private boolean I = false;

    public ConstantImpl(String string) throws ConditionException {
        super(string);
    }

    public ConstantImpl(String string, boolean bl) throws ConditionException {
        super(string);
        this.isSpecialField = bl;
        if (bl) {
            this.setValue("");
        }
    }

    @Override
    public boolean isSpecialField() {
        return this.isSpecialField;
    }

    @Override
    public void setObjectValue(Object object) throws ConditionException {
        this.obValue = object;
        this.needParse = false;
    }

    @Override
    public boolean needParse() {
        return this.needParse;
    }

    @Override
    public Object getObjectValue() throws ConditionException {
        if (this.isNull) {
            return null;
        }
        return this.obValue;
    }

    @Override
    public String getValue() throws ConditionException {
        if (this.isNull) {
            return null;
        }
        return this.strValue;
    }

    @Override
    public void check() throws ConditionException {
    }

    @Override
    public int expressionType() {
        return 32770;
    }

    @Override
    public String toExpString() throws ConditionException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("constant (");
        if (this.strValue == null && this.obValue != null) {
            this.strValue = this.obValue.toString();
        }
        try {
            if (this.dataType == 0) {
                stringBuffer.append("UNKNOWN DATATYPE");
            } else {
                stringBuffer.append(Types.getDataTypeName(this.dataType));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append("UNKNOWN DATATYPE");
        }
        stringBuffer.append(") -");
        stringBuffer.append(" <" + this.strValue + ">");
        return stringBuffer.toString();
    }

    @Override
    public void setValue(String string) throws ConditionException {
        if (string == null) {
            throw new ConditionException(8263, new Object[]{"constant value is null"});
        }
        this.strValue = string;
    }

    @Override
    public void setDataType(int n) throws ConditionException {
        if (Types.isTimeType(n) && this.needParse() && !this.isNull() && (!this.isSpecialField || this.strValue != null && this.strValue.trim().length() > 0)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
            if (n == 92) {
                simpleDateFormat.applyPattern("yyyy-MM-dd HH:mm:ss.SSS z");
                try {
                    this.obValue = simpleDateFormat.parse(this.strValue);
                }
                catch (ParseException parseException) {
                    simpleDateFormat.applyPattern("HH:mm:ss.SSS");
                    try {
                        this.obValue = simpleDateFormat.parse(this.strValue);
                    }
                    catch (ParseException parseException2) {
                        simpleDateFormat.applyPattern("HH:mm:ss");
                        try {
                            this.obValue = simpleDateFormat.parse(this.strValue);
                        }
                        catch (ParseException parseException3) {
                            throw new ConditionException(8264, new Object[]{"Error occurs when formatting strings of date type. Detail: " + parseException3.getMessage() + ". The data type: " + Types.getDataTypeName(n)});
                        }
                    }
                }
            } else if (n == 93) {
                simpleDateFormat.applyPattern("yyyy-MM-dd HH:mm:ss.SSS z");
                try {
                    this.obValue = simpleDateFormat.parse(this.strValue);
                }
                catch (ParseException parseException) {
                    simpleDateFormat.applyPattern("yyyy-MM-dd HH:mm:ss.SSS");
                    try {
                        this.obValue = simpleDateFormat.parse(this.strValue);
                    }
                    catch (ParseException parseException4) {
                        simpleDateFormat.applyPattern("yyyy-MM-dd HH:mm:ss");
                        try {
                            this.obValue = simpleDateFormat.parse(this.strValue);
                        }
                        catch (ParseException parseException5) {
                            throw new ConditionException(8272, new Object[]{"Error occurs when formatting strings of date type. Detail: " + parseException4.getMessage() + ". The data type: " + Types.getDataTypeName(n)});
                        }
                    }
                }
            } else if (n == 91) {
                simpleDateFormat.applyPattern("yyyy-MM-dd HH:mm:ss.SSS z");
                try {
                    this.obValue = simpleDateFormat.parse(this.strValue);
                }
                catch (ParseException parseException) {
                    simpleDateFormat.applyPattern("yyyy-MM-dd z");
                    try {
                        this.obValue = simpleDateFormat.parse(this.strValue);
                    }
                    catch (ParseException parseException6) {
                        simpleDateFormat.applyPattern("yyyy-MM-dd");
                        try {
                            this.obValue = simpleDateFormat.parse(this.strValue);
                        }
                        catch (ParseException parseException7) {
                            throw new ConditionException(8273, new Object[]{"Error occurs when formatting strings of date type. Detail: " + parseException7.getMessage() + ". The data type: " + Types.getDataTypeName(n)});
                        }
                    }
                }
            }
        }
        super.setDataType(n);
    }

    @Override
    public String toString() {
        if (this.isNull) {
            return "NULL";
        }
        if (this.strValue == null) {
            return "<" + this.obValue.toString() + ">";
        }
        return "<" + this.strValue + ">";
    }

    @Override
    public boolean equals(Object object) {
        block5: {
            if (object instanceof IConstant) {
                if (((IConstant)object).isSpecialField() != this.isSpecialField) {
                    return false;
                }
                try {
                    if (this.name.equalsIgnoreCase(((IConstant)object).getName()) && (this.needParse() ? this.strValue.equals(((IConstant)object).getValue()) : this.obValue.equals(((IConstant)object).getObjectValue()))) {
                        return this.dataType == ((IConstant)object).getDataType();
                    }
                }
                catch (ConditionException conditionException) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError((Object)"can't get constant value");
                }
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        Object object = this.strValue == null ? this.obValue : this.strValue;
        this.hashCode = 17;
        this.hashCode = this.hashCode * 37 + this.name.toUpperCase().hashCode();
        this.hashCode = this.hashCode * 37 + object.hashCode();
        this.hashCode = this.hashCode * 37 + this.dataType;
        return this.hashCode;
    }

    @Override
    public void setNull(boolean bl) {
        this.isNull = bl;
    }

    @Override
    public boolean isNull() {
        return this.isNull;
    }

    @Override
    public String getStringValue(boolean bl) throws ConditionException {
        if (this.isSpecialField) {
            return "@" + this.name;
        }
        if (this.isNull) {
            return "Null";
        }
        if (this.strValue == null) {
            return ((IExpression)this.obValue).getStringValue(bl);
        }
        return this.strValue;
    }

    @Override
    public boolean isAll() {
        return this.I;
    }

    @Override
    public void setIsAll(boolean bl) {
        this.I = bl;
    }

    @Override
    public String getStringValue(boolean bl, int n) throws ConditionException {
        return this.getStringValue(bl);
    }
}

