/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.expression.variable;

import com.jinfonet.api.datatypes.Types;
import com.jinfonet.dataservice.expression.impl.AVariableExpression;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.api.expression.ExpressionTypes;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.variable.IConstant;
import jet.dataengine.api.expression.variable.IFormula;
import jet.dataengine.api.expression.variable.IParameter;
import jet.dataengine.api.expression.variable.IVariableExpression;
import jet.dataengine.api.expression.variable.IVariableList;

public final class VariableListImpl
extends AVariableExpression
implements IVariableList {
    private List I = new LinkedList();

    public VariableListImpl(String string) throws ConditionException {
        super(string);
        this.dataType = 0;
    }

    @Override
    public int size() throws ConditionException {
        return this.I.size();
    }

    @Override
    public IVariableExpression getVariableExp(int n) throws ConditionException {
        return (IVariableExpression)this.I.get(n);
    }

    @Override
    public void check() throws ConditionException {
    }

    @Override
    public int expressionType() {
        return 32784;
    }

    @Override
    public String toExpString() throws ConditionException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("var list ");
        if (this.dataType == 0) {
            stringBuffer.append("(UNKNOWN DATATYPE) -");
        } else {
            try {
                stringBuffer.append("(" + Types.getDataTypeName(this.dataType) + ") -");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                stringBuffer.append("(UNKNOWN DATATYPE) -");
            }
        }
        Iterator iterator = this.I.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(" <");
            stringBuffer.append(((IVariableExpression)iterator.next()).toExpString() + ">");
        }
        return stringBuffer.toString();
    }

    @Override
    public void addConstant(IConstant iConstant) throws ConditionException {
        this.I.add(iConstant);
    }

    @Override
    public void addFormula(IFormula iFormula) throws ConditionException {
        this.I.add(iFormula);
    }

    @Override
    public void addParameter(IParameter iParameter) throws ConditionException {
        this.I.add(iParameter);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("VL@");
        Iterator iterator = this.I.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(" <");
            stringBuffer.append(((IVariableExpression)iterator.next()).toString() + ">");
        }
        return stringBuffer.toString();
    }

    @Override
    public void setConstant(IConstant iConstant, int n) throws ConditionException {
        if (n < 0 || n > this.I.size() - 1) {
            throw new ConditionException(8265, new Object[]{"index out of bounds : " + n});
        }
        this.I.set(n, iConstant);
    }

    @Override
    public void setFormula(IFormula iFormula, int n) throws ConditionException {
        if (n < 0 || n > this.I.size() - 1) {
            throw new ConditionException(8266, new Object[]{"index out of bounds : " + n});
        }
        this.I.set(n, iFormula);
    }

    @Override
    public int indexOf(IVariableExpression iVariableExpression) throws ConditionException {
        if (iVariableExpression == null) assert (false) : "sub expression was null";
        try {
            return this.I.indexOf(iVariableExpression);
        }
        catch (ClassCastException classCastException) {
            throw new ConditionException(8267, new Object[]{"indexing " + iVariableExpression.toString() + " error"}, (Throwable)classCastException);
        }
    }

    @Override
    public void setDataType(int n) throws ConditionException {
        super.setDataType(n);
        if (this.I.size() > 0) {
            for (IVariableExpression iVariableExpression : this.I) {
                if (ExpressionToolKit.isReference(iVariableExpression.expressionType()) || ExpressionToolKit.isConstant(iVariableExpression.expressionType()) || ExpressionToolKit.isFormula(iVariableExpression.expressionType()) || ExpressionToolKit.isParameter(iVariableExpression.expressionType())) {
                    iVariableExpression.setDataType(n);
                    continue;
                }
                assert (false) : "sub exp in list type error : " + ExpressionTypes.getExpressionName(iVariableExpression.expressionType());
            }
        }
    }

    @Override
    public int getDataType() {
        return this.dataType;
    }

    @Override
    public boolean equals(Object object) {
        block5: {
            if (object instanceof IVariableList) {
                try {
                    IVariableList iVariableList = (IVariableList)object;
                    if (this.size() != iVariableList.size()) {
                        return false;
                    }
                    Iterator iterator = this.I.iterator();
                    for (int i = 0; i < iVariableList.size(); ++i) {
                        if (iterator.next().equals(iVariableList.getVariableExp(i))) continue;
                        return false;
                    }
                    return true;
                }
                catch (ConditionException conditionException) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError((Object)"get sub-exp size error");
                }
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        this.hashCode = 17;
        Iterator iterator = this.I.iterator();
        while (iterator.hasNext()) {
            this.hashCode = this.hashCode * 37 + iterator.next().hashCode();
        }
        return this.hashCode;
    }

    @Override
    public void setParameter(IParameter iParameter, int n) throws ConditionException {
        if (n < 0 || n > this.I.size() - 1) {
            throw new ConditionException(8477, new Object[]{"index out of bounds : " + n});
        }
        this.I.set(n, iParameter);
    }

    @Override
    public String getStringValue(boolean bl) throws ConditionException {
        StringBuffer stringBuffer = new StringBuffer();
        IExpression iExpression = null;
        for (int i = 0; i < this.I.size(); ++i) {
            iExpression = (IExpression)this.I.get(i);
            if (i != this.I.size() - 1) {
                stringBuffer.append(iExpression.getStringValue(bl)).append(",");
                continue;
            }
            stringBuffer.append(iExpression.getStringValue(bl));
        }
        return stringBuffer.toString();
    }

    @Override
    public IVariableExpression remove(int n) {
        return (IVariableExpression)this.I.remove(n);
    }

    @Override
    public String getStringValue(boolean bl, int n) throws ConditionException {
        return this.getStringValue(bl);
    }
}

