/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.map;

import com.jinfonet.image.encoder.ImageFrameGrabber;
import com.jinfonet.image.encoder.gif.GIFEncoder;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import jet.controls.JetBigString;
import jet.controls.JetString;
import jet.export.util.ImageGrabber;
import jet.log.JRLogger;
import jet.report.JetRptArea;
import jet.report.JetRptAreaText;
import jet.report.JetRptMap;
import jet.report.JetRptPolyLine;
import jet.util.JpegEncoder;
import jet.util.MapUtil;

public class MapTools {
    private static JRLogger Compress = JRLogger.getLogger(MapTools.class.getName());
    public static final int ENCODE_ERR = -1;
    public static final int ENCODE_GIF = 1;
    public static final int ENCODE_JPEG = 2;
    public static final int ENCODE_LOSTFRAMES = 4;
    public static final float DEFAULTQUALITY = 0.75f;

    public static void createShapeImage(JetRptMap jetRptMap, String string) throws IOException {
        File file = null;
        boolean bl = true;
        String string2 = jetRptMap.name.get() + ".jpg";
        file = new File(string + string2);
        if (file.exists()) {
            file.delete();
            file.createNewFile();
        }
        int n = Unit.convertUnitToPixel(jetRptMap.getActualWidth());
        int n2 = Unit.convertUnitToPixel(jetRptMap.getActualHeight());
        JetRptArea[] jetRptAreaArray = jetRptMap.getAreas(false);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 5);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setBackground(Color.white);
        graphics2D.clearRect(0, 0, n, n2);
        graphics2D.setPaint(Color.black);
        for (int i = 0; i < jetRptAreaArray.length; ++i) {
            JetRptArea jetRptArea = jetRptAreaArray[i];
            int n3 = jetRptArea.type.intValue();
            JetString jetString = jetRptArea.coordParts;
            JetBigString jetBigString = jetRptArea.coords;
            int[][] nArray = MapUtil.parseAreaShapeCoordinate(n3, jetBigString.get(), jetString.get());
            for (int j = 0; j < nArray.length; ++j) {
                Polygon polygon = new Polygon();
                for (int k = 0; k < nArray[j].length; k += 2) {
                    polygon.addPoint(Unit.convertUnitToPixel(nArray[j][k]), Unit.convertUnitToPixel(nArray[j][k + 1]));
                }
                graphics2D.drawPolygon(polygon);
            }
        }
        ImageIO.write((RenderedImage)bufferedImage, "jpg", file);
        bufferedImage.flush();
        jetRptMap.src.set(string2);
    }

    private static void Compress(Graphics2D graphics2D, JetRptArea jetRptArea) {
        JetRptAreaText jetRptAreaText = jetRptArea.getAreaText();
        JetRptPolyLine jetRptPolyLine = (JetRptPolyLine)jetRptAreaText.getChildren().get(0);
        JetString jetString = (JetString)jetRptPolyLine.getPropertyByName("Coordinate");
        if (jetString != null && jetString.toString().length() != 0 && !jetRptPolyLine.invisible.booleanValue()) {
            Vector vector = MapTools.SEDU(jetString.toString());
            ArrayList arrayList = (ArrayList)vector.get(0);
            ArrayList arrayList2 = (ArrayList)vector.get(1);
            int n = arrayList.size();
            if (n != arrayList2.size()) {
                return;
            }
            float f = Unit.convertUnitToPixel((Integer)arrayList.get(0));
            float f2 = Unit.convertUnitToPixel((Integer)arrayList2.get(0));
            Point2D.Float float_ = new Point2D.Float(f, f2);
            for (int i = 1; i < n; ++i) {
                float f3 = Unit.convertUnitToPixel((Integer)arrayList.get(i));
                float f4 = Unit.convertUnitToPixel((Integer)arrayList2.get(i));
                Point2D.Float float_2 = new Point2D.Float(f3, f4);
                Line2D.Float float_3 = new Line2D.Float(float_, float_2);
                graphics2D.draw(float_3);
                float_ = float_2;
            }
            graphics2D.drawString(jetRptAreaText.text.get(), float_.x, float_.y);
        }
    }

    private static Vector SEDU(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        while (stringTokenizer.hasMoreElements()) {
            arrayList.add(Integer.valueOf(stringTokenizer.nextToken()));
            arrayList2.add(Integer.valueOf(stringTokenizer.nextToken()));
        }
        Vector<ArrayList<Integer>> vector = new Vector<ArrayList<Integer>>(2);
        vector.add(arrayList);
        vector.add(arrayList2);
        return vector;
    }

    public static byte[] createMapImage(JetRptMap jetRptMap) throws IOException {
        int n = Unit.convertUnitToPixel(jetRptMap.getActualWidth());
        int n2 = Unit.convertUnitToPixel(jetRptMap.getActualHeight());
        JetRptArea[] jetRptAreaArray = jetRptMap.getAreas(false);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 5);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setBackground(Color.white);
        graphics2D.clearRect(0, 0, n, n2);
        graphics2D.setPaint(Color.black);
        if (!jetRptMap.isData.booleanValue()) {
            for (int i = 0; i < jetRptAreaArray.length; ++i) {
                int n3;
                int n4;
                int n5;
                JetRptArea jetRptArea = jetRptAreaArray[i];
                int n6 = jetRptArea.type.intValue();
                JetString jetString = jetRptArea.coordParts;
                JetBigString jetBigString = jetRptArea.coords;
                int[][] nArray = MapUtil.parseAreaShapeCoordinate(n6, jetBigString.get(), jetString.get());
                if (n6 == 3 || n6 == 4) {
                    for (n5 = 0; n5 < nArray.length; ++n5) {
                        Polygon polygon = new Polygon();
                        for (n4 = 0; n4 < nArray[n5].length; n4 += 2) {
                            polygon.addPoint(Unit.convertUnitToPixel(nArray[n5][n4]), Unit.convertUnitToPixel(nArray[n5][n4 + 1]));
                        }
                        graphics2D.drawPolygon(polygon);
                    }
                    continue;
                }
                if (n6 == 1) {
                    n5 = nArray[0][0];
                    n3 = nArray[0][1];
                    n4 = nArray[0][2];
                    int n7 = nArray[0][3];
                    graphics2D.drawRect(n5, n3, n4, n7);
                    continue;
                }
                if (n6 != 2) continue;
                n5 = nArray[0][0];
                n3 = nArray[0][1];
                n4 = nArray[0][2];
                graphics2D.drawOval(n5, n3, n4, n4);
            }
        }
        return MapTools.renderImageToJpeg(bufferedImage);
    }

    private static String add(String string) {
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        string = string.substring(string.lastIndexOf("/") + 1);
        return string;
    }

    public static byte[] encoderImage(Image image, float f) throws IOException {
        byte[] byArray = null;
        ImageGrabber imageGrabber = new ImageGrabber(image);
        if (0.0f <= f && f <= 1.0f) {
            byArray = MapTools.addPoint(imageGrabber, f);
        } else {
            imageGrabber.processImage();
            boolean bl = imageGrabber.hasAlpha();
            byArray = bl ? MapTools.black(imageGrabber) : MapTools.addPoint(imageGrabber, -1.0f);
        }
        return byArray;
    }

    public static byte[] renderImageToGif(Image image) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        Vector vector = new Vector();
        new ImageFrameGrabber().startGrab(image, vector);
        GIFEncoder.encode(dataOutputStream, vector);
        return byteArrayOutputStream.toByteArray();
    }

    private static byte[] addPoint(ImageGrabber imageGrabber, float f) throws IOException {
        imageGrabber.processImage();
        BufferedImage bufferedImage = imageGrabber.convertToBufferedImage(false);
        byte[] byArray = MapTools.append(bufferedImage, f);
        return byArray;
    }

    public static byte[] renderImageToJpeg(Image image) throws IOException {
        ImageGrabber imageGrabber = new ImageGrabber(image);
        return MapTools.addPoint(imageGrabber, -1.0f);
    }

    public static byte[] renderImageToJpeg(Image image, float f) throws IOException {
        ImageGrabber imageGrabber = new ImageGrabber(image);
        return MapTools.addPoint(imageGrabber, f);
    }

    private static byte[] append(BufferedImage bufferedImage, float f) throws IOException {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(byteArrayOutputStream);
            ImageWriter imageWriter = null;
            Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName("JPG");
            if (iterator.hasNext()) {
                imageWriter = iterator.next();
            }
            imageWriter.setOutput(imageOutputStream);
            JPEGImageWriteParam jPEGImageWriteParam = new JPEGImageWriteParam(Locale.getDefault());
            jPEGImageWriteParam.setCompressionMode(2);
            if (f >= 0.0f && f <= 1.0f) {
                jPEGImageWriteParam.setCompressionQuality(f);
            }
            imageWriter.write(null, new IIOImage(bufferedImage, null, null), jPEGImageWriteParam);
            imageWriter.dispose();
            byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            if (byArray == null || byArray.length == 0) {
                JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)byteArrayOutputStream);
                JPEGEncodeParam jPEGEncodeParam = jPEGImageEncoder.getDefaultJPEGEncodeParam(bufferedImage);
                if (f >= 0.0f || f <= 1.0f) {
                    jPEGEncodeParam.setQuality(f, false);
                }
                jPEGImageEncoder.encode(bufferedImage);
                byArray = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.close();
                return byArray;
            }
        }
        catch (Exception exception) {
            JpegEncoder jpegEncoder = new JpegEncoder(bufferedImage, (int)(f * 100.0f), byteArrayOutputStream);
            jpegEncoder.Compress();
            byArray = byteArrayOutputStream.toByteArray();
        }
        return byArray;
    }

    private static byte[] black(ImageGrabber imageGrabber) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        imageGrabber.processImage();
        BufferedImage bufferedImage = imageGrabber.convertToBufferedImage(imageGrabber.hasAlpha());
        ImageIO.write((RenderedImage)bufferedImage, "PNG", byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return byArray;
    }

    public static byte[] renderImageToPNG(Image image) throws IOException {
        ImageGrabber imageGrabber = new ImageGrabber(image);
        return MapTools.black(imageGrabber);
    }
}

