/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.relational;

import com.jinfonet.api.datatypes.Array;
import com.jinfonet.api.datatypes.Blob;
import com.jinfonet.api.datatypes.Clob;
import com.jinfonet.api.datatypes.Date;
import com.jinfonet.api.datatypes.Time;
import com.jinfonet.api.datatypes.Timestamp;
import com.jinfonet.dataservice.api.schema.relational.JRelation;
import com.jinfonet.dataservice.relational.ARelation;
import com.jinfonet.dataservice.relational.IRelationData;
import com.jinfonet.dataservice.relational.IRowID;
import com.jinfonet.dataservice.relational.ITuple;
import com.jinfonet.dataservice.util.IntList;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jet.dataengine.api.DSException;

public abstract class AGeneralRelation
extends ARelation {
    protected final ITuple tuple;
    protected IRowID rowID;
    protected boolean isClose = false;
    protected final List subRelationDataList = new LinkedList();

    protected AGeneralRelation(String string, IRelationData iRelationData) throws DSException {
        super(string, iRelationData);
        this.tuple = iRelationData.createTuple();
        this.rowID = iRelationData.createRowID();
    }

    protected abstract void onGetValueBefore() throws DSException;

    protected abstract void onChangePosition() throws DSException;

    protected abstract void onClose() throws DSException;

    protected void beforeChangePosition(long l) throws DSException {
    }

    protected abstract boolean canClose() throws DSException;

    protected final void checkClose() throws DSException {
        if (this.isClose) {
            throw new DSException(1125);
        }
    }

    protected final void checkPosition() throws DSException {
        if (!this.rowID.currentRowIDIsAvailable()) {
            throw new IndexOutOfBoundsException("Position: " + this.rowID.getPosition());
        }
    }

    public final IntList getRowIDs() throws DSException {
        return this.rowID.getRowIDs();
    }

    @Override
    public final int getCurrentRowID() throws DSException {
        return this.rowID.getCurrentRowID();
    }

    @Override
    public final int size() throws DSException {
        return this.rowID.size();
    }

    @Override
    public final JRelation getRelation(String string) throws DSException {
        int n = this.findColumn(string);
        return this.getRelation(n);
    }

    @Override
    public final JRelation getRelation(int n) throws DSException {
        IRelationData iRelationData = this.getRelationData(n);
        return iRelationData.createRelation();
    }

    @Override
    public final IRelationData getRelationData(String string) throws DSException {
        int n = this.findColumn(string);
        return this.getRelationData(n);
    }

    @Override
    public final IRelationData getRelationData(int n) throws DSException {
        this.checkClose();
        this.checkPosition();
        this.onGetValueBefore();
        IRelationData iRelationData = this.tuple.getRelationData(n);
        this.subRelationDataList.add(iRelationData);
        return iRelationData;
    }

    @Override
    public final boolean next() throws DSException {
        this.checkClose();
        long l = this.getPosition();
        if (l == -1L) {
            l = 0L;
        }
        this.beforeChangePosition(l + 1L);
        boolean bl = this.rowID.next();
        this.onChangePosition();
        return bl;
    }

    @Override
    public final void close() throws DSException {
        if (!this.canClose()) {
            return;
        }
        if (this.isClose) {
            return;
        }
        this.onClose();
        for (IRelationData iRelationData : this.subRelationDataList) {
            if (iRelationData.isClosed()) continue;
            iRelationData.close();
        }
        this.subRelationDataList.clear();
        this.tuple.close();
        this.relationData.removeTuple(this.tuple);
        this.isClose = true;
    }

    @Override
    public final void beforeFirst() throws DSException {
        this.checkClose();
        this.rowID.beforeFirst();
        this.onChangePosition();
    }

    @Override
    public final void afterLast() throws DSException {
        this.checkClose();
        this.rowID.afterLast();
        this.onChangePosition();
    }

    @Override
    public final boolean first() throws DSException {
        this.checkClose();
        boolean bl = this.rowID.first();
        this.onChangePosition();
        return bl;
    }

    @Override
    public final boolean isAfterLast() throws DSException {
        this.checkClose();
        return this.rowID.isAfterLast();
    }

    @Override
    public final boolean isBeforeFirst() throws DSException {
        this.checkClose();
        return this.rowID.isBeforeFirst();
    }

    @Override
    public final boolean isFirst() throws DSException {
        this.checkClose();
        return this.rowID.isFirst();
    }

    @Override
    public final boolean isLast() throws DSException {
        this.checkClose();
        return this.rowID.isLast();
    }

    @Override
    public final boolean last() throws DSException {
        this.checkClose();
        boolean bl = this.rowID.last();
        this.onChangePosition();
        return bl;
    }

    @Override
    public final boolean previous() throws DSException {
        this.checkClose();
        boolean bl = this.rowID.previous();
        this.onChangePosition();
        return bl;
    }

    @Override
    public final boolean relative(int n) throws DSException {
        this.checkClose();
        boolean bl = this.rowID.relative(n);
        this.onChangePosition();
        return bl;
    }

    @Override
    public final void setFetchDirection(int n) throws DSException {
        this.checkClose();
        this.rowID.setFetchDirection(n);
    }

    @Override
    public final void setFetchSize(int n) throws DSException {
        this.checkClose();
        this.rowID.setFetchSize(n);
    }

    @Override
    public final void clearWarnings() throws DSException {
        this.checkClose();
        this.rowID.clearWarnings();
    }

    @Override
    public final void getWarnings() throws DSException {
        this.checkClose();
        this.rowID.getWarnings();
    }

    @Override
    public final int getFetchDirection() throws DSException {
        this.checkClose();
        return this.rowID.getFetchDirection();
    }

    @Override
    public final int getFetchSize() throws DSException {
        this.checkClose();
        return this.rowID.getFetchSize();
    }

    @Override
    public final long getExtent() throws DSException {
        this.checkClose();
        return this.rowID.getExtent();
    }

    @Override
    public final void setPosition(long l) throws DSException {
        this.checkClose();
        this.beforeChangePosition(l);
        this.rowID.setPosition(l);
        this.onChangePosition();
    }

    @Override
    public final long getPosition() throws DSException {
        this.checkClose();
        return this.rowID.getPosition();
    }

    @Override
    public final InputStream getAsciiStream(int n) throws DSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final InputStream getAsciiStream(String string) throws DSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final BigDecimal getBigDecimal(int n) throws DSException {
        this.checkClose();
        this.checkPosition();
        this.onGetValueBefore();
        return this.tuple.getBigDecimal(n);
    }

    @Override
    public final BigDecimal getBigDecimal(String string) throws DSException {
        int n = this.findColumn(string);
        return this.getBigDecimal(n);
    }

    @Override
    public final InputStream getBinaryStream(int n) throws DSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final InputStream getBinaryStream(String string) throws DSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Blob getBlob(int n) throws DSException {
        this.checkClose();
        this.checkPosition();
        this.onGetValueBefore();
        return this.tuple.getBlob(n);
    }

    @Override
    public final Blob getBlob(String string) throws DSException {
        int n = this.findColumn(string);
        return this.getBlob(n);
    }

    @Override
    public final boolean getBoolean(int n) throws DSException {
        this.checkClose();
        this.checkPosition();
        this.onGetValueBefore();
        return this.tuple.getBoolean(n);
    }

    @Override
    public final boolean getBoolean(String string) throws DSException {
        int n = this.findColumn(string);
        return this.getBoolean(n);
    }

    @Override
    public final byte getByte(int n) throws DSException {
        this.checkClose();
        this.checkPosition();
        this.onGetValueBefore();
        return this.tuple.getByte(n);
    }

    @Override
    public final byte getByte(String string) throws DSException {
        int n = this.findColumn(string);
        return this.getByte(n);
    }

    @Override
    public final byte[] getBytes(int n) throws DSException {
        this.checkClose();
        this.checkPosition();
        this.onGetValueBefore();
        return this.tuple.getBytes(n);
    }

    @Override
    public final byte[] getBytes(String string) throws DSException {
        int n = this.findColumn(string);
        return this.getBytes(n);
    }

    @Override
    public final Reader getCharacterStream(int n) throws DSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Reader getCharacterStream(String string) throws DSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Clob getClob(int n) throws DSException {
        this.checkClose();
        this.checkPosition();
        this.onGetValueBefore();
        return this.tuple.getClob(n);
    }

    @Override
    public final Clob getClob(String string) throws DSException {
        int n = this.findColumn(string);
        return this.getClob(n);
    }

    @Override
    public final Date getDate(int n) throws DSException {
        this.checkClose();
        this.checkPosition();
        this.onGetValueBefore();
        return this.tuple.getDate(n);
    }

    @Override
    public final Date getDate(String string) throws DSException {
        int n = this.findColumn(string);
        return this.getDate(n);
    }

    @Override
    public final Date getDate(int n, Calendar calendar) throws DSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Date getDate(String string, Calendar calendar) throws DSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final double getDouble(int n) throws DSException {
        this.checkClose();
        this.checkPosition();
        this.onGetValueBefore();
        return this.tuple.getDouble(n);
    }

    @Override
    public final double getDouble(String string) throws DSException {
        int n = this.findColumn(string);
        return this.getDouble(n);
    }

    @Override
    public final float getFloat(int n) throws DSException {
        this.checkClose();
        this.checkPosition();
        this.onGetValueBefore();
        return this.tuple.getFloat(n);
    }

    @Override
    public final float getFloat(String string) throws DSException {
        int n = this.findColumn(string);
        return this.getFloat(n);
    }

    @Override
    public final int getInt(int n) throws DSException {
        this.checkClose();
        this.checkPosition();
        this.onGetValueBefore();
        return this.tuple.getInt(n);
    }

    @Override
    public final int getInt(String string) throws DSException {
        int n = this.findColumn(string);
        return this.getInt(n);
    }

    @Override
    public final long getLong(int n) throws DSException {
        this.checkClose();
        this.checkPosition();
        this.onGetValueBefore();
        return this.tuple.getLong(n);
    }

    @Override
    public final long getLong(String string) throws DSException {
        int n = this.findColumn(string);
        return this.getLong(n);
    }

    @Override
    public final Object getObject(int n) throws DSException {
        this.checkClose();
        this.checkPosition();
        this.onGetValueBefore();
        return this.tuple.getObject(n);
    }

    @Override
    public final Object getObject(String string) throws DSException {
        int n = this.findColumn(string);
        return this.tuple.getObject(n);
    }

    @Override
    public final Object getObject(int n, Map map) throws DSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Object getObject(String string, Map map) throws DSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final short getShort(int n) throws DSException {
        this.checkClose();
        this.checkPosition();
        this.onGetValueBefore();
        return this.tuple.getShort(n);
    }

    @Override
    public final short getShort(String string) throws DSException {
        int n = this.findColumn(string);
        return this.getShort(n);
    }

    @Override
    public final String getString(int n) throws DSException {
        this.checkClose();
        this.checkPosition();
        this.onGetValueBefore();
        return this.tuple.getString(n);
    }

    @Override
    public final String getString(String string) throws DSException {
        int n = this.findColumn(string);
        return this.getString(n);
    }

    @Override
    public final Time getTime(int n) throws DSException {
        this.checkClose();
        this.checkPosition();
        this.onGetValueBefore();
        return this.tuple.getTime(n);
    }

    @Override
    public final Time getTime(String string) throws DSException {
        int n = this.findColumn(string);
        return this.getTime(n);
    }

    @Override
    public final Time getTime(int n, Calendar calendar) throws DSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Time getTime(String string, Calendar calendar) throws DSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Timestamp getTimestamp(int n) throws DSException {
        this.checkClose();
        this.checkPosition();
        this.onGetValueBefore();
        return this.tuple.getTimeStamp(n);
    }

    @Override
    public final Timestamp getTimestamp(String string) throws DSException {
        int n = this.findColumn(string);
        return this.getTimestamp(n);
    }

    @Override
    public final Timestamp getTimestamp(int n, Calendar calendar) throws DSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Timestamp getTimestamp(String string, Calendar calendar) throws DSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean wasNull() throws DSException {
        this.checkClose();
        this.checkPosition();
        this.onGetValueBefore();
        return this.tuple.wasNull();
    }

    @Override
    public Array getArray(int n) throws DSException {
        this.checkClose();
        this.checkPosition();
        this.onGetValueBefore();
        return this.tuple.getArray(n);
    }

    @Override
    public Array getArray(String string) throws DSException {
        int n = this.findColumn(string);
        return this.getArray(n);
    }
}

