/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.relational;

import com.jinfonet.api.datatypes.Types;
import com.jinfonet.dataservice.api.schema.relational.JAttribute;
import com.jinfonet.dataservice.relational.AAttribute;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import jet.dataengine.util.DSLog;

public class Attribute
extends AAttribute
implements Serializable,
Externalizable {
    private static final long serialVersionUID = 950644507088918394L;
    private static String SEDU = "Attribute";
    private DSLog logger = DSLog.getDSLog(this.getClass().getName());
    private String name;
    private int dataType;
    private int precision;
    private int scale;
    private int length;
    private int nullable;
    private boolean isCurrency;
    private int baseType = Integer.MIN_VALUE;
    private int hashCode;
    private boolean isConstant;
    private Object constant;

    public Attribute() {
    }

    public Attribute(String string, int n, int n2, int n3, int n4, int n5, boolean bl) {
        this.name = string;
        this.dataType = n;
        this.precision = n2;
        this.scale = n3;
        this.length = n4;
        this.nullable = n5;
        this.isCurrency = bl;
        this.aliasName = string;
        this.readOnlyFlag = true;
    }

    public Attribute(String string, int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) {
        this(string, n, n2, n3, n4, n5, bl);
        this.readOnlyFlag = bl2;
    }

    public Attribute(String string, int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, boolean bl3) {
        this(string, n, n2, n3, n4, n5, bl, bl2);
        this.isConstant = bl3;
    }

    public Attribute(String string, int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, int n6) {
        this(string, n, n2, n3, n4, n5, bl);
        this.readOnlyFlag = bl2;
        this.baseType = n6;
    }

    public Attribute(String string, String string2, int n, int n2, int n3, int n4, int n5, boolean bl) {
        this(string, n, n2, n3, n4, n5, bl);
        this.aliasName = string2;
    }

    public Attribute(String string, String string2, int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) {
        this(string, n, n2, n3, n4, n5, bl);
        this.aliasName = string2;
        this.readOnlyFlag = bl2;
    }

    public Attribute(JAttribute jAttribute) {
        this.name = jAttribute.getAttributeName();
        this.dataType = jAttribute.getDataType();
        this.precision = jAttribute.getPrecision();
        this.scale = jAttribute.getScale();
        this.length = jAttribute.getLength();
        this.nullable = jAttribute.isNullable();
        this.isCurrency = jAttribute.isCurrency();
        this.aliasName = jAttribute.getAliasName();
        this.readOnlyFlag = jAttribute.isReadOnly();
        this.isConstant = jAttribute.isConstant();
        if (jAttribute.getDataType() == 2003) {
            this.baseType = jAttribute.getBaseType();
        }
    }

    @Override
    public String getAttributeName() {
        return this.name;
    }

    @Override
    public int getDataType() {
        return this.dataType;
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public boolean isCurrency() {
        return this.isCurrency;
    }

    @Override
    public int isNullable() {
        return this.nullable;
    }

    @Override
    public void dump() {
        this.logger.debug("Begin Attribute");
        this.logger.indent(SEDU);
        this.logger.debug("Attribute Name: " + this.name);
        this.logger.debug("Alias Name: " + this.aliasName);
        this.logger.debug("dataType: " + Types.getDataTypeName(this.dataType));
        this.logger.debug("precision: " + this.precision);
        this.logger.debug("scale: " + this.scale);
        this.logger.debug("nullable: " + this.nullable);
        this.logger.debug("scale: " + this.scale);
        this.logger.debug("isCurrency: " + this.isCurrency);
        this.logger.debug("isConstant: " + this.isConstant);
        this.logger.deIndent(SEDU);
        this.logger.debug("End Attribute");
    }

    @Override
    public int getBaseType() {
        assert (this.dataType == 2003) : "this is not a array!";
        return this.baseType;
    }

    @Override
    public void setBaseType(int n) {
        this.baseType = n;
    }

    public String toString() {
        return "attributeName:[" + this.getAttributeName() + "] aliasName: [" + this.getAliasName() + "] / innerDataType:[" + this.getDataType() + "] / [" + Types.getDataTypeName(this.getDataType()) + "]";
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int n = 17;
            n = n * 37 + this.getAliasName().hashCode();
            n = n * 37 + this.getDataType();
            n = n * 37 + this.getPrecision();
            n = n * 37 + this.getScale();
            n = n * 37 + this.isNullable();
            n = n * 37 + (this.isCurrency() ? 1 : 0);
            this.hashCode = n = n * 37 + (this.isConstant() ? 1 : 0);
        }
        return this.hashCode;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object instanceof JAttribute) {
            JAttribute jAttribute = (JAttribute)object;
            return this.name.equals(jAttribute.getAttributeName()) && this.dataType == jAttribute.getDataType() && this.precision == jAttribute.getPrecision() && this.scale == jAttribute.getScale() && this.nullable == jAttribute.isNullable() && this.isCurrency == jAttribute.isCurrency() && this.isConstant == jAttribute.isConstant();
        }
        return false;
    }

    @Override
    public boolean isConstant() {
        return this.isConstant;
    }

    @Override
    public Object getConstant() {
        return this.constant;
    }

    @Override
    public void setConstant(Object object) {
        this.constant = object;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.name = (String)objectInput.readObject();
        this.dataType = objectInput.readInt();
        this.precision = objectInput.readInt();
        this.scale = objectInput.readInt();
        this.length = objectInput.readInt();
        this.nullable = objectInput.readInt();
        this.isCurrency = objectInput.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.name);
        objectOutput.writeInt(this.dataType);
        objectOutput.writeInt(this.precision);
        objectOutput.writeInt(this.scale);
        objectOutput.writeInt(this.length);
        objectOutput.writeInt(this.nullable);
        objectOutput.writeBoolean(this.isCurrency);
    }
}

