/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.relational;

import com.jinfonet.dataservice.api.schema.relational.JRelationMetaData;
import com.jinfonet.dataservice.expression.executor.conditiontools.TupleIDComparator;
import com.jinfonet.dataservice.relational.ARelationData;
import com.jinfonet.dataservice.relational.CachedTuple;
import com.jinfonet.dataservice.relational.DistinctRowId;
import com.jinfonet.dataservice.relational.DistinctTuple;
import com.jinfonet.dataservice.relational.IRelationData;
import com.jinfonet.dataservice.relational.IRowID;
import com.jinfonet.dataservice.relational.ITuple;
import com.jinfonet.dataservice.util.IntList;
import com.jinfonet.dataservice.util.OneDimensionIntArrayList;
import com.jinfonet.dataservice.util.TupleHasher;
import java.util.HashSet;
import jet.dataengine.api.DSException;

public class DistinctRelationData
extends ARelationData {
    private IRelationData SEDU;
    private String[] add;
    private IRowID beforeFirst;
    TupleIDComparator tupleComparetor;
    TupleHasher tupleHasher;
    private CachedTuple close;
    private Object createRowID = new Object();
    private HashSet createTuple;
    private IntList currentTimeMillis;
    private boolean get = false;

    public DistinctRelationData(String string, IRelationData iRelationData, String[] stringArray) throws DSException {
        super(string, iRelationData.getRelationOption());
        this.SEDU = iRelationData;
        this.beforeFirst = iRelationData.createRowID();
        this.beforeFirst.beforeFirst();
        CachedTuple cachedTuple = new CachedTuple(iRelationData.createTuple());
        CachedTuple cachedTuple2 = new CachedTuple(iRelationData.createTuple());
        this.close = new CachedTuple(iRelationData.createTuple());
        String[] stringArray2 = null;
        if (stringArray == null || stringArray.length == 0) {
            JRelationMetaData jRelationMetaData = iRelationData.getMetaData();
            int n = jRelationMetaData.getColumnCount();
            stringArray2 = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray2[i] = jRelationMetaData.getAttribute(i + 1).getAliasName();
            }
        } else {
            stringArray2 = stringArray;
        }
        this.tupleComparetor = new TupleIDComparator(stringArray2, cachedTuple.getMetaData(), (ITuple)cachedTuple, (ITuple)cachedTuple2);
        this.tupleHasher = new TupleHasher(this.close.getMetaData(), stringArray2, 17, 37);
        this.createTuple = new HashSet();
        this.currentTimeMillis = new OneDimensionIntArrayList();
    }

    @Override
    public IRowID createRowID() throws DSException {
        return new DistinctRowId(this);
    }

    @Override
    protected ITuple createTupleReal() throws DSException {
        return new DistinctTuple(this, this.SEDU.createTuple());
    }

    @Override
    public JRelationMetaData getMetaData() throws DSException {
        return this.SEDU.getMetaData();
    }

    @Override
    public boolean isEmpty() throws DSException {
        return this.SEDU.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasFetchedAll() {
        Object object = this.createRowID;
        synchronized (object) {
            return this.get;
        }
    }

    public IntList getRowIDs() throws DSException {
        this.last();
        return this.currentTimeMillis;
    }

    private void p(Object object) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidPosition(long l) throws DSException {
        Object object = this.createRowID;
        synchronized (object) {
            if (l <= 0L) {
                return false;
            }
            if (this.get) {
                return l <= (long)this.currentTimeMillis.size();
            }
            if (l > (long)this.createTuple.size()) {
                long l2 = l - (long)this.createTuple.size();
                while (this.beforeFirst.next()) {
                    int n = this.beforeFirst.getCurrentRowID();
                    this.close.init(n);
                    Key key = new Key(n);
                    if (!this.createTuple.add(key)) continue;
                    this.currentTimeMillis.add(n);
                    if (--l2 != 0L) continue;
                    break;
                }
                if (this.beforeFirst.isAfterLast()) {
                    this.get = true;
                    this.createRowID.notifyAll();
                }
            }
            return l <= (long)this.currentTimeMillis.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void last() throws DSException {
        Object object = this.createRowID;
        synchronized (object) {
            if (!this.get) {
                while (this.beforeFirst.next()) {
                    int n = this.beforeFirst.getCurrentRowID();
                    this.close.init(n);
                    Key key = new Key(n);
                    if (!this.createTuple.add(key)) continue;
                    this.currentTimeMillis.add(n);
                }
                this.get = true;
                this.createRowID.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() throws DSException {
        Object object = this.createRowID;
        synchronized (object) {
            this.last();
            return this.currentTimeMillis.size();
        }
    }

    public int mapToInputRowId(int n) throws DSException {
        return this.currentTimeMillis.get(n - 1);
    }

    @Override
    protected void onClose() throws DSException {
        this.SEDU.close();
        this.currentTimeMillis = null;
        this.createTuple = null;
    }

    @Override
    public int getType() throws DSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getIOTime() {
        throw new UnsupportedOperationException();
    }

    long t() {
        return System.currentTimeMillis();
    }

    class Key {
        final int row;
        int hash = -1;
        boolean hasHashed = false;

        Key(int n) {
            this.row = n;
        }

        public int hashCode() {
            try {
                if (!this.hasHashed) {
                    this.hash = DistinctRelationData.this.tupleHasher.hash(DistinctRelationData.this.close);
                    this.hasHashed = true;
                }
            }
            catch (DSException dSException) {
                throw new RuntimeException(dSException);
            }
            return this.hash;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            Key key = (Key)object;
            if (key.row == this.row) {
                return true;
            }
            boolean bl = DistinctRelationData.this.tupleComparetor.equals(this.row, key.row);
            return bl;
        }
    }
}

