/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.relational;

import com.jinfonet.dataservice.api.schema.relational.JAttribute;
import com.jinfonet.dataservice.api.schema.relational.JRelationMetaData;
import com.jinfonet.dataservice.relational.ARelationData;
import com.jinfonet.dataservice.relational.BaseRowID;
import com.jinfonet.dataservice.relational.FakeTuple;
import com.jinfonet.dataservice.relational.IRowID;
import com.jinfonet.dataservice.relational.ITuple;
import com.jinfonet.dataservice.relational.RelationMetaData;
import com.jinfonet.dataservice.relational.RelationOption;
import java.security.SecureRandom;
import jet.dataengine.api.DSException;

public class FakeRelationData
extends ARelationData {
    private final int SEDU;
    private final FakeColumn[] createRowID;
    private final JRelationMetaData currentTimeMillis;
    private final long desiredAssertionStatus = System.currentTimeMillis();

    public FakeRelationData(String string, int n, RelationMetaData relationMetaData, RelationOption relationOption) throws DSException {
        super(string, relationOption);
        assert (n >= 0) : "maxTuples >= 0";
        this.SEDU = n;
        JAttribute[] jAttributeArray = relationMetaData.getAttributes();
        this.createRowID = new FakeColumn[jAttributeArray.length];
        SecureRandom secureRandom = new SecureRandom();
        int n2 = jAttributeArray.length;
        for (int i = 0; i < n2; ++i) {
            this.createRowID[i] = new FakeColumn(jAttributeArray[i], secureRandom.nextInt() + 1, 1000L);
        }
        this.currentTimeMillis = new RelationMetaData(jAttributeArray);
    }

    @Override
    protected ITuple createTupleReal() throws DSException {
        return new FakeTuple(this.desiredAssertionStatus, this.currentTimeMillis, this.createRowID);
    }

    @Override
    protected void onClose() throws DSException {
    }

    @Override
    public JRelationMetaData getMetaData() throws DSException {
        return this.currentTimeMillis;
    }

    @Override
    public IRowID createRowID() throws DSException {
        return BaseRowID.createRowID(-1, this.SEDU);
    }

    @Override
    public int getType() throws DSException {
        return 0;
    }

    @Override
    public boolean isEmpty() throws DSException {
        return this.SEDU == 0;
    }

    @Override
    public long getIOTime() {
        return 0L;
    }

    public class FakeColumn {
        public static final int ID = 0;
        public static final int OTHER = 1;
        JAttribute attribute;
        int modulus;
        long maxValue;
        int type = 1;

        public FakeColumn(JAttribute jAttribute, int n, long l) {
            this.attribute = jAttribute;
            this.modulus = n;
            this.maxValue = l;
        }
    }
}

