/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.relational;

import com.jinfonet.dataservice.relational.ALazyRelationData;
import com.jinfonet.dataservice.relational.IRowID;
import com.jinfonet.dataservice.util.IntList;
import jet.dataengine.api.DSException;

public class LazyRowID
implements IRowID {
    protected final ALazyRelationData relationData;
    protected static final int beforeFirst = -1;
    protected int position = -1;

    public LazyRowID(ALazyRelationData aLazyRelationData) {
        this.relationData = aLazyRelationData;
    }

    @Override
    public int getRowID(int n) throws DSException {
        return this.relationData.getRowId(n);
    }

    @Override
    public int getCurrentRowID() throws DSException {
        return this.relationData.getRowId(this.position);
    }

    @Override
    public IntList getRowIDs() throws DSException {
        return this.relationData.getRowIdsCopy();
    }

    @Override
    public boolean currentRowIDIsAvailable() throws DSException {
        if (this.position <= -1) {
            this.position = -1;
            return false;
        }
        int n = this.relationData.getCurrentFilledRecordsCount();
        if (this.position < n) {
            return true;
        }
        if (this.isFinished()) {
            this.position = n;
            return false;
        }
        boolean bl = this.relationData.nextToPosition(this.position);
        if (bl) {
            return true;
        }
        assert (this.isFinished()) : "relation data have not finished.";
        this.position = this.relationData.getRecordsCount();
        return false;
    }

    protected int getAfterLast() throws DSException {
        this.relationData.nextToPosition(Integer.MAX_VALUE);
        return this.relationData.getRecordsCount();
    }

    @Override
    public int size() throws DSException {
        return this.relationData.getRecordsCount();
    }

    @Override
    public boolean next() throws DSException {
        ++this.position;
        return this.currentRowIDIsAvailable();
    }

    @Override
    public void beforeFirst() throws DSException {
        this.position = -1;
    }

    @Override
    public void afterLast() throws DSException {
        this.position = this.getAfterLast();
    }

    @Override
    public boolean first() throws DSException {
        this.position = 0;
        return this.currentRowIDIsAvailable();
    }

    @Override
    public boolean isAfterLast() throws DSException {
        return this.position == this.getAfterLast();
    }

    @Override
    public boolean isBeforeFirst() throws DSException {
        return this.position == -1;
    }

    @Override
    public boolean isFirst() throws DSException {
        return this.position == 0;
    }

    @Override
    public boolean isLast() throws DSException {
        return this.position == this.getAfterLast() - 1;
    }

    @Override
    public boolean last() throws DSException {
        this.position = this.getAfterLast() - 1;
        return this.currentRowIDIsAvailable();
    }

    @Override
    public boolean previous() throws DSException {
        --this.position;
        return this.currentRowIDIsAvailable();
    }

    @Override
    public boolean relative(int n) throws DSException {
        this.position += n;
        return this.currentRowIDIsAvailable();
    }

    @Override
    public void setPosition(long l) throws DSException {
        this.position = (int)l + -1;
        this.currentRowIDIsAvailable();
    }

    @Override
    public long getPosition() throws DSException {
        return this.position - -1;
    }

    @Override
    public boolean isFinished() {
        return this.relationData.isFinished();
    }

    @Override
    public void setFetchDirection(int n) throws DSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFetchSize(int n) throws DSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearWarnings() throws DSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void getWarnings() throws DSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFetchDirection() throws DSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFetchSize() throws DSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getExtent() throws DSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getPosition(int n) {
        return this.relationData.getPosition(n);
    }
}

