/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.relational;

import com.jinfonet.dataservice.api.schema.relational.JRelationMetaData;
import com.jinfonet.dataservice.relational.ARelation;
import com.jinfonet.dataservice.relational.IRelationData;
import com.jinfonet.dataservice.relational.IRowID;
import com.jinfonet.dataservice.relational.ITuple;
import com.jinfonet.dataservice.relational.LocalConvertTuple;
import com.jinfonet.dataservice.relational.MaxrRowID;
import com.jinfonet.dataservice.relational.RelationOption;
import java.util.TimeZone;
import jet.dataengine.api.DSException;
import jet.dataengine.api.DataCacheInfo;

public class LocalConvertRelationData
implements IRelationData {
    private IRelationData SEDU;
    private TimeZone close;
    private long createRelation;
    private final int createRowID;
    private JRelationMetaData createTuple;
    private Object getDataCacheInfo = new Object();
    private boolean getIOTime = false;

    public LocalConvertRelationData(TimeZone timeZone, JRelationMetaData jRelationMetaData, long l, int n) {
        this.createTuple = jRelationMetaData;
        this.close = timeZone;
        this.createRelation = l;
        this.createRowID = n;
    }

    @Override
    public String getName() throws DSException {
        this.check();
        return this.SEDU.getName();
    }

    @Override
    public ARelation createRelation() throws DSException {
        this.check();
        return this.SEDU.createRelation();
    }

    @Override
    public JRelationMetaData getMetaData() throws DSException {
        return this.createTuple;
    }

    @Override
    public ITuple createTuple() throws DSException {
        this.check();
        return new LocalConvertTuple(this.SEDU.createTuple(), this.close, this.createRowID);
    }

    @Override
    public void removeTuple(ITuple iTuple) throws DSException {
        this.check();
        this.SEDU.removeTuple(iTuple);
    }

    @Override
    public IRowID createRowID() throws DSException {
        this.check();
        return new MaxrRowID(this.SEDU.createRowID(), (int)this.createRelation);
    }

    @Override
    public void close() throws DSException {
        this.check();
        this.SEDU.close();
    }

    @Override
    public boolean isClosed() throws DSException {
        this.check();
        return this.SEDU.isClosed();
    }

    @Override
    public int getType() throws DSException {
        this.check();
        return this.SEDU.getType();
    }

    @Override
    public boolean isEmpty() throws DSException {
        this.check();
        return this.SEDU.isEmpty();
    }

    @Override
    public long getIOTime() {
        this.check();
        return this.SEDU.getIOTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRealData(IRelationData iRelationData) {
        Object object = this.getDataCacheInfo;
        synchronized (object) {
            this.SEDU = iRelationData;
            this.getIOTime = true;
            this.getDataCacheInfo.notifyAll();
        }
    }

    private void check() {
        Object object = this.getDataCacheInfo;
        synchronized (object) {
            while (true) {
                if (this.getIOTime) {
                    return;
                }
                try {
                    this.getDataCacheInfo.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    @Override
    public DataCacheInfo getDataCacheInfo() {
        this.check();
        return this.SEDU.getDataCacheInfo();
    }

    @Override
    public RelationOption getRelationOption() {
        this.check();
        return this.SEDU.getRelationOption();
    }
}

