/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.relational.datasource.json;

import com.jinfonet.api.datatypes.Date;
import com.jinfonet.api.datatypes.Time;
import com.jinfonet.dataservice.api.schema.relational.JAttribute;
import com.jinfonet.dataservice.api.schema.relational.JRelationMetaData;
import com.jinfonet.dataservice.relational.Record;
import com.jinfonet.dataservice.relational.RelationMetaData;
import com.jinfonet.dataservice.relational.RelationOption;
import com.jinfonet.dataservice.relational.swap.RelationPool;
import com.jinfonet.dataservice.schema.relational.TransformRelationModel;
import com.jinfonet.dataservice.schema.relational.datasource.xml.IXmlMappingRule;
import com.jinfonet.dataservice.schema.relational.datasource.xml.XmlMappingRule;
import com.jinfonet.dataservice.schema.relational.datasource.xml.XmlTransformToRelation;
import com.jinfonet.dataservice.schema.relational.datasource.xml.XmlTransformToRelationRule;
import com.jinfonet.datatypes.JinfonetArrayBaseObject;
import com.jinfonet.datatypes.JinfonetDate;
import com.jinfonet.datatypes.JinfonetTime;
import com.jinfonet.datatypes.JinfonetTimeStamp;
import com.jinfonet.util.JRLog;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.TimeZone;
import java.util.Vector;
import javax.json.Json;
import javax.json.stream.JsonParser;
import javax.xml.bind.DatatypeConverter;
import jet.connect.DbArray;
import jet.connect.DbColDesc;
import jet.dataengine.api.DSException;
import jet.datasource.JRUserDataSourceException;
import jet.datasource.JRUserStreamFactory;
import jet.util.ReportFormat;

public class JsonDataFetcher {
    private static final int END_ARRAY = 1;
    private static final int END_OBJECT = 2;
    private static final int KEY_NAME = 3;
    private static final String SEDU = "jsonObject";
    private static final String START_ARRAY = "jsonArray";
    private static final String START_OBJECT = "jet.universe.xml.JSonElement";
    public static final int BOOLEAN = 1;
    public static final int NUMBER = 2;
    public static final int STRING = 3;
    private Map VALUE_FALSE = new HashMap();
    Hashtable records = new Hashtable();
    private TimeZone VALUE_NULL;
    private Locale VALUE_NUMBER;
    private SimpleDateFormat VALUE_STRING;
    private NumberFormat VALUE_TRUE;

    public JsonDataFetcher(TransformRelationModel[] transformRelationModelArray, TimeZone timeZone, Locale locale, HashMap hashMap) throws DSException {
        this.VALUE_NULL = timeZone;
        this.VALUE_NUMBER = locale;
        this.VALUE_STRING = new SimpleDateFormat("", locale);
        this.VALUE_STRING.setTimeZone(timeZone);
        this.VALUE_TRUE = NumberFormat.getInstance(locale);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JsonDataFetcher/ timezone=" + timeZone.getDisplayName() + "; locale = " + locale.getDisplayName());
        }
        for (int i = 0; i < transformRelationModelArray.length; ++i) {
            TransformRelationModel transformRelationModel = transformRelationModelArray[i];
            RelationPool relationPool = new RelationPool(transformRelationModel.getName(), new RelationMetaData(transformRelationModel.getAttributes()), (RelationOption)hashMap.get(transformRelationModelArray[i]));
            this.VALUE_FALSE.put(transformRelationModelArray[i], relationPool);
            XmlTransformToRelationRule[] xmlTransformToRelationRuleArray = ((XmlTransformToRelation)transformRelationModel.getTransformToRelation()).getXmlTransformRules();
            JRelationMetaData jRelationMetaData = relationPool.getMetaData();
            String string = null;
            for (int j = 0; j < xmlTransformToRelationRuleArray.length; ++j) {
                string = xmlTransformToRelationRuleArray[j].getXmlTransformSource().getXpath();
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "tablePath=" + string);
                }
                int n = -1;
                int n2 = -1;
                HashMap<String, DbArray> hashMap2 = new HashMap<String, DbArray>();
                HashMap<String, DateParser> hashMap3 = new HashMap<String, DateParser>();
                for (int k = 1; k <= jRelationMetaData.getColumnCount(); ++k) {
                    Object object;
                    IXmlMappingRule iXmlMappingRule;
                    int n3;
                    String string2 = jRelationMetaData.getColumnName(k);
                    if (JRLog.isTrace(6)) {
                        JRLog.trace(6, "column=" + string2);
                    }
                    if ((n3 = (iXmlMappingRule = xmlTransformToRelationRuleArray[j].getXmlMappingRule(string2)).getType()) == 1) {
                        n = k;
                        continue;
                    }
                    if (n3 == 2) {
                        n2 = k;
                        continue;
                    }
                    JAttribute jAttribute = jRelationMetaData.getAttribute(k);
                    int n4 = jAttribute.getDataType();
                    if (jAttribute.getDataType() == 2003) {
                        object = new DbColDesc(string2, 2003, -1, -1, 2);
                        hashMap2.put(string2, new DbArray((DbColDesc)object));
                        n4 = jAttribute.getBaseType();
                        if (JRLog.isTrace(6)) {
                            JRLog.trace(6, "array column=" + object);
                        }
                    }
                    switch (n4) {
                        case 91: 
                        case 92: 
                        case 93: {
                            object = ((XmlMappingRule)iXmlMappingRule).getXmlTransformSource().getXsdPattern();
                            DateParser dateParser = new DateParser(string2, (String)object, n4);
                            hashMap3.put(string2, dateParser);
                        }
                    }
                }
                JsonRecord jsonRecord = new JsonRecord(relationPool, n, n2, hashMap2, hashMap3);
                this.records.put(string, jsonRecord);
            }
        }
    }

    private boolean END_ARRAY(JsonElement jsonElement) {
        return this.records.get(jsonElement.fullName()) != null;
    }

    private void END_OBJECT(InputStream inputStream) throws DSException {
        JsonParser jsonParser = Json.createParser((InputStream)inputStream);
        class MyStack
        extends Stack {
            MyStack() {
            }

            public Object push(Object object) {
                return super.push(object);
            }

            public synchronized Object pop() {
                if (this.size() == 1) {
                    // empty if block
                }
                return super.pop();
            }

            public synchronized Object peek() {
                return super.peek();
            }
        }
        MyStack myStack = new MyStack();
        Stack<Integer> stack = new Stack<Integer>();
        Stack<JsonRecord> stack2 = new Stack<JsonRecord>();
        ((Stack)myStack).push(new JsonElement(START_OBJECT, 1));
        stack.push(3);
        boolean bl = false;
        Object object = null;
        while (jsonParser.hasNext()) {
            JsonParser.Event event = jsonParser.next();
            object = (JsonElement)((Stack)myStack).peek();
            if (event == JsonParser.Event.START_OBJECT) {
                Object object2;
                int n = (Integer)stack.peek();
                if (n == 2) {
                    ((JsonElement)object).setType(3);
                    ((JsonElement)object).setIsTable(this.END_ARRAY((JsonElement)object));
                    object2 = new JsonElement(SEDU, 1);
                    ((JsonElement)object2).setParent((JsonElement)object);
                    ((Stack)myStack).push(object2);
                    stack.push(3);
                    object = object2;
                } else {
                    ((JsonElement)object).setType(1);
                }
                stack.push(1);
                bl = this.END_ARRAY((JsonElement)object);
                ((JsonElement)object).setIsTable(bl);
                if (!bl) continue;
                object2 = ((JsonElement)object).fullName();
                JsonRecord jsonRecord = (JsonRecord)this.records.get(object2);
                jsonRecord.increaseKey();
                stack2.push(jsonRecord);
                continue;
            }
            if (event == JsonParser.Event.END_OBJECT) {
                stack.pop();
                stack.pop();
                object = (JsonElement)((Stack)myStack).pop();
                if (((JsonElement)object).isTable() && ((JsonElement)object).SEDU != 3) {
                    JsonRecord jsonRecord = (JsonRecord)stack2.pop();
                    int n = 0;
                    if (!stack2.isEmpty()) {
                        JsonRecord jsonRecord2 = (JsonRecord)stack2.peek();
                        n = jsonRecord2.access$400;
                    }
                    jsonRecord.insertData(n);
                    jsonRecord.clear();
                }
                if (myStack.isEmpty()) continue;
                JsonElement jsonElement = (JsonElement)((Stack)myStack).peek();
                bl = jsonElement.isTable();
                continue;
            }
            if (event == JsonParser.Event.START_ARRAY) {
                ((JsonElement)object).setType(2);
                int n = (Integer)stack.peek();
                if (n == 2) {
                    JsonElement jsonElement = new JsonElement(START_ARRAY, 2);
                    jsonElement.setParent((JsonElement)object);
                    ((Stack)myStack).push(jsonElement);
                    stack.push(3);
                }
                stack.push(2);
                continue;
            }
            if (event == JsonParser.Event.END_ARRAY) {
                stack.pop();
                stack.pop();
                object = (JsonElement)((Stack)myStack).pop();
                switch (((JsonElement)object).SEDU) {
                    case 2: {
                        if (!bl) break;
                        JsonRecord jsonRecord = (JsonRecord)stack2.peek();
                        jsonRecord.putValue(((JsonElement)object).add, (JsonElement)object);
                        break;
                    }
                    case 3: {
                        if (myStack.isEmpty()) break;
                        JsonElement jsonElement = (JsonElement)((Stack)myStack).peek();
                        bl = jsonElement.isTable();
                    }
                }
                continue;
            }
            if (event == JsonParser.Event.KEY_NAME) {
                stack.push(3);
                String string = jsonParser.getString();
                JsonElement jsonElement = new JsonElement(string);
                jsonElement.setParent((JsonElement)object);
                ((Stack)myStack).push(jsonElement);
                continue;
            }
            int n = (Integer)stack.peek();
            if (!bl) {
                if (n != 3) continue;
                stack.pop();
                JsonElement jsonElement = (JsonElement)((Stack)myStack).pop();
                continue;
            }
            String string = null;
            boolean bl2 = false;
            int n2 = 3;
            if (event == JsonParser.Event.VALUE_FALSE) {
                string = "false";
                n2 = 1;
                bl2 = false;
            } else if (event == JsonParser.Event.VALUE_TRUE) {
                string = "true";
                n2 = 1;
                bl2 = false;
            } else if (event == JsonParser.Event.VALUE_NULL) {
                string = "null";
                n2 = 3;
                bl2 = true;
            } else if (event == JsonParser.Event.VALUE_NUMBER) {
                string = jsonParser.getString();
                n2 = 2;
                bl2 = false;
            } else if (event == JsonParser.Event.VALUE_STRING) {
                string = jsonParser.getString();
                n2 = 3;
                bl2 = false;
            }
            if (n == 3) {
                stack.pop();
                object = (JsonElement)((Stack)myStack).pop();
                ((JsonElement)object).collectValue(new JsonValue(string, n2, bl2));
            } else if (n == 2) {
                object = (JsonElement)((Stack)myStack).peek();
                if (!bl2) {
                    ((JsonElement)object).collectValue(new JsonValue(string, n2, bl2));
                }
            }
            if (n != 3) continue;
            JsonRecord jsonRecord = (JsonRecord)stack2.peek();
            jsonRecord.putValue(((JsonElement)object).add, (JsonElement)object);
        }
        for (JsonRecord jsonRecord : this.records.values()) {
            jsonRecord.appendFinished();
        }
    }

    public Map getAllRelationData(InputStream inputStream) throws DSException {
        this.END_OBJECT(inputStream);
        return this.VALUE_FALSE;
    }

    public Map getAllRelationData(JRUserStreamFactory jRUserStreamFactory) throws DSException, JRUserDataSourceException {
        while (jRUserStreamFactory.nextInputStream()) {
            InputStream inputStream = jRUserStreamFactory.getInputStream();
            this.END_OBJECT(inputStream);
        }
        return this.VALUE_FALSE;
    }

    private class JsonElement {
        public static final int UNKNOWN = 0;
        public static final int OBJECT = 1;
        public static final int SIMPLE_ARRAY = 2;
        public static final int OBJECT_ARRAY = 3;
        private int SEDU = 0;
        private String add = null;
        private JsonElement append = null;
        private boolean equalsIgnoreCase = false;
        Vector values = new Vector();
        private String set = null;

        public JsonElement(String string, int n) {
            this.add = string;
            this.SEDU = n;
        }

        public JsonElement(String string) {
            this(string, 0);
        }

        public void setType(int n) {
            this.SEDU = n;
        }

        public boolean isTable() {
            return this.equalsIgnoreCase;
        }

        public void setIsTable(boolean bl) {
            this.equalsIgnoreCase = bl;
        }

        public void collectValue(JsonValue jsonValue) {
            if (this.SEDU == 2) {
                this.values.add(jsonValue);
            } else if (this.values.size() == 0) {
                this.values.add(jsonValue);
            } else {
                this.values.set(0, jsonValue);
            }
        }

        public void setParent(JsonElement jsonElement) {
            this.append = jsonElement;
        }

        public String fullName() {
            if (this.set != null) {
                return this.set;
            }
            String string = "";
            if (this.append != null) {
                string = this.append.fullName();
                this.set = this.add.equalsIgnoreCase(JsonDataFetcher.SEDU) ? string : string + "/" + this.add;
            } else {
                this.set = "/" + this.add;
            }
            return this.set;
        }

        public String toStirng() {
            return this.fullName();
        }
    }

    class JsonRecord {
        private Hashtable SEDU = new Hashtable();
        private RelationPool access$000;
        private int access$400;
        private Record access$500;
        private int access$600;
        private int append;
        private Map appendFinished;
        private Map appendRecord;

        public JsonRecord(RelationPool relationPool, int n, int n2, Map map, Map map2) throws DSException {
            this.access$000 = relationPool;
            this.access$400 = 0;
            this.access$600 = n;
            this.append = n2;
            this.appendFinished = map;
            this.appendRecord = map2;
            this.access$500 = relationPool.createRecord();
        }

        public void increaseKey() {
            ++this.access$400;
        }

        public int primaryKey() {
            return this.access$400;
        }

        private void SEDU(JsonValue jsonValue, int n, Object object, int n2, boolean bl, String string) throws DSException {
            block31: {
                String string2 = jsonValue.SEDU;
                DateParser dateParser = null;
                if (jsonValue.Z) {
                    if (!bl) {
                        ((Record)object).putNull(n);
                    }
                } else {
                    try {
                        switch (n) {
                            case -6: {
                                byte by = Byte.valueOf(string2);
                                if (bl) {
                                    byte[] byArray = (byte[])object;
                                    byArray[n2] = by;
                                    break;
                                }
                                ((Record)object).putByte(by);
                                break;
                            }
                            case -7: {
                                boolean bl2 = string2.equalsIgnoreCase("true");
                                if (bl) {
                                    boolean[] blArray = (boolean[])object;
                                    blArray[n2] = bl2;
                                    break;
                                }
                                ((Record)object).putBoolean(bl2);
                                break;
                            }
                            case 5: {
                                short s = Short.parseShort(string2);
                                if (bl) {
                                    short[] sArray = (short[])object;
                                    sArray[n2] = s;
                                    break;
                                }
                                ((Record)object).putShort(s);
                                break;
                            }
                            case 4: {
                                int n3 = Integer.parseInt(string2);
                                if (bl) {
                                    int[] nArray = (int[])object;
                                    nArray[n2] = n3;
                                    break;
                                }
                                ((Record)object).putInt(n3);
                                break;
                            }
                            case 6: {
                                float f = JsonDataFetcher.this.VALUE_TRUE.parse(string2).floatValue();
                                if (bl) {
                                    float[] fArray2 = (float[])object;
                                    fArray2[n2] = f;
                                    break;
                                }
                                ((Record)object).putFloat(f);
                                break;
                            }
                            case -5: {
                                long l = Long.parseLong(string2);
                                if (bl) {
                                    long[] lArray = (long[])object;
                                    lArray[n2] = l;
                                    break;
                                }
                                ((Record)object).putLong(l);
                                break;
                            }
                            case 8: {
                                double d = JsonDataFetcher.this.VALUE_TRUE.parse(string2).doubleValue();
                                if (bl) {
                                    double[] dArray = (double[])object;
                                    dArray[n2] = d;
                                    break;
                                }
                                ((Record)object).putDouble(d);
                                break;
                            }
                            case 3: {
                                BigDecimal bigDecimal = new BigDecimal(string2);
                                if (bl) {
                                    BigDecimal[] bigDecimalArray = (BigDecimal[])object;
                                    bigDecimalArray[n2] = bigDecimal;
                                    break;
                                }
                                ((Record)object).putBigDecimal(bigDecimal);
                                break;
                            }
                            case 12: {
                                if (bl) {
                                    String[] stringArray = (String[])object;
                                    stringArray[n2] = string2;
                                    break;
                                }
                                ((Record)object).putString(string2);
                                break;
                            }
                            case 91: {
                                dateParser = (DateParser)this.appendRecord.get(string);
                                JinfonetDate jinfonetDate = new JinfonetDate(dateParser.parse(string2));
                                if (bl) {
                                    Date[] dateArray = (Date[])object;
                                    dateArray[n2] = jinfonetDate;
                                    break;
                                }
                                ((Record)object).putDate(jinfonetDate);
                                break;
                            }
                            case 93: {
                                dateParser = (DateParser)this.appendRecord.get(string);
                                JinfonetTimeStamp jinfonetTimeStamp = new JinfonetTimeStamp(dateParser.parse(string2));
                                if (bl) {
                                    com.jinfonet.api.datatypes.Timestamp[] timestampArray = (com.jinfonet.api.datatypes.Timestamp[])object;
                                    timestampArray[n2] = jinfonetTimeStamp;
                                    break;
                                }
                                ((Record)object).putTimeStamp(jinfonetTimeStamp);
                                break;
                            }
                            case 92: {
                                dateParser = (DateParser)this.appendRecord.get(string);
                                JinfonetTime jinfonetTime = new JinfonetTime(dateParser.parse(string2));
                                if (bl) {
                                    Time[] timeArray = (Time[])object;
                                    timeArray[n2] = jinfonetTime;
                                    break;
                                }
                                ((Record)object).putTime(jinfonetTime);
                                break;
                            }
                            default: {
                                throw new DSException(6037, new Object[]{Integer.toString(n2), Integer.toString(n)});
                            }
                        }
                    }
                    catch (ParseException parseException) {
                        ((Record)object).putNull(n);
                        if (!JRLog.isTrace(6)) break block31;
                        JRLog.trace(6, "Unable to parse value: '" + string2 + "of column '" + string + "'. Detail info: " + parseException.getMessage());
                    }
                }
            }
        }

        public void insertData(int n) throws DSException {
            JRelationMetaData jRelationMetaData = this.access$000.getMetaData();
            for (int i = 1; i <= jRelationMetaData.getColumnCount(); ++i) {
                if (i == this.access$600) {
                    this.access$500.putInt(this.access$400);
                    continue;
                }
                if (i == this.append) {
                    this.access$500.putInt(n);
                    continue;
                }
                JAttribute jAttribute = jRelationMetaData.getAttribute(i);
                String string = jRelationMetaData.getColumnName(i);
                JsonElement jsonElement = (JsonElement)this.SEDU.get(string);
                if (jsonElement == null) {
                    this.access$500.putNull(jAttribute.getDataType());
                    continue;
                }
                if (jsonElement.SEDU == 2) {
                    int n2 = jAttribute.getBaseType();
                    int n3 = jsonElement.values.size();
                    JinfonetArrayBaseObject jinfonetArrayBaseObject = null;
                    Object[] objectArray = null;
                    switch (n2) {
                        case -6: {
                            objectArray = new byte[n3];
                            break;
                        }
                        case -7: {
                            objectArray = new boolean[n3];
                            break;
                        }
                        case 5: {
                            objectArray = new short[n3];
                            break;
                        }
                        case 4: {
                            objectArray = new int[n3];
                            break;
                        }
                        case 6: {
                            objectArray = new float[n3];
                            break;
                        }
                        case -5: {
                            objectArray = new long[n3];
                            break;
                        }
                        case 8: {
                            objectArray = new double[n3];
                            break;
                        }
                        case 3: {
                            objectArray = new BigDecimal[n3];
                            break;
                        }
                        case 12: {
                            objectArray = new String[n3];
                            break;
                        }
                        case 91: {
                            objectArray = new Date[n3];
                            break;
                        }
                        case 93: {
                            objectArray = new com.jinfonet.api.datatypes.Timestamp[n3];
                            break;
                        }
                        case 92: {
                            objectArray = new Time[n3];
                            break;
                        }
                        default: {
                            throw new DSException(6037, new Object[]{Integer.toString(i), Integer.toString(n2)});
                        }
                    }
                    for (int j = 0; j < n3; ++j) {
                        this.SEDU((JsonValue)jsonElement.values.elementAt(j), n2, objectArray, j, true, string);
                    }
                    DbArray dbArray = (DbArray)this.appendFinished.get(string);
                    dbArray.set(n2, objectArray);
                    jinfonetArrayBaseObject = new JinfonetArrayBaseObject(dbArray);
                    this.access$500.putArray(jinfonetArrayBaseObject);
                    continue;
                }
                JsonValue jsonValue = (JsonValue)jsonElement.values.elementAt(0);
                this.SEDU(jsonValue, jAttribute.getDataType(), this.access$500, -1, false, string);
            }
            this.access$000.appendRecord(this.access$500);
        }

        public void appendFinished() {
            this.access$000.appendFinished();
        }

        public JsonElement getValue(String string) {
            return (JsonElement)this.SEDU.get(string);
        }

        public void putValue(String string, JsonElement jsonElement) {
            this.SEDU.put(string, jsonElement);
        }

        public void clear() {
            this.SEDU.clear();
        }
    }

    class DateParser {
        private final int SEDU = 0;
        private final int access$300 = 1;
        private final int append = 2;
        private final int applyPattern = 3;
        private int equalsIgnoreCase = -1;
        private String get;
        private int getJSONFormat;
        private String getMessage;

        public DateParser(String string, String string2, int n) {
            this.get = string2;
            this.getJSONFormat = n;
            this.getMessage = string;
            if (string2 == null || string2.length() == 0) {
                this.equalsIgnoreCase = 3;
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "pattern = " + string2 + "; USE_AUTO to parse");
                }
            } else if (string2.equalsIgnoreCase(ReportFormat.getJSONFormat().get(1))) {
                this.equalsIgnoreCase = 0;
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "pattern = " + string2 + "; USE_DATACONVERTOR to parse");
                }
            } else if (string2.equalsIgnoreCase(ReportFormat.getJSONFormat().get(0))) {
                this.equalsIgnoreCase = 1;
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "pattern = " + string2 + "; USE_TIMESTAMP to parse");
                }
            } else {
                this.equalsIgnoreCase = 2;
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "pattern = " + string2 + "; USE_SIMPLEDATEFORMAT to parse");
                }
            }
        }

        public long parse(String string) throws ParseException {
            Calendar calendar = null;
            if (this.equalsIgnoreCase == 0) {
                switch (this.getJSONFormat) {
                    case 91: {
                        calendar = DatatypeConverter.parseDate((String)string);
                        break;
                    }
                    case 92: {
                        calendar = DatatypeConverter.parseTime((String)string);
                        break;
                    }
                    case 93: {
                        calendar = DatatypeConverter.parseDateTime((String)string);
                    }
                }
                return calendar.getTimeInMillis();
            }
            if (this.equalsIgnoreCase == 1) {
                Timestamp timestamp = Timestamp.valueOf(string);
                return timestamp.getTime();
            }
            if (this.equalsIgnoreCase == 3) {
                long l = -1L;
                switch (this.getJSONFormat) {
                    case 91: {
                        calendar = DatatypeConverter.parseDate((String)string);
                        l = calendar.getTimeInMillis();
                        break;
                    }
                    case 92: {
                        calendar = DatatypeConverter.parseTime((String)string);
                        l = calendar.getTimeInMillis();
                        break;
                    }
                    case 93: {
                        try {
                            Timestamp timestamp = Timestamp.valueOf(string);
                            l = timestamp.getTime();
                            break;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            try {
                                calendar = DatatypeConverter.parseDateTime((String)string);
                                l = calendar.getTimeInMillis();
                                break;
                            }
                            catch (IllegalArgumentException illegalArgumentException2) {
                                throw new ParseException(illegalArgumentException2.getMessage(), -1);
                            }
                        }
                    }
                }
                return l;
            }
            JsonDataFetcher.this.VALUE_STRING.applyPattern(this.get);
            java.util.Date date = null;
            date = JsonDataFetcher.this.VALUE_STRING.parse(string);
            return date.getTime();
        }
    }

    class JsonValue {
        private String SEDU;
        private int I;
        private boolean Z;

        public JsonValue(String string, int n, boolean bl) {
            this.SEDU = string;
            this.I = n;
            this.Z = bl;
        }

        public String value() {
            return this.SEDU;
        }

        public boolean isNull() {
            return this.Z;
        }
    }
}

