/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.relational.datasource.xml;

import com.jinfonet.api.datatypes.Types;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import jet.dataengine.api.DSException;

public class DataConverterImpl {
    private static final byte[] SEDU = DataConverterImpl.append();
    private static final byte append = 127;
    private static final char[] charAt = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/', '='};

    public static String parseString(String string) {
        return string;
    }

    public static int parseInt(String string) throws DSException {
        int n = string.length();
        int n2 = 1;
        int n3 = 0;
        if (n == 0 || string == null) {
            throw new DSException(11622, new String[]{string + " is not an int value."});
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (DataConverterImpl.isBlankSpace(c)) continue;
            if ('0' <= c && c <= '9') {
                n3 = n3 * 10 + (c - 48);
                continue;
            }
            if (c == '-') {
                n2 = -1;
                continue;
            }
            if (c == '+') continue;
            throw new DSException(11614, new String[]{string + " is not an int value."});
        }
        return n3 * n2;
    }

    public static short parseShort(String string) throws DSException {
        return (short)DataConverterImpl.parseInt(string);
    }

    public static long parseLong(String string) throws DSException {
        long l = 0L;
        try {
            l = Long.valueOf(DataConverterImpl.equalsIgnoreCase(string).trim());
        }
        catch (Exception exception) {
            throw new DSException(11626, new String[]{string + " is not a long value.", exception.getMessage()});
        }
        return l;
    }

    public static BigInteger parseInteger(String string) throws DSException {
        BigInteger bigInteger = null;
        try {
            bigInteger = new BigInteger(DataConverterImpl.equalsIgnoreCase(string).toString());
        }
        catch (Exception exception) {
            throw new DSException(11627, new String[]{string + " is not a big int value.", exception.getMessage()});
        }
        return bigInteger;
    }

    public static BigDecimal parseDecimal(String string) throws DSException {
        int n;
        String string2 = string.trim();
        BigDecimal bigDecimal = null;
        try {
            bigDecimal = new BigDecimal(string2);
        }
        catch (Exception exception) {
            throw new DSException(11628, new String[]{string + " is not a decimal value.", exception.getMessage()});
        }
        int n2 = Types.getMaxPrecision(3);
        int n3 = n2 - 1;
        if (string.indexOf(43) != -1) {
            string2 = string2.replaceAll("\\+", "");
        }
        if (string2.indexOf(45) != -1) {
            string2 = string2.replaceAll("-", "");
        }
        if (string2.indexOf(46) != -1) {
            string2 = string2.replaceAll("\\.", "");
        }
        if ((n = string2.length()) > n2 || bigDecimal.scale() > n3) {
            throw new DSException(11619, new String[]{"the max precision of decimal in xml is: " + n2, " but current precision is:" + n + ".", " the max scale of decimal in xml is: " + n3, " but current scale is:" + bigDecimal.scale() + "."});
        }
        return bigDecimal;
    }

    public static float parseFloat(String string) throws DSException {
        String string2 = string.trim();
        if (string2.equals("NaN")) {
            return Float.NaN;
        }
        if (string2.equals("INF")) {
            return Float.POSITIVE_INFINITY;
        }
        if (string2.equals("-INF")) {
            return Float.NEGATIVE_INFINITY;
        }
        if (string2.length() == 0 || !DataConverterImpl.getMaxPrecision(string2.charAt(0)) || !DataConverterImpl.getMaxPrecision(string2.charAt(string2.length() - 1))) {
            throw new DSException(11615, new String[]{string + " is not a flaot value."});
        }
        float f = 0.0f;
        try {
            f = Float.parseFloat(string2);
        }
        catch (Exception exception) {
            throw new DSException(11629, new String[]{string + " is not a float value.", exception.getMessage()});
        }
        if (Float.isNaN(f)) {
            throw new DSException(11620, new String[]{"XML can not support NaN value."});
        }
        return f;
    }

    public static double parseDouble(String string) throws DSException {
        if ((string = string.trim()).equals("NaN")) {
            return Double.NaN;
        }
        if (string.equals("INF")) {
            return Double.POSITIVE_INFINITY;
        }
        if (string.equals("-INF")) {
            return Double.NEGATIVE_INFINITY;
        }
        if (string.length() == 0 || !DataConverterImpl.getMaxPrecision(string.charAt(0)) || !DataConverterImpl.getMaxPrecision(string.charAt(string.length() - 1))) {
            throw new DSException(11616, new String[]{string + " is not a double value."});
        }
        double d = 0.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            throw new DSException(11630, new String[]{string + " is not a double value.", exception.getMessage()});
        }
        if (Double.isNaN(d)) {
            throw new DSException(11621, new String[]{"XML can not support NaN value."});
        }
        return d;
    }

    public static boolean parseBoolean(String string) throws DSException {
        char c;
        String string2 = string.trim();
        int n = 0;
        int n2 = string2.length();
        while (DataConverterImpl.isBlankSpace(c = string2.charAt(n++)) && n < n2) {
        }
        if (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("yes") || c == '1') {
            return true;
        }
        if (string2.equalsIgnoreCase("false") || string2.equalsIgnoreCase("no") || c == '0') {
            return false;
        }
        throw new DSException(11631, new String[]{string + " is not a boolean value."});
    }

    public static byte parseByte(String string) throws DSException {
        return (byte)DataConverterImpl.parseInt(string);
    }

    public static byte[] parseHexBinary(String string) throws DSException {
        int n = string.length();
        if (n % 2 != 0) {
            throw new DSException(11632, new String[]{string + " is not valid HexBinary. The value length must multiple of 2."});
        }
        byte[] byArray = new byte[n / 2];
        for (int i = 0; i < n; i += 2) {
            int n2 = DataConverterImpl.getMessage(string.charAt(i));
            int n3 = DataConverterImpl.getMessage(string.charAt(i + 1));
            if (n2 == -1 || n3 == -1) {
                return null;
            }
            byArray[i / 2] = (byte)(n2 * 16 + n3);
        }
        return byArray;
    }

    public static byte[] parseBase64Binary(String string) throws DSException {
        String string2 = string.trim();
        int n = DataConverterImpl.SEDU(string2);
        if (n == -1) {
            throw new DSException(11633, new String[]{"The baseCode has invalid char."});
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = string2.length();
        byte[] byArray2 = new byte[4];
        int n4 = 0;
        try {
            for (int i = 0; i < n3; ++i) {
                char c = string2.charAt(i);
                byte by = SEDU[c];
                if (by != -1) {
                    byArray2[n4++] = by;
                }
                if (n4 != 4) continue;
                byArray[n2++] = (byte)(byArray2[0] << 2 | byArray2[1] >> 4);
                if (byArray2[2] != 127) {
                    byArray[n2++] = (byte)(byArray2[1] << 4 | byArray2[2] >> 2);
                }
                if (byArray2[3] != 127) {
                    byArray[n2++] = (byte)(byArray2[2] << 6 | byArray2[3]);
                }
                n4 = 0;
            }
        }
        catch (Exception exception) {
            throw new DSException(11634, new String[]{exception.getMessage()});
        }
        return byArray;
    }

    private static int SEDU(String string) {
        char c;
        int n = string.length();
        int n2 = 0;
        for (int i = 0; i < n && (c = string.charAt(i)) != '='; ++i) {
            if (c >= '\u0080') {
                return -1;
            }
            if (SEDU[c] == -1) continue;
            ++n2;
        }
        return n2 / 4 * 3 + Math.max(0, n2 % 4 - 1);
    }

    private static byte[] append() {
        int n;
        byte[] byArray = new byte[128];
        for (n = 0; n < 128; ++n) {
            byArray[n] = -1;
        }
        for (n = 65; n <= 90; ++n) {
            byArray[n] = (byte)(n - 65);
        }
        for (n = 97; n <= 122; ++n) {
            byArray[n] = (byte)(n - 97 + 26);
        }
        for (n = 48; n <= 57; ++n) {
            byArray[n] = (byte)(n - 48 + 52);
        }
        byArray[43] = 62;
        byArray[47] = 63;
        byArray[61] = 127;
        return byArray;
    }

    private static StringBuffer charAt(byte[] byArray) {
        int n = byArray.length;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray2 = new byte[3];
        byte by = 0;
        byArray2[0] = 0;
        byArray2[1] = 0;
        byArray2[2] = 0;
        for (int i = 0; i < n; ++i) {
            byArray2[n2] = by = byArray[i];
            if (++n2 != 3) continue;
            stringBuffer.append(DataConverterImpl.process(byArray2, false));
            n2 = 0;
        }
        if (n2 == 1 || n2 == 2) {
            stringBuffer.append(DataConverterImpl.process(byArray2, true));
        }
        return stringBuffer;
    }

    private static String process(byte[] byArray, boolean bl) {
        byte[] byArray2 = new byte[4];
        if (byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 0) {
            if (bl) {
                return null;
            }
            byArray2[0] = 0;
            byArray2[1] = 0;
            byArray2[2] = 0;
            byArray2[3] = 0;
        }
        if (byArray[0] != 0) {
            byArray2[0] = (byte)((byte)(byArray[0] >> 2) & 0x3F);
            byArray2[1] = (byte)((byte)(byArray[0] << 4 | byArray[1] >> 4 & 0xF) & 0x3F);
        } else {
            byArray2[0] = 0;
            byArray2[1] = (byte)(byArray[1] >> 4 & 0xF & 0x3F);
        }
        if (byArray[1] != 0) {
            byArray2[2] = (byte)((byte)(byArray[1] << 2 | byArray[2] >> 6 & 3) & 0x3F);
            byArray2[3] = (byte)(byArray[2] & 0x3F);
        } else if (!bl) {
            byArray2[2] = 0;
            byArray2[3] = (byte)(byArray[2] & 0x3F);
        } else {
            byArray2[2] = 64;
            byArray2[3] = 64;
        }
        if (byArray[2] != 0) {
            byArray2[2] = (byte)((byte)(byArray[1] << 2 | byArray[2] >> 6 & 3) & 0x3F);
            byArray2[3] = (byte)(byArray[2] & 0x3F);
        } else {
            byArray2[3] = !bl ? 0 : 64;
        }
        String string = String.valueOf(charAt[byArray2[0]]) + String.valueOf(charAt[byArray2[1]]) + String.valueOf(charAt[byArray2[2]]) + String.valueOf(charAt[byArray2[3]]);
        byArray[0] = 0;
        byArray[1] = 0;
        byArray[2] = 0;
        return string;
    }

    public static long parseUnsignedInt(String string) throws DSException {
        return DataConverterImpl.parseLong(string);
    }

    public static int parseUnsignedShort(String string) throws DSException {
        return DataConverterImpl.parseInt(string);
    }

    public static Date parseTime(String string, String string2) throws DSException {
        throw new UnsupportedOperationException();
    }

    public Date parseDate(String string, String string2) throws DSException {
        throw new UnsupportedOperationException();
    }

    public Date parseDateTime(String string, String string2) throws DSException {
        throw new UnsupportedOperationException();
    }

    public String parseAnySimpleType(String string) {
        throw new UnsupportedOperationException();
    }

    public static BigDecimal parseCoinType(String string) throws DSException {
        char c = string.charAt(0);
        if (c != '$') {
            throw new NumberFormatException(string + " is not a coin value.");
        }
        string = string.substring(1, string.length());
        return new BigDecimal(DataConverterImpl.equals(string));
    }

    private static double equals(String string) throws DSException {
        char c;
        int n;
        int n2 = string.length();
        int n3 = 1;
        int n4 = 0;
        double d = 0.0;
        double d2 = 0.0;
        for (n = 0; n < n2; ++n) {
            c = string.charAt(n);
            if (c == '.') {
                n4 = n;
                break;
            }
            if (DataConverterImpl.isBlankSpace(c) || c == ',') continue;
            if ('0' <= c && c <= '9') {
                d = d * 10.0 + (double)(c - 48);
                continue;
            }
            if (c == '-') {
                n3 = -1;
                continue;
            }
            if (c == '+') continue;
            throw new DSException(11617, new String[]{string + " is not a double value."});
        }
        for (n = n2 - 1; n > n4; --n) {
            c = string.charAt(n);
            if (DataConverterImpl.isBlankSpace(c) || c == ',') continue;
            if ('0' <= c && c <= '9') {
                d2 = d2 * 1.0 / 10.0 + (double)(c - 48) / 10.0;
                continue;
            }
            throw new DSException(11618, new String[]{string + " is not a double value."});
        }
        return (double)n3 * (d + d2);
    }

    public static final boolean isBlankSpace(char c) {
        if (c > ' ') {
            return false;
        }
        return c == '\t' || c == '\n' || c == '\r' || c == ' ';
    }

    private static String equalsIgnoreCase(String string) {
        int n = string.length();
        if (n <= 1 || string.charAt(0) != '+') {
            return string;
        }
        char c = (string = (String)string.subSequence(1, n)).charAt(0);
        if ('0' <= c && c <= '9') {
            return string;
        }
        if ('.' == c) {
            return string;
        }
        throw new NumberFormatException();
    }

    private static boolean getMaxPrecision(char c) {
        if (c == '+' || c == '.' || c == '-') {
            return true;
        }
        return '0' <= c && c <= '9';
    }

    private static int getMessage(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        return -1;
    }
}

