/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.relational.datasource.xml;

import com.jinfonet.dataservice.relational.datasource.xml.MutipleContentHandler;
import com.jinfonet.dataservice.relational.datasource.xml.XMLDataFetchHandler;
import com.jinfonet.dataservice.relational.datasource.xml.XPathContentHandler;
import com.jinfonet.dataservice.relational.datasource.xml.XPathErrorHandler;
import com.jinfonet.dataservice.relational.swap.RelationPool;
import com.jinfonet.dataservice.schema.relational.TransformRelationModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jet.dataengine.api.DSException;
import jet.datasource.InputStreamFactory;
import jet.log.JRLogger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SaxParseProcess {
    private static JRLogger SEDU = JRLogger.getLogger(SaxParseProcess.class.getName());
    private XMLDataFetchHandler close = null;

    public SaxParseProcess(TransformRelationModel[] transformRelationModelArray, TimeZone timeZone, Locale locale, HashMap hashMap) throws DSException {
        this.close = new XMLDataFetchHandler(transformRelationModelArray, timeZone, locale, hashMap);
    }

    public static RelationPool[] getAllResult(String string, Vector vector, HashMap hashMap) {
        XPathContentHandler xPathContentHandler = null;
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            xMLReader.setErrorHandler(new XPathErrorHandler());
            xPathContentHandler = new XPathContentHandler(vector, hashMap);
            xMLReader.setContentHandler(xPathContentHandler);
            xMLReader.parse(string);
        }
        catch (SAXException sAXException) {
            SEDU.debug(sAXException);
        }
        catch (IOException iOException) {
            SEDU.debug(iOException);
        }
        catch (DSException dSException) {
            SEDU.debug(dSException);
        }
        return xPathContentHandler.getAllResults();
    }

    public static RelationPool[] getResults(String string, Vector vector, HashMap hashMap) {
        MutipleContentHandler mutipleContentHandler = null;
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            mutipleContentHandler = new MutipleContentHandler(vector, hashMap);
            sAXParser.parse(string, (DefaultHandler)mutipleContentHandler);
        }
        catch (SAXParseException sAXParseException) {
            SEDU.debug(sAXParseException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            SEDU.debug(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            SEDU.debug(sAXException);
        }
        catch (DSException dSException) {
            SEDU.debug(dSException);
        }
        catch (IOException iOException) {
            SEDU.debug(iOException);
        }
        return mutipleContentHandler.getAllResults();
    }

    public Map getAllRelationData(String string) throws DSException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            if (string.startsWith("file:") || string.startsWith("ftp:") || string.startsWith("http:") || string.startsWith("https:")) {
                sAXParser.parse(string, (DefaultHandler)this.close);
            } else {
                sAXParser.parse(new File(string), (DefaultHandler)this.close);
            }
        }
        catch (SAXException sAXException) {
            throw new DSException(11602, (Object[])new String[]{sAXException.getMessage()}, (Throwable)sAXException);
        }
        catch (IOException iOException) {
            throw new DSException(11603, (Object[])new String[]{iOException.getMessage()}, (Throwable)iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new DSException(11604, (Object[])new String[]{parserConfigurationException.getMessage()}, (Throwable)parserConfigurationException);
        }
        return this.close.getRelationDataSet();
    }

    public Map getAllRelationData(InputStreamFactory inputStreamFactory, String string) throws DSException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            InputStream inputStream = inputStreamFactory.createInputStream(string);
            InputSource inputSource = new InputSource(inputStream);
            sAXParser.parse(inputSource, (DefaultHandler)this.close);
            inputStream.close();
            inputStream = null;
            inputSource = null;
        }
        catch (SAXException sAXException) {
            throw new DSException(2147, (Object[])new String[]{sAXException.getMessage()}, (Throwable)sAXException);
        }
        catch (IOException iOException) {
            throw new DSException(2148, (Object[])new String[]{iOException.getMessage()}, (Throwable)iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new DSException(2149, (Object[])new String[]{parserConfigurationException.getMessage()}, (Throwable)parserConfigurationException);
        }
        return this.close.getRelationDataSet();
    }

    public Map getAllRelationData(InputStream inputStream) throws DSException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            InputSource inputSource = new InputSource(inputStream);
            sAXParser.parse(inputSource, (DefaultHandler)this.close);
            inputStream.close();
            inputStream = null;
            inputSource = null;
        }
        catch (SAXException sAXException) {
            throw new DSException(2147, (Object[])new String[]{sAXException.getMessage()}, (Throwable)sAXException);
        }
        catch (IOException iOException) {
            throw new DSException(2148, (Object[])new String[]{iOException.getMessage()}, (Throwable)iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new DSException(2149, (Object[])new String[]{parserConfigurationException.getMessage()}, (Throwable)parserConfigurationException);
        }
        return this.close.getRelationDataSet();
    }

    public void setCancel(boolean bl) {
        this.close.setCancel(bl);
    }
}

