/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.relational.datasource.xml;

import com.jinfonet.api.datatypes.Types;
import com.jinfonet.dataservice.api.schema.relational.JRelationMetaData;
import com.jinfonet.dataservice.relational.Record;
import com.jinfonet.dataservice.relational.datasource.xml.DataConverterImpl;
import com.jinfonet.dataservice.relational.datasource.xml.DateTimeFormatter;
import com.jinfonet.dataservice.relational.datasource.xml.SpecialDateTimeConverter;
import com.jinfonet.dataservice.relational.datasource.xml.XmlTupleDesc;
import com.jinfonet.datatypes.JinfonetArrayBaseObject;
import com.jinfonet.datatypes.JinfonetBlobBaseBytes;
import com.jinfonet.datatypes.JinfonetDate;
import com.jinfonet.datatypes.JinfonetTime;
import com.jinfonet.datatypes.JinfonetTimeStamp;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import jet.dataengine.api.DSException;

public class XMLTuple {
    private int SEDU = 0;
    private JRelationMetaData add;
    private DateTimeFormatter[] append;
    private boolean[] booleanValue;
    private boolean[] byteValue;
    private XmlTupleDesc[] clear;
    private List[] clearValue;
    private Vector desiredAssertionStatus = new Vector();
    private HashMap doubleValue = new HashMap();
    private TimeZone equals;
    private Locale floatValue;

    public XMLTuple(JRelationMetaData jRelationMetaData, XmlTupleDesc[] xmlTupleDescArray, TimeZone timeZone, Locale locale) throws DSException {
        this.equals = timeZone;
        this.floatValue = locale;
        this.add = jRelationMetaData;
        this.clear = xmlTupleDescArray;
        this.SEDU = this.add.getColumnCount();
        this.append = new DateTimeFormatter[this.SEDU];
        this.clearValue = new List[this.SEDU];
        this.booleanValue = new boolean[this.SEDU];
        this.byteValue = new boolean[this.SEDU];
        for (int i = 0; i < this.SEDU; ++i) {
            this.clearValue[i] = new ArrayList();
            this.booleanValue[i] = false;
            this.byteValue[i] = false;
            this.doubleValue.put(xmlTupleDescArray[i].getColumnName(), new Integer(i + 1));
            if (!this.clear[i].isFixedValue()) continue;
            this.clearValue[i].add(this.clear[i].getDefaultValue());
            this.booleanValue[i] = true;
            this.byteValue[i] = true;
        }
        this.desiredAssertionStatus();
    }

    public void setValue(String string, String string2) {
        int n = this.clear(string);
        if (string2 == null || string2.trim().equals("")) {
            string2 = this.clear[n - 1].getDefaultValue();
        }
        this.clearValue[n - 1].add(string2);
        this.booleanValue[n - 1] = true;
    }

    public void convertToRecord(Record record) throws DSException {
        if (record == null) {
            return;
        }
        if (this.$assertionsDisabled()) {
            this.byteValue(record, this.add);
            return;
        }
        this.append();
        block20: for (int i = 1; i <= this.add.getColumnCount(); ++i) {
            int n = this.add.getColumnType(i);
            if (!this.booleanValue[i - 1]) {
                record.putNull(n);
                continue;
            }
            String string = this.booleanValue(i);
            if (string == null) {
                record.putNull(n);
                continue;
            }
            if (n == 2003) {
                this.add(record, i);
                continue;
            }
            if (string.trim().equals("") && n != 12) {
                record.putNull(n);
                continue;
            }
            switch (n) {
                case -7: {
                    boolean bl = DataConverterImpl.parseBoolean(string);
                    record.putBoolean(bl);
                    continue block20;
                }
                case 3: {
                    BigDecimal bigDecimal = DataConverterImpl.parseDecimal(string);
                    record.putBigDecimal(bigDecimal);
                    continue block20;
                }
                case 2004: {
                    byte[] byArray;
                    if (this.clear[i - 1].getColumnXsdType() == 28) {
                        byArray = DataConverterImpl.parseBase64Binary(string);
                        record.putBlob(new JinfonetBlobBaseBytes(byArray));
                        continue block20;
                    }
                    if (this.clear[i - 1].getColumnXsdType() != 21) continue block20;
                    byArray = DataConverterImpl.parseHexBinary(string);
                    record.putBlob(new JinfonetBlobBaseBytes(byArray));
                    continue block20;
                }
                case -6: {
                    byte by = DataConverterImpl.parseByte(string);
                    record.putByte(by);
                    continue block20;
                }
                case -2: {
                    record.putNull(n);
                    assert (false) : "unsupport data type: BYTES";
                    continue block20;
                }
                case 0x7FFFFFFD: {
                    record.putNull(n);
                    assert (false) : "unsupport data type: CUSTOMER";
                    continue block20;
                }
                case 2005: {
                    record.putNull(n);
                    continue block20;
                }
                case 91: {
                    Date date = this.append[i - 1].parser(string);
                    if (date == null) {
                        record.putNull(91);
                        continue block20;
                    }
                    record.putDate(new JinfonetDate(date.getTime()));
                    continue block20;
                }
                case 8: {
                    record.putDouble(DataConverterImpl.parseDouble(string));
                    continue block20;
                }
                case 6: {
                    record.putFloat(DataConverterImpl.parseFloat(string));
                    continue block20;
                }
                case 4: {
                    record.putInt(DataConverterImpl.parseInt(string));
                    continue block20;
                }
                case -5: {
                    record.putLong(DataConverterImpl.parseLong(string));
                    continue block20;
                }
                case 0: {
                    record.putNull(n);
                    continue block20;
                }
                case 5: {
                    record.putShort(DataConverterImpl.parseShort(string));
                    continue block20;
                }
                case 12: {
                    record.putString(DataConverterImpl.parseString(string));
                    continue block20;
                }
                case 92: {
                    Date date = this.append[i - 1].parser(string);
                    if (date == null) {
                        record.putNull(92);
                        continue block20;
                    }
                    record.putTime(new JinfonetTime(date.getTime()));
                    continue block20;
                }
                case 93: {
                    Date date = this.append[i - 1].parser(string);
                    if (date == null) {
                        record.putNull(93);
                        continue block20;
                    }
                    record.putTimeStamp(new JinfonetTimeStamp(date.getTime()));
                    continue block20;
                }
                case 0x7FFFFFFC: {
                    record.putNull(n);
                    assert (false) : "unsupport data type: UNKNOW";
                    continue block20;
                }
                default: {
                    record.putNull(n);
                    assert (false) : "unsupport data type: " + Types.getDataTypeName(n);
                    continue block20;
                }
            }
        }
        this.clearValue();
    }

    private boolean $assertionsDisabled() {
        boolean bl = true;
        int n = this.booleanValue.length;
        for (int i = 0; i < n; ++i) {
            if (this.clear[i].isNpkNfk() || !this.booleanValue[i]) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private String[] SEDU(String string) {
        String[] stringArray = string.split(" ");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("")) continue;
            arrayList.add(stringArray[i].trim());
        }
        String[] stringArray2 = new String[arrayList.size()];
        arrayList.toArray(stringArray2);
        return stringArray2;
    }

    private void add(Record record, int n) throws DSException {
        XmlTupleDesc xmlTupleDesc = this.clear[n - 1];
        int n2 = this.add.getAttribute(n).getBaseType();
        String[] stringArray = null;
        ArrayList<Comparable<Boolean>> arrayList = new ArrayList<Comparable<Boolean>>();
        if (xmlTupleDesc.isList()) {
            String string = this.booleanValue(n).replaceAll("\n", "");
            stringArray = xmlTupleDesc.getArrayDelim().equals(" ") ? this.SEDU(string) : string.split(xmlTupleDesc.getArrayDelim());
        } else {
            int n3 = this.clearValue[n - 1].size();
            stringArray = new String[n3];
            for (int i = 0; i < n3; ++i) {
                stringArray[i] = (String)this.clearValue[n - 1].get(i);
            }
        }
        int n4 = stringArray.length;
        switch (n2) {
            case -7: {
                int n5;
                int n6 = stringArray.length;
                for (n5 = 0; n5 < n6; ++n5) {
                    if (stringArray[n5] == null || stringArray[n5].equals("")) continue;
                    arrayList.add(Boolean.valueOf(DataConverterImpl.parseBoolean(stringArray[n5])));
                }
                boolean[] blArray = new boolean[arrayList.size()];
                n6 = blArray.length;
                for (n5 = 0; n5 < n6; ++n5) {
                    blArray[n5] = (Boolean)arrayList.get(n5);
                }
                record.putArray(new JinfonetArrayBaseObject(n2, blArray));
                arrayList.clear();
                break;
            }
            case 3: {
                int n7 = stringArray.length;
                for (int i = 0; i < n7; ++i) {
                    if (stringArray[i] == null || stringArray[i].equals("")) continue;
                    arrayList.add(DataConverterImpl.parseDecimal(stringArray[i].trim()));
                }
                BigDecimal[] bigDecimalArray = new BigDecimal[arrayList.size()];
                arrayList.toArray(bigDecimalArray);
                record.putArray(new JinfonetArrayBaseObject(n2, bigDecimalArray));
                arrayList.clear();
                break;
            }
            case 2004: {
                assert (false) : "unSupported Array's base-dataType: blob";
                JinfonetBlobBaseBytes[] jinfonetBlobBaseBytesArray = new JinfonetBlobBaseBytes[n4];
                if (xmlTupleDesc.getColumnXsdType() == 28) {
                    int n8 = n4;
                    for (int i = 0; i < n8; ++i) {
                        if (stringArray[i] == null || stringArray[i].equals("")) continue;
                        byte[] byArray = DataConverterImpl.parseBase64Binary(stringArray[i]);
                        jinfonetBlobBaseBytesArray[i] = byArray == null ? null : new JinfonetBlobBaseBytes(byArray);
                    }
                } else {
                    if (xmlTupleDesc.getColumnXsdType() != 21) break;
                    int n9 = n4;
                    for (int i = 0; i < n9; ++i) {
                        if (stringArray[i] == null || stringArray[i].equals("")) continue;
                        byte[] byArray = DataConverterImpl.parseHexBinary(stringArray[i]);
                        jinfonetBlobBaseBytesArray[i] = byArray == null ? null : new JinfonetBlobBaseBytes(byArray);
                    }
                }
                record.putArray(new JinfonetArrayBaseObject(n2, jinfonetBlobBaseBytesArray));
                break;
            }
            case -6: {
                int n10;
                int n11 = stringArray.length;
                for (n10 = 0; n10 < n11; ++n10) {
                    if (stringArray[n10] == null || stringArray[n10].equals("")) continue;
                    arrayList.add(new Byte(DataConverterImpl.parseByte(stringArray[n10])));
                }
                byte[] byArray = new byte[arrayList.size()];
                n11 = byArray.length;
                for (n10 = 0; n10 < n11; ++n10) {
                    byArray[n10] = (Byte)arrayList.get(n10);
                }
                record.putArray(new JinfonetArrayBaseObject(n2, byArray));
                arrayList.clear();
                break;
            }
            case -2: {
                record.putNull(n2);
                assert (false) : "unsupport data type: BYTES";
                break;
            }
            case 0x7FFFFFFD: {
                record.putNull(n2);
                assert (false) : "unsupport data type: CUSTOMER";
                break;
            }
            case 2005: {
                record.putNull(n2);
                assert (false) : "unsupport data type Clob";
                break;
            }
            case 91: {
                int n12 = stringArray.length;
                for (int i = 0; i < n12; ++i) {
                    Date date;
                    if (stringArray[i] == null || stringArray[i].equals("") || (date = this.append[n - 1].parser(stringArray[i])) == null) continue;
                    arrayList.add(new JinfonetDate(date.getTime()));
                }
                JinfonetDate[] jinfonetDateArray = new JinfonetDate[arrayList.size()];
                arrayList.toArray(jinfonetDateArray);
                record.putArray(new JinfonetArrayBaseObject(n2, jinfonetDateArray));
                arrayList.clear();
                break;
            }
            case 8: {
                int n13;
                int n14 = stringArray.length;
                for (n13 = 0; n13 < n14; ++n13) {
                    if (stringArray[n13] == null || stringArray[n13].equals("")) continue;
                    arrayList.add(new Double(DataConverterImpl.parseDouble(stringArray[n13].trim())));
                }
                double[] dArray = new double[arrayList.size()];
                n14 = dArray.length;
                for (n13 = 0; n13 < n14; ++n13) {
                    dArray[n13] = (Double)arrayList.get(n13);
                }
                record.putArray(new JinfonetArrayBaseObject(n2, dArray));
                arrayList.clear();
                break;
            }
            case 6: {
                int n15;
                int n16 = stringArray.length;
                for (n15 = 0; n15 < n16; ++n15) {
                    if (stringArray[n15] == null || stringArray[n15].equals("")) continue;
                    arrayList.add(new Float(DataConverterImpl.parseFloat(stringArray[n15].trim())));
                }
                float[] fArray2 = new float[arrayList.size()];
                n16 = fArray2.length;
                for (n15 = 0; n15 < n16; ++n15) {
                    fArray2[n15] = ((Float)arrayList.get(n15)).floatValue();
                }
                record.putArray(new JinfonetArrayBaseObject(n2, fArray2));
                arrayList.clear();
                break;
            }
            case 4: {
                int n17;
                int n18 = stringArray.length;
                for (n17 = 0; n17 < n18; ++n17) {
                    if (stringArray[n17] == null || stringArray[n17].equals("")) continue;
                    arrayList.add(new Integer(DataConverterImpl.parseInt(stringArray[n17].trim())));
                }
                int[] nArray = new int[arrayList.size()];
                n18 = nArray.length;
                for (n17 = 0; n17 < n18; ++n17) {
                    nArray[n17] = (Integer)arrayList.get(n17);
                }
                record.putArray(new JinfonetArrayBaseObject(n2, nArray));
                arrayList.clear();
                break;
            }
            case -5: {
                int n19;
                int n20 = stringArray.length;
                for (n19 = 0; n19 < n20; ++n19) {
                    if (stringArray[n19] == null || stringArray[n19].equals("")) continue;
                    arrayList.add(new Long(DataConverterImpl.parseLong(stringArray[n19].trim())));
                }
                long[] lArray = new long[arrayList.size()];
                n20 = lArray.length;
                for (n19 = 0; n19 < n20; ++n19) {
                    lArray[n19] = (Long)arrayList.get(n19);
                }
                record.putArray(new JinfonetArrayBaseObject(n2, lArray));
                arrayList.clear();
                break;
            }
            case 0: {
                record.putNull(n2);
                break;
            }
            case 5: {
                int n21;
                int n22 = stringArray.length;
                for (n21 = 0; n21 < n22; ++n21) {
                    if (stringArray[n21] == null || stringArray[n21].equals("")) continue;
                    arrayList.add(new Short(DataConverterImpl.parseShort(stringArray[n21].trim())));
                }
                short[] sArray = new short[arrayList.size()];
                n22 = sArray.length;
                for (n21 = 0; n21 < n22; ++n21) {
                    sArray[n21] = (Short)arrayList.get(n21);
                }
                record.putArray(new JinfonetArrayBaseObject(n2, sArray));
                arrayList.clear();
                break;
            }
            case 12: {
                record.putArray(new JinfonetArrayBaseObject(n2, stringArray));
                break;
            }
            case 92: {
                int n23 = stringArray.length;
                for (int i = 0; i < n23; ++i) {
                    Date date;
                    if (stringArray[i] == null || stringArray[i].equals("") || (date = this.append[n - 1].parser(stringArray[i])) == null) continue;
                    arrayList.add(new JinfonetTime(date.getTime()));
                }
                JinfonetTime[] jinfonetTimeArray = new JinfonetTime[arrayList.size()];
                arrayList.toArray(jinfonetTimeArray);
                record.putArray(new JinfonetArrayBaseObject(n2, jinfonetTimeArray));
                arrayList.clear();
                break;
            }
            case 93: {
                if (xmlTupleDesc.isList() && this.doubleValue(xmlTupleDesc.getArrayDelim())) {
                    Vector vector = new SpecialDateTimeConverter(this.append[n - 1].getOriginalPattern(), xmlTupleDesc.getArrayDelim()).parseValue(stringArray);
                    int n24 = vector.size();
                    for (int i = 0; i < n24; ++i) {
                        Date date;
                        if (vector.get(i) == null || vector.get(i).equals("") || (date = this.append[n - 1].parser((String)vector.get(i))) == null) continue;
                        arrayList.add(new JinfonetTimeStamp(date.getTime()));
                    }
                } else {
                    int n25 = stringArray.length;
                    for (int i = 0; i < n25; ++i) {
                        Date date;
                        if (stringArray[i] == null || stringArray[i].equals("") || (date = this.append[n - 1].parser(stringArray[i])) == null) continue;
                        arrayList.add(new JinfonetTimeStamp(date.getTime()));
                    }
                }
                JinfonetTimeStamp[] jinfonetTimeStampArray = new JinfonetTimeStamp[arrayList.size()];
                arrayList.toArray(jinfonetTimeStampArray);
                record.putArray(new JinfonetArrayBaseObject(n2, jinfonetTimeStampArray));
                arrayList.clear();
                break;
            }
            case 0x7FFFFFFC: {
                record.putNull(n2);
                assert (false) : "unsupport data type: UNKNOW";
                break;
            }
            default: {
                record.putNull(n2);
                assert (false) : "unsupport data type: " + Types.getDataTypeName(n2);
                break;
            }
        }
    }

    private void append() {
        int n = this.clear.length;
        for (int i = 0; i < n; ++i) {
            if (this.booleanValue[i] || this.clear[i].isFixedValue()) continue;
            if (this.clear[i].isAttNode()) {
                this.booleanValue[i] = true;
                this.clearValue[i].add(this.clear[i].getDefaultValue());
                continue;
            }
            this.clearValue[i].add(null);
        }
    }

    private String booleanValue(int n) {
        String string = null;
        XmlTupleDesc xmlTupleDesc = this.clear[n - 1];
        ArrayList arrayList = (ArrayList)this.clearValue[n - 1];
        if (arrayList.size() <= 0) {
            return string;
        }
        int n2 = xmlTupleDesc.getMultiOccurType();
        switch (n2) {
            case 1: 
            case 3: {
                string = (String)arrayList.get(arrayList.size() - 1);
                break;
            }
            case 2: {
                string = (String)arrayList.get(0);
                break;
            }
            case 5: {
                break;
            }
            default: {
                string = (String)arrayList.get(n2 - 1);
            }
        }
        return string;
    }

    private void byteValue(Record record, JRelationMetaData jRelationMetaData) throws DSException {
        for (int i = 1; i <= jRelationMetaData.getColumnCount(); ++i) {
            if (this.clear[i - 1].isNpkNfk()) {
                String string = this.booleanValue(i);
                record.putInt(DataConverterImpl.parseInt(string));
                continue;
            }
            record.putNull(jRelationMetaData.getColumnType(i));
        }
    }

    public void clearValue() {
        for (int i = 0; i < this.SEDU; ++i) {
            if (this.byteValue[i]) continue;
            this.clearValue[i].clear();
            this.booleanValue[i] = false;
        }
    }

    public boolean hasValue(String string) {
        int n = this.clear(string);
        return this.booleanValue[n - 1];
    }

    private int clear(String string) {
        return (Integer)this.doubleValue.get(string);
    }

    private void desiredAssertionStatus() throws DSException {
        block3: for (int i = 0; i < this.add.getColumnCount(); ++i) {
            int n = this.add.getColumnType(i + 1);
            if (n == 2003) {
                n = this.add.getAttribute(i + 1).getBaseType();
            }
            switch (n) {
                case 91: 
                case 92: 
                case 93: {
                    this.append[i] = new DateTimeFormatter(this.clear[i].getXsdPattren(), this.clear[i].getPatternType(), this.equals, this.floatValue);
                    continue block3;
                }
                default: {
                    this.append[i] = null;
                }
            }
        }
    }

    private boolean doubleValue(String string) {
        if (string == null) {
            return false;
        }
        return string.trim().equals("");
    }

    public Vector getBeginXpath() {
        return this.desiredAssertionStatus;
    }

    public void setBeginXpath(String string) {
        this.desiredAssertionStatus.add(string);
    }
}

