/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.relational.extendproject.function.jreportformula;

import jet.connect.DbArray;
import jet.connect.DbBigInt;
import jet.connect.DbBinary;
import jet.connect.DbBit;
import jet.connect.DbChar;
import jet.connect.DbColDesc;
import jet.connect.DbDate;
import jet.connect.DbDecimal;
import jet.connect.DbDouble;
import jet.connect.DbInteger;
import jet.connect.DbReal;
import jet.connect.DbRecord;
import jet.connect.DbRecordModel;
import jet.connect.DbSmallInt;
import jet.connect.DbTime;
import jet.connect.DbTimestamp;
import jet.connect.DbTinyInt;
import jet.connect.DbValue;

public class DSTuple
extends DbRecord {
    public DSTuple(DbRecordModel dbRecordModel) {
        super(dbRecordModel);
        DbColDesc[] dbColDescArray = dbRecordModel.getColDescs();
        this.cells = new DbValue[dbColDescArray.length];
        for (int i = 0; i < this.cells.length; ++i) {
            this.cells[i] = DSTuple.makeDbValue(dbColDescArray[i]);
            if (this.cells[i] == null) {
                throw new Error("unknown sql type : " + dbColDescArray[i].getSqlType() + " of the column " + dbColDescArray[i].colName);
            }
            this.cells[i].setColDesc(dbColDescArray[i]);
        }
    }

    public void setCell(String string, DbValue dbValue) {
        DbRecordModel dbRecordModel = this.getRecordModel();
        int n = dbRecordModel.indexOfCell(string);
        this.cells[n] = dbValue;
    }

    public void setCell(int n, DbValue dbValue) {
        this.cells[n].set(dbValue);
    }

    @Override
    public String toString() {
        DbRecordModel dbRecordModel = this.getRecordModel();
        DbColDesc[] dbColDescArray = dbRecordModel.getColDescs();
        String string = null;
        for (int i = 0; i < dbColDescArray.length; ++i) {
            string = "\n column name:";
            string = string + dbColDescArray[i].getColName();
            string = string + "/column index:" + dbColDescArray[i].getColIndex();
        }
        return string;
    }

    public static final DbValue makeDbValue(DbColDesc dbColDesc) {
        DbValue dbValue = null;
        if (dbColDesc.isArray()) {
            dbValue = new DbArray(dbColDesc);
            return dbValue;
        }
        switch (dbColDesc.sqlType) {
            case 5: {
                dbValue = new DbSmallInt(dbColDesc);
                break;
            }
            case -6: {
                dbValue = new DbTinyInt(dbColDesc);
                break;
            }
            case 4: {
                dbValue = new DbInteger(dbColDesc);
                break;
            }
            case -5: {
                dbValue = new DbBigInt(dbColDesc);
                break;
            }
            case 6: 
            case 7: {
                dbValue = new DbReal(dbColDesc);
                break;
            }
            case 2: 
            case 3: {
                dbValue = new DbDecimal(dbColDesc);
                break;
            }
            case 8: {
                dbValue = new DbDouble(dbColDesc);
                break;
            }
            case -7: {
                dbValue = new DbBit(dbColDesc);
                break;
            }
            case 91: {
                dbValue = new DbDate(dbColDesc);
                break;
            }
            case 92: {
                dbValue = new DbTime(dbColDesc);
                break;
            }
            case 93: {
                dbValue = new DbTimestamp(dbColDesc);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                dbValue = new DbChar(dbColDesc);
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                dbValue = new DbBinary(dbColDesc);
                break;
            }
        }
        return dbValue;
    }
}

