/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.relational.extendproject.function.jreportformula;

import com.jinfonet.dataservice.relational.extendproject.function.jreportformula.DSFunction;
import com.jinfonet.dataservice.relational.extendproject.function.jreportformula.FormulaDBField;
import com.jinfonet.dataservice.relational.extendproject.function.jreportformula.FunctionParser;
import com.jinfonet.dataservice.relational.extendproject.function.jreportformula.Parameter;
import com.jinfonet.dataservice.relational.extendproject.function.jreportformula.ParserToolKit;
import com.jinfonet.dataservice.relational.extendproject.function.jreportformula.RptFormulaFunctionExecutor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import jet.dataengine.api.DSException;
import jet.formula.FormulaInfo;
import jet.formula.SymbolInfo;
import jet.util.HashVector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FunctionInfoXMLTransfer {
    private HashVector ErrorInner = new HashVector();
    private Hashtable Fatal = new Hashtable();
    private Hashtable GroupbyNames = new Hashtable();
    private String I = null;
    private long SEDU;
    private String Z = null;

    public String getClassName() {
        return this.I;
    }

    public void saveFormulaInfo(OutputStream outputStream) {
        Document document = ParserToolKit.newDocument();
        Element element = document.createElement("Formulas");
        element.setAttribute("className", this.I);
        element.setAttribute("classPath", this.Z);
        element.setAttribute("versionID", String.valueOf(this.SEDU));
        String string = null;
        DSFunction dSFunction = null;
        Element element2 = null;
        Element element3 = null;
        SymbolInfo symbolInfo = null;
        FormulaInfo formulaInfo = null;
        int n = this.ErrorInner.size();
        for (int i = 0; i < n; ++i) {
            string = (String)this.ErrorInner.get(i);
            dSFunction = (DSFunction)this.ErrorInner.get(string);
            if (dSFunction == null) {
                System.out.println("null formula ..." + string);
                continue;
            }
            if (dSFunction.formulainfo == null) {
                System.out.println("null formula info ..." + string);
                continue;
            }
            if (dSFunction.formulainfo.formulatype == null) {
                System.out.println("null formula symbol info ..." + string);
                continue;
            }
            element2 = document.createElement("formula");
            element2.setAttribute("name", string);
            element2.setAttribute("expression", dSFunction.getExpression());
            symbolInfo = dSFunction.formulainfo.formulatype;
            element2.setAttribute("type", String.valueOf(symbolInfo.getDataType()));
            if (dSFunction.formulainfo != null) {
                Element element4;
                Object object;
                String string2;
                int n2;
                formulaInfo = dSFunction.formulainfo;
                element3 = document.createElement("FormulaInfo");
                element3.setAttribute("isGlobal", formulaInfo.isGlobal ? "true" : "false");
                element3.setAttribute("isGroupby", formulaInfo.isGroupby ? "true" : "false");
                element3.setAttribute("callee", String.valueOf(formulaInfo.callee));
                SymbolInfo symbolInfo2 = formulaInfo.formulatype;
                Element element5 = document.createElement("SymbolInfo");
                element5.setAttribute("name", symbolInfo2.getSymName());
                element5.setAttribute("attr", String.valueOf(symbolInfo2.getAttr()));
                element5.setAttribute("isSum", symbolInfo2.isSum ? "true" : "false");
                element5.setAttribute("type", String.valueOf(symbolInfo2.getDataType()));
                element5.setAttribute("precise", String.valueOf(symbolInfo2.getPrecise()));
                element5.setAttribute("scale", String.valueOf(symbolInfo2.getScale()));
                element3.appendChild(element5);
                Vector vector = formulaInfo.GroupbyNames;
                if (vector != null) {
                    for (n2 = 0; n2 < vector.size(); ++n2) {
                        string2 = (String)vector.get(n2);
                        object = document.createElement("GroupByName");
                        object.setAttribute("name", string2);
                        element3.appendChild((Node)object);
                    }
                }
                if ((vector = formulaInfo.refFormula) != null) {
                    for (n2 = 0; n2 < vector.size(); ++n2) {
                        string2 = (String)vector.get(n2);
                        object = document.createElement("refFormula");
                        object.setAttribute("name", string2);
                        element3.appendChild((Node)object);
                    }
                }
                if ((vector = formulaInfo.refAggregation) != null) {
                    for (n2 = 0; n2 < vector.size(); ++n2) {
                        string2 = (String)vector.get(n2);
                        object = document.createElement("refAggregation");
                        object.setAttribute("name", string2);
                        element3.appendChild((Node)object);
                    }
                }
                if ((vector = formulaInfo.refDBfield) != null) {
                    for (n2 = 0; n2 < vector.size(); ++n2) {
                        string2 = (String)vector.get(n2);
                        object = (FormulaDBField)this.Fatal.get(string2);
                        element4 = document.createElement("DBField");
                        element4.setAttribute("name", string2);
                        element4.setAttribute("type", String.valueOf(((FormulaDBField)object).getType()));
                        element3.appendChild(element4);
                    }
                }
                if ((vector = formulaInfo.refParameter) != null) {
                    for (n2 = 0; n2 < vector.size(); ++n2) {
                        string2 = (String)vector.get(n2);
                        object = (Parameter)this.GroupbyNames.get(string2);
                        element4 = document.createElement("parameter");
                        element4.setAttribute("name", string2);
                        element4.setAttribute("type", String.valueOf(((Parameter)object).getType()));
                        element3.appendChild(element4);
                    }
                }
                element2.appendChild(element3);
            }
            element.appendChild(element2);
        }
        document.appendChild(element);
        try {
            ParserToolKit.toStream(document, outputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void loadFormulaInfo(InputStream inputStream) throws DSException {
        Document document = null;
        try {
            document = ParserToolKit.parseToDOM1(inputStream);
        }
        catch (SAXException sAXException) {
            throw new DSException(DSException.ErrorType.ErrorInner, DSException.ExceptionLevel.Fatal, "DSF15", "An SAXException encounted when parsing XML file: " + sAXException.getMessage(), true, null);
        }
        catch (IOException iOException) {
            throw new DSException(DSException.ErrorType.ErrorInner, DSException.ExceptionLevel.Fatal, "DSF16", "An IOException encounted when reading XML file: " + iOException.getMessage(), true, null);
        }
        NodeList nodeList = document.getChildNodes();
        Node node = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!nodeList.item(i).getNodeName().equals("Formulas")) continue;
            node = nodeList.item(i);
            NamedNodeMap namedNodeMap = node.getAttributes();
            this.I = namedNodeMap.getNamedItem("className").getNodeValue();
            this.Z = namedNodeMap.getNamedItem("classPath").getNodeValue();
            if (namedNodeMap.getNamedItem("versionID") == null) break;
            this.SEDU = Long.parseLong(namedNodeMap.getNamedItem("versionID").getNodeValue());
            break;
        }
        if (node == null) {
            throw new DSException(DSException.ErrorType.ErrorInner, DSException.ExceptionLevel.Fatal, "DSF17", "Error format in XML file of formula infomation: root node not found!", true, null);
        }
        NodeList nodeList2 = node.getChildNodes();
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            Node node2 = nodeList2.item(i);
            if (!node2.getNodeName().equals("formula")) continue;
            NamedNodeMap namedNodeMap = node2.getAttributes();
            DSFunction dSFunction = new DSFunction(namedNodeMap.getNamedItem("name").getNodeValue(), namedNodeMap.getNamedItem("expression").getNodeValue(), null);
            Node node3 = null;
            NodeList nodeList3 = node2.getChildNodes();
            for (int j = 0; j < nodeList3.getLength(); ++j) {
                node3 = nodeList3.item(j);
                if (!node3.getNodeName().equals("FormulaInfo")) continue;
                namedNodeMap = node3.getAttributes();
                FormulaInfo formulaInfo = new FormulaInfo();
                String string = namedNodeMap.getNamedItem("isGlobal").getNodeValue();
                formulaInfo.isGlobal = string.equals("true");
                string = namedNodeMap.getNamedItem("isGroupby").getNodeValue();
                formulaInfo.isGroupby = string.equals("true");
                formulaInfo.callee = Integer.parseInt(namedNodeMap.getNamedItem("callee").getNodeValue());
                dSFunction.formulainfo = formulaInfo;
                NodeList nodeList4 = node3.getChildNodes();
                for (int k = 0; k < nodeList4.getLength(); ++k) {
                    int n;
                    String string2;
                    Node node4 = nodeList4.item(k);
                    namedNodeMap = node4.getAttributes();
                    if (node4.getNodeName().equals("SymbolInfo")) {
                        SymbolInfo symbolInfo;
                        string2 = namedNodeMap.getNamedItem("name").getNodeValue();
                        n = Integer.parseInt(namedNodeMap.getNamedItem("type").getNodeValue());
                        int n2 = Integer.parseInt(namedNodeMap.getNamedItem("attr").getNodeValue());
                        boolean bl = namedNodeMap.getNamedItem("isSum").getNodeValue().equals("true");
                        int n3 = Integer.parseInt(namedNodeMap.getNamedItem("precise").getNodeValue());
                        int n4 = Integer.parseInt(namedNodeMap.getNamedItem("scale").getNodeValue());
                        formulaInfo.formulatype = symbolInfo = new SymbolInfo(string2, "", n, 1, n2, 1, bl, n3, n4);
                    }
                    if (node4.getNodeName().equals("GroupByName")) {
                        if (formulaInfo.GroupbyNames == null) {
                            formulaInfo.GroupbyNames = new Vector();
                        }
                        formulaInfo.GroupbyNames.add(namedNodeMap.getNamedItem("name").getNodeValue());
                    }
                    if (node4.getNodeName().equals("refFormula")) {
                        if (formulaInfo.refFormula == null) {
                            formulaInfo.refFormula = new Vector();
                        }
                        formulaInfo.refFormula.add(namedNodeMap.getNamedItem("name").getNodeValue());
                    }
                    if (node4.getNodeName().equals("refAggregation")) {
                        if (formulaInfo.refAggregation == null) {
                            formulaInfo.refAggregation = new Vector();
                        }
                        formulaInfo.refAggregation.add(namedNodeMap.getNamedItem("name").getNodeValue());
                    }
                    if (node4.getNodeName().equals("DBField")) {
                        if (formulaInfo.refDBfield == null) {
                            formulaInfo.refDBfield = new Vector();
                        }
                        string2 = namedNodeMap.getNamedItem("name").getNodeValue();
                        n = Integer.parseInt(namedNodeMap.getNamedItem("type").getNodeValue());
                        formulaInfo.refDBfield.add(string2);
                        FormulaDBField formulaDBField = new FormulaDBField(string2, n);
                        this.Fatal.put(string2, formulaDBField);
                    }
                    if (!node4.getNodeName().equals("parameter")) continue;
                    if (formulaInfo.refParameter == null) {
                        formulaInfo.refParameter = new Vector();
                    }
                    string2 = namedNodeMap.getNamedItem("name").getNodeValue();
                    n = Integer.parseInt(namedNodeMap.getNamedItem("type").getNodeValue());
                    formulaInfo.refParameter.add(string2);
                    Parameter parameter = new Parameter(string2, n);
                    this.GroupbyNames.put(string2, parameter);
                }
                this.ErrorInner.put(dSFunction.getName(), dSFunction);
            }
        }
    }

    public String getClassPath() {
        return this.Z;
    }

    public void loadFromParser(FunctionParser functionParser) {
        this.ErrorInner = functionParser.getFunctions();
        this.Fatal = functionParser.getAllDBFields();
        this.GroupbyNames = functionParser.getAllParameters();
        this.Z = functionParser.getClassPath();
        this.I = functionParser.getClassName();
        this.SEDU = functionParser.getVersion();
    }

    public RptFormulaFunctionExecutor getFormulaExecutor() throws DSException {
        if (this.ErrorInner.size() == 0) {
            return null;
        }
        RptFormulaFunctionExecutor rptFormulaFunctionExecutor = new RptFormulaFunctionExecutor();
        rptFormulaFunctionExecutor.setDBFields(this.Fatal);
        rptFormulaFunctionExecutor.setParameters(this.GroupbyNames);
        rptFormulaFunctionExecutor.setFunctions(this.ErrorInner);
        rptFormulaFunctionExecutor.setClassName(this.I);
        rptFormulaFunctionExecutor.setClassPath(this.Z);
        rptFormulaFunctionExecutor.loadClass();
        return rptFormulaFunctionExecutor;
    }

    public HashVector getFormulas() {
        return this.ErrorInner;
    }
}

