/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.relational.extendproject.function.jreportformula;

import com.jinfonet.api.datatypes.Blob;
import com.jinfonet.api.datatypes.Date;
import com.jinfonet.api.datatypes.Time;
import com.jinfonet.api.datatypes.Timestamp;
import com.jinfonet.dataservice.api.schema.relational.JRelationMetaData;
import com.jinfonet.dataservice.api.schema.relational.datasource.relational.SqlTypes;
import com.jinfonet.dataservice.relational.AAdditionTuple;
import com.jinfonet.dataservice.relational.ITuple;
import com.jinfonet.dataservice.relational.extendproject.function.IExtendFunctionExecutor;
import com.jinfonet.dataservice.relational.extendproject.function.jreportformula.DSColDesc;
import com.jinfonet.dataservice.relational.extendproject.function.jreportformula.DSFunction;
import com.jinfonet.dataservice.relational.extendproject.function.jreportformula.DSTuple;
import com.jinfonet.dataservice.relational.extendproject.function.jreportformula.FunctionBase;
import com.jinfonet.dataservice.relational.extendproject.function.jreportformula.FunctionInfoXMLTransfer;
import com.jinfonet.dataservice.relational.extendproject.function.jreportformula.Parameter;
import com.jinfonet.datatypes.JinfonetDate;
import com.jinfonet.datatypes.JinfonetSqlBlob;
import com.jinfonet.datatypes.JinfonetTime;
import com.jinfonet.datatypes.JinfonetTimeStamp;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import jet.connect.DbBigInt;
import jet.connect.DbBinary;
import jet.connect.DbBit;
import jet.connect.DbChar;
import jet.connect.DbColDesc;
import jet.connect.DbDate;
import jet.connect.DbDecimal;
import jet.connect.DbDouble;
import jet.connect.DbInteger;
import jet.connect.DbNumber;
import jet.connect.DbReal;
import jet.connect.DbRecord;
import jet.connect.DbRecordModel;
import jet.connect.DbSmallInt;
import jet.connect.DbTime;
import jet.connect.DbTimestamp;
import jet.connect.DbTinyInt;
import jet.connect.DbValue;
import jet.connect.Groupable;
import jet.dataengine.api.DSException;
import jet.formula.DataType;
import jet.formula.FormulaClassLoader;
import jet.formula.JavaFormula;
import jet.formula.SymbolInfo;

public class RptFormulaFunctionExecutor
extends FunctionBase
implements IExtendFunctionExecutor {
    private Class B = null;
    private JavaFormula D = null;
    private JRelationMetaData ErrorInner = null;
    private JRelationMetaData F = null;
    private int[] Fatal = null;
    private int[] FmlToSql = null;
    private int[] I = null;
    private int[] J = null;
    private DSTuple S = null;
    private String[] SEDU;
    protected String[] executableFunctions = null;
    private int[] Z;

    public RptFormulaFunctionExecutor() {
    }

    public RptFormulaFunctionExecutor(String string) throws DSException, FileNotFoundException {
        FunctionInfoXMLTransfer functionInfoXMLTransfer = new FunctionInfoXMLTransfer();
        FileInputStream fileInputStream = null;
        fileInputStream = new FileInputStream(new File(string));
        try {
            functionInfoXMLTransfer.loadFormulaInfo(fileInputStream);
        }
        catch (DSException dSException) {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                throw new DSException(DSException.ErrorType.ErrorInner, DSException.ExceptionLevel.Fatal, "DSF5", "Close file failed: " + string, true, dSException.getMessageStack());
            }
            throw dSException;
        }
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {
            throw new DSException(DSException.ErrorType.ErrorInner, DSException.ExceptionLevel.Fatal, "DSF6", "Close file failed: " + string, true, null);
        }
        this.functions = functionInfoXMLTransfer.getFormulas();
        this.sortAllFormulas();
        this.className = functionInfoXMLTransfer.getClassName();
        this.classPath = functionInfoXMLTransfer.getClassPath();
        this.loadClass();
    }

    public void loadClass() throws DSException {
        byte[] byArray;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.classPath + this.className + ".class");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new DSException(DSException.ErrorType.ErrorInner, DSException.ExceptionLevel.Fatal, "DSF7", "file not found: " + this.classPath + this.className + ".class", true, null);
        }
        try {
            byArray = new byte[fileInputStream.available()];
            fileInputStream.read(byArray);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            throw new DSException(DSException.ErrorType.ErrorInner, DSException.ExceptionLevel.Fatal, "DSF8", "IOException encounted when read class file", true, null);
        }
        FormulaClassLoader formulaClassLoader = new FormulaClassLoader();
        try {
            this.B = formulaClassLoader.defineClass(this.className, byArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DSException(DSException.ErrorType.ErrorInner, DSException.ExceptionLevel.Fatal, "DSF9", "class not found: " + this.className, true, null);
        }
    }

    private void B() throws DSException {
        try {
            this.D = (JavaFormula)this.B.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new DSException(DSException.ErrorType.ErrorInner, DSException.ExceptionLevel.Fatal, "DSF10", "IllegalAccessException encountered during initialize class " + this.className, true, null);
        }
        catch (InstantiationException instantiationException) {
            throw new DSException(DSException.ErrorType.ErrorInner, DSException.ExceptionLevel.Fatal, "DSF11", "InstantiationException encountered during initialize class " + this.className, true, null);
        }
    }

    private DSTuple D() throws DSException {
        int n;
        Object object;
        int n2;
        int n3;
        int n4;
        String[] stringArray;
        int n5;
        String string = null;
        DSFunction dSFunction = null;
        SymbolInfo symbolInfo = null;
        this.formulaSorted = this.sortFormulas(this.executableFunctions);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        HashSet<String> hashSet = new HashSet<String>();
        for (n5 = 0; n5 < this.executableFunctions.length; ++n5) {
            stringArray = this.getDBFieldRef(this.executableFunctions[n5]);
            for (n4 = 0; n4 < stringArray.length; ++n4) {
                hashSet.add(stringArray[n4]);
            }
        }
        n5 = 0;
        stringArray = new ArrayList();
        n4 = this.ErrorInner.getColumnCount();
        for (n3 = 1; n3 <= n4; ++n3) {
            if (!hashSet.contains(this.SEDU[n3 - 1])) continue;
            n2 = SqlTypes.typeToSqlType(this.ErrorInner.getColumnType(n3));
            stringArray.add(new Integer(n3));
            object = new DSColDesc(this.SEDU[n3 - 1], n2, n2 == 2004 ? 0 : this.ErrorInner.getPrecision(n3), this.ErrorInner.getScale(n3), SqlTypes.typeIsNullableToSql(this.ErrorInner.isNullable(n3)), this.ErrorInner.isCurrency(n3));
            ((DbColDesc)object).setColIndex(++n5);
            ((DSColDesc)object).isDBField = true;
            arrayList.add(object);
        }
        this.I = new int[stringArray.size()];
        for (n3 = 0; n3 < this.I.length; ++n3) {
            this.I[n3] = (Integer)stringArray.get(n3);
        }
        stringArray.clear();
        hashSet.clear();
        hashSet = null;
        n3 = this.formulaSorted.size();
        for (n2 = 0; n2 < n3; ++n2) {
            string = (String)this.formulaSorted.get(n2);
            dSFunction = (DSFunction)this.functions.get(string);
            if (dSFunction.formulainfo == null) continue;
            symbolInfo = dSFunction.formulainfo.formulatype;
            object = new DSColDesc(string, DataType.FmlToSql(symbolInfo.getDataType()), symbolInfo.getPrecise(), symbolInfo.getScale(), 2);
            ((DbColDesc)object).setColIndex(++n5);
            ((DSColDesc)object).isDBField = false;
            arrayList.add(object);
        }
        DbColDesc[] dbColDescArray = new DSColDesc[arrayList.size()];
        arrayList.toArray(dbColDescArray);
        object = new DSTuple(new DbRecordModel(dbColDescArray, (Groupable)null));
        DbRecordModel dbRecordModel = ((DbRecord)object).getRecordModel();
        this.Fatal = new int[this.formulaSorted.size()];
        this.FmlToSql = new int[this.Fatal.length];
        for (n = 0; n < this.Fatal.length; ++n) {
            string = (String)this.formulaSorted.get(n);
            dSFunction = (DSFunction)this.functions.get(string);
            this.Fatal[n] = dSFunction.formulainfo.callee;
            this.FmlToSql[n] = dbRecordModel.indexOfCell(string);
        }
        this.J = new int[this.executableFunctions.length];
        for (n = 0; n < this.executableFunctions.length; ++n) {
            this.J[n] = dbRecordModel.indexOfCell(this.executableFunctions[n]);
        }
        return object;
    }

    public void initMetaData(JRelationMetaData jRelationMetaData) throws DSException {
        this.ErrorInner = jRelationMetaData;
        this.SEDU = new String[jRelationMetaData.getColumnCount()];
        for (int i = 0; i < this.SEDU.length; ++i) {
            this.SEDU[i] = jRelationMetaData.getColumnName(i + 1).toUpperCase();
        }
        this.B();
        this.S = this.D();
        this.D.setEnvironment(this.S);
        this.D.setRecord(this.S);
        this.D.setParameters(this.getParameters());
    }

    public void setExecutableFunctions(JRelationMetaData jRelationMetaData) throws DSException {
        int n;
        int n2 = jRelationMetaData.getColumnCount();
        this.executableFunctions = new String[n2];
        for (n = 0; n < n2; ++n) {
            this.executableFunctions[n] = jRelationMetaData.getColumnName(n + 1).toUpperCase();
        }
        this.F = jRelationMetaData;
        for (n = 0; n < n2; ++n) {
            int n3;
            DSFunction dSFunction = (DSFunction)this.functions.get(this.executableFunctions[n]);
            int n4 = DataType.FmlToSql(dSFunction.formulainfo.formulatype.getDataType());
            if (n4 == (n3 = SqlTypes.typeToSqlType(jRelationMetaData.getColumnType(n + 1)))) continue;
            throw new DSException();
        }
    }

    public void setParameter(String string, DbValue dbValue) {
        Parameter parameter = (Parameter)this.parameters.get(string);
        parameter.setValue(dbValue);
    }

    private void ErrorInner(ITuple iTuple, DbColDesc dbColDesc, DbValue dbValue) throws DSException {
        try {
            int n = this.I[dbColDesc.getColIndex()];
            switch (dbColDesc.sqlType) {
                case 5: {
                    ((DbSmallInt)dbValue).value = iTuple.getShort(n);
                    break;
                }
                case -6: {
                    ((DbTinyInt)dbValue).value = iTuple.getByte(n);
                    break;
                }
                case 4: {
                    ((DbInteger)dbValue).value = iTuple.getInt(n);
                    break;
                }
                case -5: {
                    ((DbBigInt)dbValue).value = iTuple.getLong(n);
                    break;
                }
                case 7: {
                    try {
                        ((DbReal)dbValue).value = iTuple.getFloat(n);
                    }
                    catch (DSException dSException) {
                        ((DbReal)dbValue).value = Float.parseFloat(iTuple.getString(n));
                    }
                    break;
                }
                case 2: 
                case 3: {
                    ((DbDecimal)dbValue).value = iTuple.getBigDecimal(n);
                    break;
                }
                case 6: 
                case 8: {
                    ((DbDouble)dbValue).value = iTuple.getDouble(n);
                    break;
                }
                case -7: {
                    ((DbBit)dbValue).value = iTuple.getBoolean(n);
                    break;
                }
                case 91: {
                    Date date = iTuple.getDate(n);
                    if (date == null) break;
                    ((DbDate)dbValue).value = date.getTime();
                    break;
                }
                case 92: {
                    Time time2 = iTuple.getTime(n);
                    if (time2 == null) break;
                    ((DbTime)dbValue).value = time2.getTime();
                    break;
                }
                case 93: {
                    Timestamp timestamp = iTuple.getTimeStamp(n);
                    if (timestamp == null) break;
                    ((DbTimestamp)dbValue).value = timestamp.getTime();
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    ((DbChar)dbValue).value = iTuple.getString(n);
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    ((DbBinary)dbValue).value = iTuple.getBytes(n);
                    break;
                }
                case 2004: {
                    Blob blob = iTuple.getBlob(n);
                    if (blob == null) break;
                    JinfonetSqlBlob jinfonetSqlBlob = new JinfonetSqlBlob(iTuple.getBlob(n));
                    ((DbBinary)dbValue).value = jinfonetSqlBlob.getBytes(1L, (int)jinfonetSqlBlob.length());
                    break;
                }
                default: {
                    String string = "Unsupported sql type : " + dbColDesc.getSqlType() + " of the column " + dbColDesc.colName;
                    throw new DSException(DSException.ErrorType.ErrorInner, DSException.ExceptionLevel.Fatal, "DSF13", string, true, null);
                }
            }
            dbValue.bNull = iTuple.wasNull();
        }
        catch (SQLException sQLException) {
            throw new DSException(DSException.ErrorType.ErrorInner, DSException.ExceptionLevel.Fatal, "DSF14", "SQLException encounted during retrieve data. column: " + dbColDesc.colName + "\n" + sQLException.toString(), true, null);
        }
    }

    public void setSpicalFields(Object object) {
        this.D.__sys__USERNAME().set("userName");
    }

    @Override
    public ITuple execute(ITuple iTuple, AAdditionTuple aAdditionTuple) throws DSException {
        int n;
        DbRecordModel dbRecordModel = this.S.getRecordModel();
        DSColDesc[] dSColDescArray = (DSColDesc[])dbRecordModel.getColDescs();
        DbValue dbValue = null;
        int n2 = this.I.length;
        for (n = 0; n < n2; ++n) {
            this.ErrorInner(iTuple, dSColDescArray[n], this.S.getCell(dSColDescArray[n].getColIndex()));
        }
        for (n = 0; n < this.Fatal.length; ++n) {
            dbValue = this.D.schedule(this.Fatal[n]);
            this.S.setCell(this.FmlToSql[n], dbValue);
        }
        this.F(aAdditionTuple);
        return aAdditionTuple;
    }

    private void F(AAdditionTuple aAdditionTuple) throws DSException {
        int n = this.J.length;
        block16: for (int i = 0; i < n; ++i) {
            int n2 = this.F.getColumnType(i + 1);
            switch (n2) {
                case -6: {
                    throw new DSException();
                }
                case 5: {
                    DbSmallInt dbSmallInt = (DbSmallInt)this.S.getCell(this.J[i]);
                    if (dbSmallInt == null || dbSmallInt.bNull) {
                        aAdditionTuple.putNull(n2);
                        continue block16;
                    }
                    aAdditionTuple.putShort(((DbNumber)dbSmallInt).shortValue());
                    continue block16;
                }
                case 4: {
                    DbInteger dbInteger = (DbInteger)this.S.getCell(this.J[i]);
                    if (dbInteger == null || dbInteger.bNull) {
                        aAdditionTuple.putNull(n2);
                        continue block16;
                    }
                    aAdditionTuple.putInt(((DbNumber)dbInteger).intValue());
                    continue block16;
                }
                case -5: {
                    DbBigInt dbBigInt = (DbBigInt)this.S.getCell(this.J[i]);
                    if (dbBigInt == null || dbBigInt.bNull) {
                        aAdditionTuple.putNull(n2);
                        continue block16;
                    }
                    aAdditionTuple.putLong(((DbNumber)dbBigInt).longValue());
                    continue block16;
                }
                case 6: 
                case 8: {
                    DbNumber dbNumber = (DbNumber)this.S.getCell(this.J[i]);
                    if (dbNumber == null || dbNumber.bNull) {
                        aAdditionTuple.putNull(n2);
                        continue block16;
                    }
                    aAdditionTuple.putDouble(dbNumber.doubleValue());
                    continue block16;
                }
                case -7: {
                    DbBit dbBit = (DbBit)this.S.getCell(this.J[i]);
                    if (dbBit == null || dbBit.bNull) {
                        aAdditionTuple.putNull(n2);
                        continue block16;
                    }
                    aAdditionTuple.putBoolean(dbBit.value);
                    continue block16;
                }
                case 3: {
                    DbDecimal dbDecimal = (DbDecimal)this.S.getCell(this.J[i]);
                    if (dbDecimal == null || dbDecimal.bNull) {
                        aAdditionTuple.putNull(n2);
                        continue block16;
                    }
                    aAdditionTuple.putBigDecimal(dbDecimal.value);
                    continue block16;
                }
                case 12: {
                    DbChar dbChar = (DbChar)this.S.getCell(this.J[i]);
                    if (dbChar == null || dbChar.bNull) {
                        aAdditionTuple.putNull(n2);
                        continue block16;
                    }
                    aAdditionTuple.putString(dbChar.value);
                    continue block16;
                }
                case -2: {
                    throw new DSException();
                }
                case 2005: {
                    throw new DSException();
                }
                case 2004: {
                    throw new DSException();
                }
                case 91: {
                    DbDate dbDate = (DbDate)this.S.getCell(this.J[i]);
                    if (dbDate == null || dbDate.bNull) {
                        aAdditionTuple.putNull(n2);
                        continue block16;
                    }
                    aAdditionTuple.putDate(new JinfonetDate(dbDate.value));
                    continue block16;
                }
                case 92: {
                    DbTime dbTime = (DbTime)this.S.getCell(this.J[i]);
                    if (dbTime == null || dbTime.bNull) {
                        aAdditionTuple.putNull(n2);
                        continue block16;
                    }
                    aAdditionTuple.putTime(new JinfonetTime(dbTime.value));
                    continue block16;
                }
                case 93: {
                    DbTimestamp dbTimestamp = (DbTimestamp)this.S.getCell(this.J[i]);
                    if (dbTimestamp == null || dbTimestamp.bNull) {
                        aAdditionTuple.putNull(n2);
                        continue block16;
                    }
                    aAdditionTuple.putTimeStamp(new JinfonetTimeStamp(dbTimestamp.value));
                    continue block16;
                }
                default: {
                    aAdditionTuple.putNull(n2);
                }
            }
        }
    }

    protected Hashtable getParameters() {
        Hashtable<String, DbValue> hashtable = new Hashtable<String, DbValue>();
        Parameter parameter = null;
        Enumeration enumeration = this.parameters.elements();
        while (enumeration.hasMoreElements()) {
            parameter = (Parameter)enumeration.nextElement();
            hashtable.put(parameter.getName(), parameter.getValue());
        }
        return hashtable;
    }
}

