/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.relational.index;

import com.jinfonet.api.datatypes.Date;
import com.jinfonet.api.datatypes.Time;
import com.jinfonet.api.datatypes.Timestamp;
import com.jinfonet.dataservice.api.schema.relational.JRelationMetaData;
import com.jinfonet.dataservice.api.schema.relational.index.JColumnIndexedRelation;
import com.jinfonet.dataservice.api.schema.relational.index.JIndexedColumn;
import com.jinfonet.dataservice.relational.AGeneralRelation;
import com.jinfonet.dataservice.relational.IRelationData;
import com.jinfonet.dataservice.relational.IntListRowID;
import com.jinfonet.dataservice.relational.index.AIndexedColumn;
import com.jinfonet.dataservice.relational.index.AIndexedColumnFactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import jet.dataengine.api.DSException;
import jet.dataengine.util.DSLog;

public class ColumnIndexedRelationImpl
extends AGeneralRelation
implements JColumnIndexedRelation {
    protected final DSLog dslog = DSLog.getDSLog(this.getClass().getName());
    protected final IRelationData relationData;
    protected final JRelationMetaData metaData;
    protected final AIndexedColumn[] indexedColumns;
    protected final AIndexedColumnFactory indexedColumnFactory;
    protected boolean isClose = false;
    AIndexedColumn activeIndexedColumn = null;
    protected boolean needRefreshTuple = true;

    protected ColumnIndexedRelationImpl(String string, IRelationData iRelationData, AIndexedColumnFactory aIndexedColumnFactory) throws DSException {
        super(string, iRelationData);
        this.relationData = iRelationData;
        this.indexedColumnFactory = aIndexedColumnFactory;
        this.metaData = iRelationData.getMetaData();
        this.indexedColumns = new AIndexedColumn[this.metaData.getColumnCount()];
    }

    @Override
    protected void onGetValueBefore() throws DSException {
        if (!this.needRefreshTuple || !this.rowID.currentRowIDIsAvailable()) {
            throw new DSException("position out of bound: " + this.rowID.getPosition());
        }
        this.tuple.init(this.rowID.getCurrentRowID());
        this.needRefreshTuple = false;
    }

    @Override
    protected void onChangePosition() throws DSException {
        this.needRefreshTuple = true;
        if (this.activeIndexedColumn != null) {
            this.activeIndexedColumn.setPosition((int)this.rowID.getPosition());
        }
    }

    @Override
    protected void onClose() throws DSException {
    }

    @Override
    protected boolean canClose() throws DSException {
        return true;
    }

    @Override
    public int getType() throws DSException {
        return 0xC000007;
    }

    @Override
    public String createIndex(String string) throws DSException {
        this.checkClose();
        int n = this.findColumn(string);
        if (this.indexedColumns[n] == null) {
            this.indexedColumns[n] = this.indexedColumnFactory.create(this, n, "Indexed_" + string);
            this.rowID = this.indexedColumns[n];
        }
        return this.indexedColumns[n].getName();
    }

    @Override
    public String createIndex(String string, double d) throws DSException {
        this.checkClose();
        int n = this.findColumn(string);
        if (this.indexedColumns[n] == null) {
            this.indexedColumns[n] = this.indexedColumnFactory.create(this, n, "Indexed_" + string, d);
        }
        return this.indexedColumns[n].getName();
    }

    @Override
    public void discardALLIndexes() throws DSException {
        this.checkClose();
        int n = this.indexedColumns.length;
        for (int i = 0; i < n; ++i) {
            if (this.indexedColumns[i] == null) continue;
            this.indexedColumns[i] = null;
        }
    }

    @Override
    public void discardIndex(JIndexedColumn jIndexedColumn) throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == jIndexedColumn) {
            this.activeIndexedColumn = null;
        }
        int n = this.indexedColumns.length;
        for (int i = 0; i < n; ++i) {
            if (this.indexedColumns[i] != jIndexedColumn) continue;
            this.indexedColumns[i] = null;
        }
    }

    @Override
    public String getActiveIndex() throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            return null;
        }
        return this.activeIndexedColumn.getName();
    }

    public AIndexedColumn getActiveIndexedColumn() {
        return this.activeIndexedColumn;
    }

    @Override
    public void setActiveIndex(String string) throws DSException {
        this.checkClose();
        for (AIndexedColumn aIndexedColumn : this.indexedColumns) {
            if (aIndexedColumn == null || !aIndexedColumn.getName().equals(string)) continue;
            this.activeIndexedColumn = aIndexedColumn;
            this.rowID = new IntListRowID(aIndexedColumn.getRowIDs());
            return;
        }
        throw new DSException("Index " + string + " not found. ");
    }

    public void updatePositionAfterFind(boolean bl) throws DSException {
    }

    @Override
    public boolean findFirst(int n, int n2) throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        boolean bl = this.activeIndexedColumn.findFirst(n, n2);
        this.updatePositionAfterFind(bl);
        return bl;
    }

    @Override
    public boolean findNext(int n, int n2) throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        boolean bl = this.activeIndexedColumn.findNext(n, n2);
        this.updatePositionAfterFind(bl);
        return bl;
    }

    @Override
    public boolean findPrevious(int n, int n2) throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        boolean bl = this.activeIndexedColumn.findPrevious(n, n2);
        this.updatePositionAfterFind(bl);
        return bl;
    }

    @Override
    public boolean findLast(int n, int n2) throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        boolean bl = this.activeIndexedColumn.findLast(n, n2);
        this.updatePositionAfterFind(bl);
        return bl;
    }

    @Override
    public int getInt() throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        return this.activeIndexedColumn.getInt();
    }

    @Override
    public boolean findFirst(long l, int n) throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        boolean bl = this.activeIndexedColumn.findFirst(l, n);
        this.updatePositionAfterFind(bl);
        return bl;
    }

    @Override
    public boolean findNext(long l, int n) throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        boolean bl = this.activeIndexedColumn.findNext(l, n);
        this.updatePositionAfterFind(bl);
        return bl;
    }

    @Override
    public boolean findPrevious(long l, int n) throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        boolean bl = this.activeIndexedColumn.findPrevious(l, n);
        this.updatePositionAfterFind(bl);
        return bl;
    }

    @Override
    public boolean findLast(long l, int n) throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        boolean bl = this.activeIndexedColumn.findLast(l, n);
        this.updatePositionAfterFind(bl);
        return bl;
    }

    @Override
    public long getLong() throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        return this.activeIndexedColumn.getLong();
    }

    @Override
    public boolean findFirst(float f, int n) throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        boolean bl = this.activeIndexedColumn.findFirst(f, n);
        this.updatePositionAfterFind(bl);
        return bl;
    }

    @Override
    public boolean findNext(float f, int n) throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        boolean bl = this.activeIndexedColumn.findNext(f, n);
        this.updatePositionAfterFind(bl);
        return bl;
    }

    @Override
    public boolean findPrevious(float f, int n) throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        boolean bl = this.activeIndexedColumn.findPrevious(f, n);
        this.updatePositionAfterFind(bl);
        return bl;
    }

    @Override
    public boolean findLast(float f, int n) throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        boolean bl = this.activeIndexedColumn.findLast(f, n);
        this.updatePositionAfterFind(bl);
        return bl;
    }

    @Override
    public float getFloat() throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        return this.activeIndexedColumn.getFloat();
    }

    @Override
    public boolean findFirst(double d, int n) throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        boolean bl = this.activeIndexedColumn.findFirst(d, n);
        this.updatePositionAfterFind(bl);
        return bl;
    }

    @Override
    public boolean findNext(double d, int n) throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        boolean bl = this.activeIndexedColumn.findNext(d, n);
        this.updatePositionAfterFind(bl);
        return bl;
    }

    @Override
    public boolean findPrevious(double d, int n) throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        boolean bl = this.activeIndexedColumn.findPrevious(d, n);
        this.updatePositionAfterFind(bl);
        return bl;
    }

    @Override
    public boolean findLast(double d, int n) throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        boolean bl = this.activeIndexedColumn.findLast(d, n);
        this.updatePositionAfterFind(bl);
        return bl;
    }

    @Override
    public double getDouble() throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        return this.activeIndexedColumn.getDouble();
    }

    @Override
    public boolean findFirst(BigDecimal bigDecimal, int n) throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        boolean bl = this.activeIndexedColumn.findFirst(bigDecimal, n);
        this.updatePositionAfterFind(bl);
        return bl;
    }

    @Override
    public boolean findNext(BigDecimal bigDecimal, int n) throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        boolean bl = this.activeIndexedColumn.findNext(bigDecimal, n);
        this.updatePositionAfterFind(bl);
        return bl;
    }

    @Override
    public boolean findPrevious(BigDecimal bigDecimal, int n) throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        boolean bl = this.activeIndexedColumn.findPrevious(bigDecimal, n);
        this.updatePositionAfterFind(bl);
        return bl;
    }

    @Override
    public boolean findLast(BigDecimal bigDecimal, int n) throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        boolean bl = this.activeIndexedColumn.findLast(bigDecimal, n);
        this.updatePositionAfterFind(bl);
        return bl;
    }

    @Override
    public BigDecimal getBigDecimal() throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        return this.activeIndexedColumn.getBigDecimal();
    }

    @Override
    public boolean findFirst(BigInteger bigInteger, int n) throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        boolean bl = this.activeIndexedColumn.findFirst(bigInteger, n);
        this.updatePositionAfterFind(bl);
        return bl;
    }

    @Override
    public boolean findNext(BigInteger bigInteger, int n) throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        boolean bl = this.activeIndexedColumn.findNext(bigInteger, n);
        this.updatePositionAfterFind(bl);
        return bl;
    }

    @Override
    public boolean findPrevious(BigInteger bigInteger, int n) throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        boolean bl = this.activeIndexedColumn.findPrevious(bigInteger, n);
        this.updatePositionAfterFind(bl);
        return bl;
    }

    @Override
    public boolean findLast(BigInteger bigInteger, int n) throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        boolean bl = this.activeIndexedColumn.findLast(bigInteger, n);
        this.updatePositionAfterFind(bl);
        return bl;
    }

    @Override
    public BigInteger getBigInteger() throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        return this.activeIndexedColumn.getBigInteger();
    }

    @Override
    public boolean findFirst(String string, int n) throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        boolean bl = this.activeIndexedColumn.findFirst(string, n);
        this.updatePositionAfterFind(bl);
        return bl;
    }

    @Override
    public boolean findNext(String string, int n) throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        boolean bl = this.activeIndexedColumn.findNext(string, n);
        this.updatePositionAfterFind(bl);
        return bl;
    }

    @Override
    public boolean findPrevious(String string, int n) throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        boolean bl = this.activeIndexedColumn.findPrevious(string, n);
        this.updatePositionAfterFind(bl);
        return bl;
    }

    @Override
    public boolean findLast(String string, int n) throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        boolean bl = this.activeIndexedColumn.findLast(string, n);
        this.updatePositionAfterFind(bl);
        return bl;
    }

    @Override
    public String getString() throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        return this.activeIndexedColumn.getString();
    }

    @Override
    public boolean findFirst(Date date, int n) throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        boolean bl = this.activeIndexedColumn.findFirst(date, n);
        this.updatePositionAfterFind(bl);
        return bl;
    }

    @Override
    public boolean findNext(Date date, int n) throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        boolean bl = this.activeIndexedColumn.findNext(date, n);
        this.updatePositionAfterFind(bl);
        return bl;
    }

    @Override
    public boolean findPrevious(Date date, int n) throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        boolean bl = this.activeIndexedColumn.findPrevious(date, n);
        this.updatePositionAfterFind(bl);
        return bl;
    }

    @Override
    public boolean findLast(Date date, int n) throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        boolean bl = this.activeIndexedColumn.findLast(date, n);
        this.updatePositionAfterFind(bl);
        return bl;
    }

    @Override
    public Date getDate() throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        return this.activeIndexedColumn.getDate();
    }

    @Override
    public boolean findFirst(Time time2, int n) throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        boolean bl = this.activeIndexedColumn.findFirst(time2, n);
        this.updatePositionAfterFind(bl);
        return bl;
    }

    @Override
    public boolean findNext(Time time2, int n) throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        boolean bl = this.activeIndexedColumn.findNext(time2, n);
        this.updatePositionAfterFind(bl);
        return bl;
    }

    @Override
    public boolean findPrevious(Time time2, int n) throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        boolean bl = this.activeIndexedColumn.findPrevious(time2, n);
        this.updatePositionAfterFind(bl);
        return bl;
    }

    @Override
    public boolean findLast(Time time2, int n) throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        boolean bl = this.activeIndexedColumn.findLast(time2, n);
        this.updatePositionAfterFind(bl);
        return bl;
    }

    @Override
    public Time getTime() throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        return this.activeIndexedColumn.getTime();
    }

    @Override
    public boolean findFirst(Timestamp timestamp, int n) throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        boolean bl = this.activeIndexedColumn.findFirst(timestamp, n);
        this.updatePositionAfterFind(bl);
        return bl;
    }

    @Override
    public boolean findNext(Timestamp timestamp, int n) throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        boolean bl = this.activeIndexedColumn.findNext(timestamp, n);
        this.updatePositionAfterFind(bl);
        return bl;
    }

    @Override
    public boolean findPrevious(Timestamp timestamp, int n) throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        boolean bl = this.activeIndexedColumn.findPrevious(timestamp, n);
        this.updatePositionAfterFind(bl);
        return bl;
    }

    @Override
    public boolean findLast(Timestamp timestamp, int n) throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        boolean bl = this.activeIndexedColumn.findLast(timestamp, n);
        this.updatePositionAfterFind(bl);
        return bl;
    }

    @Override
    public Timestamp getTimestamp() throws DSException {
        this.checkClose();
        if (this.activeIndexedColumn == null) {
            throw new DSException("Cannot find, the relation have not active index.");
        }
        return this.activeIndexedColumn.getTimestamp();
    }
}

