/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.relational.localrelation.cartesian;

import com.jinfonet.api.datatypes.Array;
import com.jinfonet.api.datatypes.Blob;
import com.jinfonet.api.datatypes.Clob;
import com.jinfonet.api.datatypes.Date;
import com.jinfonet.api.datatypes.Time;
import com.jinfonet.api.datatypes.Timestamp;
import com.jinfonet.dataservice.api.schema.relational.JAttribute;
import com.jinfonet.dataservice.api.schema.relational.JRelationMetaData;
import com.jinfonet.dataservice.expression.executor.impl.IExpressionExecutorEnv;
import com.jinfonet.dataservice.relational.ARelationData;
import com.jinfonet.dataservice.relational.ATuple;
import com.jinfonet.dataservice.relational.BaseRowID;
import com.jinfonet.dataservice.relational.IRelationData;
import com.jinfonet.dataservice.relational.IRowID;
import com.jinfonet.dataservice.relational.ITuple;
import java.math.BigDecimal;
import jet.dataengine.api.DSException;
import jet.dataengine.listener.CancelEvent;
import jet.dataengine.listener.JCancelListener;
import jet.dataengine.util.DSLog;

public final class CartesianRelationData
extends ARelationData
implements JCancelListener {
    private IRelationData SEDU;
    private IRelationData append;
    private JRelationMetaData close;
    private boolean createRowID;
    private long debug;
    private int equals;
    private int getAliasName;
    private DSLog getAttribute = DSLog.getDSLog(CartesianRelationData.class.getName());
    private final int getColumnCount = -1;
    private final int getDSLog = 1;
    private final int getMetaData = 0;
    private final int getName = -1;
    private int getRelationOption;

    public CartesianRelationData(String string, IRelationData iRelationData, IRelationData iRelationData2, JRelationMetaData jRelationMetaData, IExpressionExecutorEnv iExpressionExecutorEnv) throws DSException {
        super(string, iRelationData.getRelationOption());
        this.getAttribute.debug("Cartesian data init start");
        if (iRelationData == null) {
            throw new IllegalArgumentException("input relation data 1 was null");
        }
        this.SEDU = iRelationData;
        if (iRelationData2 == null) {
            throw new IllegalArgumentException("input relation data 2 was null");
        }
        this.append = iRelationData2;
        if (jRelationMetaData == null) {
            throw new IllegalArgumentException("input relation metadata was null");
        }
        this.SEDU(jRelationMetaData, iRelationData.getMetaData(), iRelationData2.getMetaData());
        this.close = jRelationMetaData;
        this.equals = -1;
        this.getAliasName = -1;
        this.getRelationOption = -1;
        this.createRowID = false;
        this.getAttribute.debug("Cartesian data init end");
    }

    private void SEDU(JRelationMetaData jRelationMetaData, JRelationMetaData jRelationMetaData2, JRelationMetaData jRelationMetaData3) throws DSException {
        if (jRelationMetaData2.getColumnCount() < 1) {
            throw new IllegalArgumentException("input relation 1 metadata has no column");
        }
        if (jRelationMetaData3.getColumnCount() < 1) {
            throw new IllegalArgumentException("input relation 2 metadata has no column");
        }
        if (jRelationMetaData.getColumnCount() < 1) {
            throw new IllegalArgumentException("end metadata has no column");
        }
        String string = null;
        int n = -1;
        this.close("input meta1: ", jRelationMetaData2);
        this.close("input meta2: ", jRelationMetaData3);
        this.close("output meta: ", jRelationMetaData);
        for (int i = 1; i <= jRelationMetaData.getColumnCount(); ++i) {
            string = jRelationMetaData.getAttribute(i).getAliasName();
            n = this.append(string, jRelationMetaData2);
            if (n != -1 && (n = this.append(string, jRelationMetaData3)) != -1) {
                throw new IllegalStateException("attribute : " + string + " exits in input meta1 and meta2");
            }
            n = this.append(string, jRelationMetaData2);
            if (n == -1 && (n = this.append(string, jRelationMetaData3)) == -1) {
                this.getAttribute.debug("can not found column : " + string + " in input metadata 1: " + jRelationMetaData2.getAliasName());
                this.getAttribute.debug("can not found column : " + string + " in input metadata 2: " + jRelationMetaData3.getAliasName());
            }
            if (n >= 1) continue;
            throw new IllegalArgumentException("can not found column : " + string);
        }
    }

    private int append(String string, JRelationMetaData jRelationMetaData) throws DSException {
        int n;
        JAttribute[] jAttributeArray = new JAttribute[jRelationMetaData.getColumnCount()];
        for (n = 1; n <= jRelationMetaData.getColumnCount(); ++n) {
            jAttributeArray[n - 1] = jRelationMetaData.getAttribute(n);
        }
        for (n = 0; n < jAttributeArray.length; ++n) {
            if (!string.equals(jAttributeArray[n].getAliasName())) continue;
            return n + 1;
        }
        return -1;
    }

    private void close(String string, JRelationMetaData jRelationMetaData) throws DSException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string + "[");
        for (int i = 1; i <= jRelationMetaData.getColumnCount(); ++i) {
            stringBuffer.append(jRelationMetaData.getAttribute(i).getAliasName());
            if (i >= jRelationMetaData.getColumnCount()) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("]");
        this.getAttribute.debug(stringBuffer.toString());
    }

    @Override
    protected ITuple createTupleReal() throws DSException {
        if (this.createRowID) {
            throw new IllegalStateException("cancel happend, calling error");
        }
        return new CartesianTuple();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onClose() throws DSException {
        IRelationData iRelationData;
        if (this.SEDU != null) {
            iRelationData = this.SEDU;
            synchronized (iRelationData) {
                if (!this.SEDU.isClosed()) {
                    this.SEDU.close();
                }
                this.SEDU = null;
            }
        }
        if (this.append != null) {
            iRelationData = this.append;
            synchronized (iRelationData) {
                if (!this.append.isClosed()) {
                    this.append.close();
                }
                this.append = null;
            }
        }
        this.close = null;
    }

    @Override
    public void cancel(CancelEvent cancelEvent) throws DSException {
        if (cancelEvent == null) {
            throw new IllegalArgumentException("CancelEvent was null");
        }
        this.createRowID = true;
    }

    @Override
    public JRelationMetaData getMetaData() throws DSException {
        if (this.createRowID) {
            throw new IllegalStateException("cancel happend, calling error");
        }
        return this.close;
    }

    @Override
    public IRowID createRowID() throws DSException {
        if (this.createRowID) {
            throw new IllegalStateException("cancel happend, calling error");
        }
        if (this.getRelationOption == -1) {
            this.getRelationOption = this.debug();
        }
        return BaseRowID.createRowID(0, this.getRelationOption + 1);
    }

    private int debug() throws DSException {
        if (this.equals == -1) {
            if (this.SEDU.createRowID().size() == -1) {
                throw new IllegalStateException("can not get first data size, is unknow size");
            }
            this.equals = this.SEDU.createRowID().size();
        }
        if (this.getAliasName == -1) {
            if (this.append.createRowID().size() == -1) {
                throw new IllegalStateException("can not get first data size, is unknow size");
            }
            this.getAliasName = this.append.createRowID().size();
        }
        if (this.equals == 0 || this.getAliasName == 0) {
            return 0;
        }
        return this.equals * this.getAliasName;
    }

    @Override
    public int getType() throws DSException {
        return 0x400000F;
    }

    @Override
    public boolean isEmpty() throws DSException {
        if (this.createRowID) {
            throw new IllegalStateException("cancel happend, calling error");
        }
        if (this.SEDU.isEmpty() || this.append.isEmpty()) {
            return true;
        }
        if (this.getRelationOption == -1) {
            this.getRelationOption = this.debug();
        }
        return this.getRelationOption == 0;
    }

    @Override
    public long getIOTime() {
        if (this.createRowID) {
            return -1L;
        }
        return this.debug;
    }

    private class CartesianTuple
    extends ATuple {
        private ITuple[] SEDU;
        private int[] access$000;
        private int access$100;
        private int access$200;
        private int access$300;
        private int access$400;
        private ITuple access$500;
        private ITuple append;
        private IRowID createRowID;
        private IRowID createTuple;
        private static final int getAliasName = 0;

        public CartesianTuple() throws DSException {
            String string = null;
            int n = -1;
            this.access$500 = CartesianRelationData.this.SEDU.createTuple();
            this.append = CartesianRelationData.this.append.createTuple();
            this.createRowID = CartesianRelationData.this.SEDU.createRowID();
            this.createTuple = CartesianRelationData.this.append.createRowID();
            this.SEDU = new ITuple[CartesianRelationData.this.close.getColumnCount() + 1];
            this.access$000 = new int[CartesianRelationData.this.close.getColumnCount() + 1];
            for (int i = 1; i <= CartesianRelationData.this.close.getColumnCount(); ++i) {
                string = CartesianRelationData.this.close.getAttribute(i).getAliasName();
                n = CartesianRelationData.this.append(string, CartesianRelationData.this.SEDU.getMetaData());
                if (n != -1) {
                    this.SEDU[i] = this.access$500;
                    this.access$000[i] = n;
                    continue;
                }
                n = CartesianRelationData.this.append(string, CartesianRelationData.this.append.getMetaData());
                if (n != -1) {
                    this.SEDU[i] = this.append;
                    this.access$000[i] = n;
                    continue;
                }
                throw new DSException(12001, new Object[]{"can not found column: " + string + " in input relation"});
            }
        }

        @Override
        public void init(int n) throws DSException {
            this.SEDU(n);
            this.access$300 = n / CartesianRelationData.this.getAliasName;
            if (n % CartesianRelationData.this.getAliasName != 0) {
                this.access$100 = this.access$300 + 1;
                this.access$200 = n - CartesianRelationData.this.getAliasName * this.access$300;
            } else {
                this.access$100 = this.access$300;
                this.access$200 = n - CartesianRelationData.this.getAliasName * (this.access$300 - 1);
            }
            this.createRowID.setPosition(this.access$100);
            this.createTuple.setPosition(this.access$200);
            this.access$500.init(this.createRowID.getCurrentRowID());
            this.append.init(this.createTuple.getCurrentRowID());
        }

        private void SEDU(int n) throws DSException {
            if (n < 1 && n > CartesianRelationData.this.getRelationOption) {
                throw new DSException(12002, new Object[]{"input row id out of bounds : " + n});
            }
        }

        @Override
        public void close() throws DSException {
            this.SEDU = null;
            this.access$000 = null;
            this.createRowID = null;
            this.createTuple = null;
            this.access$500 = null;
            this.append = null;
        }

        @Override
        public JRelationMetaData getMetaData() throws DSException {
            return CartesianRelationData.this.close;
        }

        @Override
        public int dataType(int n) throws DSException {
            return CartesianRelationData.this.close.getColumnType(n);
        }

        @Override
        public BigDecimal getBigDecimal(int n) throws DSException {
            this.access$400 = n;
            return this.SEDU[n].getBigDecimal(this.access$000[n]);
        }

        @Override
        public Blob getBlob(int n) throws DSException {
            this.access$400 = n;
            return this.SEDU[n].getBlob(this.access$000[n]);
        }

        @Override
        public boolean getBoolean(int n) throws DSException {
            this.access$400 = n;
            return this.SEDU[n].getBoolean(this.access$000[n]);
        }

        @Override
        public byte getByte(int n) throws DSException {
            this.access$400 = n;
            return this.SEDU[n].getByte(this.access$000[n]);
        }

        @Override
        public byte[] getBytes(int n) throws DSException {
            this.access$400 = n;
            return this.SEDU[n].getBytes(this.access$000[n]);
        }

        @Override
        public Clob getClob(int n) throws DSException {
            this.access$400 = n;
            return this.SEDU[n].getClob(this.access$000[n]);
        }

        @Override
        public Date getDate(int n) throws DSException {
            this.access$400 = n;
            return this.SEDU[n].getDate(this.access$000[n]);
        }

        @Override
        public double getDouble(int n) throws DSException {
            this.access$400 = n;
            return this.SEDU[n].getDouble(this.access$000[n]);
        }

        @Override
        public float getFloat(int n) throws DSException {
            this.access$400 = n;
            return this.SEDU[n].getFloat(this.access$000[n]);
        }

        @Override
        public int getInt(int n) throws DSException {
            this.access$400 = n;
            return this.SEDU[n].getInt(this.access$000[n]);
        }

        @Override
        public long getLong(int n) throws DSException {
            this.access$400 = n;
            return this.SEDU[n].getLong(this.access$000[n]);
        }

        @Override
        public Object getObject(int n) throws DSException {
            this.access$400 = n;
            return this.SEDU[n].getObject(this.access$000[n]);
        }

        @Override
        public short getShort(int n) throws DSException {
            this.access$400 = n;
            return this.SEDU[n].getShort(this.access$000[n]);
        }

        @Override
        public String getString(int n) throws DSException {
            this.access$400 = n;
            return this.SEDU[n].getString(this.access$000[n]);
        }

        @Override
        public Time getTime(int n) throws DSException {
            this.access$400 = n;
            return this.SEDU[n].getTime(this.access$000[n]);
        }

        @Override
        public Timestamp getTimeStamp(int n) throws DSException {
            this.access$400 = n;
            return this.SEDU[n].getTimeStamp(this.access$000[n]);
        }

        @Override
        public boolean isNull(int n) throws DSException {
            this.access$400 = n;
            return this.SEDU[n].isNull(this.access$000[n]);
        }

        @Override
        public boolean wasNull() throws DSException {
            return this.SEDU[this.access$400].wasNull();
        }

        @Override
        public IRelationData getRelationData(int n) throws DSException {
            this.access$400 = n;
            return this.SEDU[n].getRelationData(this.access$000[n]);
        }

        @Override
        public Array getArray(int n) throws DSException {
            this.access$400 = n;
            return this.SEDU[n].getArray(this.access$000[n]);
        }
    }
}

