/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.relational.localrelation.index.page;

import com.jinfonet.dataservice.relational.localrelation.index.page.LocalTreeMap;
import com.jinfonet.dataservice.relational.localrelation.util.LRelationShip;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import jet.dataengine.api.DSException;
import jet.dataengine.api.EnvironmentPropertiesFactory;

public abstract class MemoryPage
implements Comparable {
    private static int append = 16384;
    public static float halfSize = append / 2 + 1;
    private static final String canSplit = "indexCatch_";
    private static final String clear = ".tem";
    private static int close = 0;
    private String compareTo;
    private String delete;
    private long deleteOnExit;
    private boolean entrySet;
    private boolean exists;
    protected LocalTreeMap page;
    protected Object start;
    protected Object end;

    protected MemoryPage(int n, Object object, Object object2) {
        this(object, object2);
        append = n;
        halfSize = n / 2 + 1;
    }

    protected MemoryPage(Object object, Object object2) {
        this.start = object;
        this.end = object2;
        this.entrySet = true;
        this.exists = false;
        this.page = new LocalTreeMap();
        if (this.compareTo == null) {
            this.delete = EnvironmentPropertiesFactory.getEnviromentProperties().getTemporaryPath();
            this.compareTo = this.delete + canSplit + MemoryPage.SEDU() + clear;
        }
    }

    protected MemoryPage(LocalTreeMap localTreeMap, Object object, Object object2) {
        this.start = object;
        this.end = object2;
        this.entrySet = true;
        this.exists = false;
        this.page = localTreeMap;
        if (this.compareTo == null) {
            this.delete = EnvironmentPropertiesFactory.getEnviromentProperties().getTemporaryPath();
            this.compareTo = this.delete + canSplit + MemoryPage.SEDU() + clear;
        }
    }

    private static synchronized String SEDU() {
        return String.valueOf(++close);
    }

    public Object find(Object object, int n) {
        if (LRelationShip.isAllEquals(n) || LRelationShip.isAllNoLessThan(n) || LRelationShip.isAllNoMoreThan(n)) {
            return this.page.getEntry(object);
        }
        if (LRelationShip.isAllMoreThan(n)) {
            return this.page.successor(this.page.getEntry(object));
        }
        if (LRelationShip.isAllLessThan(n)) {
            return this.page.predecessor(this.page.getEntry(object));
        }
        return null;
    }

    public Object find(Object object) {
        return this.page.getEntry(object);
    }

    public Iterator getIterator() {
        return this.page.entrySet().iterator();
    }

    public void put(Object object, int n) {
        this.page.put(object, n);
    }

    public Object getStart() {
        return this.start;
    }

    public Object getEnd() {
        return this.end;
    }

    public void setStart(Object object) {
        this.start = object;
    }

    public void setEnd(Object object) {
        this.end = object;
    }

    public MemoryPage splitPage() {
        if (this.canSplit()) {
            Object object = this.start;
            Object object2 = this.end;
            LocalTreeMap localTreeMap = this.page.headMap();
            LocalTreeMap localTreeMap2 = this.page.tailMap();
            LocalTreeMap.Entry[] entryArray = this.getSplitter();
            this.page.clear();
            this.page = localTreeMap;
            this.end = entryArray[0].getKey();
            System.gc();
            return this.getNewMemoryPage(localTreeMap2, entryArray[1].getKey(), object2);
        }
        throw new IllegalStateException("can't split index, internal error");
    }

    protected abstract MemoryPage getNewMemoryPage(LocalTreeMap var1, Object var2, Object var3);

    protected abstract int getDataType();

    protected LocalTreeMap.Entry[] getSplitter() {
        return this.page.getSplitter();
    }

    public int size() {
        return this.page.size();
    }

    public boolean canSplit() {
        return this.page.menSize() >= append;
    }

    public boolean isInMemory() {
        return this.entrySet;
    }

    public boolean hasPutToDisk() {
        return this.exists;
    }

    public void setTimestamp(long l) {
        this.deleteOnExit = l;
    }

    public long getTimestamp() {
        return this.deleteOnExit;
    }

    public synchronized void clear() {
        if (this.exists) {
            File file = new File(this.compareTo);
            if (file.exists() && !file.delete()) {
                file.deleteOnExit();
            }
            this.exists = false;
        }
        this.deleteOnExit = Long.MIN_VALUE;
        this.start = null;
        this.end = null;
        this.page.clear();
    }

    public synchronized void swapToDisk() throws DSException {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(this.compareTo));
            this.page.write(objectOutputStream, this.getDataType());
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            throw new DSException(12003, new Object[]{"index page saving error"}, (Throwable)iOException);
        }
        this.page.clear();
        System.gc();
        this.entrySet = false;
        this.exists = true;
    }

    public synchronized void swapToMemory() throws DSException {
        File file = new File(this.compareTo);
        try {
            if (!file.exists()) {
                throw new FileNotFoundException("specified stream do not existed" + this.compareTo);
            }
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
            System.gc();
            this.page.read(objectInputStream);
        }
        catch (IOException iOException) {
            throw new DSException(12004, new Object[]{"index page loading error"}, (Throwable)iOException);
        }
        this.entrySet = true;
    }

    public int compareTo(Object object) {
        if (((Comparable)object).compareTo(this.start) < 0) {
            return -1;
        }
        if (((Comparable)object).compareTo(this.end) > 0) {
            return 1;
        }
        return 0;
    }
}

