/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.relational.localrelation.join;

import com.jinfonet.api.datatypes.Types;
import com.jinfonet.dataservice.api.schema.relational.JAttribute;
import com.jinfonet.dataservice.api.schema.relational.JRelationMetaData;
import com.jinfonet.dataservice.expression.executor.conditiontools.SetExpRelationData;
import com.jinfonet.dataservice.expression.set.SortInformationCollectorImpl;
import com.jinfonet.dataservice.relational.Attribute;
import com.jinfonet.dataservice.relational.IRelationData;
import com.jinfonet.dataservice.relational.RelationMetaData;
import com.jinfonet.dataservice.relational.RelationOption;
import com.jinfonet.dataservice.relational.localrelation.LocalRelationManager;
import com.jinfonet.dataservice.relational.localrelation.join.JoinRelationData;
import com.jinfonet.dataservice.relational.localrelation.join.SortMergeJoin;
import com.jinfonet.dataservice.relational.localrelation.join.core.Joiner;
import com.jinfonet.dataservice.relational.localrelation.util.LRelationShip;
import com.jinfonet.dataservice.relational.localrelation.util.cont.IndexLocalRelation;
import com.jinfonet.dataservice.relational.localrelation.util.cont.LocalRelationData;
import com.jinfonet.dataservice.relational.swap.RelationPool;
import java.util.List;
import jet.dataengine.api.DSException;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.IOperatorInformation;
import jet.dataengine.api.expression.OperatorToolKit;
import jet.dataengine.api.expression.info.ISortInformation;
import jet.dataengine.api.expression.tuple.IBinaryConditionExpression;
import jet.dataengine.api.expression.variable.IReference;
import jet.dataengine.listener.CancelEvent;
import jet.dataengine.listener.JCancelListener;
import jet.dataengine.util.DSLog;
import jet.dataengine8.core.queryengine.atapter.QueryOption;
import jet.log.JRLogger;

public class JoinEngine
implements JCancelListener {
    private static final String SEDU = "leftRowId";
    private static final String addJoinInfo = "rightRowId";
    private IBinaryConditionExpression addSortInformation;
    private IRelationData append;
    private IRelationData buildOriginalIndex;
    private LocalRelationData buildSortedIndex;
    private IndexLocalRelation createRelationOption;
    private IndexLocalRelation createRowMap;
    private Joiner createSortInfo;
    private int currentTimeMillis;
    private int debug;
    private int doJoin;
    private int equals = -1;
    private JRelationMetaData equalsIgnoreCase;
    private List equijoin;
    private static JRLogger expressionType = JRLogger.getLogger(JoinEngine.class.getName());

    public static RelationOption createRelationOption(RelationOption relationOption, JAttribute[] jAttributeArray) {
        QueryOption queryOption = new QueryOption();
        queryOption.setMaxRows(relationOption.getMaxRows());
        queryOption.setMaxDuration(relationOption.getMaxDuration());
        queryOption.setMaxPageNumber(relationOption.getMaxPageNumber());
        queryOption.setRecordsPerPage(relationOption.getRecordsPerPage());
        queryOption.setMaxRecords(relationOption.getMaxRecords());
        queryOption.setDistinct(relationOption.isDistinct());
        queryOption.setCacheZip(relationOption.isCacheZip());
        RelationOption relationOption2 = new RelationOption(queryOption, jAttributeArray, relationOption.getSpecialFields());
        relationOption2.setDiskStore(relationOption.getDiskStore());
        return relationOption2;
    }

    protected static RelationPool createRowMap(String[] stringArray, RelationOption relationOption) throws DSException {
        JAttribute[] jAttributeArray = new JAttribute[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            jAttributeArray[i] = new Attribute(stringArray[i], 4, 0, 0, 0, 1, false);
        }
        RelationOption relationOption2 = JoinEngine.createRelationOption(relationOption, jAttributeArray);
        return new RelationPool("", new RelationMetaData(jAttributeArray), relationOption2);
    }

    public JoinEngine() {
    }

    private IRelationData sort(IRelationData iRelationData, String[] stringArray) throws DSException {
        Object object;
        boolean bl;
        ISortInformation[] iSortInformationArray;
        block11: {
            block10: {
                JRelationMetaData jRelationMetaData = iRelationData.getMetaData();
                iSortInformationArray = jRelationMetaData.getSortInformation();
                bl = false;
                if (iSortInformationArray != null) break block10;
                bl = true;
                if (!expressionType.isDebugEnabled()) break block11;
                expressionType.debug("Relation Sort information is null.");
                break block11;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                object = stringArray[i];
                if (!iSortInformationArray[i].getReference().getAttributeName().equalsIgnoreCase((String)object)) {
                    if (expressionType.isDebugEnabled()) {
                        expressionType.debug("Relation is not sorted by join column:" + (String)object + ". Must resort relation.");
                    }
                    bl = true;
                    break;
                }
                if (iSortInformationArray[i].getSortType() == 1) continue;
                if (expressionType.isDebugEnabled()) {
                    expressionType.debug("Relation is not sorted in ASC. Must resort relation.");
                }
                bl = true;
                break;
            }
        }
        IRelationData iRelationData2 = null;
        if (bl) {
            try {
                iSortInformationArray = SetExpRelationData.createSortInfo(iRelationData.getMetaData(), stringArray);
                object = new SortInformationCollectorImpl();
                for (ISortInformation iSortInformation : iSortInformationArray) {
                    ((SortInformationCollectorImpl)object).addSortInformation(iSortInformation);
                }
                boolean bl2 = true;
                iRelationData2 = new SetExpRelationData(iRelationData.getName() + "_Sorted", iRelationData, (IOperatorInformation)object, DSLog.getDSLog(SetExpRelationData.class.getName()), bl2);
            }
            catch (Exception exception) {
                throw new DSException(5141, (Throwable)exception);
            }
        } else {
            if (expressionType.isDebugEnabled()) {
                expressionType.debug("Relation is already sorted in ASC. Need not resort relation.");
            }
            iRelationData2 = iRelationData;
        }
        return iRelationData2;
    }

    public IRelationData equijoin(IRelationData iRelationData, String[] stringArray, IRelationData iRelationData2, String[] stringArray2, int n, JRelationMetaData jRelationMetaData) throws DSException {
        RelationPool relationPool = JoinEngine.createRowMap(new String[]{SEDU, addJoinInfo}, iRelationData.getRelationOption());
        JAttribute[] jAttributeArray = new JAttribute[jRelationMetaData.getColumnCount()];
        for (int i = 1; i <= jRelationMetaData.getColumnCount(); ++i) {
            jAttributeArray[i - 1] = jRelationMetaData.getAttribute(i);
        }
        RelationOption relationOption = JoinEngine.createRelationOption(iRelationData.getRelationOption(), jAttributeArray);
        JoinRelationData joinRelationData = new JoinRelationData(iRelationData, iRelationData2, jRelationMetaData, relationPool, relationOption);
        SortMergeJoin sortMergeJoin = new SortMergeJoin(iRelationData, stringArray, iRelationData2, stringArray2, n, relationPool);
        sortMergeJoin.join();
        return joinRelationData;
    }

    public JoinEngine(String string, IRelationData iRelationData, IRelationData iRelationData2, JRelationMetaData jRelationMetaData, int n) {
        this.doJoin = n;
        this.append = iRelationData;
        this.buildOriginalIndex = iRelationData2;
        this.buildSortedIndex = new LocalRelationData(string, jRelationMetaData, iRelationData.getRelationOption());
        this.equalsIgnoreCase = jRelationMetaData;
    }

    public void setFilterExp(List list) throws DSException {
        this.equijoin = list;
        this.buildSortedIndex.setFilterList(list);
    }

    public IRelationData runEngine(IBinaryConditionExpression iBinaryConditionExpression, int n) throws DSException {
        boolean bl;
        long l = System.currentTimeMillis();
        if (expressionType.isDebugEnabled()) {
            expressionType.debug("Begine local join...");
        }
        int n2 = iBinaryConditionExpression.getOperator().operatorType();
        boolean bl2 = bl = this.equijoin != null && this.equijoin.size() > 0;
        if (OperatorToolKit.isEquals(n2) && !bl) {
            this.buildOriginalIndex(this.append, this.buildOriginalIndex, iBinaryConditionExpression);
            String string = ((IReference)iBinaryConditionExpression.getExpression1()).getAttributeName();
            String[] stringArray = new String[]{string};
            string = ((IReference)iBinaryConditionExpression.getExpression2()).getAttributeName();
            String[] stringArray2 = new String[]{string};
            if (expressionType.isDebugEnabled()) {
                expressionType.debug("JoinEngine. try sort relation1: leftCol = " + stringArray[0]);
            }
            IRelationData iRelationData = this.sort(this.append, stringArray);
            if (expressionType.isDebugEnabled()) {
                expressionType.debug("JoinEngine. try sort relation2: rightCol = " + stringArray2[0]);
            }
            IRelationData iRelationData2 = this.sort(this.buildOriginalIndex, stringArray2);
            if (expressionType.isDebugEnabled()) {
                expressionType.debug("JoinEngine. begin join.");
            }
            IRelationData iRelationData3 = this.equijoin(iRelationData, stringArray, iRelationData2, stringArray2, n, this.equalsIgnoreCase);
            return iRelationData3;
        }
        this.equals = n;
        this.addJoinInfo(iBinaryConditionExpression);
        this.addSortInformation = iBinaryConditionExpression;
        this.SEDU(this.addSortInformation);
        this.createSortInfo = Joiner.getInstance(this.currentTimeMillis, this.equals, this.doJoin);
        if (expressionType.isDebugEnabled()) {
            expressionType.debug("Prepare join elapsed: " + (System.currentTimeMillis() - l));
        }
        long l2 = System.currentTimeMillis();
        this.createSortInfo.doJoin(this.createRelationOption, this.debug, this.createRowMap, this.buildSortedIndex);
        if (expressionType.isDebugEnabled()) {
            expressionType.debug("Do join elapsed: " + (System.currentTimeMillis() - l2));
        }
        if (expressionType.isDebugEnabled()) {
            expressionType.debug("End local join. Total elapse: " + (System.currentTimeMillis() - l));
        }
        return this.buildSortedIndex;
    }

    private void SEDU(IBinaryConditionExpression iBinaryConditionExpression) throws DSException {
        LRelationShip lRelationShip = new LRelationShip(new IndexLocalRelation(this.append, this.doJoin), iBinaryConditionExpression, new IndexLocalRelation(this.buildOriginalIndex, this.doJoin), this.equals);
        this.buildSortedIndex.addJoinInfo(lRelationShip);
        this.debug = lRelationShip.getConditionType();
        this.currentTimeMillis = this.append(lRelationShip);
        this.createRelationOption = lRelationShip.getFirstView();
        this.createRowMap = lRelationShip.getSecondView();
        if (LocalRelationManager.isRightOutJoin(this.equals)) {
            if (this.debug != 3) {
                switch (this.debug) {
                    case 1: {
                        this.debug = 7;
                        break;
                    }
                    case 2: {
                        this.debug = 6;
                        break;
                    }
                    case 6: {
                        this.debug = 2;
                        break;
                    }
                    case 7: {
                        this.debug = 1;
                    }
                }
            }
            this.createRowMap.buildOriginalIndex(lRelationShip.getSecondQualifyName());
            this.createRelationOption.buildSortedIndex(lRelationShip.getFirstQualifyName());
        } else {
            this.createRelationOption.buildOriginalIndex(lRelationShip.getFirstQualifyName());
            this.createRowMap.buildSortedIndex(lRelationShip.getSecondQualifyName());
        }
        this.createRelationOption.setDefaultSearchColumn(lRelationShip.getFirstQualifyName());
        this.createRowMap.setDefaultSearchColumn(lRelationShip.getSecondQualifyName());
    }

    private void addJoinInfo(IBinaryConditionExpression iBinaryConditionExpression) throws DSException {
        if (this.addSortInformation(iBinaryConditionExpression.getExpression1(), this.append.getMetaData())) {
            if (this.addSortInformation(iBinaryConditionExpression.getExpression2(), this.buildOriginalIndex.getMetaData())) {
                return;
            }
        } else if (this.addSortInformation(iBinaryConditionExpression.getExpression1(), this.buildOriginalIndex.getMetaData()) && this.addSortInformation(iBinaryConditionExpression.getExpression2(), this.append.getMetaData())) {
            IRelationData iRelationData = this.append;
            this.append = this.buildOriginalIndex;
            this.buildOriginalIndex = iRelationData;
            return;
        }
        throw new IllegalArgumentException("join condition expression not matched with input relation metadata, joinField1: " + iBinaryConditionExpression.getExpression1() + " joinField2: " + iBinaryConditionExpression.getExpression2());
    }

    private boolean addSortInformation(IExpression iExpression, JRelationMetaData jRelationMetaData) throws DSException {
        int n;
        if (!ExpressionToolKit.isReference(iExpression.expressionType())) {
            throw new IllegalArgumentException("join column must be IReference, not " + iExpression.toString());
        }
        String string = ((IReference)iExpression).getAttributeName();
        JAttribute[] jAttributeArray = new JAttribute[jRelationMetaData.getColumnCount()];
        for (n = 0; n < jAttributeArray.length; ++n) {
            jAttributeArray[n] = jRelationMetaData.getAttribute(n + 1);
        }
        for (n = 0; n < jAttributeArray.length; ++n) {
            if (!jAttributeArray[n].getAliasName().equals(string)) continue;
            return true;
        }
        return false;
    }

    private int append(LRelationShip lRelationShip) throws DSException {
        return this.buildOriginalIndex(this.append, this.buildOriginalIndex, this.addSortInformation);
    }

    private int buildOriginalIndex(IRelationData iRelationData, IRelationData iRelationData2, IBinaryConditionExpression iBinaryConditionExpression) throws DSException {
        JAttribute jAttribute = this.buildSortedIndex(iBinaryConditionExpression.getExpression1(), iRelationData.getMetaData());
        JAttribute jAttribute2 = this.buildSortedIndex(iBinaryConditionExpression.getExpression2(), iRelationData2.getMetaData());
        int n = jAttribute.getDataType();
        int n2 = jAttribute2.getDataType();
        if (Types.isNumeric(n) && Types.isNumeric(n2)) {
            if (n == 3) {
                return 3;
            }
            if (n2 == 3) {
                return 3;
            }
            if (n == 8 || n == 6) {
                return 8;
            }
            if (n2 == 8 || n2 == 6) {
                return 8;
            }
            return -5;
        }
        if (Types.isTimeType(n) && Types.isTimeType(n2)) {
            return 93;
        }
        if (n == n2) {
            return n;
        }
        throw new IllegalArgumentException("Join column data type not compatible: " + jAttribute.getAliasName() + " dataType: " + jAttribute.getDataType() + ", " + jAttribute2.getAliasName() + " dataType: " + jAttribute2.getDataType());
    }

    private JAttribute buildSortedIndex(IExpression iExpression, JRelationMetaData jRelationMetaData) throws DSException {
        int n;
        if (!ExpressionToolKit.isReference(iExpression.expressionType())) {
            throw new IllegalArgumentException("join column must be IReference, not " + iExpression.toString());
        }
        String string = ((IReference)iExpression).getAttributeName();
        JAttribute[] jAttributeArray = new JAttribute[jRelationMetaData.getColumnCount()];
        for (n = 0; n < jAttributeArray.length; ++n) {
            jAttributeArray[n] = jRelationMetaData.getAttribute(n + 1);
        }
        for (n = 0; n < jAttributeArray.length; ++n) {
            if (!jAttributeArray[n].getAliasName().equals(string)) continue;
            return jAttributeArray[n];
        }
        throw new IllegalArgumentException("can not found column: " + string + " in metadata");
    }

    @Override
    public void cancel(CancelEvent cancelEvent) throws DSException {
    }
}

