/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.relational.localrelation.project;

import com.jinfonet.api.datatypes.Array;
import com.jinfonet.api.datatypes.Blob;
import com.jinfonet.api.datatypes.Clob;
import com.jinfonet.api.datatypes.Date;
import com.jinfonet.api.datatypes.Time;
import com.jinfonet.api.datatypes.Timestamp;
import com.jinfonet.dataservice.api.expression.relational.IProjectInformation;
import com.jinfonet.dataservice.api.schema.relational.JAttribute;
import com.jinfonet.dataservice.api.schema.relational.JRelationMetaData;
import com.jinfonet.dataservice.expression.executor.impl.IExpressionExecutorEnv;
import com.jinfonet.dataservice.relational.ARelationData;
import com.jinfonet.dataservice.relational.ATuple;
import com.jinfonet.dataservice.relational.IRelationData;
import com.jinfonet.dataservice.relational.IRowID;
import com.jinfonet.dataservice.relational.ITuple;
import com.jinfonet.dataservice.relational.localrelation.util.LocalToolkit;
import java.math.BigDecimal;
import jet.dataengine.api.DSException;
import jet.dataengine.listener.CancelEvent;
import jet.dataengine.listener.JCancelListener;
import jet.dataengine.util.DSLog;

public final class ProjectRelationData
extends ARelationData
implements JCancelListener {
    private IRelationData SEDU;
    private JRelationMetaData append;
    private JRelationMetaData close;
    private String[] createRowID;
    private String[] debug;
    private int[] equalsIgnoreCase;
    private boolean getAliasName = false;
    private long getAttribute;
    private DSLog getColumnCount = DSLog.getDSLog(ProjectRelationData.class.getName());
    private final int getDSLog = -1;

    public ProjectRelationData(String string, IProjectInformation iProjectInformation, IRelationData iRelationData, JRelationMetaData jRelationMetaData, IExpressionExecutorEnv iExpressionExecutorEnv) throws DSException {
        super(string, iRelationData.getRelationOption());
        this.SEDU(iProjectInformation, iRelationData, jRelationMetaData, iExpressionExecutorEnv);
    }

    private void SEDU(IProjectInformation iProjectInformation, IRelationData iRelationData, JRelationMetaData jRelationMetaData, IExpressionExecutorEnv iExpressionExecutorEnv) throws DSException {
        if (this.getColumnCount.isDebugEnabled()) {
            this.getColumnCount.debug("Project data init start");
        }
        if (iProjectInformation == null) {
            throw new DSException(8680, new Object[]{"input project information was null"});
        }
        if (iProjectInformation.getProjectNameMappings() == null) {
            throw new DSException(8681, new Object[]{"project name mapping was null"});
        }
        this.createRowID = this.equalsIgnoreCase(iProjectInformation.getProjectNameMappings());
        this.debug = this.debug(iProjectInformation.getProjectNameMappings());
        if (iRelationData == null) {
            throw new DSException(8682, new Object[]{"input relation data was null"});
        }
        this.SEDU = iRelationData;
        this.close = iRelationData.getMetaData();
        if (jRelationMetaData == null) {
            throw new DSException(8683, new Object[]{"input relation metadata was null"});
        }
        this.append = jRelationMetaData;
        this.append(jRelationMetaData, this.createRowID, this.debug, this.close);
        this.equalsIgnoreCase = new int[this.createRowID.length + 1];
        for (int i = 0; i < this.createRowID.length; ++i) {
            boolean bl = false;
            for (int j = 1; j <= this.close.getColumnCount(); ++j) {
                if (!this.createRowID[i].equalsIgnoreCase(this.close.getAttribute(j).getAliasName())) continue;
                this.equalsIgnoreCase[i + 1] = j;
                bl = true;
                break;
            }
            if (bl) continue;
            throw new DSException(8686, new Object[]{"can not found col : " + this.createRowID[i] + " in input relation metadata"});
        }
        if (this.getColumnCount.isDebugEnabled()) {
            this.getColumnCount.debug("Project data init end");
        }
    }

    private void append(JRelationMetaData jRelationMetaData, String[] stringArray, String[] stringArray2, JRelationMetaData jRelationMetaData2) throws DSException {
        this.close(stringArray, jRelationMetaData2);
        this.createRowID(jRelationMetaData, stringArray2);
    }

    private void close(String[] stringArray, JRelationMetaData jRelationMetaData) throws DSException {
        int n;
        JAttribute[] jAttributeArray = new JAttribute[jRelationMetaData.getColumnCount()];
        for (n = 0; n < jRelationMetaData.getColumnCount(); ++n) {
            jAttributeArray[n] = jRelationMetaData.getAttribute(n + 1);
        }
        LocalToolkit.logMetaData(this.getColumnCount, 8682, "project base input relation metadata : ", jAttributeArray);
        LocalToolkit.logMappingNames(this.getColumnCount, 8683, "project original mapping names : ", stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            n = 0;
            for (int j = 0; j < jRelationMetaData.getColumnCount(); ++j) {
                if (!stringArray[i].equalsIgnoreCase(jAttributeArray[j].getAliasName())) continue;
                n = 1;
                break;
            }
            if (n != 0) continue;
            throw new DSException(8685, new Object[]{"not found original name : " + stringArray[i] + "in input relation matadata"});
        }
    }

    private void createRowID(JRelationMetaData jRelationMetaData, String[] stringArray) throws DSException {
        int n;
        JAttribute[] jAttributeArray = new JAttribute[jRelationMetaData.getColumnCount()];
        for (n = 0; n < jRelationMetaData.getColumnCount(); ++n) {
            jAttributeArray[n] = jRelationMetaData.getAttribute(n + 1);
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equalsIgnoreCase(jAttributeArray[n].getAliasName())) continue;
            LocalToolkit.logMetaData(this.getColumnCount, 8680, "endMetaData : ", jAttributeArray);
            LocalToolkit.logMappingNames(this.getColumnCount, 8681, "project mapping names : ", stringArray);
            throw new DSException(8684, new Object[]{"project nanme : " + stringArray[n] + " not match with output metadata"});
        }
    }

    private String[] debug(String[][] stringArray) {
        String[] stringArray2 = new String[stringArray[1].length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = stringArray[1][i];
        }
        return stringArray2;
    }

    private String[] equalsIgnoreCase(String[][] stringArray) {
        String[] stringArray2 = new String[stringArray[0].length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = stringArray[0][i];
        }
        return stringArray2;
    }

    @Override
    protected ITuple createTupleReal() throws DSException {
        return new ProjectTuple();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onClose() throws DSException {
        this.append = null;
        this.close = null;
        if (this.SEDU != null) {
            IRelationData iRelationData = this.SEDU;
            synchronized (iRelationData) {
                if (!this.SEDU.isClosed()) {
                    this.SEDU.close();
                }
                this.SEDU = null;
            }
        }
        this.createRowID = null;
        this.debug = null;
        this.equalsIgnoreCase = null;
    }

    @Override
    public void cancel(CancelEvent cancelEvent) throws DSException {
        if (cancelEvent == null) {
            throw new DSException(8680, new Object[]{"CancelEvent was null"});
        }
        this.getAliasName = true;
    }

    @Override
    public JRelationMetaData getMetaData() throws DSException {
        return this.append;
    }

    @Override
    public IRowID createRowID() throws DSException {
        return this.SEDU.createRowID();
    }

    @Override
    public int getType() throws DSException {
        return 0x4000011;
    }

    @Override
    public boolean isEmpty() throws DSException {
        return this.SEDU.isEmpty();
    }

    @Override
    public long getIOTime() {
        if (this.getAliasName) {
            return -1L;
        }
        return this.getAttribute;
    }

    private class ProjectTuple
    extends ATuple {
        private ITuple SEDU;

        public ProjectTuple() throws DSException {
            this.SEDU = ProjectRelationData.this.SEDU.createTuple();
        }

        @Override
        public void init(int n) throws DSException {
            this.SEDU.init(n);
        }

        @Override
        public boolean isNull(int n) throws DSException {
            return this.SEDU.isNull(ProjectRelationData.this.equalsIgnoreCase[n]);
        }

        @Override
        public boolean wasNull() throws DSException {
            return this.SEDU.wasNull();
        }

        @Override
        public void close() throws DSException {
            this.SEDU = null;
        }

        @Override
        public JRelationMetaData getMetaData() throws DSException {
            return ProjectRelationData.this.append;
        }

        @Override
        public int dataType(int n) throws DSException {
            return this.SEDU.dataType(ProjectRelationData.this.equalsIgnoreCase[n]);
        }

        @Override
        public BigDecimal getBigDecimal(int n) throws DSException {
            return this.SEDU.getBigDecimal(ProjectRelationData.this.equalsIgnoreCase[n]);
        }

        @Override
        public Blob getBlob(int n) throws DSException {
            return this.SEDU.getBlob(ProjectRelationData.this.equalsIgnoreCase[n]);
        }

        @Override
        public boolean getBoolean(int n) throws DSException {
            return this.SEDU.getBoolean(ProjectRelationData.this.equalsIgnoreCase[n]);
        }

        @Override
        public byte getByte(int n) throws DSException {
            return this.SEDU.getByte(ProjectRelationData.this.equalsIgnoreCase[n]);
        }

        @Override
        public byte[] getBytes(int n) throws DSException {
            return this.SEDU.getBytes(ProjectRelationData.this.equalsIgnoreCase[n]);
        }

        @Override
        public Clob getClob(int n) throws DSException {
            return this.SEDU.getClob(ProjectRelationData.this.equalsIgnoreCase[n]);
        }

        @Override
        public Date getDate(int n) throws DSException {
            return this.SEDU.getDate(ProjectRelationData.this.equalsIgnoreCase[n]);
        }

        @Override
        public double getDouble(int n) throws DSException {
            return this.SEDU.getDouble(ProjectRelationData.this.equalsIgnoreCase[n]);
        }

        @Override
        public float getFloat(int n) throws DSException {
            return this.SEDU.getFloat(ProjectRelationData.this.equalsIgnoreCase[n]);
        }

        @Override
        public int getInt(int n) throws DSException {
            return this.SEDU.getInt(ProjectRelationData.this.equalsIgnoreCase[n]);
        }

        @Override
        public long getLong(int n) throws DSException {
            return this.SEDU.getLong(ProjectRelationData.this.equalsIgnoreCase[n]);
        }

        @Override
        public Object getObject(int n) throws DSException {
            return this.SEDU.getObject(ProjectRelationData.this.equalsIgnoreCase[n]);
        }

        @Override
        public short getShort(int n) throws DSException {
            return this.SEDU.getShort(ProjectRelationData.this.equalsIgnoreCase[n]);
        }

        @Override
        public String getString(int n) throws DSException {
            return this.SEDU.getString(ProjectRelationData.this.equalsIgnoreCase[n]);
        }

        @Override
        public Time getTime(int n) throws DSException {
            return this.SEDU.getTime(ProjectRelationData.this.equalsIgnoreCase[n]);
        }

        @Override
        public Timestamp getTimeStamp(int n) throws DSException {
            return this.SEDU.getTimeStamp(ProjectRelationData.this.equalsIgnoreCase[n]);
        }

        @Override
        public Array getArray(int n) throws DSException {
            return this.SEDU.getArray(ProjectRelationData.this.equalsIgnoreCase[n]);
        }

        @Override
        public IRelationData getRelationData(int n) throws DSException {
            return this.SEDU.getRelationData(ProjectRelationData.this.equalsIgnoreCase[n]);
        }
    }
}

