/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.relational.localrelation.union.core;

import com.jinfonet.api.datatypes.Blob;
import com.jinfonet.api.datatypes.Clob;
import com.jinfonet.api.datatypes.Date;
import com.jinfonet.api.datatypes.Time;
import com.jinfonet.api.datatypes.Timestamp;
import com.jinfonet.dataservice.api.exceptions.InternalException;
import com.jinfonet.dataservice.api.exceptions.LocalUnionExcepion;
import com.jinfonet.dataservice.api.schema.relational.JRelationMetaData;
import com.jinfonet.dataservice.relational.ARelationData;
import com.jinfonet.dataservice.relational.IRelationData;
import com.jinfonet.dataservice.relational.ITuple;
import com.jinfonet.dataservice.relational.Record;
import com.jinfonet.dataservice.relational.localrelation.union.core.UndistinctUnioner;
import com.jinfonet.dataservice.relational.localrelation.util.TupleBlockCache;
import com.jinfonet.dataservice.relational.localrelation.util.TupleComparator;
import com.jinfonet.dataservice.relational.swap.RelationPool;
import java.math.BigDecimal;
import java.util.Comparator;
import jet.dataengine.api.DSException;

public abstract class Unioner {
    protected static int nullStrategy = -1;
    protected static final String errID = "DSLR019";
    protected TupleBlockCache firstCacher = new TupleBlockCache();
    protected Comparator comparator = new TupleComparator();

    public static Unioner getInstance(int n, int n2) throws LocalUnionExcepion {
        nullStrategy = n2;
        return new UndistinctUnioner();
    }

    protected void appendTuple(RelationPool relationPool, ITuple iTuple) throws LocalUnionExcepion {
        try {
            Record record = relationPool.createRecord();
            this.SEDU(record, iTuple);
            relationPool.appendRecord(record);
        }
        catch (DSException dSException) {
            throw new LocalUnionExcepion(errID, dSException.getDetailMsg(), dSException.getMessageStack());
        }
    }

    public abstract void doUnion(RelationPool var1, IRelationData var2) throws LocalUnionExcepion;

    private void SEDU(Record record, ITuple iTuple) throws DSException {
        JRelationMetaData jRelationMetaData = iTuple.getMetaData();
        int[] nArray = new int[jRelationMetaData.getColumnCount()];
        for (int i = 0; i < jRelationMetaData.getColumnCount(); ++i) {
            nArray[i] = jRelationMetaData.getColumnType(i + 1);
        }
        block19: for (int i = 0; i < jRelationMetaData.getColumnCount(); ++i) {
            switch (nArray[i]) {
                case -6: {
                    long l = iTuple.getByte(i + 1);
                    if (iTuple.wasNull()) {
                        record.putNull(-6);
                        continue block19;
                    }
                    record.putByte((byte)l);
                    continue block19;
                }
                case 5: {
                    long l = iTuple.getShort(i + 1);
                    if (iTuple.wasNull()) {
                        record.putNull(5);
                        continue block19;
                    }
                    record.putShort((short)l);
                    continue block19;
                }
                case 4: {
                    long l = iTuple.getInt(i + 1);
                    if (iTuple.wasNull()) {
                        record.putNull(4);
                        continue block19;
                    }
                    record.putInt((int)l);
                    continue block19;
                }
                case -5: {
                    long l = iTuple.getLong(i + 1);
                    if (iTuple.wasNull()) {
                        record.putNull(-5);
                        continue block19;
                    }
                    record.putLong(l);
                    continue block19;
                }
                case 6: {
                    double d = iTuple.getFloat(i + 1);
                    if (iTuple.wasNull()) {
                        record.putNull(6);
                        continue block19;
                    }
                    record.putFloat((float)d);
                    continue block19;
                }
                case 8: {
                    double d = iTuple.getDouble(i + 1);
                    if (iTuple.wasNull()) {
                        record.putNull(8);
                        continue block19;
                    }
                    record.putDouble(d);
                    continue block19;
                }
                case -7: {
                    boolean bl = iTuple.getBoolean(i + 1);
                    if (iTuple.wasNull()) {
                        record.putNull(-7);
                        continue block19;
                    }
                    record.putBoolean(bl);
                    continue block19;
                }
                case 12: {
                    Object object = iTuple.getString(i + 1);
                    if (iTuple.wasNull()) {
                        record.putNull(12);
                        continue block19;
                    }
                    record.putString((String)object);
                    continue block19;
                }
                case 91: {
                    Object object = iTuple.getDate(i + 1);
                    if (iTuple.wasNull()) {
                        record.putNull(91);
                        continue block19;
                    }
                    record.putDate((Date)object);
                    continue block19;
                }
                case 92: {
                    Object object = iTuple.getTime(i + 1);
                    if (iTuple.wasNull()) {
                        record.putNull(92);
                        continue block19;
                    }
                    record.putTime((Time)object);
                    continue block19;
                }
                case 93: {
                    Object object = iTuple.getTimeStamp(i + 1);
                    if (iTuple.wasNull()) {
                        record.putNull(93);
                        continue block19;
                    }
                    record.putTimeStamp((Timestamp)object);
                    continue block19;
                }
                case 0x7FFFFFFF: {
                    Object object = iTuple.getRelationData(i + 1);
                    if (iTuple.wasNull()) {
                        record.putNull(Integer.MAX_VALUE);
                    } else {
                        record.pubRelationData((ARelationData)object);
                    }
                    ((ARelationData)object).close();
                    continue block19;
                }
                case 3: {
                    Object object = iTuple.getBigDecimal(i + 1);
                    if (iTuple.wasNull()) {
                        record.putNull(3);
                        continue block19;
                    }
                    record.putBigDecimal((BigDecimal)object);
                    continue block19;
                }
                case 2005: {
                    Object object = iTuple.getClob(i + 1);
                    if (iTuple.wasNull()) {
                        record.putNull(2005);
                        continue block19;
                    }
                    record.putClob((Clob)object);
                    continue block19;
                }
                case 2004: {
                    Object object = iTuple.getBlob(i + 1);
                    if (iTuple.wasNull()) {
                        record.putNull(2004);
                        continue block19;
                    }
                    record.putBlob((Blob)object);
                    continue block19;
                }
                case -2: {
                    byte[] byArray = iTuple.getBytes(i + 1);
                    if (iTuple.wasNull()) {
                        record.putNull(-2);
                        continue block19;
                    }
                    record.putBytes(byArray);
                    continue block19;
                }
                default: {
                    throw new InternalException(errID, "not support such data type", null);
                }
            }
        }
    }
}

