/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.relational.localrelation.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;

public class IntArrayList
implements Cloneable,
Serializable {
    private transient int[] SEDU;
    private int modCount = 0;
    private int size;

    public IntArrayList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        this.SEDU = new int[n];
    }

    public IntArrayList() {
        this(30);
    }

    public void trimToSize() {
        ++this.modCount;
        int n = this.SEDU.length;
        if (this.size < n) {
            int[] nArray = this.SEDU;
            this.SEDU = new int[this.size];
            System.arraycopy(nArray, 0, this.SEDU, 0, this.size);
        }
    }

    public void ensureCapacity(int n) {
        ++this.modCount;
        int n2 = this.SEDU.length;
        if (n > n2) {
            int[] nArray = this.SEDU;
            int n3 = n2 * 2;
            if (n3 < n) {
                n3 = n;
            }
            this.SEDU = new int[n3];
            System.arraycopy(nArray, 0, this.SEDU, 0, this.size);
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(int n) {
        return this.indexOf(n) >= 0;
    }

    public int indexOf(int n) {
        for (int i = 0; i < this.size; ++i) {
            if (this.SEDU[i] != n) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(int n) {
        if (n >= Integer.MIN_VALUE && n <= Integer.MAX_VALUE) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (this.SEDU[i] != n) continue;
                return i;
            }
        }
        return -1;
    }

    public Object clone() {
        try {
            IntArrayList intArrayList = (IntArrayList)super.clone();
            intArrayList.SEDU = new int[this.size];
            System.arraycopy(this.SEDU, 0, intArrayList.SEDU, 0, this.size);
            intArrayList.modCount = 0;
            return intArrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public int[] toArray() {
        int[] nArray = new int[this.size];
        System.arraycopy(this.SEDU, 0, nArray, 0, this.size);
        return nArray;
    }

    public int[] toArray(int[] nArray) {
        if (nArray.length < this.size) {
            nArray = (int[])Array.newInstance(nArray.getClass().getComponentType(), this.size);
        }
        System.arraycopy(this.SEDU, 0, nArray, 0, this.size);
        if (nArray.length > this.size) {
            nArray[this.size] = 0;
        }
        return nArray;
    }

    public int get(int n) {
        this.append(n);
        return this.SEDU[n];
    }

    public int set(int n, int n2) {
        this.append(n);
        int n3 = this.SEDU[n];
        this.SEDU[n] = n2;
        return n3;
    }

    public boolean add(int n) {
        this.ensureCapacity(this.size + 1);
        this.SEDU[this.size++] = n;
        return true;
    }

    public boolean addAll(int[] nArray) {
        int[] nArray2 = nArray;
        int n = nArray2.length;
        this.ensureCapacity(this.size + n);
        System.arraycopy(nArray2, 0, this.SEDU, this.size, n);
        this.size += n;
        return n != 0;
    }

    public boolean addAll(IntArrayList intArrayList) {
        return this.SEDU(intArrayList.SEDU, intArrayList.size());
    }

    private boolean SEDU(int[] nArray, int n) {
        int[] nArray2 = nArray;
        int n2 = n;
        this.ensureCapacity(this.size + n2);
        System.arraycopy(nArray2, 0, this.SEDU, this.size, n2);
        this.size += n2;
        return n2 != 0;
    }

    public void add(int n, int n2) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.SEDU, n, this.SEDU, n + 1, this.size - n);
        this.SEDU[n] = n2;
        ++this.size;
    }

    public void clear() {
        ++this.modCount;
        for (int i = 0; i < this.size; ++i) {
            this.SEDU[i] = 0;
        }
        this.size = 0;
    }

    protected void removeRange(int n, int n2) {
        ++this.modCount;
        int n3 = this.size - n2;
        System.arraycopy(this.SEDU, n2, this.SEDU, n, n3);
        int n4 = this.size - (n2 - n);
        while (this.size != n4) {
            this.SEDU[--this.size] = 0;
        }
    }

    private void append(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
    }

    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Object)) {
            return false;
        }
        IntArrayList intArrayList = (IntArrayList)object;
        if (intArrayList.size() != this.size()) {
            return false;
        }
        try {
            for (int i = 0; i < intArrayList.SEDU.length; ++i) {
                if (this.SEDU[i] == intArrayList.SEDU[i]) {
                    continue;
                }
                return false;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        return true;
    }

    public int remove(int n) {
        this.append(n);
        ++this.modCount;
        int n2 = this.SEDU[n];
        int n3 = this.size - n - 1;
        if (n3 > 0) {
            System.arraycopy(this.SEDU, n + 1, this.SEDU, n, n3);
        }
        this.SEDU[--this.size] = 0;
        return n2;
    }

    public int removeElement(int n) {
        int n2 = this.indexOf(n);
        if (n2 >= 0) {
            return this.remove(n2);
        }
        return n - 1;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.SEDU.length);
        for (int i = 0; i < this.size; ++i) {
            objectOutputStream.writeInt(this.SEDU[i]);
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.SEDU = new int[n];
        for (int i = 0; i < this.size; ++i) {
            this.SEDU[i] = objectInputStream.readInt();
        }
    }

    public IntArrayList merge(IntArrayList intArrayList) {
        int n = intArrayList.size();
        for (int i = 0; i < n; ++i) {
            if (this.contains(intArrayList.SEDU[i])) continue;
            this.add(intArrayList.SEDU[i]);
        }
        return this;
    }

    public IntArrayList sort() {
        IntArrayList intArrayList = (IntArrayList)this.clone();
        Arrays.sort(intArrayList.SEDU);
        return intArrayList;
    }

    public IntArrayList interSectionForDataTeam(IntArrayList intArrayList) {
        int n;
        IntArrayList intArrayList2 = new IntArrayList();
        IntArrayList intArrayList3 = this.size <= intArrayList.size() ? this : intArrayList;
        IntArrayList intArrayList4 = this.size > intArrayList.size() ? this : intArrayList;
        intArrayList3 = intArrayList3.sort();
        intArrayList4 = intArrayList4.sort();
        int n2 = 0;
        int n3 = 0;
        n2 = intArrayList3.SEDU[0];
        n3 = intArrayList4.SEDU[0];
        int n4 = 0;
        int n5 = 0;
        int n6 = intArrayList3.size();
        do {
            n = intArrayList4.size();
            n2 = intArrayList3.SEDU[n4];
            n3 = intArrayList4.SEDU[n5];
            if (n2 == n3) {
                intArrayList2.add(n2);
                ++n4;
                ++n5;
                continue;
            }
            if (n2 > n3) {
                ++n5;
                continue;
            }
            ++n4;
        } while (n4 < n6 && n5 < n);
        return intArrayList2;
    }
}

