/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.relational.localrelation.util.cont;

import com.jinfonet.api.datatypes.Array;
import com.jinfonet.api.datatypes.Blob;
import com.jinfonet.api.datatypes.Clob;
import com.jinfonet.api.datatypes.Date;
import com.jinfonet.api.datatypes.Time;
import com.jinfonet.api.datatypes.Types;
import com.jinfonet.dataservice.api.schema.relational.JRelation;
import com.jinfonet.dataservice.api.schema.relational.JRelationMetaData;
import com.jinfonet.dataservice.relational.ARelation;
import com.jinfonet.dataservice.relational.IRelationData;
import com.jinfonet.dataservice.relational.IndexRelation;
import com.jinfonet.dataservice.relational.RelationMetaData;
import com.jinfonet.dataservice.relational.localrelation.index.LocalIndex;
import com.jinfonet.dataservice.relational.localrelation.index.page.RowIDChain;
import com.jinfonet.dataservice.relational.localrelation.index.sorted.SortedLocalIndex;
import com.jinfonet.dataservice.relational.localrelation.join.data.DataTyper;
import com.jinfonet.dataservice.relational.localrelation.util.Comparator;
import com.jinfonet.dataservice.relational.localrelation.util.IntArrayList;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import jet.dataengine.api.DSException;

public class IndexLocalRelation
extends IndexRelation {
    private int SEDU = -1;
    private HashMap add;
    private HashMap afterLast;
    private HashMap append;
    private LocalIndex beforeFirst;
    private IntArrayList canIndexing;
    private JRelationMetaData clear;
    private ARelation close;
    private int compare;
    private int contains;
    private String createRelation;
    private DataTyper destroyAllIndexes;
    int joinColType = 0;

    public IndexLocalRelation(IRelationData iRelationData, int n) throws DSException {
        super(iRelationData.getName(), iRelationData);
        this.SEDU = n;
        this.close = iRelationData.createRelation();
        this.contains = this.close.size();
        this.add = new HashMap();
        this.append = new HashMap();
        this.afterLast = new HashMap();
        this.canIndexing = new IntArrayList(10);
        this.clear = new RelationMetaData(iRelationData.getMetaData());
    }

    public void setDataTyper(DataTyper dataTyper) {
        this.destroyAllIndexes = dataTyper;
    }

    @Override
    public void close() throws DSException {
        this.destroyAllIndexes();
        this.close.close();
        this.realData.close();
    }

    public RowIDChain getIndexPositions() {
        return this.beforeFirst.getPositions();
    }

    @Override
    public boolean hasIndexed(String string) {
        if (this.add == null) {
            return false;
        }
        return this.add.keySet().contains(string);
    }

    @Override
    public boolean hasIndexed(int n) {
        if (this.canIndexing == null) {
            return false;
        }
        return this.canIndexing.contains(n);
    }

    @Override
    public boolean hasIndexInDefaultCol() {
        return this.canIndexing.contains(this.compare);
    }

    @Override
    public void buildOriginalIndex(String string) throws DSException {
    }

    @Override
    public void buildSortedIndex(String string) throws DSException {
    }

    private void SEDU(String string, int n) throws DSException {
        JRelationMetaData jRelationMetaData = this.close.getMetaData();
        int n2 = jRelationMetaData.getColumnType(n);
        this.add.put(string, LocalIndex.getSortedInstance(string, n2, this.SEDU));
        this.append.put(string, new Integer(n));
        this.afterLast.put(string, new Integer(n2));
        this.canIndexing.add(n);
    }

    private int add(String string) throws DSException {
        for (int i = 0; i < this.clear.getColumnCount(); ++i) {
            if (!string.equals(this.clear.getColumnName(i + 1))) continue;
            return i + 1;
        }
        return -1;
    }

    private boolean afterLast(int n) throws DSException {
        return SortedLocalIndex.canIndexing(this.clear.getColumnType(n));
    }

    private void append(String string, int n) throws DSException {
        int n2 = this.close.getMetaData().getColumnType(n);
        LocalIndex localIndex = (LocalIndex)this.add.get(string);
        int n3 = -1;
        block12: while (this.close.next()) {
            n3 = this.close.getCurrentRowID();
            switch (n2) {
                case -6: {
                    int n4 = this.close.getByte(n);
                    if (this.close.wasNull()) {
                        localIndex.putNull(n3);
                        continue block12;
                    }
                    localIndex.put(new Integer(n4), n3);
                    continue block12;
                }
                case 5: {
                    int n4 = this.close.getShort(n);
                    if (this.close.wasNull()) {
                        localIndex.putNull(n3);
                        continue block12;
                    }
                    localIndex.put(new Integer(n4), n3);
                    continue block12;
                }
                case 4: {
                    int n4 = this.close.getInt(n);
                    if (this.close.wasNull()) {
                        localIndex.putNull(n3);
                        continue block12;
                    }
                    localIndex.put(new Integer(n4), n3);
                    continue block12;
                }
                case -5: {
                    long l = this.close.getLong(n);
                    if (this.close.wasNull()) {
                        localIndex.putNull(n3);
                        continue block12;
                    }
                    localIndex.put(new Long(l), n3);
                    continue block12;
                }
                case 6: {
                    float f = this.close.getFloat(n);
                    if (this.close.wasNull()) {
                        localIndex.putNull(n3);
                        continue block12;
                    }
                    localIndex.put(new Float(f), n3);
                    continue block12;
                }
                case 8: {
                    double d = this.close.getDouble(n);
                    if (this.close.wasNull()) {
                        localIndex.putNull(n3);
                        continue block12;
                    }
                    localIndex.put(new Double(d), n3);
                    continue block12;
                }
                case 12: {
                    Object object = this.close.getString(n);
                    if (this.close.wasNull()) {
                        localIndex.putNull(n3);
                        continue block12;
                    }
                    localIndex.put(object, n3);
                    continue block12;
                }
                case 91: {
                    Object object = this.close.getDate(n);
                    if (this.close.wasNull()) {
                        localIndex.putNull(n3);
                        continue block12;
                    }
                    localIndex.put(object, n3);
                    continue block12;
                }
                case 92: {
                    Object object = this.close.getTime(n);
                    if (this.close.wasNull()) {
                        localIndex.putNull(n3);
                        continue block12;
                    }
                    localIndex.put(object, n3);
                    continue block12;
                }
                case 93: {
                    Object object = this.close.getTimestamp(n);
                    if (this.close.wasNull()) {
                        localIndex.putNull(n3);
                        continue block12;
                    }
                    localIndex.put(object, n3);
                    continue block12;
                }
            }
            throw new UnsupportedOperationException("Unsupport data type for building index: " + string);
        }
    }

    public ARelation getDataSource() {
        return this.close;
    }

    public IndexLocalRelation[] getReference() {
        return new IndexLocalRelation[]{this};
    }

    @Override
    public int size() {
        return this.contains;
    }

    @Override
    public Blob getBlob(int n) throws DSException {
        return this.close.getBlob(n);
    }

    @Override
    public Blob getBlob(String string) throws DSException {
        return this.close.getBlob(string);
    }

    @Override
    public boolean getBoolean(int n) throws DSException {
        return this.close.getBoolean(n);
    }

    @Override
    public boolean getBoolean(String string) throws DSException {
        return this.close.getBoolean(string);
    }

    @Override
    public byte getByte(int n) throws DSException {
        return this.close.getByte(n);
    }

    @Override
    public byte getByte(String string) throws DSException {
        return this.close.getByte(string);
    }

    @Override
    public byte[] getBytes(int n) throws DSException {
        return this.close.getBytes(n);
    }

    @Override
    public byte[] getBytes(String string) throws DSException {
        return this.close.getBytes(string);
    }

    @Override
    public Clob getClob(int n) throws DSException {
        return this.close.getClob(n);
    }

    @Override
    public Clob getClob(String string) throws DSException {
        return this.close.getClob(string);
    }

    @Override
    public short getShort(int n) throws DSException {
        return this.close.getShort(n);
    }

    @Override
    public short getShort(String string) throws DSException {
        return this.close.getShort(string);
    }

    @Override
    public void setDefaultSearchColumn(String string) throws DSException {
        boolean bl = false;
        for (int i = 0; i < this.clear.getColumnCount(); ++i) {
            if (!this.clear.getColumnName(i + 1).equals(string)) continue;
            bl = true;
            this.compare = i + 1;
            this.joinColType = this.clear.getAttribute(this.compare).getDataType();
            this.createRelation = string;
            break;
        }
        if (!bl) {
            throw new IllegalArgumentException("can not found column : " + string + " in relation data");
        }
        if (this.add != null) {
            this.beforeFirst = (LocalIndex)this.add.get(this.createRelation);
        }
    }

    @Override
    public void setDefaultSearchColumn(int n) throws DSException {
        this.compare = n;
        this.joinColType = this.clear.getAttribute(this.compare).getDataType();
        this.createRelation = this.clear.getColumnName(n);
        this.beforeFirst = (SortedLocalIndex)this.add.get(this.createRelation);
    }

    public Object getCompatibleObject() throws DSException {
        int n = this.destroyAllIndexes.getDataType();
        Object var2_2 = null;
        if (Types.isNumeric(n)) {
            Object object = this.close.getObject(this.compare);
            String string = object.toString();
            switch (n) {
                case -5: {
                    return Long.valueOf(string);
                }
                case 8: {
                    return Double.valueOf(string);
                }
                case 3: {
                    return new BigDecimal(string);
                }
            }
        } else {
            switch (this.joinColType) {
                case 91: {
                    Date date = this.close.getDate(this.compare);
                    return new Timestamp(date.getTime());
                }
                case 92: {
                    Time time2 = this.close.getTime(this.compare);
                    return new Timestamp(time2.getTime());
                }
                case 93: {
                    com.jinfonet.api.datatypes.Timestamp timestamp = this.close.getTimestamp(this.compare);
                    return new Timestamp(timestamp.getTime());
                }
                case 12: {
                    return this.close.getString(this.compare);
                }
            }
            throw new IllegalArgumentException("join column data type not supported");
        }
        return null;
    }

    @Override
    public boolean wasNull() throws DSException {
        return this.close.wasNull();
    }

    @Override
    public void destroyIndex(String string) {
        this.add.remove(string);
    }

    @Override
    public void destroyAllIndexes() {
        SortedLocalIndex sortedLocalIndex = null;
        Iterator iterator = this.add.keySet().iterator();
        while (iterator.hasNext()) {
            sortedLocalIndex = (SortedLocalIndex)this.add.get(iterator.next());
            sortedLocalIndex.clear();
        }
        this.add.clear();
    }

    @Override
    public boolean findLong(Long l, int n) throws DSException {
        if (this.hasIndexed(this.compare)) {
            return this.beforeFirst.find(l, n);
        }
        while (this.close.next()) {
            long l2 = this.close.getLong(this.compare);
            if (this.close.wasNull() || !Comparator.compare(l, n, l2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean findInt(Integer n, int n2) throws DSException {
        if (this.hasIndexed(this.compare)) {
            return this.beforeFirst.find(n, n2);
        }
        while (this.close.next()) {
            int n3 = this.close.getInt(this.compare);
            if (this.close.wasNull() || !Comparator.compare(n.intValue(), n2, n3)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean findFloat(Float f, int n) throws DSException {
        if (this.hasIndexed(this.compare)) {
            return this.beforeFirst.find(f, n);
        }
        while (this.close.next()) {
            float f2 = this.close.getFloat(this.compare);
            if (this.close.wasNull() || !Comparator.compare(f.floatValue(), n, f2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean findDouble(Double d, int n) throws DSException {
        if (this.hasIndexed(this.compare)) {
            return this.beforeFirst.find(d, n);
        }
        while (this.close.next()) {
            double d2 = this.close.getDouble(this.compare);
            if (this.close.wasNull() || !Comparator.compare(d, n, d2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean findString(String string, int n) throws DSException {
        if (this.hasIndexed(this.compare)) {
            return this.beforeFirst.find(string, n);
        }
        while (this.close.next()) {
            String string2 = this.close.getString(this.compare);
            if (this.close.wasNull() || !Comparator.compare(string, n, string2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean findObject(Object object, int n) throws DSException {
        if (this.hasIndexed(this.compare)) {
            return this.beforeFirst.find(object, n);
        }
        while (this.close.next()) {
            Object object2 = this.getCompatibleObject();
            if (this.close.wasNull() || !Comparator.compare(object, n, object2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean findNull(int n) throws DSException {
        if (this.hasIndexed(this.compare) && this.SEDU != -1) {
            return this.beforeFirst.hasNull();
        }
        while (this.close.next()) {
            switch (n) {
                case -6: {
                    this.close.getByte(this.compare);
                    break;
                }
                case 5: {
                    this.close.getShort(this.compare);
                    break;
                }
                case 4: {
                    this.close.getInt(this.compare);
                    break;
                }
                case -5: {
                    this.close.getLong(this.compare);
                    break;
                }
                case 6: {
                    this.close.getFloat(this.compare);
                    break;
                }
                case 8: {
                    this.close.getDouble(this.compare);
                    break;
                }
                case 91: {
                    this.close.getDate(this.compare);
                    break;
                }
                case 92: {
                    this.close.getTime(this.compare);
                    break;
                }
                case 93: {
                    this.close.getTimestamp(this.compare);
                    break;
                }
                case 12: {
                    this.close.getTimestamp(this.compare);
                    break;
                }
                case 3: {
                    this.close.getBigDecimal(this.compare);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("data types not support for findNull: " + this.compare);
                }
            }
            if (!this.close.wasNull()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setDefaultIndex(String string) throws DSException {
        if (!this.hasIndexed(string)) {
            throw new IllegalStateException("no such index in indexContainer, named: " + string);
        }
        this.beforeFirst = (SortedLocalIndex)this.add.get(string);
    }

    @Override
    public void setDefaultIndex(int n) throws DSException {
        if (this.canIndexing.contains(n)) {
            this.beforeFirst = (SortedLocalIndex)this.add.get(this.clear.getColumnName(n));
        }
    }

    @Override
    public Long getTargetLong() throws DSException {
        if (this.hasIndexed(this.compare)) {
            return (Long)this.beforeFirst.getValue();
        }
        return new Long(this.close.getLong(this.compare));
    }

    @Override
    public Integer getTargetByteInt() throws DSException {
        if (this.hasIndexed(this.compare)) {
            return (Integer)this.beforeFirst.getValue();
        }
        return new Integer(this.close.getByte(this.compare));
    }

    @Override
    public Integer getTargetShortInt() throws DSException {
        if (this.hasIndexed(this.compare)) {
            return (Integer)this.beforeFirst.getValue();
        }
        return new Integer(this.close.getShort(this.compare));
    }

    @Override
    public Integer getTargetInt() throws DSException {
        if (this.hasIndexed(this.compare)) {
            return (Integer)this.beforeFirst.getValue();
        }
        return new Integer(this.close.getInt(this.compare));
    }

    @Override
    public Float getTargetFloat() throws DSException {
        if (this.hasIndexed(this.compare)) {
            return (Float)this.beforeFirst.getValue();
        }
        return new Float(this.close.getFloat(this.compare));
    }

    @Override
    public Double getTargetDouble() throws DSException {
        if (this.hasIndexed(this.compare)) {
            return (Double)this.beforeFirst.getValue();
        }
        return new Double(this.close.getDouble(this.compare));
    }

    @Override
    public Date getTargetDate() throws DSException {
        if (this.hasIndexed(this.compare)) {
            return (Date)this.beforeFirst.getValue();
        }
        return this.close.getDate(this.compare);
    }

    @Override
    public Time getTargetTime() throws DSException {
        if (this.hasIndexed(this.compare)) {
            return (Time)this.beforeFirst.getValue();
        }
        return this.close.getTime(this.compare);
    }

    @Override
    public com.jinfonet.api.datatypes.Timestamp getTargetTimestamp() throws DSException {
        if (this.hasIndexed(this.compare)) {
            return (com.jinfonet.api.datatypes.Timestamp)this.beforeFirst.getValue();
        }
        return this.close.getTimestamp(this.compare);
    }

    @Override
    public String getTargetString() throws DSException {
        if (this.hasIndexed(this.compare)) {
            return (String)this.beforeFirst.getValue();
        }
        return this.close.getString(this.compare);
    }

    @Override
    public Object getTargetObject() throws DSException {
        if (this.hasIndexed(this.compare)) {
            return this.beforeFirst.getValue();
        }
        return this.close.getObject(this.compare);
    }

    @Override
    public boolean next() throws DSException {
        return this.close.next();
    }

    @Override
    public boolean isAfterLast() throws DSException {
        return this.close.isAfterLast();
    }

    @Override
    public boolean isBeforeFirst() throws DSException {
        return this.close.isBeforeFirst();
    }

    @Override
    public boolean isFirst() throws DSException {
        return this.close.isFirst();
    }

    @Override
    public boolean isLast() throws DSException {
        return this.close.isLast();
    }

    @Override
    public boolean last() throws DSException {
        return this.close.last();
    }

    @Override
    public boolean previous() throws DSException {
        return this.close.previous();
    }

    @Override
    public boolean relative(int n) throws DSException {
        return this.close.relative(n);
    }

    @Override
    public void afterLast() throws DSException {
        this.close.afterLast();
    }

    public boolean indexNext() throws DSException {
        if (this.hasIndexed(this.compare)) {
            return this.beforeFirst.next();
        }
        return false;
    }

    @Override
    public void beforeFirst() throws DSException {
        if (this.hasIndexed(this.compare)) {
            this.beforeFirst.beforeFirst();
        }
        this.close.beforeFirst();
    }

    @Override
    public boolean first() throws DSException {
        return this.close.first();
    }

    @Override
    public void setPosition(long l) throws DSException {
        this.close.setPosition(l);
    }

    @Override
    public long getPosition() throws DSException {
        if (this.hasIndexInDefaultCol()) {
            return this.beforeFirst.getPosition();
        }
        return this.close.getPosition();
    }

    @Override
    public long getIndexPosition() {
        return this.beforeFirst.getPosition();
    }

    @Override
    public JRelation getRelation(String string) throws DSException {
        return this.close.getRelation(string);
    }

    @Override
    public JRelation getRelation(int n) throws DSException {
        return this.close.getRelation(n);
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws DSException {
        return this.close.getBigDecimal(n);
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws DSException {
        return this.close.getBigDecimal(string);
    }

    @Override
    public InputStream getBinaryStream(int n) throws DSException {
        return this.close.getBinaryStream(n);
    }

    @Override
    public InputStream getBinaryStream(String string) throws DSException {
        return this.close.getBinaryStream(string);
    }

    @Override
    public Date getDate(int n) throws DSException {
        return this.close.getDate(n);
    }

    @Override
    public Date getDate(String string) throws DSException {
        return this.close.getDate(string);
    }

    @Override
    public double getDouble(int n) throws DSException {
        return this.close.getDouble(n);
    }

    @Override
    public double getDouble(String string) throws DSException {
        return this.close.getDouble(string);
    }

    @Override
    public float getFloat(int n) throws DSException {
        return this.close.getFloat(n);
    }

    @Override
    public float getFloat(String string) throws DSException {
        return this.close.getFloat(string);
    }

    @Override
    public int getInt(int n) throws DSException {
        return this.close.getInt(n);
    }

    @Override
    public int getInt(String string) throws DSException {
        return this.close.getInt(string);
    }

    @Override
    public long getLong(int n) throws DSException {
        return this.close.getLong(n);
    }

    @Override
    public long getLong(String string) throws DSException {
        return this.close.getLong(string);
    }

    @Override
    public Object getObject(int n) throws DSException {
        return this.close.getObject(n);
    }

    @Override
    public Object getObject(String string) throws DSException {
        return this.close.getObject(string);
    }

    @Override
    public String getString(int n) throws DSException {
        return this.close.getString(n);
    }

    @Override
    public String getString(String string) throws DSException {
        return this.close.getString(string);
    }

    @Override
    public Time getTime(int n) throws DSException {
        return this.close.getTime(n);
    }

    @Override
    public Time getTime(String string) throws DSException {
        return this.close.getTime(string);
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws DSException {
        return this.close.getTime(n, calendar);
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws DSException {
        return this.close.getTime(string, calendar);
    }

    @Override
    public com.jinfonet.api.datatypes.Timestamp getTimestamp(int n) throws DSException {
        return this.close.getTimestamp(n);
    }

    @Override
    public com.jinfonet.api.datatypes.Timestamp getTimestamp(String string) throws DSException {
        return this.close.getTimestamp(string);
    }

    @Override
    public IRelationData getRelationData(String string) throws DSException {
        return this.close.getRelationData(string);
    }

    @Override
    public IRelationData getRelationData(int n) throws DSException {
        return this.close.getRelationData(n);
    }

    @Override
    public Array getArray(int n) throws DSException {
        return this.close.getArray(n);
    }

    @Override
    public Array getArray(String string) throws DSException {
        return this.close.getArray(string);
    }

    @Override
    public int getCurrentRowID() throws DSException {
        return this.close.getCurrentRowID();
    }

    @Override
    public int getType() throws DSException {
        return 0xC000007;
    }
}

