/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.relational.swap;

import com.jinfonet.dataservice.ANamedObject;
import com.jinfonet.dataservice.api.schema.relational.JRelationMetaData;
import com.jinfonet.dataservice.relational.ARelation;
import com.jinfonet.dataservice.relational.GeneralRelation;
import com.jinfonet.dataservice.relational.IRelationData;
import com.jinfonet.dataservice.relational.IRowID;
import com.jinfonet.dataservice.relational.ITuple;
import com.jinfonet.dataservice.relational.Record;
import com.jinfonet.dataservice.relational.RelationOption;
import com.jinfonet.dataservice.relational.swap.PooledRowID;
import com.jinfonet.dataservice.relational.swap.RowDataPool;
import com.jinfonet.dataservice.relational.swap.RowDataPoolListener;
import java.util.ArrayList;
import java.util.List;
import jet.dataengine.api.DSException;
import jet.dataengine.api.DataCacheInfo;
import jet.dataengine8.util.dataswap.DataCacheManagerImpl;
import jet.dataengine8.util.dataswap.IDataCache;

public abstract class ARelationPool
extends ANamedObject
implements IRelationData {
    protected final List subRelationRowDataPools = new ArrayList();
    protected final List subRelPropList = new ArrayList();
    protected final ArrayList listeners = new ArrayList();
    private final Object SEDU = new Object();
    protected final JRelationMetaData metaData;
    protected final IDataCache dataCache;
    protected final RowDataPool rowDataPool;
    protected final RelationOption option;
    protected long fetchCount = 0L;
    private boolean active = false;
    protected boolean hasNotifyListeners = false;
    private int add = 0;
    private boolean addPooledRelationRefrence = false;
    private Object appendFinished = new Object();

    public ARelationPool(String string, JRelationMetaData jRelationMetaData, RelationOption relationOption) throws DSException {
        super(string);
        this.metaData = jRelationMetaData;
        this.dataCache = DataCacheManagerImpl.getInstance().getDataCache(relationOption.getDiskStore(), relationOption.getLevelOneMemorySize(), relationOption.getLevelTwoMemeorySize(), relationOption.isCacheZip(), false);
        this.rowDataPool = new RowDataPool(this, jRelationMetaData);
        this.option = relationOption;
    }

    public ARelationPool(String string, JRelationMetaData jRelationMetaData, RelationOption relationOption, IDataCache iDataCache) throws DSException {
        super(string);
        this.metaData = jRelationMetaData;
        this.dataCache = iDataCache;
        this.rowDataPool = new RowDataPool(this, jRelationMetaData);
        this.option = relationOption;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPooledRelationRefrence() {
        Object object = this.SEDU;
        synchronized (object) {
            ++this.add;
        }
    }

    public Record createRecord() throws DSException {
        return this.rowDataPool.createRecord();
    }

    @Override
    public boolean isEmpty() throws DSException {
        return this.rowDataPool.isEmpty();
    }

    public long getFetchCount() {
        return this.fetchCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRowDataPoolListener(RowDataPoolListener rowDataPoolListener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(rowDataPoolListener);
            if (this.hasNotifyListeners) {
                rowDataPoolListener.fetchDataCompleted();
            }
        }
    }

    public void appendFinished() {
        this.rowDataPool.appendFinished();
    }

    public boolean appendRecord(ITuple iTuple) throws DSException {
        return this.rowDataPool.appendRecord(iTuple);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canClose() {
        Object object = this.SEDU;
        synchronized (object) {
            return this.add == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws DSException {
        this.addPooledRelationRefrence = true;
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.clear();
        }
        if (!this.canClose()) {
            this.log.warn(6022);
        }
        this.SEDU();
    }

    @Override
    public ARelation createRelation() throws DSException {
        return new GeneralRelation(this.getName(), this);
    }

    @Override
    public IRowID createRowID() throws DSException {
        return new PooledRowID(this.rowDataPool);
    }

    @Override
    public ITuple createTuple() throws DSException {
        this.addPooledRelationRefrence();
        return this.createTupleReal();
    }

    protected ITuple createTupleReal() throws DSException {
        return this.rowDataPool.createRecord();
    }

    public int getCurrentFilledRecordsCount() {
        return this.rowDataPool.getCurrentFilledRecordsCount();
    }

    public IDataCache getDataCache() {
        return this.dataCache;
    }

    @Override
    public JRelationMetaData getMetaData() {
        return this.metaData;
    }

    public List getSubRelationRowDataPools() {
        return this.subRelationRowDataPools;
    }

    public List getSubRelPropList() {
        return this.subRelPropList;
    }

    @Override
    public int getType() throws DSException {
        return 0x1000003;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SEDU() {
        Object object = this.appendFinished;
        synchronized (object) {
            if (this.active) {
                return;
            }
            this.rowDataPool.releaseRowDataPool();
            this.subRelationRowDataPools.clear();
            this.active = true;
        }
    }

    @Override
    public boolean isClosed() {
        return this.addPooledRelationRefrence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePooledRelationReference() {
        Object object = this.SEDU;
        synchronized (object) {
            --this.add;
            if (this.addPooledRelationRefrence && this.add == 0) {
                this.SEDU();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRowDataPoolListener(RowDataPoolListener rowDataPoolListener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(rowDataPoolListener);
        }
    }

    @Override
    public void removeTuple(ITuple iTuple) throws DSException {
        this.removePooledRelationReference();
    }

    @Override
    public DataCacheInfo getDataCacheInfo() {
        return this.rowDataPool.getDataCacheInfo();
    }

    public void hibernate() {
        this.dataCache.hibernate();
    }

    public void active() {
        this.dataCache.active();
    }

    @Override
    public RelationOption getRelationOption() {
        return this.option;
    }

    static class SubRelationPorperty {
        SubRelationPorperty() {
        }
    }
}

