/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.relational.swap;

import com.jinfonet.api.datatypes.Array;
import com.jinfonet.api.datatypes.Blob;
import com.jinfonet.api.datatypes.Clob;
import com.jinfonet.api.datatypes.Date;
import com.jinfonet.api.datatypes.Time;
import com.jinfonet.api.datatypes.Timestamp;
import com.jinfonet.api.datatypes.Types;
import com.jinfonet.dataservice.api.schema.relational.JAttribute;
import com.jinfonet.dataservice.api.schema.relational.JRelation;
import com.jinfonet.dataservice.api.schema.relational.JRelationMetaData;
import com.jinfonet.dataservice.relational.IRelationData;
import com.jinfonet.dataservice.relational.Record;
import com.jinfonet.dataservice.relational.swap.ARelationPool;
import com.jinfonet.dataservice.relational.swap.RowDataPool;
import com.jinfonet.dataservice.util.Bits;
import com.jinfonet.datatypes.JinfonetBlobBaseBytes;
import com.jinfonet.datatypes.JinfonetDate;
import com.jinfonet.datatypes.JinfonetTime;
import com.jinfonet.datatypes.JinfonetTimeStamp;
import java.math.BigDecimal;
import java.math.BigInteger;
import jet.dataengine.api.DSException;
import jet.dataengine8.util.JBoolean;
import jet.dataengine8.util.dataswap.ArrayTool;
import jet.dataengine8.util.dataswap.IDataCache;

public class PooledRecord
extends Record {
    private final Object SEDU;
    private final int array2Bytes;
    private static final int arraycopy = 255;
    private static final long booleanValue = 255L;
    private static final byte byteValue = 1;
    private static final byte bytes2Array = 0;
    private static final int createRelation = 4;
    private static final int desiredAssertionStatus = 255;
    private byte[] doubleToRawLongBits = null;
    private boolean doubleValue = false;
    private final IDataCache findColumn;
    private JRelationMetaData floatToIntBits = null;
    private int[] floatValue;
    private char[] getAttribute;
    private int[] getBigDecimal;
    private int[] getBlob;
    private int getBoolean = 1;
    private int getByte;
    private int getBytes;
    private int getChars;
    private int getClob;
    private int[] getColumnCount;
    private JAttribute[] getColumnType;

    public PooledRecord(RowDataPool rowDataPool) throws DSException {
        this.SEDU = rowDataPool;
        this.findColumn = rowDataPool.dataCache;
        this.floatToIntBits = rowDataPool.getMetaData();
        this.array2Bytes = this.floatToIntBits.getColumnCount();
        this.$assertionsDisabled();
    }

    public PooledRecord(ARelationPool aRelationPool, JRelationMetaData jRelationMetaData) throws DSException {
        this.SEDU = aRelationPool;
        this.findColumn = aRelationPool.getDataCache();
        this.floatToIntBits = jRelationMetaData;
        this.array2Bytes = jRelationMetaData.getColumnCount();
        this.$assertionsDisabled();
    }

    private final void $assertionsDisabled() throws DSException {
        int n = this.getByte = (this.array2Bytes >> 3) + 1;
        int n2 = this.getByte;
        int n3 = 0;
        this.floatValue = new int[this.array2Bytes + 1];
        this.getBigDecimal = new int[this.array2Bytes + 1];
        this.getBlob = new int[this.array2Bytes + 1];
        this.getColumnCount = new int[this.array2Bytes + 1];
        this.getColumnType = new JAttribute[this.array2Bytes + 1];
        for (int i = 1; i <= this.array2Bytes; ++i) {
            this.getColumnType[i] = this.floatToIntBits.getAttribute(i);
            this.floatValue[i] = this.floatToIntBits.getColumnType(i);
            this.getBlob[i] = Types.swapDataLength(this.floatValue[i]);
            int n4 = 0;
            if (this.getBlob[i] == 0) {
                switch (this.floatValue[i]) {
                    case 12: {
                        n4 = 255;
                        if (n3 >= this.floatToIntBits.getPrecision(i)) break;
                        n3 = this.floatToIntBits.getPrecision(i);
                        break;
                    }
                    case -2: 
                    case 3: 
                    case 2003: {
                        n4 = 255;
                    }
                }
                this.getBlob[i] = 4;
            }
            if (this.getColumnType[i].isConstant()) {
                this.getBlob[i] = 0;
            }
            this.getBigDecimal[i] = n;
            this.getColumnCount[i] = n4;
            n += this.getBlob[i];
            n2 = n2 + this.getBlob[i] + Math.max(8, n4);
        }
        assert (n2 < 0x7FFFFF);
        this.getChars = n;
        this.doubleToRawLongBits = new byte[n2];
        if (n3 > 1024) {
            n3 = 1024;
        }
        this.getAttribute = new char[n3];
        this.reset();
    }

    @Override
    public void putByte(byte by) {
        if (this.getColumnType[this.getBoolean].isConstant()) {
            ++this.getBoolean;
            return;
        }
        this.doubleToRawLongBits[this.getClob++] = by;
        ++this.getBoolean;
    }

    public byte getByte(String string) throws DSException {
        return this.getByte(this.floatToIntBits.findColumn(string));
    }

    @Override
    public byte getByte(int n) {
        if (this.getColumnType[n].isConstant()) {
            Object object = this.getColumnType[n].getConstant();
            if (object == null) {
                this.doubleValue = true;
                return 0;
            }
            this.doubleValue = false;
            return (Byte)object;
        }
        this.doubleValue = (this.doubleToRawLongBits[n >> 3] & 1 << (n - 1 & 7)) == 0;
        return this.doubleToRawLongBits[this.getBigDecimal[n]];
    }

    @Override
    public void putBoolean(boolean bl) {
        if (this.getColumnType[this.getBoolean].isConstant()) {
            ++this.getBoolean;
            return;
        }
        this.doubleToRawLongBits[this.getClob++] = bl ? (byte)1 : 0;
        ++this.getBoolean;
    }

    public boolean getBoolean(String string) throws DSException {
        return this.getBoolean(this.floatToIntBits.findColumn(string));
    }

    @Override
    public boolean getBoolean(int n) {
        if (this.getColumnType[n].isConstant()) {
            Object object = this.getColumnType[n].getConstant();
            if (object == null) {
                this.doubleValue = true;
                return false;
            }
            this.doubleValue = false;
            return (Boolean)object;
        }
        this.doubleValue = (this.doubleToRawLongBits[n >> 3] & 1 << (n - 1 & 7)) == 0;
        return this.doubleToRawLongBits[this.getBigDecimal[n]] == 1;
    }

    @Override
    public void putShort(short s) {
        if (this.getColumnType[this.getBoolean].isConstant()) {
            ++this.getBoolean;
            return;
        }
        this.doubleToRawLongBits[this.getClob++] = (byte)s;
        this.doubleToRawLongBits[this.getClob++] = (byte)(s >> 8);
        ++this.getBoolean;
    }

    public short getShort(String string) throws DSException {
        return this.getShort(this.floatToIntBits.findColumn(string));
    }

    @Override
    public short getShort(int n) {
        if (this.getColumnType[n].isConstant()) {
            Object object = this.getColumnType[n].getConstant();
            if (object == null) {
                this.doubleValue = true;
                return 0;
            }
            this.doubleValue = false;
            return (Short)object;
        }
        this.doubleValue = (this.doubleToRawLongBits[n >> 3] & 1 << (n - 1 & 7)) == 0;
        return (short)(this.doubleToRawLongBits[this.getBigDecimal[n] + 1] << 8 | this.doubleToRawLongBits[this.getBigDecimal[n]] & 0xFF);
    }

    @Override
    public void putInt(int n) {
        if (this.getColumnType[this.getBoolean].isConstant()) {
            ++this.getBoolean;
            return;
        }
        this.doubleToRawLongBits[this.getClob++] = (byte)n;
        this.doubleToRawLongBits[this.getClob++] = (byte)(n >> 8);
        this.doubleToRawLongBits[this.getClob++] = (byte)(n >> 16);
        this.doubleToRawLongBits[this.getClob++] = (byte)(n >> 24);
        ++this.getBoolean;
    }

    public void putInt(int n, int n2) {
        if (this.getColumnType[n].isConstant()) {
            return;
        }
        this.doubleToRawLongBits[n >> 3] = (byte)(this.doubleToRawLongBits[n >> 3] | 1 << (n - 1 & 7));
        this.doubleToRawLongBits[this.getBigDecimal[n]] = (byte)n2;
        this.doubleToRawLongBits[this.getBigDecimal[n] + 1] = (byte)(n2 >> 8);
        this.doubleToRawLongBits[this.getBigDecimal[n] + 2] = (byte)(n2 >> 16);
        this.doubleToRawLongBits[this.getBigDecimal[n] + 3] = (byte)(n2 >> 24);
    }

    public int getInt(String string) throws DSException {
        return this.getInt(this.floatToIntBits.findColumn(string));
    }

    @Override
    public int getInt(int n) {
        if (this.getColumnType[n].isConstant()) {
            Object object = this.getColumnType[n].getConstant();
            if (object == null) {
                this.doubleValue = true;
                return 0;
            }
            this.doubleValue = false;
            return (Integer)object;
        }
        this.doubleValue = (this.doubleToRawLongBits[n >> 3] & 1 << (n - 1 & 7)) == 0;
        return this.doubleToRawLongBits[this.getBigDecimal[n] + 3] << 24 | (this.doubleToRawLongBits[this.getBigDecimal[n] + 2] & 0xFF) << 16 | (this.doubleToRawLongBits[this.getBigDecimal[n] + 1] & 0xFF) << 8 | this.doubleToRawLongBits[this.getBigDecimal[n]] & 0xFF;
    }

    @Override
    public void putFloat(float f) {
        if (this.getColumnType[this.getBoolean].isConstant()) {
            ++this.getBoolean;
            return;
        }
        this.putInt(Float.floatToIntBits(f));
    }

    public float getFloat(String string) throws DSException {
        return this.getFloat(this.floatToIntBits.findColumn(string));
    }

    @Override
    public float getFloat(int n) {
        if (this.getColumnType[n].isConstant()) {
            Object object = this.getColumnType[n].getConstant();
            if (object == null) {
                this.doubleValue = true;
                return 0.0f;
            }
            this.doubleValue = false;
            return ((Float)object).floatValue();
        }
        this.doubleValue = (this.doubleToRawLongBits[n >> 3] & 1 << (n - 1 & 7)) == 0;
        return Float.intBitsToFloat(this.getInt(n));
    }

    @Override
    public final void putLong(long l) {
        if (this.getColumnType[this.getBoolean].isConstant()) {
            ++this.getBoolean;
            return;
        }
        this.doubleToRawLongBits[this.getClob++] = (byte)l;
        this.doubleToRawLongBits[this.getClob++] = (byte)(l >> 8);
        this.doubleToRawLongBits[this.getClob++] = (byte)(l >> 16);
        this.doubleToRawLongBits[this.getClob++] = (byte)(l >> 24);
        this.doubleToRawLongBits[this.getClob++] = (byte)(l >> 32);
        this.doubleToRawLongBits[this.getClob++] = (byte)(l >> 40);
        this.doubleToRawLongBits[this.getClob++] = (byte)(l >> 48);
        this.doubleToRawLongBits[this.getClob++] = (byte)(l >> 56);
        ++this.getBoolean;
    }

    public long getLong(String string) throws DSException {
        return this.getLong(this.floatToIntBits.findColumn(string));
    }

    @Override
    public long getLong(int n) {
        if (this.getColumnType[n].isConstant()) {
            Object object = this.getColumnType[n].getConstant();
            if (object == null) {
                this.doubleValue = true;
                return 0L;
            }
            this.doubleValue = false;
            return (Long)object;
        }
        this.doubleValue = (this.doubleToRawLongBits[n >> 3] & 1 << (n - 1 & 7)) == 0;
        int n2 = this.getBigDecimal[n];
        return (long)this.doubleToRawLongBits[n2 + 7] << 56 | ((long)this.doubleToRawLongBits[n2 + 6] & 0xFFL) << 48 | ((long)this.doubleToRawLongBits[n2 + 5] & 0xFFL) << 40 | ((long)this.doubleToRawLongBits[n2 + 4] & 0xFFL) << 32 | ((long)this.doubleToRawLongBits[n2 + 3] & 0xFFL) << 24 | ((long)this.doubleToRawLongBits[n2 + 2] & 0xFFL) << 16 | ((long)this.doubleToRawLongBits[n2 + 1] & 0xFFL) << 8 | (long)this.doubleToRawLongBits[n2] & 0xFFL;
    }

    @Override
    public void putDouble(double d) {
        if (this.getColumnType[this.getBoolean].isConstant()) {
            ++this.getBoolean;
            return;
        }
        this.putLong(Double.doubleToRawLongBits(d));
    }

    public double getDouble(String string) throws DSException {
        return this.getDouble(this.floatToIntBits.findColumn(string));
    }

    @Override
    public double getDouble(int n) {
        if (this.getColumnType[n].isConstant()) {
            Object object = this.getColumnType[n].getConstant();
            if (object == null) {
                this.doubleValue = true;
                return 0.0;
            }
            this.doubleValue = false;
            return (Double)object;
        }
        return Double.longBitsToDouble(this.getLong(n));
    }

    @Override
    public void putBigDecimal(BigDecimal bigDecimal) throws DSException {
        if (this.getColumnType[this.getBoolean].isConstant()) {
            ++this.getBoolean;
            return;
        }
        byte[] byArray = this.SEDU(bigDecimal);
        this.putBytes(byArray);
    }

    private byte[] SEDU(BigDecimal bigDecimal) {
        BigInteger bigInteger = bigDecimal.unscaledValue();
        byte[] byArray = bigInteger.toByteArray();
        int n = byArray.length;
        byte[] byArray2 = new byte[n + 4];
        int n2 = bigDecimal.scale();
        Bits.putInt(byArray2, 0, n2);
        System.arraycopy(byArray, 0, byArray2, 4, n);
        return byArray2;
    }

    public BigDecimal getBigDecimal(String string) throws DSException {
        return this.getBigDecimal(this.floatToIntBits.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws DSException {
        if (this.getColumnType[n].isConstant()) {
            Object object = this.getColumnType[n].getConstant();
            if (object == null) {
                this.doubleValue = true;
                return null;
            }
            this.doubleValue = false;
            return (BigDecimal)object;
        }
        boolean bl = this.doubleValue = (this.doubleToRawLongBits[n >> 3] & 1 << (n - 1 & 7)) == 0;
        if (this.doubleValue) {
            return null;
        }
        return this.array2Bytes(this.getBytes(n));
    }

    private BigDecimal array2Bytes(byte[] byArray) {
        int n = Bits.getInt(byArray, 0);
        byte[] byArray2 = new byte[byArray.length - 4];
        System.arraycopy(byArray, 4, byArray2, 0, byArray2.length);
        return new BigDecimal(new BigInteger(byArray2), n);
    }

    @Override
    public void putDate(Date date) {
        if (this.getColumnType[this.getBoolean].isConstant()) {
            ++this.getBoolean;
            return;
        }
        this.putLong(date.getTime());
    }

    public void putDate(long l) {
        if (this.getColumnType[this.getBoolean].isConstant()) {
            ++this.getBoolean;
            return;
        }
        this.putLong(l);
    }

    public Date getDate(String string) throws DSException {
        return this.getDate(this.floatToIntBits.findColumn(string));
    }

    @Override
    public Date getDate(int n) {
        if (this.getColumnType[n].isConstant()) {
            Object object = this.getColumnType[n].getConstant();
            if (object == null) {
                this.doubleValue = true;
                return null;
            }
            this.doubleValue = false;
            return (Date)object;
        }
        return new JinfonetDate(this.getLong(n));
    }

    @Override
    public void putTimeStamp(Timestamp timestamp) {
        if (this.getColumnType[this.getBoolean].isConstant()) {
            ++this.getBoolean;
            return;
        }
        this.putLong(timestamp.getTime() - (long)(timestamp.getNanos() / 1000000));
        int n = timestamp.getNanos();
        this.doubleToRawLongBits[this.getClob++] = (byte)n;
        this.doubleToRawLongBits[this.getClob++] = (byte)(n >> 8);
        this.doubleToRawLongBits[this.getClob++] = (byte)(n >> 16);
        this.doubleToRawLongBits[this.getClob++] = (byte)(n >> 24);
    }

    public void putTimeStamp(long l, int n) {
        if (this.getColumnType[this.getBoolean].isConstant()) {
            ++this.getBoolean;
            return;
        }
        this.putLong(l);
        this.doubleToRawLongBits[this.getClob++] = (byte)n;
        this.doubleToRawLongBits[this.getClob++] = (byte)(n >> 8);
        this.doubleToRawLongBits[this.getClob++] = (byte)(n >> 16);
        this.doubleToRawLongBits[this.getClob++] = (byte)(n >> 24);
    }

    public Timestamp getTimeStamp(String string) throws DSException {
        return this.getTimeStamp(this.floatToIntBits.findColumn(string));
    }

    @Override
    public Timestamp getTimeStamp(int n) {
        if (this.getColumnType[n].isConstant()) {
            Object object = this.getColumnType[n].getConstant();
            if (object == null) {
                this.doubleValue = true;
                return null;
            }
            this.doubleValue = false;
            return (Timestamp)object;
        }
        JinfonetTimeStamp jinfonetTimeStamp = new JinfonetTimeStamp(this.getLong(n));
        int n2 = this.doubleToRawLongBits[this.getBigDecimal[n] + 11] << 24 | (this.doubleToRawLongBits[this.getBigDecimal[n] + 10] & 0xFF) << 16 | (this.doubleToRawLongBits[this.getBigDecimal[n] + 9] & 0xFF) << 8 | this.doubleToRawLongBits[this.getBigDecimal[n] + 8] & 0xFF;
        jinfonetTimeStamp.setNanos(n2);
        return jinfonetTimeStamp;
    }

    @Override
    public void putTime(Time time2) {
        if (this.getColumnType[this.getBoolean].isConstant()) {
            ++this.getBoolean;
            return;
        }
        this.putLong(time2.getTime());
    }

    public void putTime(long l) {
        if (this.getColumnType[this.getBoolean].isConstant()) {
            ++this.getBoolean;
            return;
        }
        this.putLong(l);
    }

    public Time getTime(String string) throws DSException {
        return this.getTime(this.floatToIntBits.findColumn(string));
    }

    @Override
    public Time getTime(int n) {
        if (this.getColumnType[n].isConstant()) {
            Object object = this.getColumnType[n].getConstant();
            if (object == null) {
                this.doubleValue = true;
                return null;
            }
            this.doubleValue = false;
            return (Time)object;
        }
        return new JinfonetTime(this.getLong(n));
    }

    @Override
    public void putString(String string) throws DSException {
        int n;
        if (this.getColumnType[this.getBoolean].isConstant()) {
            ++this.getBoolean;
            return;
        }
        if (string == null) {
            this.putNull(12);
            return;
        }
        int n2 = string.length();
        if (this.getAttribute.length < n2) {
            this.getAttribute = new char[(int)((float)n2 * 1.5f)];
        }
        string.getChars(0, n2, this.getAttribute, 0);
        boolean bl = true;
        for (n = 0; n < n2; ++n) {
            if (this.getAttribute[n] <= '\u00ff') continue;
            bl = false;
            break;
        }
        if ((n = bl ? n2 + 1 : n2 * 2 + 1) <= this.getColumnCount[this.getBoolean]) {
            this.doubleToRawLongBits[this.getClob++] = (byte)(this.getBytes >> 16);
            this.doubleToRawLongBits[this.getClob++] = (byte)(this.getBytes >> 8);
            this.doubleToRawLongBits[this.getClob++] = (byte)this.getBytes;
            this.doubleToRawLongBits[this.getClob++] = (byte)n;
            if (bl) {
                this.doubleToRawLongBits[this.getBytes++] = 0;
                for (int i = 0; i < n2; ++i) {
                    this.doubleToRawLongBits[this.getBytes++] = (byte)this.getAttribute[i];
                }
            } else {
                this.doubleToRawLongBits[this.getBytes++] = 1;
                for (int i = 0; i < n2; ++i) {
                    this.doubleToRawLongBits[this.getBytes++] = (byte)this.getAttribute[i];
                    this.doubleToRawLongBits[this.getBytes++] = (byte)(this.getAttribute[i] >> 8);
                }
            }
        } else {
            int n3;
            byte[] byArray = null;
            int n4 = 0;
            if (bl) {
                byArray = new byte[n2 + 1];
                byArray[n4++] = 0;
                for (n3 = 0; n3 < n2; ++n3) {
                    byArray[n4++] = (byte)this.getAttribute[n3];
                }
            } else {
                byArray = new byte[n2 * 2 + 1];
                byArray[n4++] = 1;
                for (n3 = 0; n3 < n2; ++n3) {
                    byArray[n4++] = (byte)this.getAttribute[n3];
                    byArray[n4++] = (byte)(this.getAttribute[n3] >> 8);
                }
            }
            long l = this.findColumn.putBlob(new JinfonetBlobBaseBytes(byArray));
            this.doubleToRawLongBits[this.getClob++] = -1;
            this.doubleToRawLongBits[this.getClob++] = (byte)(this.getBytes >> 16);
            this.doubleToRawLongBits[this.getClob++] = (byte)(this.getBytes >> 8);
            this.doubleToRawLongBits[this.getClob++] = (byte)this.getBytes;
            Bits.putLong(this.doubleToRawLongBits, this.getBytes, l);
            this.getBytes += 8;
        }
        ++this.getBoolean;
    }

    public String getString(String string) throws DSException {
        return this.getString(this.floatToIntBits.findColumn(string));
    }

    @Override
    public String getString(int n) throws DSException {
        if (this.getColumnType[n].isConstant()) {
            Object object = this.getColumnType[n].getConstant();
            if (object == null) {
                this.doubleValue = true;
                return null;
            }
            this.doubleValue = false;
            return (String)object;
        }
        boolean bl = this.doubleValue = (this.doubleToRawLongBits[n >> 3] & 1 << (n - 1 & 7)) == 0;
        if (this.doubleValue) {
            return null;
        }
        if ((this.doubleToRawLongBits[this.getBigDecimal[n]] & 0x80) == 0) {
            int n2 = (this.doubleToRawLongBits[this.getBigDecimal[n] + 0] & 0xFF) << 16 | (this.doubleToRawLongBits[this.getBigDecimal[n] + 1] & 0xFF) << 8 | this.doubleToRawLongBits[this.getBigDecimal[n] + 2] & 0xFF;
            int n3 = this.doubleToRawLongBits[this.getBigDecimal[n] + 3] & 0xFF;
            return this.arraycopy(this.doubleToRawLongBits, n2, n3);
        }
        int n4 = (this.doubleToRawLongBits[this.getBigDecimal[n] + 1] & 0xFF) << 16 | (this.doubleToRawLongBits[this.getBigDecimal[n] + 2] & 0xFF) << 8 | this.doubleToRawLongBits[this.getBigDecimal[n] + 3] & 0xFF;
        Blob blob = this.findColumn.getBlob(Bits.getLong(this.doubleToRawLongBits, n4));
        return this.arraycopy(blob.getBytes(1L, (int)blob.length()), 0, (int)blob.length());
    }

    private String arraycopy(byte[] byArray, int n, int n2) {
        int n3 = n2 - 1;
        if (this.getAttribute.length < n3) {
            this.getAttribute = new char[(int)((float)n3 * 1.5f)];
        }
        if (byArray[n] == 0) {
            int n4 = n3;
            for (int i = 0; i < n4; ++i) {
                this.getAttribute[i] = (char)(byArray[n + i + 1] & 0xFF);
            }
            return new String(this.getAttribute, 0, n3);
        }
        int n5 = n3 >> 1;
        for (int i = 0; i < n5; ++i) {
            this.getAttribute[i] = (char)(byArray[n + 2 * i + 1] & 0xFF | byArray[n + 2 * i + 2] << 8);
        }
        return new String(this.getAttribute, 0, n3 >> 1);
    }

    @Override
    public void putBlob(Blob blob) throws DSException {
        if (this.getColumnType[this.getBoolean].isConstant()) {
            ++this.getBoolean;
            return;
        }
        if (blob == null) {
            this.putNull(2004);
            return;
        }
        this.putLong(this.findColumn.putBlob(blob));
    }

    public Blob getBlob(String string) throws DSException {
        return this.getBlob(this.floatToIntBits.findColumn(string));
    }

    @Override
    public Blob getBlob(int n) throws DSException {
        if (this.getColumnType[n].isConstant()) {
            Object object = this.getColumnType[n].getConstant();
            if (object == null) {
                this.doubleValue = true;
                return null;
            }
            this.doubleValue = false;
            return (Blob)object;
        }
        boolean bl = this.doubleValue = (this.doubleToRawLongBits[n >> 3] & 1 << (n - 1 & 7)) == 0;
        if (this.doubleValue) {
            return null;
        }
        return this.findColumn.getBlob(this.getLong(n));
    }

    @Override
    public void putClob(Clob clob) throws DSException {
        if (this.getColumnType[this.getBoolean].isConstant()) {
            ++this.getBoolean;
            return;
        }
        if (clob == null) {
            this.putNull(2005);
            return;
        }
        this.putLong(this.findColumn.putClob(clob));
    }

    public Clob getClob(String string) throws DSException {
        return this.getClob(this.floatToIntBits.findColumn(string));
    }

    @Override
    public Clob getClob(int n) throws DSException {
        if (this.getColumnType[n].isConstant()) {
            Object object = this.getColumnType[n].getConstant();
            if (object == null) {
                this.doubleValue = true;
                return null;
            }
            this.doubleValue = false;
            return (Clob)object;
        }
        boolean bl = this.doubleValue = (this.doubleToRawLongBits[n >> 3] & 1 << (n - 1 & 7)) == 0;
        if (this.doubleValue) {
            return null;
        }
        return this.findColumn.getClob(this.getLong(n));
    }

    @Override
    public void putBytes(byte[] byArray) throws DSException {
        if (this.getColumnType[this.getBoolean].isConstant()) {
            ++this.getBoolean;
            return;
        }
        if (byArray == null) {
            byArray = new byte[]{};
        }
        if (byArray.length > 255) {
            long l = this.findColumn.putBlob(new JinfonetBlobBaseBytes(byArray));
            this.doubleToRawLongBits[this.getClob++] = -1;
            this.doubleToRawLongBits[this.getClob++] = (byte)(this.getBytes >> 16);
            this.doubleToRawLongBits[this.getClob++] = (byte)(this.getBytes >> 8);
            this.doubleToRawLongBits[this.getClob++] = (byte)this.getBytes;
            Bits.putLong(this.doubleToRawLongBits, this.getBytes, l);
            this.getBytes += 8;
        } else {
            System.arraycopy(byArray, 0, this.doubleToRawLongBits, this.getBytes, byArray.length);
            this.doubleToRawLongBits[this.getClob++] = (byte)(this.getBytes >> 16);
            this.doubleToRawLongBits[this.getClob++] = (byte)(this.getBytes >> 8);
            this.doubleToRawLongBits[this.getClob++] = (byte)this.getBytes;
            this.doubleToRawLongBits[this.getClob++] = (byte)byArray.length;
            this.getBytes += byArray.length;
        }
        ++this.getBoolean;
    }

    public byte[] getBytes(String string) throws DSException {
        return this.getBytes(this.floatToIntBits.findColumn(string));
    }

    @Override
    public byte[] getBytes(int n) throws DSException {
        if (this.getColumnType[n].isConstant()) {
            Object object = this.getColumnType[n].getConstant();
            if (object == null) {
                this.doubleValue = true;
                return null;
            }
            this.doubleValue = false;
            return (byte[])object;
        }
        boolean bl = this.doubleValue = (this.doubleToRawLongBits[n >> 3] & 1 << (n - 1 & 7)) == 0;
        if (this.doubleValue) {
            return null;
        }
        if ((this.doubleToRawLongBits[this.getBigDecimal[n]] & 0x80) == 0) {
            int n2 = (this.doubleToRawLongBits[this.getBigDecimal[n] + 0] & 0xFF) << 16 | (this.doubleToRawLongBits[this.getBigDecimal[n] + 1] & 0xFF) << 8 | this.doubleToRawLongBits[this.getBigDecimal[n] + 2] & 0xFF;
            int n3 = this.doubleToRawLongBits[this.getBigDecimal[n] + 3] & 0xFF;
            byte[] byArray = new byte[n3];
            System.arraycopy(this.doubleToRawLongBits, n2, byArray, 0, n3);
            return byArray;
        }
        int n4 = (this.doubleToRawLongBits[this.getBigDecimal[n] + 1] & 0xFF) << 16 | (this.doubleToRawLongBits[this.getBigDecimal[n] + 2] & 0xFF) << 8 | this.doubleToRawLongBits[this.getBigDecimal[n] + 3] & 0xFF;
        Blob blob = this.findColumn.getBlob(Bits.getLong(this.doubleToRawLongBits, n4));
        return blob.getBytes(1L, (int)blob.length());
    }

    @Override
    public JRelationMetaData getMetaData() {
        return this.floatToIntBits;
    }

    @Override
    public int putRecord() {
        int n = this.findColumn.putBytes(this.doubleToRawLongBits, 0, this.getBytes);
        this.reset();
        return n;
    }

    public void reset() {
        this.getBoolean = 1;
        this.getClob = this.getByte;
        this.getBytes = this.getChars;
        for (int i = 0; i < this.getByte; ++i) {
            this.doubleToRawLongBits[i] = -1;
        }
    }

    @Override
    public void init(int n) {
        int n2 = this.findColumn.getBytes(n, 0, this.doubleToRawLongBits);
        while (n2 == this.doubleToRawLongBits.length) {
            byte[] byArray = new byte[this.booleanValue(this.doubleToRawLongBits.length)];
            System.arraycopy(this.doubleToRawLongBits, 0, byArray, 0, n2);
            n2 = this.doubleToRawLongBits.length + this.findColumn.getBytes(n, n2, byArray, n2, byArray.length - n2);
            this.doubleToRawLongBits = byArray;
        }
        this.getBytes = n2;
    }

    @Override
    public void putNull(int n) {
        this.doubleToRawLongBits[this.getBoolean >> 3] = (byte)(this.doubleToRawLongBits[this.getBoolean >> 3] & ~(1 << (this.getBoolean - 1 & 7)));
        this.getClob += this.getBlob[this.getBoolean];
        ++this.getBoolean;
    }

    public void putNull(int n, int n2) {
        this.doubleToRawLongBits[n >> 3] = (byte)(this.doubleToRawLongBits[n >> 3] & ~(1 << (n - 1 & 7)));
    }

    @Override
    public boolean wasNull() {
        return this.doubleValue;
    }

    private int booleanValue(int n) {
        if (n <= 500) {
            return (int)(2.0f * (float)n);
        }
        if (n <= 1000) {
            return (int)(1.5f * (float)n);
        }
        return (int)(1.2f * (float)n);
    }

    public int dataType(String string) throws DSException {
        return this.floatToIntBits.getColumnType(this.floatToIntBits.findColumn(string));
    }

    @Override
    public int dataType(int n) throws DSException {
        return this.floatToIntBits.getColumnType(n);
    }

    @Override
    public Object getObject(int n) throws DSException {
        int n2 = this.floatToIntBits.getColumnType(n);
        switch (n2) {
            case -6: {
                return new Byte(this.getByte(n));
            }
            case -7: {
                return new JBoolean(this.getBoolean(n));
            }
            case 5: {
                return new Short(this.getShort(n));
            }
            case 4: {
                return new Integer(this.getInt(n));
            }
            case 6: {
                return new Float(this.getFloat(n));
            }
            case -5: {
                return new Long(this.getLong(n));
            }
            case 8: {
                return new Double(this.getDouble(n));
            }
            case 3: {
                return this.getBigDecimal(n);
            }
            case 12: {
                return this.getString(n);
            }
            case 2004: {
                return this.getBlob(n);
            }
            case 2005: {
                return this.getClob(n);
            }
            case -2: {
                return this.getBytes(n);
            }
            case 91: {
                return this.getDate(n);
            }
            case 93: {
                return this.getTimeStamp(n);
            }
            case 92: {
                return this.getTime(n);
            }
            case 0x7FFFFFFF: {
                return this.getRelationData(n);
            }
        }
        throw new DSException(6036, new Object[]{Integer.toString(n), Integer.toString(n2)});
    }

    public Object getObject(String string) throws DSException {
        return this.getObject(this.floatToIntBits.findColumn(string));
    }

    void putRelation(JRelation jRelation) throws DSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isNull(int n) {
        return (this.doubleToRawLongBits[n >> 3] & 1 << (n - 1 & 7)) == 0;
    }

    @Override
    public void pubRelationData(IRelationData iRelationData) throws DSException {
        this.putRelation(iRelationData.createRelation());
    }

    @Override
    public IRelationData getRelationData(int n) throws DSException {
        return null;
    }

    @Override
    public void close() throws DSException {
        this.doubleToRawLongBits = null;
        this.floatValue = null;
    }

    public boolean update(int n) {
        boolean bl = this.findColumn.updateBytes(n, this.doubleToRawLongBits, 0, this.getBytes);
        return bl;
    }

    @Override
    public void putArray(Array array) throws DSException {
        if (this.getColumnType[this.getBoolean].isConstant()) {
            ++this.getBoolean;
            return;
        }
        byte[] byArray = ArrayTool.array2Bytes(array);
        this.putBytes(byArray);
    }

    @Override
    public Array getArray(int n) throws DSException {
        if (this.getColumnType[n].isConstant()) {
            Object object = this.getColumnType[n].getConstant();
            if (object == null) {
                this.doubleValue = true;
                return null;
            }
            this.doubleValue = false;
            return (Array)object;
        }
        boolean bl = this.doubleValue = (this.doubleToRawLongBits[n >> 3] & 1 << (n - 1 & 7)) == 0;
        if (this.doubleValue) {
            return null;
        }
        byte[] byArray = this.getBytes(n);
        return byArray == null ? null : ArrayTool.bytes2Array(byArray);
    }

    public byte[] getRec() {
        return this.doubleToRawLongBits;
    }

    public Object getParent() {
        return this.SEDU;
    }
}

