/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.relational.swap;

import com.jinfonet.dataservice.relational.IRowID;
import com.jinfonet.dataservice.relational.swap.RowDataPool;
import com.jinfonet.dataservice.util.IntList;
import jet.dataengine.api.DSException;

public class PooledRowID
implements IRowID {
    private RowDataPool SEDU = null;
    private static final int cloneRecordIndexArray = -1;
    private int currentRowIDIsAvailable = -1;
    private boolean getCurrentFilledRecordsCount = false;
    private boolean getPositionByRowID = true;

    public PooledRowID(RowDataPool rowDataPool) {
        this.SEDU = rowDataPool;
    }

    @Override
    public int getCurrentRowID() throws DSException {
        return this.SEDU.getStoreRecordIndex(this.currentRowIDIsAvailable);
    }

    @Override
    public boolean currentRowIDIsAvailable() throws DSException {
        if (this.isEmpty() || this.currentRowIDIsAvailable <= -1) {
            return false;
        }
        while (true) {
            if (this.currentRowIDIsAvailable < this.SEDU.getCurrentFilledRecordsCount()) {
                return true;
            }
            if (this.SEDU.isFinished()) break;
            this.SEDU.waitFill();
        }
        return this.currentRowIDIsAvailable < this.SEDU.getRecordsCount();
    }

    private boolean isEmpty() throws DSException {
        if (this.getPositionByRowID) {
            this.getCurrentFilledRecordsCount = this.SEDU.isEmpty();
            this.getPositionByRowID = false;
        }
        return this.getCurrentFilledRecordsCount;
    }

    @Override
    public IntList getRowIDs() throws DSException {
        return this.SEDU.cloneRecordIndexArray();
    }

    @Override
    public int size() throws DSException {
        return this.SEDU.size();
    }

    @Override
    public boolean next() throws DSException {
        this.currentRowIDIsAvailable = this.SEDU.nextCursor(this.currentRowIDIsAvailable);
        if (this.currentRowIDIsAvailable == -1) {
            this.currentRowIDIsAvailable = this.SEDU.getRecordsCount();
            return false;
        }
        return true;
    }

    @Override
    public void beforeFirst() throws DSException {
        this.currentRowIDIsAvailable = -1;
    }

    @Override
    public void afterLast() throws DSException {
        this.currentRowIDIsAvailable = this.SEDU.getRecordsCount();
    }

    @Override
    public boolean first() throws DSException {
        if (this.isEmpty()) {
            return false;
        }
        this.currentRowIDIsAvailable = 0;
        return true;
    }

    @Override
    public boolean isAfterLast() throws DSException {
        if (this.isEmpty()) {
            return true;
        }
        return this.currentRowIDIsAvailable == this.SEDU.getRecordsCount();
    }

    @Override
    public boolean isBeforeFirst() throws DSException {
        return this.currentRowIDIsAvailable == -1;
    }

    @Override
    public boolean isFirst() throws DSException {
        if (this.isEmpty()) {
            return false;
        }
        return this.currentRowIDIsAvailable == 0;
    }

    @Override
    public boolean isLast() throws DSException {
        if (this.isEmpty()) {
            return false;
        }
        return this.currentRowIDIsAvailable == this.SEDU.getRecordsCount() - 1;
    }

    @Override
    public boolean last() throws DSException {
        if (this.isEmpty()) {
            return false;
        }
        this.currentRowIDIsAvailable = this.SEDU.getRecordsCount() - 1;
        return true;
    }

    @Override
    public boolean previous() throws DSException {
        --this.currentRowIDIsAvailable;
        this.currentRowIDIsAvailable = this.currentRowIDIsAvailable < -1 ? -1 : this.currentRowIDIsAvailable;
        return this.currentRowIDIsAvailable();
    }

    @Override
    public boolean relative(int n) throws DSException {
        this.currentRowIDIsAvailable += n;
        return false;
    }

    @Override
    public void setPosition(long l) throws DSException {
        block3: {
            int n = (int)(l - 1L);
            if (n < -1) {
                n = -1;
            }
            while (true) {
                if (n < this.SEDU.getCurrentFilledRecordsCount()) {
                    this.currentRowIDIsAvailable = n;
                    break block3;
                }
                if (this.SEDU.isFinished()) break;
                this.SEDU.waitFill();
            }
            this.currentRowIDIsAvailable = n < this.SEDU.getCurrentFilledRecordsCount() ? n : this.SEDU.getRecordsCount();
        }
    }

    @Override
    public long getPosition() throws DSException {
        return this.currentRowIDIsAvailable > -1 ? (long)(this.currentRowIDIsAvailable + 1) : -1L;
    }

    @Override
    public void setFetchDirection(int n) throws DSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFetchSize(int n) throws DSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearWarnings() throws DSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void getWarnings() throws DSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFetchDirection() throws DSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFetchSize() throws DSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getExtent() throws DSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getRowID(int n) throws DSException {
        return this.SEDU.getStoreRecordIndex(n - 1);
    }

    @Override
    public boolean isFinished() {
        return this.SEDU.isFinished();
    }

    @Override
    public int getPosition(int n) {
        int n2 = this.SEDU.getPositionByRowID(n);
        if (n2 == -1) {
            return -1;
        }
        return n2 + 1;
    }
}

