/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.relational.swap;

import com.jinfonet.api.datatypes.Blob;
import com.jinfonet.api.datatypes.Clob;
import com.jinfonet.api.datatypes.Date;
import com.jinfonet.api.datatypes.Time;
import com.jinfonet.api.datatypes.Timestamp;
import com.jinfonet.api.datatypes.Types;
import com.jinfonet.dataservice.api.schema.relational.JAttribute;
import com.jinfonet.dataservice.api.schema.relational.JRelationMetaData;
import com.jinfonet.dataservice.expression.executor.conditiontools.TupleFilterTool;
import com.jinfonet.dataservice.relational.ITuple;
import com.jinfonet.dataservice.relational.RelationMetaData;
import com.jinfonet.dataservice.relational.RelationMetaDataFactory;
import com.jinfonet.dataservice.relational.RelationOption;
import com.jinfonet.dataservice.relational.TupleDbValue4ResultSet;
import com.jinfonet.dataservice.relational.formulatool.FormulaExecutorFactory;
import com.jinfonet.dataservice.relational.formulatool.IFormulaExecutor;
import com.jinfonet.dataservice.relational.swap.ARelationPool;
import com.jinfonet.dataservice.relational.swap.RowDataPoolListener;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import jet.connect.DbValue;
import jet.dataengine.api.DSException;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.api.expression.ExpressionTypes;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.tuple.ITupleExpression;
import jet.dataengine.listener.CancelEvent;
import jet.dataengine.listener.JCancelListener;
import jet.dataengine.listener.JCloseResoueceListener;
import jet.dataengine.listener.JCloseResourceContainer;
import jet.dataengine8.core.queryengine.FetchMessage;
import jet.dataengine8.core.queryengine.transform.AggInfos;
import jet.dataengine8.core.queryengine.transform.AttributeContainer;
import jet.formula.JavaFormula;

public class Relation4ResultSetPool
extends ARelationPool
implements JCloseResourceContainer,
JCancelListener {
    private static String SEDU = "Relation4ResultSetPool";
    private boolean activeCount = false;
    private IExpression add = null;
    private IExpression addRecord = null;
    private JavaFormula append = null;
    private AttributeContainer appendFinished = null;
    private IFormulaExecutor appendRecord = null;
    private IFormulaExecutor close = null;
    private TupleFilterTool closeResource = null;
    private TupleFilterTool contains = null;
    private Timer create;
    private boolean createTuple = false;
    private boolean currentTimeMillis = false;
    private TupleDbValue4ResultSet debug = null;
    private ArrayList dump = new ArrayList();
    private DbValue[] exec;
    private boolean expressionType = false;
    private boolean fetchData = false;
    private long fetchDataCompleted;
    private int fillDataError;
    private int filteTuple;
    private boolean findColumn;
    private boolean get = false;
    private boolean getAggInfos = false;
    private boolean getAllElements;
    private Object getAllFunctionsExceptWhereFormula = new Object();
    private FetchMessage getAttribute;
    private ResultSet getDistinctColNames;
    int recordCount = 0;

    public Relation4ResultSetPool(IExpression iExpression, JavaFormula javaFormula, AttributeContainer attributeContainer, RelationOption relationOption, DbValue[] dbValueArray, FetchMessage fetchMessage) throws DSException {
        this(iExpression, javaFormula, attributeContainer, relationOption, dbValueArray, false, fetchMessage);
        RelationMetaData relationMetaData = RelationMetaDataFactory.create("", this.getDistinctColNames, attributeContainer);
        this.debug = new TupleDbValue4ResultSet(this.metaData, relationMetaData, this.exec);
        this.activeCount();
    }

    private Relation4ResultSetPool(IExpression iExpression, JavaFormula javaFormula, AttributeContainer attributeContainer, RelationOption relationOption, DbValue[] dbValueArray, boolean bl, FetchMessage fetchMessage) throws DSException {
        super("", RelationMetaDataFactory.create(null, attributeContainer), relationOption);
        this.getAttribute = fetchMessage == null ? new FetchMessage() : fetchMessage;
        this.add = iExpression;
        if (this.log.isDebugEnabled()) {
            if (this.add != null) {
                this.log.debug(iExpression.toString());
            } else {
                this.log.debug("the IExpression is null");
            }
        }
        this.append = javaFormula;
        this.appendFinished = attributeContainer;
        this.exec = dbValueArray;
        this.fillDataError = relationOption.getMaxRows();
        this.filteTuple = relationOption.getMaxRecords();
        this.get = relationOption.getMaxDuration() == -1L;
        this.getAggInfos = this.fillDataError == -1;
        this.getAllElements = this.filteTuple != -1;
        boolean bl2 = this.findColumn = !this.getAggInfos || this.getAllElements;
        if (this.log.isDebugEnabled()) {
            this.log.debug("fetch row size : " + relationOption.getMaxRows() + " rows");
            this.log.debug("fetch record size : " + relationOption.getMaxRows() + " records");
            this.log.debug("fetch duration : " + relationOption.getMaxDuration() + " ms");
        }
    }

    public Relation4ResultSetPool(ResultSet resultSet, IExpression iExpression, JavaFormula javaFormula, AttributeContainer attributeContainer, RelationOption relationOption, DbValue[] dbValueArray, boolean bl, FetchMessage fetchMessage) throws DSException {
        this(iExpression, javaFormula, attributeContainer, relationOption, dbValueArray, bl, fetchMessage);
        RelationMetaData relationMetaData = RelationMetaDataFactory.create("", resultSet, attributeContainer);
        this.debug = new TupleDbValue4ResultSet(this.metaData, relationMetaData, this.exec);
        this.activeCount();
        this.getDistinctColNames = resultSet;
    }

    public void fetchData(ResultSet resultSet) throws DSException {
        block14: {
            try {
                if (resultSet == null) {
                    throw new UnsupportedOperationException();
                }
                if (!this.get) {
                    this.create = new Timer();
                    this.create.schedule((TimerTask)new time(), this.option.getMaxDuration() * 1000L);
                }
                try {
                    if (this.log.isDebugAll()) {
                        this.add(resultSet);
                    } else {
                        this.addRecord(resultSet);
                    }
                }
                catch (DSException dSException) {
                    if (!this.expressionType) {
                        this.rowDataPool.fillDataError(dSException);
                        break block14;
                    }
                    throw dSException;
                }
                catch (Throwable throwable) {
                    DSException dSException = new DSException(2914, throwable);
                    if (!this.expressionType) {
                        this.rowDataPool.fillDataError(dSException);
                    }
                }
            }
            catch (Exception exception) {
                throw new DSException(2913, new Object[]{"result set next error"}, (Throwable)exception);
            }
            finally {
                this.appendFinished();
            }
        }
    }

    public void fetchData() throws DSException {
        this.fetchData(this.getDistinctColNames);
    }

    public Relation4ResultSetPool(AttributeContainer attributeContainer, RelationOption relationOption) throws DSException {
        super("", new RelationMetaData(attributeContainer.getAllElements()), relationOption);
        this.fillDataError = relationOption.getMaxRows();
        this.filteTuple = relationOption.getMaxRecords();
        this.get = relationOption.getMaxDuration() == -1L;
        this.getAggInfos = this.fillDataError == -1;
        this.getAllElements = this.filteTuple != -1;
        this.findColumn = !this.getAggInfos || this.getAllElements;
        this.getAttribute = this.getAttribute == null ? new FetchMessage() : this.getAttribute;
        RelationMetaData relationMetaData = new RelationMetaData(attributeContainer.getAllElements());
        this.debug = new TupleDbValue4ResultSet(relationMetaData, relationMetaData, new DbValue[0]);
    }

    private void activeCount() throws DSException {
        if (this.appendFinished.getAllFunctionsExceptWhereFormula().length > 0) {
            AggInfos aggInfos = this.appendFinished.getAggInfos();
            if (aggInfos == null) {
                this.currentTimeMillis = true;
                this.appendRecord = FormulaExecutorFactory.getFormulaExecutor(this.append, this.appendFinished, this.debug, this.option.getSpecialFields());
            } else {
                String[] stringArray = aggInfos.getExecutedF();
                if (stringArray != null && stringArray.length > 0) {
                    this.currentTimeMillis = true;
                    this.appendRecord = FormulaExecutorFactory.getFormulaExecutor(this.append, this.appendFinished, stringArray, this.debug, this.option.getSpecialFields());
                }
            }
        }
        if (this.appendFinished.getWhereFormula() != null) {
            this.fetchData = true;
            this.addRecord = this.appendFinished.getWhereFormulaExpression();
            this.close = FormulaExecutorFactory.getWhereFormulaExecutor(this.append, this.appendFinished, this.debug, this.option.getSpecialFields());
            if (!ExpressionToolKit.isTupleExp(this.appendFinished.getWhereFormulaExpression().expressionType())) {
                throw new DSException(2911, new Object[]{"exp type error : " + ExpressionTypes.getExpressionName(this.add.expressionType()) + " must be tuple exp"});
            }
            this.contains = TupleFilterTool.getInstance((ITupleExpression)this.appendFinished.getWhereFormulaExpression(), this.metaData, this.appendFinished, this.append, this.option.getSpecialFields());
            if (this.log.isDebugEnabled()) {
                this.log.debug("where formula epxression : " + this.addRecord.toString());
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("input where formula expression : null");
        }
        if (this.add != null) {
            this.createTuple = true;
            if (!ExpressionToolKit.isTupleExp(this.add.expressionType())) {
                throw new DSException(2912, new Object[]{"exp type error : " + ExpressionTypes.getExpressionName(this.add.expressionType()) + " must be tuple exp"});
            }
            this.closeResource = TupleFilterTool.getInstance((ITupleExpression)this.add, this.metaData, this.appendFinished, this.append, this.option.getSpecialFields());
            if (this.log.isDebugEnabled()) {
                this.log.debug("condition expression : " + this.add.toString());
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("condition expression : null");
        }
    }

    @Override
    public void dump() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Begin ResusltMetaData");
            this.log.indent(SEDU);
            this.metaData.dump();
            this.log.debug("IExpression:" + this.add);
            this.log.indent(SEDU);
            this.log.debug("End ResusltMetaData");
            this.log.indent(SEDU);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(ResultSet resultSet) throws DSException {
        int n;
        int n2;
        ITuple iTuple;
        ITuple iTuple2;
        TreeSet<ProxyTuple> treeSet;
        boolean bl;
        block34: {
            long l;
            int n3;
            int n4 = this.option.getMaxRecords();
            int n5 = 0;
            long l2 = 0L;
            long l3 = 0L;
            int n6 = 0;
            long l4 = System.currentTimeMillis();
            long l5 = 0L;
            boolean bl2 = true;
            bl = this.option.isDistinct();
            treeSet = null;
            iTuple2 = null;
            iTuple = null;
            if (bl) {
                iTuple2 = this.createTuple();
                iTuple = this.createTuple();
                JRelationMetaData jRelationMetaData = iTuple2.getMetaData();
                String[] stringArray = this.option.getDistinctColNames();
                if (stringArray != null && stringArray.length > 0) {
                    n3 = 1;
                    JRelationMetaData jRelationMetaData2 = iTuple2.getMetaData();
                    JAttribute[] jAttributeArray = new JAttribute[stringArray.length];
                    for (int i = 0; i < stringArray.length; ++i) {
                        JAttribute jAttribute;
                        int n7 = jRelationMetaData2.findColumn(stringArray[i]);
                        if (n7 == -1) {
                            n3 = 0;
                            break;
                        }
                        jAttributeArray[i] = jAttribute = jRelationMetaData2.getAttribute(n7);
                    }
                    if (n3 != 0) {
                        jRelationMetaData = new RelationMetaData(jAttributeArray);
                    }
                }
                treeSet = new TreeSet<ProxyTuple>(new TupleComparator(jRelationMetaData, iTuple2, iTuple));
            }
            try {
                this.getAttribute.setFetchStartTime(System.currentTimeMillis());
                this.getAttribute.setFetchDate(System.currentTimeMillis());
                this.getAttribute.setFetchTime(System.currentTimeMillis());
                int n8 = 0;
                int n9 = 0;
                n3 = 0;
                n2 = 0;
                n = 0;
                long l6 = 0L;
                long l7 = 0L;
                long l8 = 0L;
                long l9 = 0L;
                long l10 = 0L;
                long l11 = 0L;
                long l12 = 0L;
                long l13 = 0L;
                long l14 = System.nanoTime();
                while (!this.expressionType) {
                    long l15;
                    long l16 = System.nanoTime();
                    if (!resultSet.next()) break;
                    long l17 = System.nanoTime();
                    ++n9;
                    this.getAttribute.setFetchRecordNO(++n8);
                    if (this.activeCount || this.findColumn && (!this.getAggInfos && n5 >= this.fillDataError || this.getAllElements && this.recordCount >= n4)) break;
                    bl2 = true;
                    this.debug.readDataFromResultSet(resultSet);
                    long l18 = System.nanoTime();
                    if (n6 < 50) {
                        l2 = System.currentTimeMillis();
                    }
                    if (this.fetchData) {
                        this.close.exec();
                        bl2 = this.contains.filteTuple(this.debug);
                        if (!bl2) {
                            ++n;
                        }
                    }
                    long l19 = System.nanoTime();
                    if (bl2 && this.currentTimeMillis) {
                        this.appendRecord.exec();
                    }
                    long l20 = System.nanoTime();
                    if (bl2 && this.createTuple && !this.closeResource.filteTuple(this.debug)) {
                        bl2 = false;
                        ++n2;
                    }
                    long l21 = System.nanoTime();
                    if (bl2 && bl && !treeSet.add(new ProxyTuple(this.recordCount + 1))) {
                        bl2 = false;
                        ++n3;
                    }
                    long l22 = System.nanoTime();
                    if (bl2) {
                        this.appendRecord(this.debug);
                        if (this.getAttribute.hasSpecialT2ExceptionFetchTime()) {
                            this.getAttribute.addRecord(this.debug);
                        }
                        ++this.recordCount;
                    }
                    long l23 = System.nanoTime();
                    if (n6 < 50) {
                        l2 = System.currentTimeMillis() - l2;
                        l15 = 0L;
                        l15 = l2 < 16L ? 2L : (long)((double)l2 * 1.15);
                        long l24 = l5;
                        l5 = System.currentTimeMillis() - l4;
                        long l25 = l5 - l24;
                        if (l15 > l25) {
                            l15 = l25;
                        }
                        l3 += l15;
                        ++n6;
                    }
                    ++n5;
                    l15 = System.nanoTime();
                    l6 += l17 - l16;
                    l7 += l18 - l17;
                    l8 += l19 - l18;
                    l9 += l20 - l19;
                    l10 += l21 - l20;
                    l11 += l22 - l21;
                    l12 += l23 - l22;
                    l13 += l15 - l23;
                }
                this.fetchCount = this.recordCount;
                if (this.log.isInfoEnabled()) {
                    this.log.info(2013, new Object[]{" addRecord = " + this.fetchCount + " ResultSet count = " + n9 + "  distinct count= " + n3 + " LocalConditionFilter count =  " + n2 + " whereFormulaCondition filter count = " + n});
                    this.log.info(2013, new Object[]{"(ms) time_next() = " + l6 / 1000000L + " time_readData = " + l7 / 1000000L + "  time_whereformula = " + l8 / 1000000L + " time_pass1formula =  " + l9 / 1000000L + " time_localcondition = " + l10 / 1000000L + " time_distinct = " + l11 / 1000000L + " time_append = " + l12 / 1000000L + " time_calcul = " + l13 / 1000000L + " total time = " + (System.nanoTime() - l14) / 1000000L});
                }
                l4 = System.currentTimeMillis() - l4;
                int n10 = Thread.activeCount();
                this.fetchDataCompleted = (long)((double)l4 / (double)n10 - (double)l4 / (double)n10 * ((double)l3 / (double)l5));
                this.getAttribute.setFetchEndTime(System.currentTimeMillis());
                this.getAttribute.setIoTime(this.fetchDataCompleted);
                this.getAttribute.setTotalFetchedRecord(this.fetchCount);
                l = this.getAttribute.getFetchEndTime() - this.getAttribute.getFetchStartTime();
                if (!this.log.isInfoEnabled()) break block34;
            }
            catch (SQLException sQLException) {
                try {
                    throw new DSException(2913, new Object[]{"result set next error"}, (Throwable)sQLException);
                }
                catch (Throwable throwable) {
                    this.getAttribute.setFetchEndTime(System.currentTimeMillis());
                    this.getAttribute.setIoTime(this.fetchDataCompleted);
                    this.getAttribute.setTotalFetchedRecord(this.fetchCount);
                    long l26 = this.getAttribute.getFetchEndTime() - this.getAttribute.getFetchStartTime();
                    if (this.log.isInfoEnabled()) {
                        this.log.info(2012, new String[]{"" + l26});
                    }
                    if (bl) {
                        this.removeTuple(iTuple2);
                        this.removeTuple(iTuple);
                        treeSet = null;
                    }
                    Object object = this.getAllFunctionsExceptWhereFormula;
                    synchronized (object) {
                        int n11;
                        int n12 = this.listeners.size();
                        for (n11 = 0; n11 < n12; ++n11) {
                            ((RowDataPoolListener)this.listeners.get(n11)).fetchDataCompleted();
                        }
                        n12 = this.dump.size();
                        for (n11 = 0; n11 < n12; ++n11) {
                            ((JCloseResoueceListener)this.dump.get(n11)).closeResource();
                        }
                        this.hasNotifyListeners = true;
                    }
                    throw throwable;
                }
            }
            this.log.info(2012, new String[]{"" + l});
        }
        if (bl) {
            this.removeTuple(iTuple2);
            this.removeTuple(iTuple);
            treeSet = null;
        }
        Object object = this.getAllFunctionsExceptWhereFormula;
        synchronized (object) {
            n = this.listeners.size();
            for (n2 = 0; n2 < n; ++n2) {
                ((RowDataPoolListener)this.listeners.get(n2)).fetchDataCompleted();
            }
            n = this.dump.size();
            for (n2 = 0; n2 < n; ++n2) {
                ((JCloseResoueceListener)this.dump.get(n2)).closeResource();
            }
            this.hasNotifyListeners = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRecord(ResultSet resultSet) throws DSException {
        int n;
        int n2;
        ITuple iTuple;
        ITuple iTuple2;
        TreeSet<ProxyTuple> treeSet;
        boolean bl;
        block34: {
            long l;
            int n3;
            int n4 = this.option.getMaxRecords();
            int n5 = 0;
            long l2 = 0L;
            long l3 = 0L;
            int n6 = 0;
            long l4 = System.currentTimeMillis();
            long l5 = 0L;
            boolean bl2 = true;
            bl = this.option.isDistinct();
            treeSet = null;
            iTuple2 = null;
            iTuple = null;
            if (bl) {
                iTuple2 = this.createTuple();
                iTuple = this.createTuple();
                JRelationMetaData jRelationMetaData = iTuple2.getMetaData();
                String[] stringArray = this.option.getDistinctColNames();
                if (stringArray != null && stringArray.length > 0) {
                    n3 = 1;
                    JRelationMetaData jRelationMetaData2 = iTuple2.getMetaData();
                    JAttribute[] jAttributeArray = new JAttribute[stringArray.length];
                    for (int i = 0; i < stringArray.length; ++i) {
                        JAttribute jAttribute;
                        int n7 = jRelationMetaData2.findColumn(stringArray[i]);
                        if (n7 == -1) {
                            n3 = 0;
                            break;
                        }
                        jAttributeArray[i] = jAttribute = jRelationMetaData2.getAttribute(n7);
                    }
                    if (n3 != 0) {
                        jRelationMetaData = new RelationMetaData(jAttributeArray);
                    }
                }
                treeSet = new TreeSet<ProxyTuple>(new TupleComparator(jRelationMetaData, iTuple2, iTuple));
            }
            try {
                this.getAttribute.setFetchStartTime(System.currentTimeMillis());
                this.getAttribute.setFetchDate(System.currentTimeMillis());
                this.getAttribute.setFetchTime(System.currentTimeMillis());
                int n8 = 0;
                int n9 = 0;
                n3 = 0;
                n2 = 0;
                n = 0;
                while (!this.expressionType && resultSet.next()) {
                    ++n9;
                    this.getAttribute.setFetchRecordNO(++n8);
                    if (this.activeCount || this.findColumn && (!this.getAggInfos && n5 >= this.fillDataError || this.getAllElements && this.recordCount >= n4)) break;
                    bl2 = true;
                    this.debug.readDataFromResultSet(resultSet);
                    if (n6 < 50) {
                        l2 = System.currentTimeMillis();
                    }
                    if (this.fetchData) {
                        this.close.exec();
                        bl2 = this.contains.filteTuple(this.debug);
                        if (!bl2) {
                            ++n;
                        }
                    }
                    if (bl2 && this.currentTimeMillis) {
                        this.appendRecord.exec();
                    }
                    if (bl2 && this.createTuple && !this.closeResource.filteTuple(this.debug)) {
                        bl2 = false;
                        ++n2;
                    }
                    if (bl2 && bl && !treeSet.add(new ProxyTuple(this.recordCount + 1))) {
                        bl2 = false;
                        ++n3;
                    }
                    if (bl2) {
                        this.appendRecord(this.debug);
                        if (this.getAttribute.hasSpecialT2ExceptionFetchTime()) {
                            this.getAttribute.addRecord(this.debug);
                        }
                        ++this.recordCount;
                    }
                    if (n6 < 50) {
                        l2 = System.currentTimeMillis() - l2;
                        long l6 = 0L;
                        l6 = l2 < 16L ? 2L : (long)((double)l2 * 1.15);
                        long l7 = l5;
                        l5 = System.currentTimeMillis() - l4;
                        long l8 = l5 - l7;
                        if (l6 > l8) {
                            l6 = l8;
                        }
                        l3 += l6;
                        ++n6;
                    }
                    ++n5;
                }
                this.fetchCount = this.recordCount;
                if (this.log.isInfoEnabled()) {
                    this.log.info(2013, new Object[]{" addRecord = " + this.fetchCount + " ResultSet count = " + n9 + "  distinct count= " + n3 + " LocalConditionFilter count =  " + n2 + " whereFormulaCondition filter count = " + n});
                }
                l4 = System.currentTimeMillis() - l4;
                int n10 = Thread.activeCount();
                this.fetchDataCompleted = (long)((double)l4 / (double)n10 - (double)l4 / (double)n10 * ((double)l3 / (double)l5));
                this.getAttribute.setFetchEndTime(System.currentTimeMillis());
                this.getAttribute.setIoTime(this.fetchDataCompleted);
                this.getAttribute.setTotalFetchedRecord(this.fetchCount);
                l = this.getAttribute.getFetchEndTime() - this.getAttribute.getFetchStartTime();
                if (!this.log.isInfoEnabled()) break block34;
            }
            catch (SQLException sQLException) {
                try {
                    throw new DSException(2913, new Object[]{"result set next error"}, (Throwable)sQLException);
                }
                catch (Throwable throwable) {
                    this.getAttribute.setFetchEndTime(System.currentTimeMillis());
                    this.getAttribute.setIoTime(this.fetchDataCompleted);
                    this.getAttribute.setTotalFetchedRecord(this.fetchCount);
                    long l9 = this.getAttribute.getFetchEndTime() - this.getAttribute.getFetchStartTime();
                    if (this.log.isInfoEnabled()) {
                        this.log.info(2012, new String[]{"" + l9});
                    }
                    if (bl) {
                        this.removeTuple(iTuple2);
                        this.removeTuple(iTuple);
                        treeSet = null;
                    }
                    Object object = this.getAllFunctionsExceptWhereFormula;
                    synchronized (object) {
                        int n11;
                        int n12 = this.listeners.size();
                        for (n11 = 0; n11 < n12; ++n11) {
                            ((RowDataPoolListener)this.listeners.get(n11)).fetchDataCompleted();
                        }
                        n12 = this.dump.size();
                        for (n11 = 0; n11 < n12; ++n11) {
                            ((JCloseResoueceListener)this.dump.get(n11)).closeResource();
                        }
                        this.hasNotifyListeners = true;
                    }
                    throw throwable;
                }
            }
            this.log.info(2012, new String[]{"" + l});
        }
        if (bl) {
            this.removeTuple(iTuple2);
            this.removeTuple(iTuple);
            treeSet = null;
        }
        Object object = this.getAllFunctionsExceptWhereFormula;
        synchronized (object) {
            n = this.listeners.size();
            for (n2 = 0; n2 < n; ++n2) {
                ((RowDataPoolListener)this.listeners.get(n2)).fetchDataCompleted();
            }
            n = this.dump.size();
            for (n2 = 0; n2 < n; ++n2) {
                ((JCloseResoueceListener)this.dump.get(n2)).closeResource();
            }
            this.hasNotifyListeners = true;
        }
    }

    @Override
    public boolean isEmpty() throws DSException {
        return this.rowDataPool.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCloseResourceListener(JCloseResoueceListener jCloseResoueceListener) throws DSException {
        Object object = this.getAllFunctionsExceptWhereFormula;
        synchronized (object) {
            this.dump.add(jCloseResoueceListener);
            if (this.hasNotifyListeners) {
                jCloseResoueceListener.closeResource();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCloseResourceListener(JCloseResoueceListener jCloseResoueceListener) {
        Object object = this.getAllFunctionsExceptWhereFormula;
        synchronized (object) {
            if (this.dump.contains(jCloseResoueceListener)) {
                this.dump.remove(jCloseResoueceListener);
            }
        }
    }

    @Override
    public void cancel(CancelEvent cancelEvent) throws DSException {
        this.expressionType = true;
    }

    @Override
    public long getIOTime() {
        long l = this.fetchDataCompleted;
        this.fetchDataCompleted = 0L;
        return l;
    }

    @Override
    public void close() throws DSException {
        super.close();
        this.append = null;
        this.appendFinished = null;
        this.appendRecord = null;
        this.close = null;
        this.closeResource = null;
        this.contains = null;
    }

    public void setPushDownDuration(boolean bl) {
        this.get = this.get || bl;
    }

    public void setPushDownMaxRows(boolean bl) {
        this.getAggInfos = this.getAggInfos || bl;
        this.findColumn = !bl || this.getAllElements;
    }

    class ProxyTuple {
        final int index;

        public ProxyTuple(int n) {
            this.index = n;
        }
    }

    public class TupleComparator
    implements Comparator {
        private static final int SEDU = 1024;
        private int[][] abs;
        private int access$300;
        private int append;
        private boolean compare;
        private boolean compareTo;
        private boolean compareToIgnoreCase;
        boolean boolean1;
        boolean boolean2;
        int result;
        int length1;
        int length2;
        int int1;
        int int2;
        long long1;
        long long2;
        float float1;
        float float2;
        float floatV;
        double double1;
        double double2;
        double doubleV;
        Blob blob1;
        Blob blob2;
        Clob clob1;
        Clob clob2;
        String string1;
        String string2;
        Date date1;
        Date date2;
        Time time1;
        Time time2;
        Timestamp timeStamp1;
        Timestamp timeStamp2;
        BigDecimal bigDec1;
        BigDecimal bigDec2;
        ITuple tupleA;
        ITuple tupleB;

        public TupleComparator(JRelationMetaData jRelationMetaData, ITuple iTuple, ITuple iTuple2) throws DSException {
            this.abs = this.SEDU(jRelationMetaData, iTuple, iTuple2);
            this.compareToIgnoreCase = true;
            this.tupleA = iTuple;
            this.tupleB = iTuple2;
        }

        private int[][] SEDU(JRelationMetaData jRelationMetaData, ITuple iTuple, ITuple iTuple2) throws DSException {
            JRelationMetaData jRelationMetaData2 = iTuple.getMetaData();
            JRelationMetaData jRelationMetaData3 = iTuple2.getMetaData();
            int[][] nArray = new int[jRelationMetaData.getColumnCount()][6];
            String string = null;
            for (int i = 0; i < nArray.length; ++i) {
                string = jRelationMetaData.getColumnName(i + 1);
                nArray[i][0] = jRelationMetaData2.findColumn(string);
                nArray[i][1] = jRelationMetaData2.getColumnType(jRelationMetaData2.findColumn(string));
                nArray[i][2] = jRelationMetaData3.findColumn(string);
                nArray[i][3] = jRelationMetaData3.getColumnType(jRelationMetaData3.findColumn(string));
                nArray[i][4] = 1;
                nArray[i][5] = 1;
            }
            return nArray;
        }

        public int compare(ProxyTuple proxyTuple, ProxyTuple proxyTuple2) {
            ITuple iTuple;
            ITuple iTuple2;
            try {
                if (proxyTuple.index == Relation4ResultSetPool.this.recordCount + 1) {
                    iTuple2 = Relation4ResultSetPool.this.debug;
                } else {
                    this.tupleA.init(proxyTuple.index);
                    iTuple2 = this.tupleA;
                }
                if (proxyTuple2.index == Relation4ResultSetPool.this.recordCount + 1) {
                    iTuple = Relation4ResultSetPool.this.debug;
                } else {
                    this.tupleB.init(proxyTuple2.index);
                    iTuple = this.tupleB;
                }
            }
            catch (DSException dSException) {
                throw new RuntimeException("init the ProxyTuple fail...");
            }
            this.access$300 = 0;
            this.compare = false;
            this.compareTo = false;
            for (int i = 0; i < this.abs.length; ++i) {
                this.append = 0;
                if (this.abs[i][4] == 0) continue;
                if (this.compareToIgnoreCase) {
                    try {
                        this.compare = iTuple2.isNull(this.abs[i][0]);
                        this.compareTo = iTuple.isNull(this.abs[i][0]);
                    }
                    catch (DSException dSException) {
                        this.compareToIgnoreCase = false;
                    }
                }
                if (this.compareToIgnoreCase) {
                    if (this.compare && this.compareTo) {
                        this.append = 0;
                        continue;
                    }
                    if (this.compare) {
                        this.append = this.abs[i][2] == 1 ? -1 : 1;
                        this.access$300 = this.append;
                        continue;
                    }
                    if (this.compareTo) {
                        this.append = this.abs[i][2] == 1 ? 1 : -1;
                        this.access$300 = this.append;
                        continue;
                    }
                }
                this.append = this.abs(iTuple2, iTuple, this.abs[i], this.append);
                if (this.append == 0 || this.abs[i][2] == 0) continue;
                if (this.abs[i][2] == 1) {
                    this.access$300 = this.append;
                    break;
                }
                this.access$300 = -this.append;
                break;
            }
            return this.access$300;
        }

        private int abs(ITuple iTuple, ITuple iTuple2, int[] nArray, int n) {
            switch (nArray[1]) {
                case -6: {
                    try {
                        this.int1 = iTuple.getByte(nArray[0]);
                        this.int2 = iTuple2.getByte(nArray[2]);
                        if (!iTuple.wasNull() && !iTuple2.wasNull()) {
                            if (this.int1 == this.int2) {
                                this.result = 0;
                                break;
                            }
                            this.result = this.int1 > this.int2 ? 1 : -1;
                            break;
                        }
                        this.result = this.access$300(iTuple, iTuple2);
                        break;
                    }
                    catch (DSException dSException) {
                        throw new RuntimeException("DSException, can't get int from ITuple : " + dSException.getMessage(), dSException);
                    }
                }
                case 4: {
                    try {
                        this.int1 = iTuple.getInt(nArray[0]);
                        this.int2 = iTuple2.getInt(nArray[2]);
                        if (!iTuple.wasNull() && !iTuple2.wasNull()) {
                            if (this.int1 == this.int2) {
                                this.result = 0;
                                break;
                            }
                            this.result = this.int1 > this.int2 ? 1 : -1;
                            break;
                        }
                        this.result = this.access$300(iTuple, iTuple2);
                        break;
                    }
                    catch (DSException dSException) {
                        throw new RuntimeException("DSException, can't get int from ITuple : " + dSException.getMessage(), dSException);
                    }
                }
                case 5: {
                    try {
                        this.int1 = iTuple.getShort(nArray[0]);
                        this.int2 = iTuple2.getShort(nArray[2]);
                        if (!iTuple.wasNull() && !iTuple2.wasNull()) {
                            if (this.int1 == this.int2) {
                                this.result = 0;
                                break;
                            }
                            this.result = this.int1 > this.int2 ? 1 : -1;
                            break;
                        }
                        this.result = this.access$300(iTuple, iTuple2);
                        break;
                    }
                    catch (DSException dSException) {
                        throw new RuntimeException("DSException, can't get short from ITuple : " + dSException.getMessage(), dSException);
                    }
                }
                case -5: {
                    try {
                        this.long1 = iTuple.getLong(nArray[0]);
                        this.long2 = iTuple2.getLong(nArray[2]);
                        if (!iTuple.wasNull() && !iTuple2.wasNull()) {
                            if (this.long1 == this.long2) {
                                this.result = 0;
                                break;
                            }
                            this.result = this.long1 > this.long2 ? 1 : -1;
                            break;
                        }
                        this.result = this.access$300(iTuple, iTuple2);
                        break;
                    }
                    catch (DSException dSException) {
                        throw new RuntimeException("DSException, can't get long from ITuple : " + dSException.getMessage(), dSException);
                    }
                }
                case 6: {
                    try {
                        this.float1 = iTuple.getFloat(nArray[0]);
                        this.float2 = iTuple2.getFloat(nArray[2]);
                        if (!iTuple.wasNull() && !iTuple2.wasNull()) {
                            this.floatV = this.float1 - this.float2;
                            if ((double)Math.abs(this.floatV) < (double)4.0E-9f) {
                                this.result = 0;
                                break;
                            }
                            this.result = this.floatV > 0.0f ? 1 : -1;
                            break;
                        }
                        this.result = this.access$300(iTuple, iTuple2);
                        break;
                    }
                    catch (DSException dSException) {
                        throw new RuntimeException("DSException, can't get float from ITuple : " + dSException.getMessage(), dSException);
                    }
                }
                case 8: {
                    try {
                        this.double1 = iTuple.getDouble(nArray[0]);
                        this.double2 = iTuple2.getDouble(nArray[2]);
                        if (!iTuple.wasNull() && !iTuple2.wasNull()) {
                            this.doubleV = this.double1 - this.double2;
                            if (Math.abs(this.doubleV) < 4.0E-16) {
                                this.result = 0;
                                break;
                            }
                            this.result = this.doubleV > 0.0 ? 1 : -1;
                            break;
                        }
                        this.result = this.access$300(iTuple, iTuple2);
                        break;
                    }
                    catch (DSException dSException) {
                        throw new RuntimeException("DSException, can't get double from ITuple : " + dSException.getMessage(), dSException);
                    }
                }
                case 91: {
                    try {
                        this.date1 = iTuple.getDate(nArray[0]);
                        this.date2 = iTuple2.getDate(nArray[2]);
                        if (!iTuple.wasNull() && !iTuple2.wasNull()) {
                            this.result = this.date1.compareTo(this.date2);
                            break;
                        }
                        this.result = this.access$300(iTuple, iTuple2);
                        break;
                    }
                    catch (DSException dSException) {
                        throw new RuntimeException("DSException, can't get date from ITuple : " + dSException.getMessage(), dSException);
                    }
                }
                case 92: {
                    try {
                        this.time1 = iTuple.getTime(nArray[0]);
                        this.time2 = iTuple2.getTime(nArray[2]);
                        if (!iTuple.wasNull() && !iTuple2.wasNull()) {
                            this.result = this.time1.compareTo(this.time2);
                            break;
                        }
                        this.result = this.access$300(iTuple, iTuple2);
                        break;
                    }
                    catch (DSException dSException) {
                        throw new RuntimeException("DSException, can't get time from ITuple : " + dSException.getMessage(), dSException);
                    }
                }
                case 93: {
                    try {
                        this.timeStamp1 = iTuple.getTimeStamp(nArray[0]);
                        this.timeStamp2 = iTuple2.getTimeStamp(nArray[2]);
                        if (!iTuple.wasNull() && !iTuple2.wasNull()) {
                            this.result = this.timeStamp1.compareTo(this.timeStamp2);
                            break;
                        }
                        this.result = this.access$300(iTuple, iTuple2);
                        break;
                    }
                    catch (DSException dSException) {
                        throw new RuntimeException("DSException, can't get timestamp from ITuple : " + dSException.getMessage(), dSException);
                    }
                }
                case 3: {
                    try {
                        this.bigDec1 = iTuple.getBigDecimal(nArray[0]);
                        this.bigDec2 = iTuple2.getBigDecimal(nArray[2]);
                        if (!iTuple.wasNull() && !iTuple2.wasNull()) {
                            this.result = this.bigDec1.compareTo(this.bigDec2);
                            break;
                        }
                        this.result = this.access$300(iTuple, iTuple2);
                        break;
                    }
                    catch (DSException dSException) {
                        throw new RuntimeException("DSException, can't get bigdecimal from ITuple : " + dSException.getMessage(), dSException);
                    }
                }
                case -7: {
                    try {
                        this.boolean1 = iTuple.getBoolean(nArray[0]);
                        this.boolean2 = iTuple2.getBoolean(nArray[2]);
                        if (!iTuple.wasNull() && !iTuple2.wasNull()) {
                            this.int1 = this.boolean1 ? 1 : 0;
                            this.int2 = this.boolean2 ? 1 : 0;
                            this.result = this.int1 - this.int2;
                            break;
                        }
                        this.result = this.access$300(iTuple, iTuple2);
                        break;
                    }
                    catch (DSException dSException) {
                        throw new RuntimeException("DSException, can't get boolean from ITuple : " + dSException.getMessage(), dSException);
                    }
                }
                case 12: {
                    try {
                        this.string1 = iTuple.getString(nArray[0]);
                        this.string2 = iTuple2.getString(nArray[2]);
                        if (!iTuple.wasNull() && !iTuple2.wasNull()) {
                            if (nArray[5] == 1) {
                                this.result = this.string1.compareToIgnoreCase(this.string2);
                                break;
                            }
                            this.result = this.string1.compareTo(this.string2);
                            break;
                        }
                        this.result = this.access$300(iTuple, iTuple2);
                        break;
                    }
                    catch (DSException dSException) {
                        throw new RuntimeException("DSException, can't get string from ITuple : " + dSException.getMessage(), dSException);
                    }
                }
                case 2005: {
                    try {
                        this.clob1 = iTuple.getClob(nArray[0]);
                        this.clob2 = iTuple2.getClob(nArray[2]);
                        if (!iTuple.wasNull() && !iTuple2.wasNull()) {
                            this.length1 = this.bigDec2(this.clob1);
                            this.length2 = this.bigDec2(this.clob2);
                            this.string1 = this.clob1.getSubString(0L, this.length1);
                            this.string2 = this.clob2.getSubString(0L, this.length2);
                            if (nArray[5] == 1) {
                                this.result = this.string1.compareToIgnoreCase(this.string2);
                                break;
                            }
                            this.result = this.string1.compareTo(this.string2);
                            break;
                        }
                        this.result = this.access$300(iTuple, iTuple2);
                        break;
                    }
                    catch (DSException dSException) {
                        throw new RuntimeException("DSException, can't get clob from ITuple : " + dSException.getMessage(), dSException);
                    }
                }
                case 2004: {
                    try {
                        this.blob1 = iTuple.getBlob(nArray[0]);
                        this.blob2 = iTuple2.getBlob(nArray[2]);
                        if (!iTuple.wasNull() && !iTuple2.wasNull()) {
                            this.length1 = this.bigDec1(this.blob1);
                            this.length2 = this.bigDec1(this.blob2);
                            this.result = this.append(this.blob1.getBytes(0L, this.length1), this.blob2.getBytes(0L, this.length2));
                            break;
                        }
                        this.result = this.access$300(iTuple, iTuple2);
                        break;
                    }
                    catch (DSException dSException) {
                        throw new RuntimeException("DSException, can't get blob from ITuple : " + dSException.getMessage(), dSException);
                    }
                }
                default: {
                    throw new UnsupportedOperationException("not support data type in Types : " + Types.getDataTypeName(nArray[1]));
                }
            }
            return this.result;
        }

        private int access$300(ITuple iTuple, ITuple iTuple2) throws DSException {
            if (iTuple.wasNull() && iTuple2.wasNull()) {
                return 0;
            }
            if (iTuple.wasNull() && !iTuple2.wasNull()) {
                return -1;
            }
            return 1;
        }

        private int append(byte[] byArray, byte[] byArray2) {
            if (byArray.length != byArray2.length) {
                return byArray.length - byArray2.length;
            }
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] == byArray2[i]) continue;
                return byArray[i] - byArray2[i];
            }
            return 0;
        }

        private int bigDec1(Blob blob) throws DSException {
            if (blob.length() < 1024L) {
                return (int)blob.length();
            }
            return 1024;
        }

        private int bigDec2(Clob clob) throws DSException {
            if (clob.length() < 1024L) {
                return (int)clob.length();
            }
            return 1024;
        }
    }

    private class time
    extends TimerTask {
        private time() {
        }

        @Override
        public void run() {
            Relation4ResultSetPool.this.activeCount = true;
            Relation4ResultSetPool.this.create.cancel();
        }
    }
}

