/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.util;

import com.jinfonet.api.datatypes.Array;
import com.jinfonet.api.datatypes.Types;
import com.jinfonet.datatypes.JinfonetDate;
import com.jinfonet.datatypes.JinfonetTime;
import com.jinfonet.datatypes.JinfonetTimeStamp;
import java.math.BigDecimal;
import jet.dataengine.api.DSException;

public abstract class BaseHasher {
    protected final int initialNonZeroOddNumber;
    protected int multiplierNonZeroOddNumber = 0;

    public BaseHasher(int n, int n2) {
        if (n == 0) {
            throw new IllegalArgumentException("Requires a non zero initial value");
        }
        if (n % 2 == 0) {
            throw new IllegalArgumentException("Requires an odd initial value");
        }
        if (n2 == 0) {
            throw new IllegalArgumentException("Requires a non zero multiplier");
        }
        if (n2 % 2 == 0) {
            throw new IllegalArgumentException("Requires an odd multiplier");
        }
        this.initialNonZeroOddNumber = n;
        this.multiplierNonZeroOddNumber = n2;
    }

    protected int hashLong(long l) {
        return (int)(l ^ l >> 32);
    }

    protected int hashArray(Array array) throws DSException {
        int n = this.multiplierNonZeroOddNumber;
        if (array == null) {
            return n;
        }
        Object object = array.getArray();
        if (object == null) {
            return n;
        }
        int n2 = array.getBaseType();
        switch (n2) {
            case -6: {
                for (byte by : (byte[])object) {
                    n *= this.initialNonZeroOddNumber;
                    n += by;
                }
                break;
            }
            case 4: {
                for (int n3 : (int[])object) {
                    n *= this.initialNonZeroOddNumber;
                    n += n3;
                }
                break;
            }
            case 5: {
                for (short s : (short[])object) {
                    n *= this.initialNonZeroOddNumber;
                    n += s;
                }
                break;
            }
            case -5: {
                for (long l : (long[])object) {
                    n *= this.initialNonZeroOddNumber;
                    n += this.hashLong(l);
                }
                break;
            }
            case 6: {
                for (float f : (float[])object) {
                    n *= this.initialNonZeroOddNumber;
                    n += Float.floatToIntBits(f);
                }
                break;
            }
            case 8: {
                for (double d : (double[])object) {
                    n *= this.initialNonZeroOddNumber;
                    long l = Double.doubleToLongBits(d);
                    n += this.hashLong(l);
                }
                break;
            }
            case 91: {
                for (JinfonetDate jinfonetDate : (JinfonetDate[])object) {
                    n *= this.initialNonZeroOddNumber;
                    if (jinfonetDate == null) continue;
                    n += this.hashLong(jinfonetDate.getTime());
                }
                break;
            }
            case 92: {
                for (JinfonetTime jinfonetTime : (JinfonetTime[])object) {
                    n *= this.initialNonZeroOddNumber;
                    if (jinfonetTime == null) continue;
                    n += this.hashLong(jinfonetTime.getTime());
                }
                break;
            }
            case 93: {
                for (JinfonetTimeStamp jinfonetTimeStamp : (JinfonetTimeStamp[])object) {
                    n *= this.initialNonZeroOddNumber;
                    if (jinfonetTimeStamp == null) continue;
                    n += this.hashLong(jinfonetTimeStamp.getTime());
                }
                break;
            }
            case -7: {
                for (boolean bl : (boolean[])object) {
                    n *= this.initialNonZeroOddNumber;
                    n += bl ? 1 : 0;
                }
                break;
            }
            case 12: 
            case 2005: {
                for (String string : (String[])object) {
                    n *= this.initialNonZeroOddNumber;
                    n += string.hashCode();
                }
                break;
            }
            case 3: {
                for (BigDecimal bigDecimal : (BigDecimal[])object) {
                    n *= this.initialNonZeroOddNumber;
                    if (bigDecimal == null) continue;
                    n += bigDecimal.hashCode();
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported data type: " + Types.getDataTypeName(n2));
            }
        }
        return n;
    }
}

