/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.util;

import com.jinfonet.api.datatypes.Types;
import com.jinfonet.dataservice.util.BaseHasher;
import jet.connect.DbBigInt;
import jet.connect.DbBit;
import jet.connect.DbChar;
import jet.connect.DbDate;
import jet.connect.DbDecimal;
import jet.connect.DbDouble;
import jet.connect.DbInteger;
import jet.connect.DbReal;
import jet.connect.DbSmallInt;
import jet.connect.DbTime;
import jet.connect.DbTimestamp;
import jet.connect.DbTinyInt;
import jet.connect.DbValue;

public class DbValueHasher
extends BaseHasher {
    public DbValueHasher(int n, int n2) {
        super(n, n2);
    }

    public int hash(DbValue[] dbValueArray) {
        int n = this.multiplierNonZeroOddNumber;
        block14: for (DbValue dbValue : dbValueArray) {
            n *= this.initialNonZeroOddNumber;
            if (dbValue.desc.isArray()) {
                // empty if block
            }
            if (dbValue.isNull()) continue;
            int n2 = dbValue.getSqlType();
            switch (n2) {
                case 5: {
                    n += ((DbSmallInt)dbValue).value;
                    continue block14;
                }
                case -6: {
                    n += ((DbTinyInt)dbValue).byteValue();
                    continue block14;
                }
                case 4: {
                    n += ((DbInteger)dbValue).value;
                    continue block14;
                }
                case -5: {
                    n += this.hashLong(((DbBigInt)dbValue).value);
                    continue block14;
                }
                case 7: {
                    n += Float.floatToIntBits(((DbReal)dbValue).value);
                    continue block14;
                }
                case 2: 
                case 3: {
                    n += ((DbDecimal)dbValue).value.hashCode();
                    continue block14;
                }
                case 6: 
                case 8: {
                    long l = Double.doubleToLongBits(((DbDouble)dbValue).value);
                    n += this.hashLong(l);
                    continue block14;
                }
                case -7: {
                    n += ((DbBit)dbValue).value ? 1 : 0;
                    continue block14;
                }
                case 91: {
                    n += this.hashLong(((DbDate)dbValue).value);
                    continue block14;
                }
                case 92: {
                    n += this.hashLong(((DbTime)dbValue).value);
                    continue block14;
                }
                case 93: {
                    n += this.hashLong(((DbTimestamp)dbValue).value) + ((DbTimestamp)dbValue).nanos;
                    continue block14;
                }
                case -1: 
                case 1: 
                case 12: 
                case 2005: {
                    n += ((DbChar)dbValue).value.hashCode();
                    continue block14;
                }
                default: {
                    throw new IllegalArgumentException("unsupported data type: " + Types.getDataTypeName(n2));
                }
            }
        }
        return n;
    }
}

