/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;

public class FloatArrayList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient float[] SEDU;
    private int modCount = 0;
    private int size;

    public FloatArrayList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        this.SEDU = new float[n];
    }

    public FloatArrayList() {
        this(30);
    }

    public FloatArrayList(float[] fArray2) {
        this.SEDU = fArray2;
        this.size = this.SEDU.length;
    }

    public void trimToSize() {
        ++this.modCount;
        if (this.size < this.SEDU.length) {
            float[] fArray2 = this.SEDU;
            this.SEDU = new float[this.size];
            System.arraycopy(fArray2, 0, this.SEDU, 0, this.size);
        }
    }

    public void ensureCapacity(int n) {
        ++this.modCount;
        if (n > this.SEDU.length) {
            float[] fArray2 = this.SEDU;
            int n2 = this.SEDU.length * 2 + 1;
            this.SEDU = n2 > n ? new float[n2] : new float[n];
            System.arraycopy(fArray2, 0, this.SEDU, 0, this.size);
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(float f) {
        return this.indexOf(f) >= 0;
    }

    public int indexOf(float f) {
        if (f >= -2.1474836E9f && f <= 2.1474836E9f) {
            for (int i = 0; i < this.size; ++i) {
                if (!(Math.abs(this.SEDU[i] - f) < 4.0E-9f)) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(float f) {
        if (f >= -2.1474836E9f && f <= 2.1474836E9f) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (!(Math.abs(this.SEDU[i] - f) < 4.0E-9f)) continue;
                return i;
            }
        }
        return -1;
    }

    public float[] toArray() {
        float[] fArray2 = new float[this.size];
        System.arraycopy(this.SEDU, 0, fArray2, 0, this.size);
        return fArray2;
    }

    public float[] toArray(float[] fArray2) {
        if (fArray2.length < this.size) {
            fArray2 = (float[])Array.newInstance(fArray2.getClass().getComponentType(), this.size);
        }
        System.arraycopy(this.SEDU, 0, fArray2, 0, this.size);
        if (fArray2.length > this.size) {
            fArray2[this.size] = 0.0f;
        }
        return fArray2;
    }

    public float get(int n) {
        this.SEDU(n);
        return this.SEDU[n];
    }

    public float set(int n, float f) {
        this.SEDU(n);
        float f2 = this.SEDU[n];
        this.SEDU[n] = f;
        return f2;
    }

    public boolean add(float f) {
        this.ensureCapacity(this.size + 1);
        this.SEDU[this.size++] = f;
        return true;
    }

    public boolean addAll(float[] fArray2) {
        float[] fArray3 = fArray2;
        int n = fArray3.length;
        this.ensureCapacity(this.size + n);
        System.arraycopy(fArray3, 0, this.SEDU, this.size, n);
        this.size += n;
        return n != 0;
    }

    public void add(int n, float f) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.SEDU, n, this.SEDU, n + 1, this.size - n);
        this.SEDU[n] = f;
        ++this.size;
    }

    public void clear() {
        ++this.modCount;
        for (int i = 0; i < this.size; ++i) {
            this.SEDU[i] = 0.0f;
        }
        this.size = 0;
    }

    private void SEDU(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.SEDU.length);
        for (int i = 0; i < this.size; ++i) {
            objectOutputStream.writeFloat(this.SEDU[i]);
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.SEDU = new float[n];
        for (int i = 0; i < this.size; ++i) {
            this.SEDU[i] = objectInputStream.readFloat();
        }
    }
}

