/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.util;

public class InnerDataParser {
    protected static byte[] oneByteType = new byte[1];
    protected static byte[] twoByteType = new byte[2];
    protected static byte[] fourByteType = new byte[4];
    protected static byte[] eightByteType = new byte[8];

    public static synchronized byte[] parseByte(byte by) {
        InnerDataParser.oneByteType[0] = by;
        return oneByteType;
    }

    public static synchronized byte[] parseShort(short s) {
        InnerDataParser.twoByteType[0] = (byte)(s >>> 8 & 0xFF);
        InnerDataParser.twoByteType[1] = (byte)(s & 0xFF);
        return twoByteType;
    }

    public static synchronized byte[] parseInt(int n) {
        InnerDataParser.fourByteType[0] = (byte)(n >>> 24 & 0xFF);
        InnerDataParser.fourByteType[1] = (byte)(n >>> 16 & 0xFF);
        InnerDataParser.fourByteType[2] = (byte)(n >>> 8 & 0xFF);
        InnerDataParser.fourByteType[3] = (byte)(n >>> 0 & 0xFF);
        return fourByteType;
    }

    public static synchronized byte[] parseLong(long l) {
        InnerDataParser.eightByteType[0] = (byte)(l >>> 56 & 0xFFL);
        InnerDataParser.eightByteType[1] = (byte)(l >>> 48 & 0xFFL);
        InnerDataParser.eightByteType[2] = (byte)(l >>> 40 & 0xFFL);
        InnerDataParser.eightByteType[3] = (byte)(l >>> 32 & 0xFFL);
        InnerDataParser.eightByteType[4] = (byte)(l >>> 24 & 0xFFL);
        InnerDataParser.eightByteType[5] = (byte)(l >>> 16 & 0xFFL);
        InnerDataParser.eightByteType[6] = (byte)(l >>> 8 & 0xFFL);
        InnerDataParser.eightByteType[7] = (byte)(l >>> 0 & 0xFFL);
        return eightByteType;
    }

    public static synchronized byte[] parseFloat(float f) {
        return InnerDataParser.parseInt(Float.floatToIntBits(f));
    }

    public static synchronized byte[] parseDouble(double d) {
        return InnerDataParser.parseLong(Double.doubleToLongBits(d));
    }

    public static synchronized byte[] parseChar(char c) {
        InnerDataParser.twoByteType[0] = (byte)(c >>> 8 & 0xFF);
        InnerDataParser.twoByteType[1] = (byte)(c >>> 0 & 0xFF);
        return twoByteType;
    }

    public static synchronized byte[] parseBoolean(boolean bl) {
        InnerDataParser.oneByteType[0] = (byte)(bl ? 1 : 0);
        return oneByteType;
    }

    public static synchronized byte revertByte(byte[] byArray) {
        return byArray[0];
    }

    public static synchronized short revertShort(byte[] byArray) {
        return (short)((short)(byArray[0] & 0xFF) << 8 | (short)(byArray[1] & 0xFF));
    }

    public static synchronized int revertUnsignedShort(byte[] byArray) {
        return (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
    }

    public static synchronized int revertInt(byte[] byArray) {
        return (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | (byArray[3] & 0xFF) << 0;
    }

    public static synchronized long revertLong(byte[] byArray) {
        return (long)(byArray[0] & 0xFF) << 56 | (long)(byArray[1] & 0xFF) << 48 | (long)(byArray[2] & 0xFF) << 40 | (long)(byArray[3] & 0xFF) << 32 | (long)(byArray[4] & 0xFF) << 24 | (long)(byArray[5] & 0xFF) << 16 | (long)(byArray[6] & 0xFF) << 8 | (long)(byArray[7] & 0xFF);
    }

    public static synchronized float revertFloat(byte[] byArray) {
        return Float.intBitsToFloat(InnerDataParser.revertInt(byArray));
    }

    public static synchronized double revertDouble(byte[] byArray) {
        return Double.longBitsToDouble(InnerDataParser.revertLong(byArray));
    }

    public static synchronized char revertChar(byte[] byArray) {
        return (char)((char)(byArray[0] & 0xFF) << 8 | (char)(byArray[1] & 0xFF) << 0);
    }

    public static synchronized boolean revertBoolean(byte[] byArray) {
        return byArray[0] == 1;
    }
}

