/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.util;

import com.jinfonet.dataservice.util.IntList;
import com.jinfonet.dataservice.util.OneDimensionIntArrayList;
import java.util.Arrays;
import jet.dataengine8.util.ArraysUtil;

public class Int2DimensionArrayList
implements IntList {
    private transient int[][] SEDU;
    private int addAll;
    private static final int arraycopy = 5;
    private static final int binarySearch = 31;
    private static final int getIntArray = 32;
    private int indexOf = 1;

    public Int2DimensionArrayList() {
        this(32);
    }

    public Int2DimensionArrayList(int n) {
        int n2 = (n >> 5) + ((n & 0x1F) == 0 ? 0 : 1);
        if (n2 == 0) {
            ++n2;
        }
        this.SEDU = new int[n2][32];
    }

    @Override
    public boolean add(int n) {
        this.SEDU(1 + this.addAll);
        this.SEDU[this.addAll / 32][this.addAll % 32] = n;
        ++this.addAll;
        return true;
    }

    @Override
    public int remove(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] getIntArray() {
        int[] nArray = new int[this.addAll];
        int n = this.addAll < 32 ? this.addAll : 32;
        int n2 = 0;
        int n3 = 0;
        while (n > 0) {
            System.arraycopy(this.SEDU[n3], 0, nArray, n2, n);
            n = this.addAll - (n2 += n) < 32 ? this.addAll - n2 : 32;
            ++n3;
        }
        return nArray;
    }

    @Override
    public IntList sort() {
        int[] nArray = this.getIntArray();
        Arrays.sort(nArray);
        OneDimensionIntArrayList oneDimensionIntArrayList = new OneDimensionIntArrayList(nArray.length);
        oneDimensionIntArrayList.addAll(nArray);
        return oneDimensionIntArrayList;
    }

    @Override
    public IntList interSection(IntList intList) {
        int[] nArray = this.getIntArray();
        int[] nArray2 = intList.getIntArray();
        int[] nArray3 = ArraysUtil.intersection(nArray, nArray2);
        OneDimensionIntArrayList oneDimensionIntArrayList = new OneDimensionIntArrayList(nArray3.length);
        oneDimensionIntArrayList.addAll(nArray3);
        return oneDimensionIntArrayList;
    }

    @Override
    public synchronized int size() {
        return this.addAll;
    }

    @Override
    public IntList merge(IntList intList) {
        int[] nArray = this.getIntArray();
        OneDimensionIntArrayList oneDimensionIntArrayList = new OneDimensionIntArrayList(nArray.length);
        oneDimensionIntArrayList.addAll(nArray);
        oneDimensionIntArrayList.merge(intList);
        return oneDimensionIntArrayList;
    }

    @Override
    public synchronized int get(int n) {
        if (n >= this.size() || n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.SEDU[n >> 5][n & 0x1F];
    }

    @Override
    public boolean contains(int n) {
        return this.indexOf(n) >= 0;
    }

    @Override
    public int indexOf(int n) {
        int[] nArray = this.getIntArray();
        Arrays.sort(nArray);
        return Arrays.binarySearch(nArray, n);
    }

    @Override
    public int removeElement(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(IntList intList) {
        int[] nArray = intList.getIntArray();
        return this.addAll(nArray);
    }

    @Override
    public boolean addAll(int[] nArray) {
        int n = this.addAll / 32;
        int n2 = this.addAll % 32;
        int n3 = 0;
        int n4 = n2 + nArray.length < 32 ? nArray.length : 32 - n2;
        this.SEDU(this.addAll + nArray.length);
        int n5 = n;
        while (n4 > 0) {
            System.arraycopy(nArray, n3, this.SEDU[n5], n2, n4);
            n4 = nArray.length - (n3 += n4) < 32 ? nArray.length - n3 : 32;
            n2 = 0;
            ++n5;
        }
        this.addAll += nArray.length;
        return true;
    }

    @Override
    public void clear() {
        this.addAll = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.addAll == 0;
    }

    @Override
    public void trimToSize() {
        int n = this.addAll / 32 + (this.addAll % 32 == 0 ? 0 : 1);
        if (n < this.SEDU.length) {
            int[][] nArray = this.SEDU;
            this.SEDU = new int[n][];
            System.arraycopy(nArray, 0, this.SEDU, 0, n);
        }
    }

    @Override
    public Object clone() {
        int[] nArray = this.getIntArray();
        Int2DimensionArrayList int2DimensionArrayList = new Int2DimensionArrayList(nArray.length);
        int2DimensionArrayList.addAll(nArray);
        return int2DimensionArrayList;
    }

    @Override
    public void close() {
    }

    private void SEDU(int n) {
        int n2 = this.SEDU.length * 32;
        if (n > n2) {
            n2 = n >> 5;
            n2 = n == this.addAll + 1 ? this.indexOf + (n >> 5) : (n >> 5) + ((n & 0x1F) == 0 ? 0 : 1);
            this.indexOf = (int)((double)n2 * 0.75);
            int[][] nArray = this.SEDU;
            this.SEDU = new int[n2][];
            System.arraycopy(nArray, 0, this.SEDU, 0, nArray.length);
            for (int i = nArray.length; i < n2; ++i) {
                this.SEDU[i] = new int[32];
            }
        }
    }
}

